/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class SanKeyPort
extends JGoPort {
    public static final int ChangedLinkPointsSpread = 333;
    private static Comparator myComparer = new EndPositionComparer();
    private int myTopBreadth;
    private int myRightBreadth;
    private int myBottomBreadth;
    private int myLeftBreadth;
    private Point myTopStart;
    private Point myRightStart;
    private Point myBottomStart;
    private Point myLeftStart;
    private GoBoxPortLinkInfo[] mySortedLinks;
    private boolean myRespreading;

    public SanKeyPort() {
        this.setFromSpot(0);
        this.setToSpot(0);
        this.setStyle(0);
        this.setPen(JGoPen.black);
        this.setBrush(JGoBrush.white);
    }

    public Point getFromLinkPoint(JGoLink jGoLink, Point point) {
        if (jGoLink != null) {
            GoBoxPortLinkInfo[] goBoxPortLinkInfoArray = this.GetLinkInfos(true);
            for (int i = 0; i < goBoxPortLinkInfoArray.length; ++i) {
                GoBoxPortLinkInfo goBoxPortLinkInfo = goBoxPortLinkInfoArray[i];
                if (goBoxPortLinkInfo.Link != jGoLink) continue;
                point.x = goBoxPortLinkInfo.LinkPoint.x;
                point.y = goBoxPortLinkInfo.LinkPoint.y;
                return point;
            }
        }
        return this.getSpotLocation(0, point);
    }

    public Point getToLinkPoint(JGoLink jGoLink, Point point) {
        if (jGoLink != null) {
            GoBoxPortLinkInfo[] goBoxPortLinkInfoArray = this.GetLinkInfos(true);
            for (int i = 0; i < goBoxPortLinkInfoArray.length; ++i) {
                GoBoxPortLinkInfo goBoxPortLinkInfo = goBoxPortLinkInfoArray[i];
                if (goBoxPortLinkInfo.Link != jGoLink) continue;
                point.x = goBoxPortLinkInfo.LinkPoint.x;
                point.y = goBoxPortLinkInfo.LinkPoint.y;
                return point;
            }
        }
        return this.getSpotLocation(0, point);
    }

    public double GetAngle(JGoLink jGoLink) {
        if (jGoLink == null) {
            return 0.0;
        }
        JGoPort jGoPort = jGoLink.getOtherPort(this);
        if (jGoPort == null) {
            return 0.0;
        }
        Point point = jGoPort.getSpotLocation(0);
        Point point2 = this.getSpotLocation(0);
        if (jGoLink.getNumPoints() > 0) {
            point = jGoLink.getFromPort() == jGoPort ? jGoLink.getPoint(0) : jGoLink.getPoint(jGoLink.getNumPoints() - 1);
        }
        return -Math.atan2(point.x - point2.x, point.y - point2.y);
    }

    public double GetDirection(JGoLink jGoLink) {
        if (jGoLink == null) {
            return 0.0;
        }
        if (jGoLink.getFromPort() == this) {
            return this.getFromLinkDir(jGoLink);
        }
        return this.getToLinkDir(jGoLink);
    }

    GoBoxPortLinkInfo[] GetLinkInfos(boolean bl) {
        if (this.mySortedLinks == null || this.mySortedLinks.length != this.getNumLinks()) {
            this.mySortedLinks = new GoBoxPortLinkInfo[this.getNumLinks()];
            bl = true;
        }
        if (bl && !this.myRespreading) {
            boolean bl2 = this.myRespreading;
            this.myRespreading = true;
            int n = 0;
            JGoListPosition jGoListPosition = this.getFirstLinkPos();
            while (jGoListPosition != null) {
                int n2;
                JGoLink jGoLink = this.getLinkAtPos(jGoListPosition);
                jGoListPosition = this.getNextLinkPos(jGoListPosition);
                double d = this.GetDirection(jGoLink);
                double d2 = this.GetAngle(jGoLink);
                if (d == 0.0) {
                    n2 = 4;
                } else if (d == 1.5707963267948966) {
                    n2 = 6;
                } else if (d == Math.PI) {
                    n2 = 8;
                } else {
                    n2 = 2;
                    if (d2 < 0.0) {
                        d2 += Math.PI * 2;
                    }
                }
                GoBoxPortLinkInfo goBoxPortLinkInfo = this.mySortedLinks[n];
                if (goBoxPortLinkInfo == null) {
                    this.mySortedLinks[n] = new GoBoxPortLinkInfo(jGoLink, d2, n2);
                } else {
                    goBoxPortLinkInfo.Link = jGoLink;
                    goBoxPortLinkInfo.Angle = d2;
                    goBoxPortLinkInfo.Side = n2;
                }
                ++n;
            }
            this.SortLinkInfos(this.mySortedLinks);
            int n3 = this.mySortedLinks.length;
            int n4 = -1;
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                GoBoxPortLinkInfo goBoxPortLinkInfo = this.mySortedLinks[n];
                if (goBoxPortLinkInfo.Side != n4) {
                    n4 = goBoxPortLinkInfo.Side;
                    n5 = 0;
                }
                goBoxPortLinkInfo.IndexOnSide = n5++;
            }
            n4 = -1;
            n5 = 0;
            for (n = n3 - 1; n >= 0; --n) {
                GoBoxPortLinkInfo goBoxPortLinkInfo = this.mySortedLinks[n];
                if (goBoxPortLinkInfo.Side != n4) {
                    n4 = goBoxPortLinkInfo.Side;
                    n5 = goBoxPortLinkInfo.IndexOnSide + 1;
                }
                goBoxPortLinkInfo.CountOnSide = n5;
            }
            this.AssignLinkPoints(this.mySortedLinks);
            this.AssignEndSegmentLengths(this.mySortedLinks);
            this.myRespreading = bl2;
        }
        return this.mySortedLinks;
    }

    protected void SortLinkInfos(GoBoxPortLinkInfo[] goBoxPortLinkInfoArray) {
        Arrays.sort(goBoxPortLinkInfoArray, myComparer);
    }

    protected void AssignEndSegmentLengths(GoBoxPortLinkInfo[] goBoxPortLinkInfoArray) {
        for (int i = 0; i < goBoxPortLinkInfoArray.length; ++i) {
            GoBoxPortLinkInfo goBoxPortLinkInfo = goBoxPortLinkInfoArray[i];
            goBoxPortLinkInfo.EndSegmentLength = this.getEndSegmentLength();
        }
    }

    protected void AssignLinkPoints(GoBoxPortLinkInfo[] goBoxPortLinkInfoArray) {
        Serializable serializable;
        Serializable serializable2;
        this.myTopBreadth = 0;
        this.myRightBreadth = 0;
        this.myBottomBreadth = 0;
        this.myLeftBreadth = 0;
        block12: for (int i = 0; i < goBoxPortLinkInfoArray.length; ++i) {
            serializable2 = goBoxPortLinkInfoArray[i];
            serializable = serializable2.Link;
            int n = serializable.getPen().getWidth();
            if (serializable.getHighlight() != null) {
                n = Math.max(n, serializable.getHighlight().getWidth());
            }
            switch (serializable2.Side) {
                case 2: {
                    this.myTopBreadth += n;
                    continue block12;
                }
                case 4: {
                    this.myRightBreadth += n;
                    continue block12;
                }
                case 6: {
                    this.myBottomBreadth += n;
                    continue block12;
                }
                case 8: {
                    this.myLeftBreadth += n;
                    continue block12;
                }
            }
        }
        JGoObject jGoObject = this.getPortObject();
        if (jGoObject == null) {
            jGoObject = this;
        }
        serializable2 = jGoObject.getBoundingRect();
        this.myTopStart = new Point(((Rectangle)serializable2).x + ((Rectangle)serializable2).width / 2 - this.myTopBreadth / 2, ((Rectangle)serializable2).y);
        this.myRightStart = new Point(((Rectangle)serializable2).x + ((Rectangle)serializable2).width, ((Rectangle)serializable2).y + ((Rectangle)serializable2).height / 2 - this.myRightBreadth / 2);
        this.myBottomStart = new Point(((Rectangle)serializable2).x + ((Rectangle)serializable2).width / 2 + this.myBottomBreadth / 2, ((Rectangle)serializable2).y + ((Rectangle)serializable2).height);
        this.myLeftStart = new Point(((Rectangle)serializable2).x, ((Rectangle)serializable2).y + ((Rectangle)serializable2).height / 2 + this.myLeftBreadth / 2);
        serializable = new Point(this.myTopStart);
        Point point = new Point(this.myRightStart);
        Point point2 = new Point(this.myBottomStart);
        Point point3 = new Point(this.myLeftStart);
        block13: for (int i = 0; i < goBoxPortLinkInfoArray.length; ++i) {
            GoBoxPortLinkInfo goBoxPortLinkInfo = goBoxPortLinkInfoArray[i];
            JGoLink jGoLink = goBoxPortLinkInfo.Link;
            int n = Math.max(1, jGoLink.getPen().getWidth());
            if (jGoLink.getHighlight() != null) {
                n = Math.max(n, jGoLink.getHighlight().getWidth());
            }
            switch (goBoxPortLinkInfo.Side) {
                case 2: {
                    goBoxPortLinkInfo.LinkPoint.x = ((Point)serializable).x + n / 2;
                    goBoxPortLinkInfo.LinkPoint.y = ((Point)serializable).y - this.getEndSegmentLength();
                    ((Point)serializable).x += n;
                    continue block13;
                }
                case 4: {
                    goBoxPortLinkInfo.LinkPoint.x = point.x;
                    goBoxPortLinkInfo.LinkPoint.y = point.y + n / 2;
                    point.y += n;
                    continue block13;
                }
                case 6: {
                    goBoxPortLinkInfo.LinkPoint.x = point2.x - n / 2;
                    goBoxPortLinkInfo.LinkPoint.y = point2.y;
                    point2.x -= n;
                    continue block13;
                }
                case 8: {
                    goBoxPortLinkInfo.LinkPoint.x = point3.x - this.getEndSegmentLength();
                    goBoxPortLinkInfo.LinkPoint.y = point3.y - n / 2;
                    point3.y -= n;
                }
            }
        }
    }

    public void linkChange() {
        this.portChange(333, 0, null);
        this.update();
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        super.paint(graphics2D, jGoView);
        if (this.getNumLinks() == 0) {
            return;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (this.myTopBreadth > 0) {
            nArray[0] = this.myTopStart.x;
            nArray2[0] = this.myTopStart.y;
            nArray[1] = this.myTopStart.x;
            nArray2[1] = this.myTopStart.y;
            nArray[2] = this.myTopStart.x;
            nArray2[2] = this.myTopStart.y;
            nArray2[0] = nArray2[0] - this.getEndSegmentLength();
            nArray[1] = nArray[1] + this.myTopBreadth / 2;
            nArray[2] = nArray[2] + this.myTopBreadth;
            nArray2[2] = nArray2[2] - this.getEndSegmentLength();
            this.drawPolygon(graphics2D, nArray, nArray2, 3);
        }
        if (this.myRightBreadth > 0) {
            nArray[0] = this.myRightStart.x;
            nArray2[0] = this.myRightStart.y;
            nArray[1] = this.myRightStart.x;
            nArray2[1] = this.myRightStart.y;
            nArray[2] = this.myRightStart.x;
            nArray2[2] = this.myRightStart.y;
            nArray2[1] = nArray2[1] + this.myRightBreadth / 2;
            nArray[1] = nArray[1] + this.getEndSegmentLength();
            nArray2[2] = nArray2[2] + this.myRightBreadth;
            this.drawPolygon(graphics2D, nArray, nArray2, 3);
        }
        if (this.myBottomBreadth > 0) {
            nArray[0] = this.myBottomStart.x;
            nArray2[0] = this.myBottomStart.y;
            nArray[1] = this.myBottomStart.x;
            nArray2[1] = this.myBottomStart.y;
            nArray[2] = this.myBottomStart.x;
            nArray2[2] = this.myBottomStart.y;
            nArray[1] = nArray[1] - this.myBottomBreadth / 2;
            nArray2[1] = nArray2[1] + this.getEndSegmentLength();
            nArray[2] = nArray[2] - this.myBottomBreadth;
            this.drawPolygon(graphics2D, nArray, nArray2, 3);
        }
        if (this.myLeftBreadth > 0) {
            nArray[0] = this.myLeftStart.x;
            nArray2[0] = this.myLeftStart.y;
            nArray[1] = this.myLeftStart.x;
            nArray2[1] = this.myLeftStart.y;
            nArray[2] = this.myLeftStart.x;
            nArray2[2] = this.myLeftStart.y;
            nArray[0] = nArray[0] - this.getEndSegmentLength();
            nArray2[1] = nArray2[1] - this.myLeftBreadth / 2;
            nArray[2] = nArray[2] - this.getEndSegmentLength();
            nArray2[2] = nArray2[2] - this.myLeftBreadth;
            this.drawPolygon(graphics2D, nArray, nArray2, 3);
        }
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        super.expandRectByPenWidth(rectangle);
        rectangle.grow(this.getEndSegmentLength(), this.getEndSegmentLength());
    }

    public static class GoBoxPortLinkInfo
    implements Serializable {
        public JGoLink Link;
        public double Angle;
        public int Side;
        public int CountOnSide;
        public int IndexOnSide;
        public Point LinkPoint = new Point();
        public int EndSegmentLength;

        GoBoxPortLinkInfo(JGoLink jGoLink, double d, int n) {
            this.Link = jGoLink;
            this.Angle = d;
            this.Side = n;
        }
    }

    static class EndPositionComparer
    implements Comparator {
        EndPositionComparer() {
        }

        public int compare(Object object, Object object2) {
            GoBoxPortLinkInfo goBoxPortLinkInfo = (GoBoxPortLinkInfo)object;
            GoBoxPortLinkInfo goBoxPortLinkInfo2 = (GoBoxPortLinkInfo)object2;
            if (goBoxPortLinkInfo == null || goBoxPortLinkInfo2 == null) {
                return 0;
            }
            if (goBoxPortLinkInfo.Side < goBoxPortLinkInfo2.Side) {
                return -1;
            }
            if (goBoxPortLinkInfo.Side > goBoxPortLinkInfo2.Side) {
                return 1;
            }
            if (goBoxPortLinkInfo.Angle < goBoxPortLinkInfo2.Angle) {
                return -1;
            }
            if (goBoxPortLinkInfo.Angle > goBoxPortLinkInfo2.Angle) {
                return 1;
            }
            return 0;
        }
    }
}

