/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSubGraph;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class TestSubGraph
extends JGoSubGraph {
    private JGoPort myInput = null;
    private JGoPort myOutput = null;

    public TestSubGraph() {
    }

    public TestSubGraph(String string) {
        super(string);
        this.init();
    }

    public void init() {
        this.setInitializing(true);
        this.setLabelSpot(1);
        this.setCollapsedLabelSpot(6);
        this.setInsets(new Insets(10, 10, 10, 10));
        this.setCollapsedInsets(new Insets(10, 10, 10, 10));
        this.myInput = new JGoPort();
        this.myInput.setSize(7, 7);
        this.myInput.setBrush(JGoBrush.green);
        this.myInput.setStyle(3);
        this.myInput.setValidSource(false);
        this.addObjectAtTail(this.myInput);
        this.myOutput = new JGoPort();
        this.myOutput.setSize(7, 7);
        this.myOutput.setBrush(JGoBrush.green);
        this.myOutput.setStyle(3);
        this.myOutput.setValidDestination(false);
        this.addObjectAtTail(this.myOutput);
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        TestSubGraph testSubGraph = (TestSubGraph)jGoArea;
        testSubGraph.myInput = (JGoPort)jGoCopyEnvironment.get(this.myInput);
        testSubGraph.myOutput = (JGoPort)jGoCopyEnvironment.get(this.myOutput);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myInput) {
            this.myInput = null;
        } else if (jGoObject == this.myOutput) {
            this.myOutput = null;
        }
        return jGoObject;
    }

    public void layoutPort() {
        Rectangle rectangle = this.computeBorder();
        if (this.getInput() != null) {
            this.getInput().setSpotLocation(8, new Point(rectangle.x, rectangle.y + rectangle.height / 2));
        }
        if (this.getOutput() != null) {
            this.getOutput().setSpotLocation(4, new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2));
        }
    }

    public JGoPort getInput() {
        return this.myInput;
    }

    public JGoPort getOutput() {
        return this.myOutput;
    }
}

