/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.demo1;

import com.nwoods.jgo.JGoText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TextPropsDialog
extends JDialog {
    JPanel panel1 = new JPanel();
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JLabel label1 = new JLabel();
    JTextField heightField = new JTextField();
    JLabel jLabel1 = new JLabel();
    JTextField widthField = new JTextField();
    JTextField xField = new JTextField();
    JLabel label2 = new JLabel();
    JTextField yField = new JTextField();
    JLabel label3 = new JLabel();
    JCheckBox visibleBox = new JCheckBox();
    JCheckBox selectableBox = new JCheckBox();
    JCheckBox resizableBox = new JCheckBox();
    JCheckBox draggableBox = new JCheckBox();
    JLabel label4 = new JLabel();
    JCheckBox editableBox = new JCheckBox();
    JCheckBox boldBox = new JCheckBox();
    JCheckBox italicBox = new JCheckBox();
    JCheckBox underlineBox = new JCheckBox();
    JCheckBox strikeBox = new JCheckBox();
    JTextField textField = new JTextField();
    JLabel label5 = new JLabel();
    JTextField faceNameField = new JTextField();
    ButtonGroup alignGroup = new ButtonGroup();
    JRadioButton alignLeftRadio = new JRadioButton();
    JRadioButton alignCenterRadio = new JRadioButton();
    JRadioButton alignRightRadio = new JRadioButton();
    JCheckBox multilineBox = new JCheckBox();
    JLabel label6 = new JLabel();
    JTextField fontSizeField = new JTextField();
    JButton textColorButton = new JButton();
    JButton backgroundColorButton = new JButton();
    JCheckBox transparentBox = new JCheckBox();
    JTextArea textArea = new JTextArea();
    JScrollPane textAreaScroll = new JScrollPane(this.textArea);
    JLabel classNameLabel = new JLabel();
    JCheckBox editSingle = new JCheckBox();
    JCheckBox selectBack = new JCheckBox();
    JCheckBox twoDScale = new JCheckBox();
    JCheckBox clipping = new JCheckBox();
    JCheckBox autoResize = new JCheckBox();
    JCheckBox wrapping = new JCheckBox();
    JLabel label7 = new JLabel();
    JTextField wrapwidth = new JTextField();
    BorderLayout borderLayout1 = new BorderLayout();
    Color myTextColor;
    Color myBkColor;
    public JGoText myObject;
    boolean fComponentsAdjusted = false;

    public TextPropsDialog(Frame frame, String string, boolean bl, JGoText jGoText) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.myObject = jGoText;
            this.UpdateDialog();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TextPropsDialog() {
        this((Frame)null, "", false, (JGoText)null);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(null);
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPropsDialog.this.OKButton_actionPerformed(actionEvent);
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPropsDialog.this.CancelButton_actionPerformed(actionEvent);
            }
        });
        this.textColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPropsDialog.this.textColorButton_actionPerformed(actionEvent);
            }
        });
        this.backgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPropsDialog.this.backgroundColorButton_actionPerformed(actionEvent);
            }
        });
        this.OKButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TextPropsDialog.this.OKButton_keyPressed(keyEvent);
            }
        });
        this.CancelButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TextPropsDialog.this.CancelButton_keyPressed(keyEvent);
            }
        });
        this.panel1.setMinimumSize(new Dimension(545, 310));
        this.panel1.setPreferredSize(new Dimension(545, 310));
        this.setResizable(false);
        this.getContentPane().add(this.panel1);
        this.setTitle("Text Properties");
        this.OKButton.setText("OK");
        this.panel1.add(this.OKButton);
        this.OKButton.setFont(new Font("Dialog", 0, 12));
        this.OKButton.setBounds(new Rectangle(168, 272, 79, 22));
        this.CancelButton.setText("Cancel");
        this.panel1.add(this.CancelButton);
        this.CancelButton.setFont(new Font("Dialog", 0, 12));
        this.CancelButton.setBounds(new Rectangle(276, 272, 79, 22));
        this.classNameLabel.setText("class name");
        this.classNameLabel.setBounds(new Rectangle(8, 4, 389, 24));
        this.panel1.add(this.classNameLabel);
        this.label1.setText("Height:");
        this.label1.setHorizontalAlignment(4);
        this.label1.setBounds(new Rectangle(67, 36, 43, 24));
        this.heightField.setEditable(false);
        this.heightField.setBounds(new Rectangle(114, 37, 36, 24));
        this.jLabel1.setText("Width:");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setBounds(new Rectangle(68, 70, 41, 17));
        this.widthField.setEditable(false);
        this.widthField.setBounds(new Rectangle(113, 66, 40, 23));
        this.label2.setText("x:");
        this.label2.setHorizontalAlignment(4);
        this.label2.setBounds(new Rectangle(1, 35, 19, 24));
        this.xField.setBounds(new Rectangle(25, 36, 36, 24));
        this.label3.setText("y:");
        this.label3.setHorizontalAlignment(4);
        this.label3.setBounds(new Rectangle(1, 67, 19, 24));
        this.yField.setBounds(new Rectangle(27, 67, 36, 24));
        this.label6.setText("Font Size:");
        this.label6.setHorizontalAlignment(4);
        this.label6.setBounds(new Rectangle(12, 108, 64, 24));
        this.panel1.add(this.label6);
        this.fontSizeField.setBounds(new Rectangle(84, 108, 36, 24));
        this.panel1.add(this.fontSizeField);
        this.label4.setText("Text:");
        this.label4.setHorizontalAlignment(4);
        this.label4.setBounds(new Rectangle(161, 36, 40, 24));
        this.textField.setBounds(new Rectangle(209, 36, 324, 24));
        this.textAreaScroll.setBounds(new Rectangle(209, 36, 209, 67));
        this.label5.setText("Face:");
        this.label5.setHorizontalAlignment(4);
        this.label5.setBounds(new Rectangle(136, 108, 36, 24));
        this.panel1.add(this.label5);
        this.faceNameField.setBounds(new Rectangle(180, 108, 324, 24));
        this.panel1.add(this.faceNameField);
        this.visibleBox.setText("Visible");
        this.visibleBox.setBounds(new Rectangle(24, 144, 104, 24));
        this.panel1.add(this.visibleBox);
        this.selectableBox.setText("Selectable");
        this.selectableBox.setBounds(new Rectangle(24, 168, 104, 24));
        this.panel1.add(this.selectableBox);
        this.resizableBox.setText("Resizable");
        this.resizableBox.setBounds(new Rectangle(24, 192, 104, 24));
        this.panel1.add(this.resizableBox);
        this.draggableBox.setText("Draggable");
        this.draggableBox.setBounds(new Rectangle(24, 216, 104, 24));
        this.panel1.add(this.draggableBox);
        this.twoDScale.setText("2D Scale");
        this.twoDScale.setBounds(new Rectangle(24, 240, 104, 24));
        this.panel1.add(this.twoDScale);
        this.autoResize.setText("AutoResize");
        this.autoResize.setBounds(new Rectangle(132, 144, 94, 24));
        this.panel1.add(this.autoResize);
        this.multilineBox.setText("Multiline");
        this.multilineBox.setBounds(new Rectangle(132, 168, 94, 24));
        this.panel1.add(this.multilineBox);
        this.clipping.setText("Clipping");
        this.clipping.setBounds(new Rectangle(132, 192, 94, 24));
        this.panel1.add(this.clipping);
        this.wrapping.setText("Wrapping");
        this.wrapping.setBounds(new Rectangle(132, 216, 94, 24));
        this.panel1.add(this.wrapping);
        this.editableBox.setText("Editable");
        this.editableBox.setBounds(new Rectangle(132, 240, 94, 24));
        this.panel1.add(this.editableBox);
        this.editSingle.setText("Edit on Single Click");
        this.panel1.add(this.editSingle);
        this.editSingle.setBounds(new Rectangle(228, 240, 140, 24));
        this.boldBox.setText("Bold");
        this.boldBox.setBounds(new Rectangle(228, 144, 94, 24));
        this.panel1.add(this.boldBox);
        this.italicBox.setText("Italic");
        this.italicBox.setBounds(new Rectangle(228, 168, 94, 24));
        this.panel1.add(this.italicBox);
        this.underlineBox.setText("Underline");
        this.underlineBox.setBounds(new Rectangle(228, 192, 94, 24));
        this.panel1.add(this.underlineBox);
        this.strikeBox.setText("Strike");
        this.strikeBox.setBounds(new Rectangle(228, 216, 94, 24));
        this.panel1.add(this.strikeBox);
        this.alignLeftRadio.setText("Align Left");
        this.alignGroup.add(this.alignLeftRadio);
        this.alignLeftRadio.setBounds(new Rectangle(324, 144, 94, 24));
        this.panel1.add(this.alignLeftRadio);
        this.alignCenterRadio.setText("Center");
        this.alignGroup.add(this.alignCenterRadio);
        this.alignCenterRadio.setBounds(new Rectangle(324, 168, 94, 24));
        this.panel1.add(this.alignCenterRadio);
        this.alignRightRadio.setText("Align Right");
        this.alignGroup.add(this.alignRightRadio);
        this.alignRightRadio.setBounds(new Rectangle(324, 192, 94, 24));
        this.panel1.add(this.alignRightRadio);
        this.textColorButton.setText("Text Color...");
        this.textColorButton.setBackground(Color.lightGray);
        this.textColorButton.setBounds(new Rectangle(420, 136, 117, 24));
        this.panel1.add(this.textColorButton);
        this.backgroundColorButton.setText("Background...");
        this.backgroundColorButton.setBackground(Color.lightGray);
        this.backgroundColorButton.setBounds(new Rectangle(420, 166, 117, 24));
        this.panel1.add(this.backgroundColorButton);
        this.transparentBox.setText("Transparent");
        this.transparentBox.setBounds(new Rectangle(420, 192, 96, 24));
        this.panel1.add(this.transparentBox);
        this.selectBack.setText("Select Background");
        this.panel1.add(this.selectBack);
        this.selectBack.setBounds(new Rectangle(420, 216, 130, 24));
        this.label7.setText("Wrap Width:");
        this.label7.setHorizontalAlignment(4);
        this.label7.setBounds(new Rectangle(408, 240, 83, 24));
        this.wrapwidth.setBounds(new Rectangle(502, 240, 36, 24));
        this.panel1.add(this.label7);
        this.panel1.add(this.wrapwidth);
        this.panel1.add(this.yField);
        this.panel1.add(this.label2);
        this.panel1.add(this.xField);
        this.panel1.add(this.label3);
        this.panel1.add(this.label1);
        this.panel1.add(this.heightField);
        this.panel1.add(this.textAreaScroll);
        this.panel1.add(this.label4);
        this.panel1.add(this.textField);
        this.panel1.add((Component)this.widthField, null);
        this.panel1.add((Component)this.jLabel1, null);
    }

    void UpdateDialog() {
        if (this.myObject == null) {
            return;
        }
        this.classNameLabel.setText(this.myObject.getClass().getName());
        Rectangle rectangle = this.myObject.getBoundingRect();
        this.heightField.setText(String.valueOf(rectangle.height));
        this.widthField.setText(String.valueOf(rectangle.width));
        Point point = this.myObject.getLocation();
        this.xField.setText(String.valueOf(point.x));
        this.yField.setText(String.valueOf(point.y));
        this.fontSizeField.setText(String.valueOf(this.myObject.getFontSize()));
        this.visibleBox.setSelected(this.myObject.isVisible());
        this.selectableBox.setSelected(this.myObject.isSelectable());
        this.resizableBox.setSelected(this.myObject.isResizable());
        this.draggableBox.setSelected(this.myObject.isDraggable());
        this.editableBox.setSelected(this.myObject.isEditable());
        this.boldBox.setSelected(this.myObject.isBold());
        this.italicBox.setSelected(this.myObject.isItalic());
        this.underlineBox.setSelected(this.myObject.isUnderline());
        this.strikeBox.setSelected(this.myObject.isStrikeThrough());
        this.textField.setText(this.myObject.getText());
        this.textArea.setText(this.myObject.getText());
        if (this.myObject.isMultiline()) {
            this.textField.setVisible(false);
            this.textAreaScroll.setVisible(true);
        } else {
            this.textField.setVisible(true);
            this.textAreaScroll.setVisible(false);
        }
        this.multilineBox.setSelected(this.myObject.isMultiline());
        this.faceNameField.setText(this.myObject.getFaceName());
        int n = this.myObject.getAlignment();
        if (n == 1) {
            this.alignLeftRadio.setSelected(true);
        } else if (n == 3) {
            this.alignRightRadio.setSelected(true);
        } else {
            this.alignCenterRadio.setSelected(true);
        }
        this.myTextColor = this.myObject.getTextColor();
        this.myBkColor = this.myObject.getBkColor();
        this.transparentBox.setSelected(this.myObject.isTransparent());
        this.editSingle.setSelected(this.myObject.isEditOnSingleClick());
        this.twoDScale.setSelected(this.myObject.is2DScale());
        this.clipping.setSelected(this.myObject.isClipping());
        this.wrapping.setSelected(this.myObject.isWrapping());
        this.autoResize.setSelected(this.myObject.isAutoResize());
        this.selectBack.setSelected(this.myObject.isSelectBackground());
        this.wrapwidth.setText(String.valueOf(this.myObject.getWrappingWidth()));
    }

    void UpdateControl() {
        if (this.myObject == null) {
            return;
        }
        Point point = new Point(Integer.parseInt(this.xField.getText()), Integer.parseInt(this.yField.getText()));
        this.myObject.setLocation(point);
        this.myObject.setFontSize(Integer.parseInt(this.fontSizeField.getText()));
        this.myObject.setVisible(this.visibleBox.isSelected());
        this.myObject.setSelectable(this.selectableBox.isSelected());
        this.myObject.setResizable(this.resizableBox.isSelected());
        this.myObject.setDraggable(this.draggableBox.isSelected());
        this.myObject.setEditable(this.editableBox.isSelected());
        this.myObject.setBold(this.boldBox.isSelected());
        this.myObject.setItalic(this.italicBox.isSelected());
        this.myObject.setUnderline(this.underlineBox.isSelected());
        this.myObject.setStrikeThrough(this.strikeBox.isSelected());
        if (this.myObject.isMultiline()) {
            this.myObject.setText(this.textArea.getText());
        } else {
            this.myObject.setText(this.textField.getText());
        }
        this.myObject.setMultiline(this.multilineBox.isSelected());
        this.myObject.setFaceName(this.faceNameField.getText());
        int n = this.alignLeftRadio.isSelected() ? 1 : (this.alignRightRadio.isSelected() ? 3 : 2);
        this.myObject.setAlignment(n);
        this.myObject.setTextColor(this.myTextColor);
        this.myObject.setBkColor(this.myBkColor);
        this.myObject.setTransparent(this.transparentBox.isSelected());
        this.myObject.setEditOnSingleClick(this.editSingle.isSelected());
        this.myObject.set2DScale(this.twoDScale.isSelected());
        this.myObject.setClipping(this.clipping.isSelected());
        this.myObject.setWrapping(this.wrapping.isSelected());
        this.myObject.setAutoResize(this.autoResize.isSelected());
        this.myObject.setSelectBackground(this.selectBack.isSelected());
        this.myObject.setWrappingWidth(Integer.parseInt(this.wrapwidth.getText()));
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            this.setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
        }
        super.setVisible(bl);
    }

    void OKButton_actionPerformed(ActionEvent actionEvent) {
        this.OnOK();
    }

    void OnOK() {
        try {
            this.UpdateControl();
            this.dispose();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
    }

    void CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.OnCancel();
    }

    void OnCancel() {
        try {
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void textColorButton_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Foreground Color", this.myTextColor);
        if (color != null) {
            this.myTextColor = color;
        }
    }

    void backgroundColorButton_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Foreground Color", this.myBkColor);
        if (color != null) {
            this.myBkColor = color;
        }
    }

    void OKButton_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.OnOK();
        } else if (keyEvent.getKeyCode() == 27) {
            this.OnCancel();
        }
    }

    void CancelButton_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.OnCancel();
        } else if (keyEvent.getKeyCode() == 27) {
            this.OnCancel();
        }
    }
}

