/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.webwalker;

import com.nwoods.jgo.examples.webwalker.Tag;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class HTMLDoc {
    protected URL myURL;
    protected String myText;
    protected Vector myLinks = new Vector();
    protected int myCurrentLink = 0;

    public HTMLDoc(URL uRL) {
        this.myURL = uRL;
    }

    public boolean loadPage() {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.myURL.openStream()));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error: Bad URL found " + this.myURL.toString());
            return false;
        }
        catch (IOException iOException) {
            System.err.println("Error: Could not open stream for " + this.myURL.toString());
            return false;
        }
        this.myText = "";
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                this.myText = this.myText + string + '\n';
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            System.err.println("Error: Exception reading stream");
            return false;
        }
        return true;
    }

    public boolean parsePage() {
        int n = 0;
        int n2;
        while ((n2 = this.myText.indexOf(60, n)) != -1) {
            n = this.myText.indexOf(62, n2);
            if (n == -1) {
                return false;
            }
            String string = this.myText.substring(n2 + 1, n);
            Tag tag = new Tag(string, this.myURL.toString());
            if (!tag.isLink()) continue;
            this.myLinks.addElement(tag);
        }
        return true;
    }

    public int getNumLinks() {
        return this.myLinks.size();
    }

    public boolean hasMoreLinks() {
        return this.myCurrentLink < this.myLinks.size();
    }

    public String nextLink() {
        return ((Tag)this.myLinks.elementAt(this.myCurrentLink++)).getValue("HREF");
    }
}

