/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.webwalker;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.webwalker.HTMLDoc;
import com.nwoods.jgo.examples.webwalker.WebView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;

public class WebNode
extends JGoNode {
    protected static int YINCREMENT = 75;
    protected static int XINCREMENT = 75;
    protected static int LABEL_OFFSET = 20;
    protected Object myUserData = null;
    protected URL myURL;
    protected JGoText myLabel;
    protected JGoObject myIcon;
    protected JGoPort myToPort = null;
    protected JGoPort myFromPort = null;

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        WebNode webNode = (WebNode)super.copyObject(jGoCopyEnvironment);
        if (webNode != null) {
            webNode.myUserData = this.myUserData;
            webNode.myURL = this.myURL;
        }
        return webNode;
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        WebNode webNode = (WebNode)jGoArea;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        webNode.myToPort = (JGoPort)jGoCopyEnvironment.get(this.myToPort);
        webNode.myFromPort = (JGoPort)jGoCopyEnvironment.get(this.myFromPort);
    }

    public void initialize(Point point, Dimension dimension, JGoObject jGoObject, String string, URL uRL) {
        this.myURL = uRL;
        this.setResizable(false);
        this.myIcon = jGoObject;
        this.myIcon.setBoundingRect(point, dimension);
        this.myIcon.setSelectable(false);
        this.addObjectAtHead(this.myIcon);
        Point point2 = this.myIcon.getSpotLocation(7);
        this.myLabel = new JGoText(new Point(point2.x, point2.y - LABEL_OFFSET), string);
        this.myLabel.setSelectable(false);
        this.addObjectAtHead(this.myLabel);
        Point point3 = this.myIcon.getSpotLocation(8);
        this.myToPort = new JGoPort(new Rectangle(point3.x, point3.y, 6, 6));
        this.myToPort.setFromSpot(8);
        this.addObjectAtTail(this.myToPort);
        point3 = this.myIcon.getSpotLocation(4);
        this.myFromPort = new JGoPort(new Rectangle(point3.x, point3.y, 6, 6));
        this.myFromPort.setToSpot(4);
        this.addObjectAtTail(this.myFromPort);
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        this.setInitializing(true);
        if (this.myLabel != null && this.myToPort != null && this.myFromPort != null) {
            this.myLabel.setSpotLocation(2, this.myIcon, 6);
            this.myToPort.setSpotLocation(0, this.myIcon, 8);
            this.myFromPort.setSpotLocation(0, this.myIcon, 4);
        }
        this.setInitializing(false);
    }

    public boolean doMouseDblClick(int n, Point point, Point point2, JGoView jGoView) {
        this.scanDoc(this.myURL, (WebView)jGoView);
        return true;
    }

    protected void scanDoc(URL uRL, WebView webView) {
        HTMLDoc hTMLDoc = new HTMLDoc(uRL);
        Cursor cursor = webView.getTopLevelAncestor().getCursor();
        webView.getTopLevelAncestor().setCursor(new Cursor(3));
        if (hTMLDoc.loadPage() && hTMLDoc.parsePage()) {
            Point point = this.getSpotLocation(4);
            int n = point.x + XINCREMENT;
            int n2 = Math.max(point.y - hTMLDoc.getNumLinks() * YINCREMENT / 2, 5);
            while (hTMLDoc.hasMoreLinks()) {
                String string = hTMLDoc.nextLink();
                if (string == null) continue;
                try {
                    URL uRL2 = new URL(this.myURL, string);
                    webView.createNode(string, uRL2, n, n2, this);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                n2 += YINCREMENT;
            }
        }
        webView.getTopLevelAncestor().setCursor(cursor);
    }

    public JGoPort getFromPort() {
        return this.myFromPort;
    }

    public JGoPort getToPort() {
        return this.myToPort;
    }
}

