/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.boxapp;

import com.nwoods.jgo.JGoBasicNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.boxapp.BoxArea;
import com.nwoods.jgo.examples.boxapp.BoxView;
import com.nwoods.jgo.examples.boxapp.TestSubGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class BoxApp
extends JApplet
implements Runnable {
    private static BoxApp myApp;
    private JGoView myView = new BoxView();
    private JLabel myStatusBarLabel;

    public BoxApp() {
        this.getContentPane().add((Component)this.myView, "Center");
        this.myStatusBarLabel = new JLabel();
        this.myStatusBarLabel.setText(" ");
        this.getContentPane().add((Component)this.myStatusBarLabel, "South");
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        this.myView.initializeDragDropHandling();
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setTitle("Box Application");
            jFrame.setSize(600, 500);
            myApp = new BoxApp();
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)myApp, "Center");
            container.validate();
            jFrame.setVisible(true);
            myApp.init();
            myApp.start();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public void init() {
        JGoDocument jGoDocument = this.myView.getDocument();
        jGoDocument.setLinksLayer(jGoDocument.addLayerAfter(jGoDocument.getDefaultLayer()));
        JGoBasicNode jGoBasicNode = new JGoBasicNode("first");
        jGoBasicNode.setLocation(new Point(100, 100));
        jGoBasicNode.setBrush(JGoBrush.blue);
        jGoDocument.add(jGoBasicNode);
        jGoBasicNode.setDragsNode(false);
        JGoBasicNode jGoBasicNode2 = new JGoBasicNode("second");
        jGoBasicNode2.setLocation(new Point(200, 100));
        jGoBasicNode2.setBrush(JGoBrush.magenta);
        jGoDocument.add(jGoBasicNode2);
        jGoBasicNode2.setDragsNode(false);
        BoxArea boxArea = new BoxArea("Box 1");
        boxArea.getBorder().setBoundingRect(50, 150, 200, 150);
        jGoDocument.add(boxArea);
        TestSubGraph testSubGraph = new TestSubGraph("Box 2");
        testSubGraph.getBorder().setBoundingRect(300, 150, 200, 150);
        jGoDocument.add(testSubGraph);
    }

    public static void setStatus(String string) {
        BoxApp.myApp.myStatusBarLabel.setText(string);
    }
}

