/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.boxapp;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoLabeledPart;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoRoundRect;
import com.nwoods.jgo.JGoSubGraphBase;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class BoxArea
extends JGoSubGraphBase
implements JGoLabeledPart {
    private static JGoPen myDefaultPen = JGoPen.make(1, 2, JGoBrush.ColorBlue);
    private static JGoBrush myDefaultBrush = JGoBrush.makeStockBrush(new Color(200, 200, 255, 63));
    private static JGoPen myHighlightPen = JGoPen.make(65535, 2, JGoBrush.ColorRed);
    private JGoDrawable myBorder = null;
    private JGoText myLabel = null;

    public BoxArea() {
    }

    public BoxArea(String string) {
        this.init();
        this.setText(string);
    }

    public void init() {
        this.setInitializing(true);
        this.setSelectable(true);
        this.setDragsNode(false);
        this.myBorder = new JGoRoundRect();
        this.myBorder.setSelectable(false);
        this.myBorder.setPen(myDefaultPen);
        this.myBorder.setBrush(myDefaultBrush);
        this.myBorder.setSize(100, 100);
        this.addObjectAtHead(this.myBorder);
        this.myLabel = new JGoText();
        this.myLabel.setText("Box");
        this.myLabel.setSelectable(false);
        this.myLabel.setEditable(true);
        this.myLabel.setEditOnSingleClick(true);
        this.addObjectAtTail(this.myLabel);
        this.setInitializing(false);
        this.layoutChildren(this.myBorder);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        BoxArea boxArea = (BoxArea)jGoArea;
        boxArea.myBorder = (JGoDrawable)jGoCopyEnvironment.get(this.myBorder);
        boxArea.myLabel = (JGoText)jGoCopyEnvironment.get(this.myLabel);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myBorder) {
            this.myBorder = null;
        } else if (jGoObject == this.myLabel) {
            this.myLabel = null;
        }
        return jGoObject;
    }

    public Rectangle computeBorder() {
        Rectangle rectangle = null;
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
            if (jGoObject == this.getBorder() || jGoObject == this.getLabel() || jGoObject instanceof JGoPort || jGoObject instanceof JGoLink) continue;
            if (rectangle == null) {
                Rectangle rectangle2 = jGoObject.getBoundingRect();
                rectangle = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                continue;
            }
            rectangle.add(jGoObject.getBoundingRect());
        }
        if (rectangle != null) {
            rectangle.grow(4, 4);
        }
        return rectangle;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        this.setInitializing(true);
        JGoDrawable jGoDrawable = this.getBorder();
        if (jGoDrawable == null) {
            return;
        }
        this.addObjectAtHead(jGoDrawable);
        if (jGoObject == jGoDrawable) {
            Rectangle rectangle = jGoDrawable.getBoundingRect();
            this.getLabel().setSpotLocation(7, rectangle.x, rectangle.y - 2);
        }
        this.setInitializing(false);
    }

    public void expandBorder() {
        Rectangle rectangle = this.computeBorder();
        if (rectangle != null) {
            rectangle.add(this.getBorder().getBoundingRect());
            this.getBorder().setBoundingRect(rectangle);
            if (this.getParent() instanceof BoxArea) {
                ((BoxArea)this.getParent()).expandBorder();
            }
        }
    }

    protected Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        Rectangle rectangle2 = this.computeResize(rectangle, point, n, n3, n4);
        rectangle2.y += this.getLabel().getHeight() + 2;
        rectangle2.height -= this.getLabel().getHeight() + 2;
        Rectangle rectangle3 = this.computeBorder();
        if (rectangle3 != null) {
            rectangle2.add(rectangle3);
        }
        this.getBorder().setBoundingRect(rectangle2);
        if (this.getParent() instanceof BoxArea) {
            ((BoxArea)this.getParent()).expandBorder();
        }
        return null;
    }

    public void setHighlit(boolean bl) {
        if (this.getBorder() != null) {
            this.setSkipsUndoManager(true);
            if (bl) {
                this.getBorder().setPen(myHighlightPen);
            } else {
                this.getBorder().setPen(myDefaultPen);
            }
            this.setSkipsUndoManager(false);
        }
    }

    public boolean isHighlit() {
        return this.getBorder() != null && this.getBorder().getPen() == myHighlightPen;
    }

    public JGoDrawable getBorder() {
        return this.myBorder;
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public String getText() {
        return this.getLabel().getText();
    }

    public void setText(String string) {
        if (this.getLabel() != null) {
            this.getLabel().setText(string);
        }
    }
}

