/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.boxapp;

import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.boxapp.BoxApp;
import com.nwoods.jgo.examples.boxapp.BoxArea;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

public class BoxView
extends JGoView {
    private BoxArea myHighlitBox = null;

    public boolean doMouseUp(int n, Point point, Point point2) {
        if (this.getState() == 2) {
            this.considerBox(point);
        }
        return super.doMouseUp(n, point, point2);
    }

    public boolean doMouseMove(int n, Point point, Point point2) {
        if (this.getState() == 2) {
            this.considerBox(point);
        }
        return super.doMouseMove(n, point, point2);
    }

    public void doUncapturedMouseMove(int n, Point point, Point point2) {
        this.setHighlit(null);
        super.doUncapturedMouseMove(n, point, point2);
    }

    private void considerBox(Point point) {
        JGoObject jGoObject;
        for (jGoObject = this.pickObjectExcluding(point, true, this.getSelection()); jGoObject != null && !(jGoObject instanceof BoxArea); jGoObject = jGoObject.getParent()) {
        }
        if (jGoObject instanceof BoxArea) {
            this.setHighlit((BoxArea)jGoObject);
        } else {
            this.setHighlit(null);
        }
        BoxApp.setStatus(" ");
    }

    public BoxArea getHighlit() {
        return this.myHighlitBox;
    }

    public void setHighlit(BoxArea boxArea) {
        BoxArea boxArea2 = this.getHighlit();
        if (boxArea2 != boxArea) {
            if (boxArea2 != null) {
                boxArea2.setHighlit(false);
            }
            this.myHighlitBox = boxArea;
            if (boxArea != null) {
                boxArea.setHighlit(true);
            }
        }
    }

    public JGoObject pickObjectExcluding(Point point, boolean bl, JGoObjectSimpleCollection jGoObjectSimpleCollection) {
        ArrayList arrayList = new ArrayList();
        JGoLayer jGoLayer = this.getLastLayer();
        while (jGoLayer != null) {
            arrayList.clear();
            jGoLayer.pickObjects(point, bl, arrayList, 999999);
            for (int i = 0; i < arrayList.size(); ++i) {
                JGoObject jGoObject = (JGoObject)arrayList.get(i);
                boolean bl2 = false;
                JGoListPosition jGoListPosition = jGoObjectSimpleCollection.getFirstObjectPos();
                while (jGoListPosition != null) {
                    JGoObject jGoObject2 = jGoObjectSimpleCollection.getObjectAtPos(jGoListPosition);
                    jGoListPosition = jGoObjectSimpleCollection.getNextObjectPosAtTop(jGoListPosition);
                    if (jGoObject == jGoObject2 || jGoObject.isChildOf(jGoObject2)) {
                        bl2 = true;
                        break;
                    }
                    if (!(jGoObject instanceof BoxArea) || jGoObject2.getParent() != jGoObject || ((BoxArea)jGoObject).getBorder().isPointInObj(point)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                return jGoObject;
            }
            jGoLayer = this.getPrevLayer(jGoLayer);
        }
        return null;
    }

    public void fireUpdate(int n, int n2, Object object, Point point, Point point2, int n3) {
        super.fireUpdate(n, n2, object, point, point2, n3);
        if (n == 26 || n == 27) {
            BoxArea boxArea = this.getHighlit();
            JGoLayer jGoLayer = this.getDocument().getDefaultLayer();
            if (boxArea != null) {
                this.getSelection().addCollection(boxArea.addCollection(this.getSelection(), true, jGoLayer));
                boxArea.expandBorder();
                BoxApp.setStatus("added to " + boxArea.getText());
            } else {
                this.getSelection().addCollection(jGoLayer.addCollection(this.getSelection(), true, jGoLayer));
                BoxApp.setStatus("moved to top-level");
            }
        } else if (n == 31 && object instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)object;
            jGoLink.setArrowHeads(false, true);
        }
    }

    public void onKeyEvent(KeyEvent keyEvent) {
        super.onKeyEvent(keyEvent);
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            this.deleteSelection();
        } else if (keyEvent.isControlDown() && n == 65) {
            this.selectAll();
        } else if (keyEvent.isControlDown() && n == 88) {
            this.cut();
        } else if (keyEvent.isControlDown() && n == 67) {
            this.copy();
        } else if (keyEvent.isControlDown() && n == 86) {
            this.paste();
        } else if (keyEvent.isControlDown() && n == 90) {
            this.getDocument().undo();
        } else if (keyEvent.isControlDown() && n == 89) {
            this.getDocument().redo();
        }
    }
}

