/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.boxapp;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.boxapp.BoxArea;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class TestSubGraph
extends BoxArea {
    private JGoPort myInput = null;
    private JGoPort myOutput = null;

    public TestSubGraph() {
    }

    public TestSubGraph(String string) {
        super(string);
        this.initPorts();
    }

    public void initPorts() {
        this.setInitializing(true);
        this.myInput = new JGoPort();
        this.myInput.setSize(7, 7);
        this.myInput.setBrush(JGoBrush.green);
        this.myInput.setStyle(3);
        this.myInput.setValidSource(false);
        this.addObjectAtTail(this.myInput);
        this.myOutput = new JGoPort();
        this.myOutput.setSize(7, 7);
        this.myOutput.setBrush(JGoBrush.green);
        this.myOutput.setStyle(3);
        this.myOutput.setValidDestination(false);
        this.addObjectAtTail(this.myOutput);
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        TestSubGraph testSubGraph = (TestSubGraph)jGoArea;
        testSubGraph.myInput = (JGoPort)jGoCopyEnvironment.get(this.myInput);
        testSubGraph.myOutput = (JGoPort)jGoCopyEnvironment.get(this.myOutput);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myInput) {
            this.myInput = null;
        } else if (jGoObject == this.myOutput) {
            this.myOutput = null;
        }
        return jGoObject;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        super.layoutChildren(jGoObject);
        if (this.getBorder() == null) {
            return;
        }
        Rectangle rectangle = this.getBorder().getBoundingRect();
        this.setInitializing(true);
        if (this.getInput() != null) {
            this.getInput().setSpotLocation(4, new Point(rectangle.x, rectangle.y + rectangle.height / 2));
        }
        if (this.getOutput() != null) {
            this.getOutput().setSpotLocation(8, new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2));
        }
        this.setInitializing(false);
    }

    protected Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        Rectangle rectangle2;
        Rectangle rectangle3 = this.computeResize(rectangle, point, n, n3, n4);
        rectangle3.y += this.getLabel().getHeight() + 2;
        rectangle3.height -= this.getLabel().getHeight() + 2;
        if (this.getInput() != null && this.getOutput() != null) {
            rectangle3.x += this.getInput().getWidth();
            rectangle3.width -= this.getInput().getWidth() + this.getOutput().getWidth();
        }
        if ((rectangle2 = this.computeBorder()) != null) {
            rectangle3.add(rectangle2);
        }
        this.getBorder().setBoundingRect(rectangle3);
        if (this.getParent() instanceof BoxArea) {
            ((BoxArea)this.getParent()).expandBorder();
        }
        return null;
    }

    public JGoPort getInput() {
        return this.myInput;
    }

    public JGoPort getOutput() {
        return this.myOutput;
    }
}

