/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.GeneralNodeLabel;
import com.nwoods.jgo.examples.GeneralNodePort;
import com.nwoods.jgo.examples.GeneralNodePortLabel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class GeneralNode
extends JGoNode {
    public static final int PortInsertedChanged = 75545;
    public static final int PortRemovedChanged = 75546;
    public static final int PortSetChanged = 75547;
    protected JGoText myTopLabel = null;
    protected JGoText myBottomLabel = null;
    protected JGoObject myIcon = null;
    protected ArrayList myLeftPorts = new ArrayList();
    protected ArrayList myRightPorts = new ArrayList();

    public void initialize(Point point, Dimension dimension, JGoObject jGoObject, String string, String string2, int n, int n2) {
        GeneralNodePortLabel generalNodePortLabel;
        GeneralNodePort generalNodePort;
        String string3;
        int n3;
        this.setInitializing(true);
        this.setDraggable(true);
        this.setResizable(false);
        this.set4ResizeHandles(true);
        this.myIcon = jGoObject;
        if (this.myIcon != null) {
            this.myIcon.setBoundingRect(point, dimension);
            this.myIcon.setSelectable(false);
            this.addObjectAtHead(this.myIcon);
        }
        if (string != null) {
            this.myTopLabel = new GeneralNodeLabel(string, this);
        }
        if (string2 != null) {
            this.myBottomLabel = new GeneralNodeLabel(string2, this);
        }
        for (n3 = 0; n3 < n; ++n3) {
            string3 = Integer.toString(n3);
            generalNodePort = new GeneralNodePort(true, string3, this);
            generalNodePortLabel = new GeneralNodePortLabel(string3, generalNodePort);
            this.addLeftPort(generalNodePort);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            string3 = Integer.toString(n3);
            generalNodePort = new GeneralNodePort(false, string3, this);
            generalNodePortLabel = new GeneralNodePortLabel(string3, generalNodePort);
            this.addRightPort(generalNodePort);
        }
        this.setInitializing(false);
        this.layoutChildren(null);
        this.setTopLeft(point);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        GeneralNodePortLabel generalNodePortLabel;
        GeneralNodePortLabel generalNodePortLabel2;
        GeneralNodePort generalNodePort;
        GeneralNodePort generalNodePort2;
        int n;
        GeneralNode generalNode = (GeneralNode)jGoArea;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        generalNode.myIcon = (JGoObject)jGoCopyEnvironment.get(this.myIcon);
        generalNode.myTopLabel = (JGoText)jGoCopyEnvironment.get(this.myTopLabel);
        generalNode.myBottomLabel = (JGoText)jGoCopyEnvironment.get(this.myBottomLabel);
        for (n = 0; n < this.myLeftPorts.size(); ++n) {
            generalNodePort2 = (GeneralNodePort)this.myLeftPorts.get(n);
            if (generalNodePort2 == null || (generalNodePort = (GeneralNodePort)jGoCopyEnvironment.get(generalNodePort2)) == null) continue;
            generalNode.myLeftPorts.add(generalNodePort);
            generalNodePort.setSideIndex(true, generalNode.myLeftPorts.size() - 1);
            generalNodePortLabel2 = generalNodePort2.getLabel();
            if (generalNodePortLabel2 == null || (generalNodePortLabel = (GeneralNodePortLabel)jGoCopyEnvironment.get(generalNodePortLabel2)) == null) continue;
            generalNodePort.setLabel(generalNodePortLabel);
        }
        for (n = 0; n < this.myRightPorts.size(); ++n) {
            generalNodePort2 = (GeneralNodePort)this.myRightPorts.get(n);
            if (generalNodePort2 == null || (generalNodePort = (GeneralNodePort)jGoCopyEnvironment.get(generalNodePort2)) == null) continue;
            generalNode.myRightPorts.add(generalNodePort);
            generalNodePort.setSideIndex(false, generalNode.myRightPorts.size() - 1);
            generalNodePortLabel2 = generalNodePort2.getLabel();
            if (generalNodePortLabel2 == null || (generalNodePortLabel = (GeneralNodePortLabel)jGoCopyEnvironment.get(generalNodePortLabel2)) == null) continue;
            generalNodePort.setLabel(generalNodePortLabel);
        }
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myTopLabel) {
            this.myTopLabel = null;
        } else if (jGoObject == this.myBottomLabel) {
            this.myBottomLabel = null;
        } else if (jGoObject == this.myIcon) {
            this.myIcon = null;
        }
        return jGoObject;
    }

    public void layoutChildren(JGoObject jGoObject) {
        GeneralNodePort generalNodePort;
        int n;
        int n2;
        int n3;
        if (this.isInitializing()) {
            return;
        }
        this.setInitializing(true);
        JGoObject jGoObject2 = this.getIcon();
        JGoText jGoText = this.getTopLabel();
        JGoText jGoText2 = this.getBottomLabel();
        int n4 = this.getNumLeftPorts();
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            GeneralNodePort generalNodePort2 = this.getLeftPort(n3);
            if (!generalNodePort2.isVisible()) continue;
            n5 += this.getPortAndLabelHeight(generalNodePort2);
            n6 = Math.max(n6, this.getPortAndLabelWidth(generalNodePort2));
        }
        if (jGoObject2 != null) {
            Dimension dimension = this.getMinimumIconSize();
            int n7 = Math.max(dimension.width, jGoObject2.getWidth());
            n2 = Math.max(dimension.height, jGoObject2.getHeight());
            jGoObject2.setBoundingRect(jGoObject2.getLeft() - (n7 - jGoObject2.getWidth()) / 2, jGoObject2.getTop() - (n2 - jGoObject2.getHeight()) / 2, n7, n2);
        }
        n3 = 0;
        int n8 = 0;
        n3 = jGoObject2 != null ? jGoObject2.getLeft() : this.getLeft();
        n8 = jGoObject2 != null ? jGoObject2.getTop() : this.getTop() + (jGoText != null ? jGoText.getHeight() : 0);
        if (jGoObject2 != null && jGoObject2.getHeight() > n5) {
            n8 += (jGoObject2.getHeight() - n5) / 2;
        }
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            generalNodePort = this.getLeftPort(n);
            if (!generalNodePort.isVisible()) continue;
            generalNodePort.setSpotLocation(4, n3, n8 + (n2 += this.getPortAndLabelHeight(generalNodePort) / 2));
            generalNodePort.layoutLabel();
            n2 += this.getPortAndLabelHeight(generalNodePort) / 2;
        }
        n4 = this.getNumRightPorts();
        n5 = 0;
        for (n = 0; n < n4; ++n) {
            generalNodePort = this.getRightPort(n);
            if (!generalNodePort.isVisible()) continue;
            n5 += this.getPortAndLabelHeight(generalNodePort);
        }
        n3 = jGoObject2 != null ? jGoObject2.getLeft() + jGoObject2.getWidth() : this.getLeft() + this.getWidth();
        n8 = jGoObject2 != null ? jGoObject2.getTop() : this.getTop() + (jGoText != null ? jGoText.getHeight() : 0);
        if (jGoObject2 != null && jGoObject2.getHeight() > n5) {
            n8 += (jGoObject2.getHeight() - n5) / 2;
        }
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            generalNodePort = this.getRightPort(n);
            if (!generalNodePort.isVisible()) continue;
            generalNodePort.setSpotLocation(8, n3, n8 + (n2 += this.getPortAndLabelHeight(generalNodePort) / 2));
            generalNodePort.layoutLabel();
            n2 += this.getPortAndLabelHeight(generalNodePort) / 2;
        }
        if (jGoText != null) {
            if (jGoObject2 != null) {
                jGoText.setSpotLocation(6, jGoObject2, 2);
            } else {
                jGoText.setSpotLocation(2, this, 2);
            }
        }
        if (jGoText2 != null) {
            if (jGoObject2 != null) {
                jGoText2.setSpotLocation(2, jGoObject2, 6);
            } else {
                jGoText2.setSpotLocation(6, this, 6);
            }
        }
        this.setInitializing(false);
    }

    public void rescaleChildren(Rectangle rectangle) {
        if (this.getIcon() != null && this.getIcon().isVisible()) {
            int n = this.getIcon().getWidth();
            int n2 = this.getIcon().getHeight();
            if (n <= 0) {
                n = 1;
            }
            double d = (double)n2 / (double)n;
            Dimension dimension = this.getMinimumSizeWithIconSize(0, 0);
            int n3 = this.getWidth() - dimension.width;
            int n4 = this.getHeight();
            if (this.getTopLabel() != null && this.getTopLabel().isVisible()) {
                n4 -= this.getTopLabel().getHeight();
            }
            if (this.getBottomLabel() != null && this.getBottomLabel().isVisible()) {
                n4 -= this.getBottomLabel().getHeight();
            }
            Dimension dimension2 = this.getMinimumIconSize();
            n3 = Math.max(n3, dimension2.width);
            double d2 = (double)(n4 = Math.max(n4, dimension2.height)) / (double)n3;
            if (d < d2) {
                n4 = (int)Math.rint(d * (double)n3);
            } else {
                n3 = (int)Math.rint((double)n4 / d);
            }
            this.getIcon().setSize(n3, n4);
        }
    }

    public int getPortAndLabelWidth(GeneralNodePort generalNodePort) {
        if (!generalNodePort.isVisible()) {
            return 0;
        }
        GeneralNodePortLabel generalNodePortLabel = generalNodePort.getLabel();
        if (generalNodePortLabel != null && generalNodePortLabel.isVisible()) {
            return generalNodePort.getWidth() + generalNodePort.getLabelSpacing() + generalNodePortLabel.getWidth();
        }
        return generalNodePort.getWidth();
    }

    public int getPortAndLabelHeight(GeneralNodePort generalNodePort) {
        if (!generalNodePort.isVisible()) {
            return 0;
        }
        GeneralNodePortLabel generalNodePortLabel = generalNodePort.getLabel();
        if (generalNodePortLabel != null && generalNodePortLabel.isVisible()) {
            return Math.max(generalNodePort.getHeight(), generalNodePortLabel.getHeight());
        }
        return generalNodePort.getHeight();
    }

    public Dimension getMinimumSizeWithIconSize(int n, int n2) {
        JGoObject jGoObject;
        int n3;
        int n4 = this.getNumLeftPorts();
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            jGoObject = this.getLeftPort(n3);
            n5 = Math.max(n5, this.getPortAndLabelWidth((GeneralNodePort)jGoObject));
            n6 += this.getPortAndLabelHeight((GeneralNodePort)jGoObject);
        }
        n += n5;
        n2 = Math.max(n2, n6);
        n4 = this.getNumRightPorts();
        n5 = 0;
        n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            jGoObject = this.getRightPort(n3);
            n5 = Math.max(n5, this.getPortAndLabelWidth((GeneralNodePort)jGoObject));
            n6 += this.getPortAndLabelHeight((GeneralNodePort)jGoObject);
        }
        n += n5;
        n2 = Math.max(n2, n6);
        n3 = 0;
        jGoObject = this.getTopLabel();
        if (jGoObject != null && jGoObject.isVisible()) {
            n = Math.max(n, jGoObject.getWidth());
            n2 += jGoObject.getHeight();
        }
        if ((jGoObject = this.getBottomLabel()) != null && jGoObject.isVisible()) {
            n = Math.max(n, jGoObject.getWidth());
            n2 += jGoObject.getHeight();
        }
        return new Dimension(n, n2);
    }

    public Dimension getMinimumIconSize() {
        return new Dimension(20, 20);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getMinimumIconSize();
        int n = dimension.width;
        int n2 = dimension.height;
        return this.getMinimumSizeWithIconSize(n, n2);
    }

    public void setBoundingRect(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getMinimumSize();
        super.setBoundingRect(n, n2, Math.max(n3, dimension.width), Math.max(n4, dimension.height));
    }

    protected Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        Dimension dimension = this.getMinimumSize();
        Rectangle rectangle2 = super.handleResize(graphics2D, jGoView, rectangle, point, n, n2, Math.max(n3, dimension.width), Math.max(n4, dimension.height));
        if (n2 == 2) {
            this.setBoundingRect(rectangle2);
        }
        return null;
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("toplabel")) {
            this.myTopLabel = (JGoText)object;
        } else if (string.equals("bottomlabel")) {
            this.myBottomLabel = (JGoText)object;
        } else if (string.equals("icon")) {
            this.myIcon = (JGoObject)object;
        } else if (string.equals("leftports")) {
            this.myLeftPorts.add(object);
        } else if (string.equals("rightports")) {
            this.myRightPorts.add(object);
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            int n;
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.GeneralNode", domElement);
            if (this.myTopLabel != null) {
                domDoc.registerReferencingNode(domElement2, "toplabel", this.myTopLabel);
            }
            if (this.myBottomLabel != null) {
                domDoc.registerReferencingNode(domElement2, "bottomlabel", this.myBottomLabel);
            }
            if (this.myIcon != null) {
                domDoc.registerReferencingNode(domElement2, "icon", this.myIcon);
            }
            for (n = 0; n < this.myLeftPorts.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "leftports", (GeneralNodePort)this.myLeftPorts.get(n));
            }
            for (n = 0; n < this.myRightPorts.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "rightports", (GeneralNodePort)this.myRightPorts.get(n));
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            String string = domElement2.getAttribute("toplabel");
            domDoc.registerReferencingObject(this, "toplabel", string);
            String string2 = domElement2.getAttribute("bottomlabel");
            domDoc.registerReferencingObject(this, "bottomlabel", string2);
            String string3 = domElement2.getAttribute("icon");
            domDoc.registerReferencingObject(this, "icon", string3);
            String string4 = domElement2.getAttribute("leftports");
            while (string4.length() > 0) {
                int n = string4.indexOf(" ");
                if (n == -1) {
                    n = string4.length();
                }
                String string5 = string4.substring(0, n);
                string4 = n >= string4.length() ? "" : string4.substring(n + 1);
                domDoc.registerReferencingObject(this, "leftports", string5);
            }
            String string6 = domElement2.getAttribute("rightports");
            while (string6.length() > 0) {
                int n = string6.indexOf(" ");
                if (n == -1) {
                    n = string6.length();
                }
                String string7 = string6.substring(0, n);
                string6 = n >= string6.length() ? "" : string6.substring(n + 1);
                domDoc.registerReferencingObject(this, "rightports", string7);
            }
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public JGoText getTopLabel() {
        return this.myTopLabel;
    }

    public JGoText getBottomLabel() {
        return this.myBottomLabel;
    }

    public JGoObject getIcon() {
        return this.myIcon;
    }

    public int getNumLeftPorts() {
        return this.myLeftPorts.size();
    }

    public int getNumRightPorts() {
        return this.myRightPorts.size();
    }

    public GeneralNodePort getLeftPort(int n) {
        if (n < 0 || n >= this.myLeftPorts.size()) {
            return null;
        }
        return (GeneralNodePort)this.myLeftPorts.get(n);
    }

    public GeneralNodePort getRightPort(int n) {
        if (n < 0 || n >= this.myRightPorts.size()) {
            return null;
        }
        return (GeneralNodePort)this.myRightPorts.get(n);
    }

    void initializePort(GeneralNodePort generalNodePort) {
        if (generalNodePort == null) {
            return;
        }
        generalNodePort.setSelectable(false);
        generalNodePort.setDraggable(false);
        generalNodePort.setResizable(false);
        if (generalNodePort.getParent() == null) {
            this.addObjectAtTail(generalNodePort);
            if (generalNodePort.getLabel() != null) {
                this.addObjectAtTail(generalNodePort.getLabel());
            }
        }
    }

    public final void addLeftPort(GeneralNodePort generalNodePort) {
        this.insertLeftPort(this.getNumLeftPorts(), generalNodePort);
    }

    public final void addRightPort(GeneralNodePort generalNodePort) {
        this.insertRightPort(this.getNumRightPorts(), generalNodePort);
    }

    public void insertLeftPort(int n, GeneralNodePort generalNodePort) {
        if (generalNodePort == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (n < this.myLeftPorts.size()) {
            this.myLeftPorts.add(n, generalNodePort);
            generalNodePort.setSideIndex(true, n);
        } else {
            this.myLeftPorts.add(generalNodePort);
            generalNodePort.setSideIndex(true, this.myLeftPorts.size() - 1);
        }
        this.initializePort(generalNodePort);
        this.layoutChildren(generalNodePort);
        this.update(75545, -(n + 1), generalNodePort);
    }

    public void insertRightPort(int n, GeneralNodePort generalNodePort) {
        if (generalNodePort == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (n < this.myRightPorts.size()) {
            this.myRightPorts.add(n, generalNodePort);
            generalNodePort.setSideIndex(false, n);
        } else {
            this.myRightPorts.add(generalNodePort);
            generalNodePort.setSideIndex(false, this.myRightPorts.size() - 1);
        }
        this.initializePort(generalNodePort);
        this.layoutChildren(generalNodePort);
        this.update(75545, n, generalNodePort);
    }

    void deletePort(GeneralNodePort generalNodePort) {
        if (generalNodePort != null) {
            if (generalNodePort.getLabel() != null) {
                this.removeObject(generalNodePort.getLabel());
            }
            this.removeObject(generalNodePort);
            generalNodePort.setSideIndex(generalNodePort.isOnLeftSide(), -1);
        }
    }

    public void removeLeftPort(int n) {
        if (n < 0 || n >= this.myLeftPorts.size()) {
            return;
        }
        GeneralNodePort generalNodePort = (GeneralNodePort)this.myLeftPorts.remove(n);
        this.deletePort(generalNodePort);
        this.layoutChildren(generalNodePort);
        this.update(75546, -(n + 1), generalNodePort);
    }

    public void removeRightPort(int n) {
        if (n < 0 || n >= this.myRightPorts.size()) {
            return;
        }
        GeneralNodePort generalNodePort = (GeneralNodePort)this.myRightPorts.remove(n);
        this.deletePort(generalNodePort);
        this.layoutChildren(generalNodePort);
        this.update(75546, n, generalNodePort);
    }

    public void setLeftPort(int n, GeneralNodePort generalNodePort) {
        GeneralNodePort generalNodePort2 = this.getLeftPort(n);
        if (generalNodePort2 != generalNodePort) {
            if (generalNodePort2 != null) {
                if (generalNodePort != null) {
                    generalNodePort.setBoundingRect(generalNodePort2.getBoundingRect());
                }
                this.removeObject(generalNodePort2);
            }
            this.myLeftPorts.set(n, generalNodePort);
            generalNodePort.setSideIndex(true, n);
            this.initializePort(generalNodePort);
            this.update(75547, -(n + 1), generalNodePort2);
        }
    }

    public void setRightPort(int n, GeneralNodePort generalNodePort) {
        GeneralNodePort generalNodePort2 = this.getRightPort(n);
        if (generalNodePort2 != generalNodePort) {
            if (generalNodePort2 != null) {
                if (generalNodePort != null) {
                    generalNodePort.setBoundingRect(generalNodePort2.getBoundingRect());
                }
                this.removeObject(generalNodePort2);
            }
            this.myRightPorts.set(n, generalNodePort);
            generalNodePort.setSideIndex(false, n);
            this.initializePort(generalNodePort);
            this.update(75547, n, generalNodePort2);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75545: {
                return;
            }
            case 75546: {
                return;
            }
            case 75547: {
                int n = jGoDocumentChangedEdit.getOldValueInt();
                if (n < 0) {
                    jGoDocumentChangedEdit.setNewValue(this.getLeftPort(-n - 1));
                } else {
                    jGoDocumentChangedEdit.setNewValue(this.getRightPort(n));
                }
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75545: {
                int n = jGoDocumentChangedEdit.getOldValueInt();
                if (n < 0) {
                    n = -n - 1;
                    if (bl) {
                        this.removeLeftPort(n);
                    } else {
                        this.insertLeftPort(n, (GeneralNodePort)jGoDocumentChangedEdit.getOldValue());
                    }
                } else if (bl) {
                    this.removeRightPort(n);
                } else {
                    this.insertRightPort(n, (GeneralNodePort)jGoDocumentChangedEdit.getOldValue());
                }
                return;
            }
            case 75546: {
                int n = jGoDocumentChangedEdit.getOldValueInt();
                if (n < 0) {
                    n = -n - 1;
                    if (bl) {
                        this.insertLeftPort(n, (GeneralNodePort)jGoDocumentChangedEdit.getOldValue());
                    } else {
                        this.removeLeftPort(n);
                    }
                } else if (bl) {
                    this.insertRightPort(n, (GeneralNodePort)jGoDocumentChangedEdit.getOldValue());
                } else {
                    this.removeRightPort(n);
                }
                return;
            }
            case 75547: {
                int n = jGoDocumentChangedEdit.getOldValueInt();
                if (n < 0) {
                    n = -n - 1;
                    this.setLeftPort(n, (GeneralNodePort)jGoDocumentChangedEdit.getValue(bl));
                } else {
                    this.setRightPort(n, (GeneralNodePort)jGoDocumentChangedEdit.getValue(bl));
                }
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

