/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.examples.GeneralNode;
import com.nwoods.jgo.examples.GeneralNodePortLabel;
import java.awt.Point;
import java.awt.Rectangle;

public class GeneralNodePort
extends JGoPort {
    public static final int NameChanged = 75550;
    public static final int LabelChanged = 75551;
    private static Rectangle myTriangleRect = new Rectangle(0, 0, 8, 8);
    private boolean myLeftSide = true;
    private int myIndex = 0;
    private GeneralNodePortLabel myPortLabel = null;
    private String myName = "";

    public GeneralNodePort() {
    }

    public GeneralNodePort(boolean bl, String string, JGoArea jGoArea) {
        super(GeneralNodePort.TriangleRect());
        this.initialize(bl, string, jGoArea);
    }

    public void initialize(boolean bl, String string, JGoArea jGoArea) {
        this.setSelectable(false);
        this.setDraggable(false);
        this.setResizable(false);
        this.setVisible(true);
        this.setStyle(3);
        this.setPen(JGoPen.darkGray);
        this.setBrush(JGoBrush.lightGray);
        if (bl) {
            this.myLeftSide = true;
            this.setValidSource(false);
            this.setValidDestination(true);
            this.setToSpot(8);
        } else {
            this.myLeftSide = false;
            this.setValidSource(true);
            this.setValidDestination(false);
            this.setFromSpot(4);
        }
        this.setTopLeft(jGoArea.getLeft(), jGoArea.getTop());
        jGoArea.addObjectAtTail(this);
        this.setName(string);
    }

    public final boolean isInput() {
        return this.isValidDestination();
    }

    public final boolean isOutput() {
        return this.isValidSource();
    }

    public boolean validLink(JGoPort jGoPort) {
        if (jGoPort.getParent() == null) {
            return false;
        }
        if (jGoPort instanceof GeneralNodePort) {
            return super.validLink(jGoPort) && this.getParent() != jGoPort.getParent() && this.isOutput() && jGoPort instanceof GeneralNodePort && ((GeneralNodePort)jGoPort).isInput() && !this.alreadyLinked(jGoPort);
        }
        return super.validLink(jGoPort) && this.getParent() != jGoPort.getParent() && this.isOutput();
    }

    public boolean alreadyLinked(JGoPort jGoPort) {
        JGoListPosition jGoListPosition = this.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = this.getLinkAtPos(jGoListPosition);
            jGoListPosition = this.getNextLinkPos(jGoListPosition);
            if (jGoLink.getFromPort() != this || jGoLink.getToPort() != jGoPort) continue;
            return true;
        }
        return false;
    }

    public boolean isOnLeftSide() {
        return this.myLeftSide;
    }

    public int getIndex() {
        return this.myIndex;
    }

    void setSideIndex(boolean bl, int n) {
        this.myLeftSide = bl;
        this.myIndex = n;
    }

    public GeneralNodePortLabel getLabel() {
        return this.myPortLabel;
    }

    public void setLabel(GeneralNodePortLabel generalNodePortLabel) {
        GeneralNodePortLabel generalNodePortLabel2 = this.myPortLabel;
        if (generalNodePortLabel2 != generalNodePortLabel) {
            if (generalNodePortLabel2 != null) {
                if (this.getParent() != null) {
                    this.getParent().removeObject(generalNodePortLabel2);
                }
                generalNodePortLabel2.setPartner(null);
            }
            this.myPortLabel = generalNodePortLabel;
            if (generalNodePortLabel != null) {
                generalNodePortLabel.setPartner(this);
                if (this.isOnLeftSide()) {
                    generalNodePortLabel.setAlignment(3);
                } else {
                    generalNodePortLabel.setAlignment(1);
                }
                if (this.getParent() != null) {
                    this.getParent().addObjectAtTail(generalNodePortLabel);
                }
            }
            this.layoutLabel();
            this.update(75551, 0, generalNodePortLabel2);
        }
    }

    public void layoutLabel() {
        if (this.getLabel() != null) {
            if (this.isOnLeftSide()) {
                this.getLabel().setSpotLocation(4, this, 8);
                this.getLabel().setLeft(this.getLabel().getLeft() - this.getLabelSpacing());
            } else {
                this.getLabel().setSpotLocation(8, this, 4);
                this.getLabel().setLeft(this.getLabel().getLeft() + this.getLabelSpacing());
            }
        }
    }

    public int getLabelSpacing() {
        return 2;
    }

    public Point getLinkPoint(int n, Point point) {
        switch (n) {
            default: {
                return super.getLinkPoint(n, point);
            }
            case 4: {
                Rectangle rectangle = this.getBoundingRect();
                if (point == null) {
                    point = new Point(0, 0);
                }
                point.x = rectangle.x + rectangle.width;
                point.y = rectangle.y + rectangle.height / 2;
                GeneralNodePortLabel generalNodePortLabel = this.getLabel();
                if (generalNodePortLabel == null || !generalNodePortLabel.isVisible()) break;
                point.x += generalNodePortLabel.getWidth() + this.getLabelSpacing();
                break;
            }
            case 8: {
                Rectangle rectangle = this.getBoundingRect();
                if (point == null) {
                    point = new Point(0, 0);
                }
                point.x = rectangle.x;
                point.y = rectangle.y + rectangle.height / 2;
                GeneralNodePortLabel generalNodePortLabel = this.getLabel();
                if (generalNodePortLabel == null || !generalNodePortLabel.isVisible()) break;
                point.x -= generalNodePortLabel.getWidth() + this.getLabelSpacing();
            }
        }
        return point;
    }

    public Point getLinkPointFromPoint(int n, int n2, Point point) {
        if (this.isOnLeftSide()) {
            return this.getLinkPoint(8, point);
        }
        return this.getLinkPoint(4, point);
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        String string2 = this.myName;
        if (!string2.equals(string)) {
            this.myName = string;
            if (this.getLabel() != null) {
                this.getLabel().setText(string);
            }
            this.update(75550, 0, string2);
        }
    }

    public GeneralNode getNode() {
        return (GeneralNode)this.getParent();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75550: {
                jGoDocumentChangedEdit.setNewValue(this.getName());
                return;
            }
            case 75551: {
                jGoDocumentChangedEdit.setNewValue(this.getLabel());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75550: {
                this.setName((String)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75551: {
                this.setLabel((GeneralNodePortLabel)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("portlabel")) {
            this.myPortLabel = (GeneralNodePortLabel)object;
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.GeneralNodePort", domElement);
            domElement2.setAttribute("index", Integer.toString(this.myIndex));
            domElement2.setAttribute("leftside", this.myLeftSide ? "true" : "false");
            domElement2.setAttribute("name", this.myName);
            if (this.myPortLabel != null) {
                domDoc.registerReferencingNode(domElement2, "portlabel", this.myPortLabel);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.myIndex = Integer.parseInt(domElement2.getAttribute("index"));
            this.myLeftSide = domElement2.getAttribute("leftside").equals("true");
            this.myName = domElement2.getAttribute("name");
            String string = domElement2.getAttribute("portlabel");
            domDoc.registerReferencingObject(this, "portlabel", string);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public static Rectangle TriangleRect() {
        return myTriangleRect;
    }
}

