/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.JGoCopyMap;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoIconicNode;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPalette;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoUndoManager;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class IconicApp
extends JApplet
implements JGoViewListener {
    private JGoView myView = new JGoView(){

        public void doUncapturedMouseMove(int n, Point point, Point point2) {
            if (IconicApp.this.myPointToSelectModeCheckBox.isSelected()) {
                IconicApp.this.handleSelectionUnderMouse(point);
            }
            super.doUncapturedMouseMove(n, point, point2);
        }
    };
    private JGoPalette myPalette;
    private JPanel myPanel;
    private JCheckBox myPointToSelectModeCheckBox;
    private JCheckBox myInsertModeCheckBox;
    private JCheckBox myLinkModeCheckBox;
    private JLabel myStatusBarLabel;
    private int myNodeCounter = 0;
    static /* synthetic */ Class class$com$nwoods$jgo$examples$IconicApp;

    public IconicApp() {
        this.myView.setBorder(new EtchedBorder());
        this.myView.setHidingDisabledScrollbars(true);
        this.myView.getDocument().setDocumentSize(400, 300);
        this.myPalette = new JGoPalette();
        this.myPanel = new JPanel();
        this.myPanel.setLayout(new FlowLayout());
        this.myInsertModeCheckBox = new JCheckBox("Insert Mode");
        this.myInsertModeCheckBox.setSelected(true);
        this.myPanel.add(this.myInsertModeCheckBox);
        this.myPointToSelectModeCheckBox = new JCheckBox("Point to Select");
        this.myPointToSelectModeCheckBox.setSelected(true);
        this.myPanel.add(this.myPointToSelectModeCheckBox);
        this.myLinkModeCheckBox = new JCheckBox("Linking Mode");
        this.myLinkModeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IconicApp.this.setLinkMode(IconicApp.this.myLinkModeCheckBox.isSelected());
            }
        });
        this.myPanel.add(this.myLinkModeCheckBox);
        this.myStatusBarLabel = new JLabel();
        this.myStatusBarLabel.setText(" ");
        this.myView.addViewListener(this);
        this.myView.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                IconicApp.this.handleKeyPressed(keyEvent);
            }
        });
        this.getContentPane().add((Component)this.myView, "Center");
        this.getContentPane().add((Component)this.myPalette, "West");
        this.getContentPane().add((Component)this.myPanel, "North");
        this.getContentPane().add((Component)this.myStatusBarLabel, "South");
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setTitle("Point to Select, Click for Action or Insertion");
            jFrame.setSize(500, 400);
            IconicApp iconicApp = new IconicApp();
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)iconicApp, "Center");
            container.validate();
            jFrame.setVisible(true);
            iconicApp.init();
            iconicApp.start();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public void init() {
        this.myView.setDragDropEnabled(false);
        this.myView.setIncludingNegativeCoords(true);
        this.myView.setHidingDisabledScrollbars(true);
        this.myView.getDocument().setUndoManager(new JGoUndoManager());
        this.myPalette.setInternalMouseActions(0);
        this.myPalette.setDragDropEnabled(false);
        JGoImage jGoImage = new JGoImage();
        jGoImage.setResizable(false);
        jGoImage.loadImage((class$com$nwoods$jgo$examples$IconicApp == null ? (class$com$nwoods$jgo$examples$IconicApp = IconicApp.class$("com.nwoods.jgo.examples.IconicApp")) : class$com$nwoods$jgo$examples$IconicApp).getResource("demo1/star.gif"), true);
        jGoImage.setSize(32, 32);
        this.myPalette.getDocument().addObjectAtTail(jGoImage);
        jGoImage = new JGoImage();
        jGoImage.setResizable(false);
        jGoImage.loadImage((class$com$nwoods$jgo$examples$IconicApp == null ? (class$com$nwoods$jgo$examples$IconicApp = IconicApp.class$("com.nwoods.jgo.examples.IconicApp")) : class$com$nwoods$jgo$examples$IconicApp).getResource("demo1/doc.gif"), true);
        jGoImage.setSize(32, 32);
        this.myPalette.getDocument().addObjectAtTail(jGoImage);
        this.myPalette.selectObject(jGoImage);
    }

    void handleSelectionUnderMouse(Point point) {
        int n = this.myView.getSelection().getNumObjects();
        JGoObject jGoObject = this.myView.pickDocObject(point, true);
        if (jGoObject != null && n <= 1) {
            this.myView.selectObject(jGoObject);
        } else if (jGoObject == null && n == 1) {
            this.myView.getSelection().clearSelection();
        }
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            this.myView.deleteSelection();
        } else if (n == 155) {
            Rectangle rectangle = this.myView.getViewRect();
            this.insertNode(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2));
        } else if (n == 36) {
            Rectangle rectangle = this.myView.getDocument().computeBounds();
            this.myView.setViewPosition(rectangle.x, rectangle.y);
        } else if (n == 35) {
            Rectangle rectangle = this.myView.getDocument().computeBounds();
            Dimension dimension = this.myView.getExtentSize();
            this.myView.setViewPosition(Math.max(rectangle.x, rectangle.x + rectangle.width - dimension.width), Math.max(rectangle.y, rectangle.y + rectangle.height - dimension.height));
        } else if (keyEvent.isControlDown() && n == 65) {
            this.myView.selectAll();
        } else if (keyEvent.isControlDown() && n == 88) {
            this.myView.cut();
        } else if (keyEvent.isControlDown() && n == 67) {
            this.myView.copy();
        } else if (keyEvent.isControlDown() && n == 86) {
            this.myView.paste();
        } else if (keyEvent.isControlDown() && n == 90) {
            this.myView.getDocument().undo();
        } else if (keyEvent.isControlDown() && n == 89) {
            this.myView.getDocument().redo();
        }
    }

    public void viewChanged(JGoViewEvent jGoViewEvent) {
        if (jGoViewEvent.getHint() == 31 && jGoViewEvent.getJGoObject() instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)jGoViewEvent.getJGoObject();
            jGoLink.setPen(JGoPen.make(65535, 2, Color.blue));
            jGoLink.setArrowHeads(false, true);
        } else if (jGoViewEvent.getHint() == 22) {
            if (this.myPointToSelectModeCheckBox.isSelected()) {
                if ((jGoViewEvent.getModifiers() & 4) != 0) {
                    this.deleteObject(jGoViewEvent.getJGoObject());
                } else {
                    this.editObject(jGoViewEvent.getJGoObject());
                }
            }
        } else if (jGoViewEvent.getHint() == 23) {
            if (!this.myPointToSelectModeCheckBox.isSelected()) {
                if ((jGoViewEvent.getModifiers() & 4) != 0) {
                    this.deleteObject(jGoViewEvent.getJGoObject());
                } else {
                    this.editObject(jGoViewEvent.getJGoObject());
                }
            }
        } else if (jGoViewEvent.getHint() == 24) {
            if (this.myInsertModeCheckBox.isSelected() && this.myPalette.getSelection().getPrimarySelection() != null && this.myView.getSelection().getNumObjects() == 0 && (jGoViewEvent.getModifiers() & 4) == 0) {
                this.insertNode(jGoViewEvent.getPointDocCoords());
            }
        } else if (jGoViewEvent.getHint() == 20 || jGoViewEvent.getHint() == 21) {
            this.describeCurrentObject();
        }
    }

    void insertNode(Point point) {
        JGoDocument jGoDocument = this.myView.getDocument();
        jGoDocument.startTransaction();
        JGoObject jGoObject = this.myPalette.getSelection().getPrimarySelection();
        JGoIconicNode jGoIconicNode = new JGoIconicNode(Integer.toString(++this.myNodeCounter));
        JGoImage jGoImage = (JGoImage)jGoObject.copyObject(new JGoCopyMap());
        jGoIconicNode.setIcon(jGoImage);
        jGoIconicNode.setLocation(point);
        jGoIconicNode.getLabel().setEditable(false);
        jGoIconicNode.getPort().setBoundingRect(jGoIconicNode.getIcon().getBoundingRect());
        jGoIconicNode.getPort().setVisible(this.myLinkModeCheckBox.isSelected());
        jGoDocument.addObjectAtTail(jGoIconicNode);
        jGoDocument.endTransaction("inserted node");
    }

    void editObject(JGoObject jGoObject) {
        if (jGoObject == null) {
            return;
        }
        if ((jGoObject = jGoObject.getParentNode()) instanceof JGoIconicNode) {
            JGoIconicNode jGoIconicNode = (JGoIconicNode)jGoObject;
            String string = JOptionPane.showInputDialog(this, (Object)"Enter a new label:");
            if (string != null && !string.equals(jGoIconicNode.getLabel().getText())) {
                JGoDocument jGoDocument = this.myView.getDocument();
                jGoDocument.startTransaction();
                jGoIconicNode.getLabel().setText(string);
                jGoDocument.endTransaction("changed label");
            }
        }
    }

    void deleteObject(JGoObject jGoObject) {
        if (jGoObject == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Delete selection?", "", 2) == 0) {
            this.myView.deleteSelection();
        }
    }

    void describeCurrentObject() {
        JGoObject jGoObject = this.myView.getSelection().getPrimarySelection();
        if (jGoObject == null) {
            this.myStatusBarLabel.setText(" ");
        } else if (jGoObject instanceof JGoIconicNode) {
            JGoIconicNode jGoIconicNode = (JGoIconicNode)jGoObject;
            this.myStatusBarLabel.setText("node " + jGoIconicNode.getLabel().getText());
        } else if (jGoObject instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)jGoObject;
            JGoIconicNode jGoIconicNode = (JGoIconicNode)jGoLink.getFromPort().getParent();
            JGoIconicNode jGoIconicNode2 = (JGoIconicNode)jGoLink.getToPort().getParent();
            String string = "link from " + jGoIconicNode.getLabel().getText() + " to " + jGoIconicNode2.getLabel().getText();
            this.myStatusBarLabel.setText(string);
        }
    }

    void setLinkMode(boolean bl) {
        JGoDocument jGoDocument = this.myView.getDocument();
        jGoDocument.setSkipsUndoManager(true);
        JGoListPosition jGoListPosition = jGoDocument.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof JGoIconicNode)) continue;
            JGoIconicNode jGoIconicNode = (JGoIconicNode)jGoObject;
            jGoIconicNode.getPort().setVisible(bl);
        }
        jGoDocument.setSkipsUndoManager(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

