/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoScrollBar;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.ListAreaRect;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;

public class ListArea
extends JGoArea {
    public static final int VerticalChanged = 75565;
    public static final int ScrollBarOnRightChanged = 75566;
    public static final int LinePenChanged = 75567;
    public static final int InsetsChanged = 75568;
    public static final int SpacingChanged = 75569;
    public static final int AlignmentChanged = 75570;
    public static final int FirstVisibleIndexChanged = 75571;
    public static final int ItemChanged = 75572;
    public static final int LeftPortChanged = 75573;
    public static final int RightPortChanged = 75574;
    public static final int ItemInsertedChanged = 75575;
    public static final int ItemRemovedChanged = 75576;
    public static final int IconChanged = 75577;
    public static final int IconAlignmentChanged = 75578;
    public static final int IconSpacingChanged = 75579;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private static int myBarSize = 14;
    private ArrayList myVector = new ArrayList();
    private ArrayList myIcons = new ArrayList();
    private ArrayList myLeftPorts = new ArrayList();
    private ArrayList myRightPorts = new ArrayList();
    private JGoRectangle myRect = null;
    private JGoScrollBar myBar = null;
    private boolean myVertical = true;
    private boolean myScrollBarOnRight = true;
    private int myAlignment = 0;
    private int myIconAlignment = 0;
    private int myFirstItem = 0;
    private int myLastItem = -1;
    private Insets myInsets = new Insets(1, 4, 1, myBarSize + 4);
    private int mySpacing = 0;
    private JGoPen myLinePen = null;
    private int myIconSpacing = 1;
    private transient Dimension myMaxItemSize = new Dimension(-1, -1);

    public void initialize() {
        this.myRect = new ListAreaRect();
        this.myRect.setBrush(JGoBrush.lightGray);
        this.myRect.setSelectable(true);
        this.addObjectAtHead(this.myRect);
        this.myBar = new JGoScrollBar();
        this.myBar.setVertical(this.isVertical());
        this.myBar.setSelectable(false);
        this.addObjectAtTail(this.myBar);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        JGoObject jGoObject;
        JGoObject jGoObject2;
        int n;
        ListArea listArea = (ListArea)jGoArea;
        listArea.myVertical = this.myVertical;
        listArea.myScrollBarOnRight = this.myScrollBarOnRight;
        listArea.myAlignment = this.myAlignment;
        listArea.myIconAlignment = this.myIconAlignment;
        listArea.myFirstItem = this.myFirstItem;
        listArea.myLastItem = this.myLastItem;
        listArea.myInsets.top = this.myInsets.top;
        listArea.myInsets.left = this.myInsets.left;
        listArea.myInsets.bottom = this.myInsets.bottom;
        listArea.myInsets.right = this.myInsets.right;
        listArea.mySpacing = this.mySpacing;
        listArea.myLinePen = this.myLinePen;
        listArea.myIconSpacing = this.myIconSpacing;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        listArea.myRect = (JGoRectangle)jGoCopyEnvironment.get(this.myRect);
        for (n = 0; n < this.myVector.size(); ++n) {
            jGoObject2 = (JGoObject)this.myVector.get(n);
            jGoObject = (JGoObject)jGoCopyEnvironment.get(jGoObject2);
            listArea.myVector.add(jGoObject);
        }
        for (n = 0; n < this.myIcons.size(); ++n) {
            jGoObject2 = (JGoObject)this.myIcons.get(n);
            jGoObject = (JGoObject)jGoCopyEnvironment.get(jGoObject2);
            listArea.myIcons.add(jGoObject);
        }
        for (n = 0; n < this.myLeftPorts.size(); ++n) {
            jGoObject2 = (JGoObject)this.myLeftPorts.get(n);
            jGoObject = (JGoObject)jGoCopyEnvironment.get(jGoObject2);
            listArea.myLeftPorts.add(jGoObject);
        }
        for (n = 0; n < this.myRightPorts.size(); ++n) {
            jGoObject2 = (JGoObject)this.myRightPorts.get(n);
            jGoObject = (JGoObject)jGoCopyEnvironment.get(jGoObject2);
            listArea.myRightPorts.add(jGoObject);
        }
        listArea.myBar = (JGoScrollBar)jGoCopyEnvironment.get(this.myBar);
    }

    public JGoRectangle getRect() {
        return this.myRect;
    }

    public JGoScrollBar getScrollBar() {
        return this.myBar;
    }

    public boolean isVertical() {
        return this.myVertical;
    }

    public void setVertical(boolean bl) {
        boolean bl2 = this.myVertical;
        if (bl2 != bl) {
            this.myVertical = bl;
            if (this.getScrollBar() != null) {
                this.getScrollBar().setVertical(this.isVertical());
            }
            Insets insets = this.getInsets();
            if (bl) {
                if (this.isScrollBarOnRight()) {
                    insets.right += myBarSize;
                    insets.bottom -= myBarSize;
                } else {
                    insets.left += myBarSize;
                    insets.top -= myBarSize;
                }
            } else if (this.isScrollBarOnRight()) {
                insets.right -= myBarSize;
                insets.bottom += myBarSize;
            } else {
                insets.left -= myBarSize;
                insets.top += myBarSize;
            }
            this.layoutChildren(null);
            this.update(75565, bl2 ? 1 : 0, null);
        }
    }

    public boolean isScrollBarOnRight() {
        return this.myScrollBarOnRight;
    }

    public void setScrollBarOnRight(boolean bl) {
        boolean bl2 = this.myScrollBarOnRight;
        if (bl2 != bl) {
            this.myScrollBarOnRight = bl;
            Insets insets = this.getInsets();
            if (bl) {
                if (this.isVertical()) {
                    insets.right += myBarSize;
                    insets.left -= myBarSize;
                } else {
                    insets.bottom += myBarSize;
                    insets.top -= myBarSize;
                }
            } else if (this.isVertical()) {
                insets.right -= myBarSize;
                insets.left += myBarSize;
            } else {
                insets.bottom -= myBarSize;
                insets.top += myBarSize;
            }
            this.layoutChildren(null);
            this.update(75566, bl2 ? 1 : 0, null);
        }
    }

    public JGoPen getLinePen() {
        return this.myLinePen;
    }

    public void setLinePen(JGoPen jGoPen) {
        JGoPen jGoPen2 = this.myLinePen;
        if (jGoPen2 != jGoPen) {
            this.myLinePen = jGoPen;
            this.layoutChildren(null);
            this.update(75567, 0, jGoPen2);
        }
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public void setInsets(Insets insets) {
        Insets insets2 = this.myInsets;
        if (!insets2.equals(insets)) {
            Insets insets3 = new Insets(insets2.top, insets2.left, insets2.bottom, insets2.right);
            this.myInsets.top = insets.top;
            this.myInsets.left = insets.left;
            this.myInsets.bottom = insets.bottom;
            this.myInsets.right = insets.right;
            this.layoutChildren(null);
            this.update(75568, 0, insets3);
        }
    }

    public int getSpacing() {
        return this.mySpacing;
    }

    public void setSpacing(int n) {
        int n2 = this.mySpacing;
        if (n2 != n) {
            this.mySpacing = n;
            this.layoutChildren(null);
            this.update(75569, n2, null);
        }
    }

    public int getAlignment() {
        return this.myAlignment;
    }

    public void setAlignment(int n) {
        int n2 = this.myAlignment;
        if (n2 != n) {
            this.myAlignment = n;
            this.layoutChildren(null);
            this.update(75570, n2, null);
        }
    }

    public int getIconAlignment() {
        return this.myIconAlignment;
    }

    public void setIconAlignment(int n) {
        int n2 = this.myIconAlignment;
        if (n2 != n) {
            this.myIconAlignment = n;
            this.layoutChildren(null);
            this.update(75578, n2, null);
        }
    }

    public int getIconSpacing() {
        return this.myIconSpacing;
    }

    public void setIconSpacing(int n) {
        int n2 = this.myIconSpacing;
        if (n2 != n) {
            this.myIconSpacing = n;
            this.layoutChildren(null);
            this.update(75579, n2, null);
        }
    }

    public int getFirstVisibleIndex() {
        return this.myFirstItem;
    }

    public void setFirstVisibleIndex(int n) {
        int n2 = this.myFirstItem;
        if (n >= 0 && n <= this.getNumItems() && n2 != n) {
            this.myFirstItem = n;
            this.layoutChildren(null);
            this.update(75571, n2, null);
        }
    }

    public int getLastVisibleIndex() {
        return this.myLastItem;
    }

    public int getNumItems() {
        return this.myVector.size();
    }

    public JGoObject getItem(int n) {
        if (n < 0 || n >= this.myVector.size()) {
            return null;
        }
        return (JGoObject)this.myVector.get(n);
    }

    public void setItem(int n, JGoObject jGoObject) {
        if (n < 0 || n >= this.getNumItems()) {
            return;
        }
        JGoObject jGoObject2 = this.getItem(n);
        if (jGoObject2 == null) {
            return;
        }
        if (jGoObject2 != jGoObject) {
            this.removeObject(jGoObject2);
            this.myVector.set(n, jGoObject);
            this.adjustMaxItemSize(jGoObject, jGoObject2.getWidth(), jGoObject2.getHeight(), this.getIcon(n));
            if (jGoObject != null) {
                this.addObjectAtTail(jGoObject);
                jGoObject.setResizable(false);
                JGoRectangle jGoRectangle = this.getRect();
                if (n < this.getFirstVisibleIndex()) {
                    jGoObject.setVisible(false);
                    jGoObject.setTopLeft(jGoRectangle.getLeft(), jGoRectangle.getTop());
                } else if (n <= this.getLastVisibleIndex()) {
                    this.layoutChildren(jGoObject);
                } else {
                    jGoObject.setVisible(false);
                    if (this.isVertical()) {
                        jGoObject.setTopLeft(jGoRectangle.getLeft(), jGoRectangle.getTop() + jGoRectangle.getHeight() - jGoObject.getHeight());
                    } else {
                        jGoObject.setTopLeft(jGoRectangle.getLeft() + jGoRectangle.getWidth() - jGoObject.getWidth(), jGoRectangle.getTop());
                    }
                }
            }
            this.update(75572, n, jGoObject2);
        }
    }

    public int findItem(JGoObject jGoObject) {
        for (int i = 0; i < this.getNumItems(); ++i) {
            JGoObject jGoObject2 = this.getItem(i);
            if (jGoObject2 != jGoObject) continue;
            return i;
        }
        return -1;
    }

    public JGoObject getIcon(int n) {
        if (n < 0 || n >= this.myIcons.size()) {
            return null;
        }
        return (JGoObject)this.myIcons.get(n);
    }

    public void setIcon(int n, JGoObject jGoObject) {
        JGoObject jGoObject2 = this.getIcon(n);
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                if (jGoObject != null) {
                    jGoObject.setBoundingRect(jGoObject2.getBoundingRect());
                }
                this.removeObject(jGoObject2);
            }
            this.myIcons.set(n, jGoObject);
            if (jGoObject != null) {
                jGoObject.setResizable(false);
                this.addObjectAtTail(jGoObject);
                if (jGoObject2 != null) {
                    this.adjustMaxItemSize(jGoObject, jGoObject2.getWidth(), jGoObject2.getHeight(), this.getItem(n));
                }
            }
            this.update(75577, n, jGoObject2);
        }
    }

    public JGoObject getLeftPort(int n) {
        if (n < 0 || n >= this.myLeftPorts.size()) {
            return null;
        }
        return (JGoObject)this.myLeftPorts.get(n);
    }

    public void setLeftPort(int n, JGoObject jGoObject) {
        JGoObject jGoObject2 = this.getLeftPort(n);
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                if (jGoObject != null) {
                    jGoObject.setBoundingRect(jGoObject2.getBoundingRect());
                }
                this.removeObject(jGoObject2);
            }
            this.myLeftPorts.set(n, jGoObject);
            if (jGoObject != null) {
                jGoObject.setSelectable(false);
                jGoObject.setDraggable(false);
                jGoObject.setResizable(false);
                this.addObjectAtTail(jGoObject);
            }
            this.update(75573, n, jGoObject2);
        }
    }

    public JGoObject getRightPort(int n) {
        if (n < 0 || n >= this.myRightPorts.size()) {
            return null;
        }
        return (JGoObject)this.myRightPorts.get(n);
    }

    public void setRightPort(int n, JGoObject jGoObject) {
        JGoObject jGoObject2 = this.getRightPort(n);
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                if (jGoObject != null) {
                    jGoObject.setBoundingRect(jGoObject2.getBoundingRect());
                }
                this.removeObject(jGoObject2);
            }
            this.myRightPorts.set(n, jGoObject);
            if (jGoObject != null) {
                jGoObject.setSelectable(false);
                jGoObject.setDraggable(false);
                jGoObject.setResizable(false);
                this.addObjectAtTail(jGoObject);
            }
            this.update(75574, n, jGoObject2);
        }
    }

    public final void addItem(JGoObject jGoObject, JGoObject jGoObject2, JGoObject jGoObject3, JGoObject jGoObject4) {
        this.insertItem(this.getNumItems(), jGoObject, jGoObject2, jGoObject3, jGoObject4);
    }

    public void insertItem(int n, JGoObject jGoObject, JGoObject jGoObject2, JGoObject jGoObject3, JGoObject jGoObject4) {
        if (n < 0 || n > this.getNumItems()) {
            return;
        }
        JGoRectangle jGoRectangle = this.getRect();
        this.myVector.add(n, jGoObject);
        if (jGoObject != null) {
            jGoObject.setTopLeft(jGoRectangle.getLeft(), jGoRectangle.getTop());
            jGoObject.setResizable(false);
            this.adjustMaxItemSize(jGoObject, -1, -1, jGoObject4);
            this.addObjectAtTail(jGoObject);
        }
        this.myIcons.add(n, jGoObject4);
        if (jGoObject4 != null) {
            jGoObject4.setTopLeft(jGoRectangle.getLeft(), jGoRectangle.getTop());
            jGoObject4.setResizable(false);
            this.addObjectAtTail(jGoObject4);
        }
        this.myLeftPorts.add(n, jGoObject2);
        if (jGoObject2 != null) {
            jGoObject2.setTopLeft(jGoRectangle.getLeft(), jGoRectangle.getTop());
            jGoObject2.setSelectable(false);
            jGoObject2.setDraggable(false);
            jGoObject2.setResizable(false);
            this.addObjectAtTail(jGoObject2);
        }
        this.myRightPorts.add(n, jGoObject3);
        if (jGoObject3 != null) {
            jGoObject3.setTopLeft(jGoRectangle.getLeft(), jGoRectangle.getTop());
            jGoObject3.setSelectable(false);
            jGoObject3.setDraggable(false);
            jGoObject3.setResizable(false);
            this.addObjectAtTail(jGoObject3);
        }
        if (n < this.getFirstVisibleIndex()) {
            if (jGoObject != null) {
                jGoObject.setVisible(false);
            }
            this.updateScrollBar();
        } else if (n <= this.getLastVisibleIndex()) {
            this.layoutChildren(null);
        } else {
            if (jGoObject != null) {
                jGoObject.setVisible(false);
                if (this.isVertical()) {
                    jGoObject.setTopLeft(jGoRectangle.getLeft(), jGoRectangle.getTop() + jGoRectangle.getHeight() - jGoObject.getHeight());
                } else {
                    jGoObject.setTopLeft(jGoRectangle.getLeft() + jGoRectangle.getWidth() - jGoObject.getWidth(), jGoRectangle.getTop());
                }
            }
            this.updateScrollBar();
        }
        JGoObject[] jGoObjectArray = new JGoObject[]{jGoObject, jGoObject2, jGoObject3, jGoObject4};
        this.update(75575, n, jGoObjectArray);
    }

    public void removeItem(int n) {
        JGoObject jGoObject;
        if (n < 0 || n >= this.getNumItems()) {
            return;
        }
        JGoObject jGoObject2 = this.getLeftPort(n);
        this.myLeftPorts.remove(n);
        if (jGoObject2 != null) {
            super.removeObject(jGoObject2);
        }
        JGoObject jGoObject3 = this.getRightPort(n);
        this.myRightPorts.remove(n);
        if (jGoObject3 != null) {
            super.removeObject(jGoObject3);
        }
        JGoObject jGoObject4 = this.getIcon(n);
        this.myIcons.remove(n);
        if (jGoObject4 != null) {
            super.removeObject(jGoObject4);
        }
        if ((jGoObject = this.getItem(n)) != null) {
            this.myVector.remove(n);
            super.removeObject(jGoObject);
            this.adjustMaxItemSize(null, jGoObject.getWidth(), jGoObject.getHeight(), null);
        }
        if (n <= this.getLastVisibleIndex()) {
            this.layoutChildren(null);
        } else {
            this.updateScrollBar();
        }
        JGoObject[] jGoObjectArray = new JGoObject[]{jGoObject, jGoObject2, jGoObject3, jGoObject4};
        this.update(75576, n, jGoObjectArray);
    }

    public void removeObject(JGoObject jGoObject) {
        boolean bl = false;
        for (int i = 0; i < this.getNumItems(); ++i) {
            JGoObject jGoObject2 = this.getItem(i);
            if (jGoObject2 != jGoObject) continue;
            this.removeItem(i);
            bl = true;
            break;
        }
        if (!bl) {
            super.removeObject(jGoObject);
        }
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        this.setInitializing(true);
        Insets insets = this.getInsets();
        JGoRectangle jGoRectangle = this.getRect();
        if (jGoRectangle == null) {
            return;
        }
        this.sendObjectToBack(jGoRectangle);
        this.myLastItem = this.getFirstVisibleIndex();
        int n = jGoRectangle.getLeft() + insets.left;
        int n2 = jGoRectangle.getTop() + insets.top;
        int n3 = jGoRectangle.getWidth() - insets.left - insets.right;
        int n4 = jGoRectangle.getHeight() - insets.top - insets.bottom;
        int n5 = 0;
        if (this.getLinePen() != null) {
            n5 = this.getLinePen().getWidth();
        }
        if (this.isVertical()) {
            int n6 = 0;
            for (int i = 0; i < this.getNumItems(); ++i) {
                JGoObject jGoObject2 = this.getItem(i);
                JGoObject jGoObject3 = this.getIcon(i);
                JGoObject jGoObject4 = this.getLeftPort(i);
                JGoObject jGoObject5 = this.getRightPort(i);
                if (i < this.getFirstVisibleIndex()) {
                    if (jGoObject2 != null) {
                        jGoObject2.setVisible(false);
                        jGoObject2.setTopLeft(n, n2);
                    }
                    if (jGoObject3 != null) {
                        jGoObject3.setVisible(false);
                        jGoObject3.setTopLeft(n, n2);
                    }
                    if (jGoObject4 != null) {
                        jGoObject4.setVisible(false);
                        jGoObject4.setTopLeft(n, n2);
                    }
                    if (jGoObject5 == null) continue;
                    jGoObject5.setVisible(false);
                    jGoObject5.setTopLeft(n + n3 - jGoObject5.getWidth(), n2);
                    continue;
                }
                int n7 = this.getItemSize(i);
                if (n6 + n7 <= n4) {
                    this.layoutItem(i, n, n2 + n6, n3, n7);
                    n6 += n7;
                    n6 += Math.max(n5, this.getSpacing());
                    this.myLastItem = i;
                    continue;
                }
                if (jGoObject2 != null) {
                    jGoObject2.setVisible(false);
                    jGoObject2.setTopLeft(n, n2 + n4 - n7);
                }
                if (jGoObject3 != null) {
                    jGoObject3.setVisible(false);
                    jGoObject3.setTopLeft(n, n2 + n4 - n7);
                }
                if (jGoObject4 != null) {
                    jGoObject4.setVisible(false);
                    jGoObject4.setTopLeft(n, n2 + n4 - jGoObject4.getHeight());
                }
                if (jGoObject5 != null) {
                    jGoObject5.setVisible(false);
                    jGoObject5.setTopLeft(n + n3 - jGoObject5.getWidth(), n2 + n4 - jGoObject5.getHeight());
                }
                n6 = n4 + 1;
            }
            JGoScrollBar jGoScrollBar = this.getScrollBar();
            if (jGoScrollBar != null) {
                if (this.isScrollBarOnRight()) {
                    jGoScrollBar.setBoundingRect(jGoRectangle.getLeft() + jGoRectangle.getWidth() - myBarSize, jGoRectangle.getTop(), myBarSize, jGoRectangle.getHeight());
                } else {
                    jGoScrollBar.setBoundingRect(jGoRectangle.getLeft(), jGoRectangle.getTop(), myBarSize, jGoRectangle.getHeight());
                }
                this.updateScrollBar();
            }
        } else {
            int n8 = 0;
            for (int i = 0; i < this.getNumItems(); ++i) {
                JGoObject jGoObject6 = this.getItem(i);
                JGoObject jGoObject7 = this.getIcon(i);
                JGoObject jGoObject8 = this.getLeftPort(i);
                JGoObject jGoObject9 = this.getRightPort(i);
                if (i < this.getFirstVisibleIndex()) {
                    if (jGoObject6 != null) {
                        jGoObject6.setVisible(false);
                        jGoObject6.setTopLeft(n, n2);
                    }
                    if (jGoObject7 != null) {
                        jGoObject7.setVisible(false);
                        jGoObject7.setTopLeft(n, n2);
                    }
                    if (jGoObject8 != null) {
                        jGoObject8.setVisible(false);
                        jGoObject8.setTopLeft(n, n2);
                    }
                    if (jGoObject9 == null) continue;
                    jGoObject9.setVisible(false);
                    jGoObject9.setTopLeft(n, n2 + n4 - jGoObject9.getHeight());
                    continue;
                }
                int n9 = this.getItemSize(i);
                if (n8 + n9 <= n3) {
                    this.layoutItem(i, n + n8, n2, n9, n4);
                    n8 += n9;
                    n8 += Math.max(n5, this.getSpacing());
                    this.myLastItem = i;
                    continue;
                }
                if (jGoObject6 != null) {
                    jGoObject6.setVisible(false);
                    jGoObject6.setTopLeft(n + n3 - n9, n2);
                }
                if (jGoObject7 != null) {
                    jGoObject7.setVisible(false);
                    jGoObject7.setTopLeft(n + n3 - n9, n2);
                }
                if (jGoObject8 != null) {
                    jGoObject8.setVisible(false);
                    jGoObject8.setTopLeft(n + n3 - jGoObject8.getWidth(), n2);
                }
                if (jGoObject9 != null) {
                    jGoObject9.setVisible(false);
                    jGoObject9.setTopLeft(n + n3 - jGoObject9.getWidth(), n2 + n4 - jGoObject9.getHeight());
                }
                n8 = n3 + 1;
            }
            JGoScrollBar jGoScrollBar = this.getScrollBar();
            if (jGoScrollBar != null) {
                if (this.isScrollBarOnRight()) {
                    jGoScrollBar.setBoundingRect(jGoRectangle.getLeft(), jGoRectangle.getTop() + jGoRectangle.getHeight() - myBarSize, jGoRectangle.getWidth(), myBarSize);
                } else {
                    jGoScrollBar.setBoundingRect(jGoRectangle.getLeft(), jGoRectangle.getTop(), jGoRectangle.getWidth(), myBarSize);
                }
                this.updateScrollBar();
            }
        }
        this.setInitializing(false);
    }

    protected int getItemSize(int n) {
        JGoObject jGoObject;
        JGoObject jGoObject2;
        JGoObject jGoObject3;
        int n2 = 0;
        JGoObject jGoObject4 = this.getItem(n);
        if (jGoObject4 != null) {
            n2 = this.isVertical() ? jGoObject4.getHeight() : jGoObject4.getWidth();
        }
        if ((jGoObject3 = this.getIcon(n)) != null) {
            n2 = this.isVertical() ? Math.max(n2, jGoObject3.getHeight()) : Math.max(n2, jGoObject3.getWidth());
        }
        if ((jGoObject2 = this.getLeftPort(n)) != null) {
            n2 = this.isVertical() ? Math.max(n2, jGoObject2.getHeight()) : Math.max(n2, jGoObject2.getWidth());
        }
        if ((jGoObject = this.getRightPort(n)) != null) {
            n2 = this.isVertical() ? Math.max(n2, jGoObject.getHeight()) : Math.max(n2, jGoObject.getWidth());
        }
        return n2;
    }

    protected void layoutItem(int n, int n2, int n3, int n4, int n5) {
        JGoObject jGoObject;
        int n6;
        JGoRectangle jGoRectangle;
        JGoObject jGoObject2 = this.getItem(n);
        JGoObject jGoObject3 = this.getIcon(n);
        int n7 = 0;
        int n8 = 0;
        if (jGoObject2 != null) {
            n7 = this.isVertical() ? jGoObject2.getWidth() : jGoObject2.getHeight();
        }
        if (jGoObject3 != null) {
            n8 = this.isVertical() ? jGoObject3.getWidth() : jGoObject3.getHeight();
        }
        int n9 = 0;
        n9 = this.isVertical() ? n4 : n5;
        int n10 = 0;
        int n11 = 0;
        int n12 = this.getIconSpacing();
        block0 : switch (this.getAlignment()) {
            default: {
                n10 = 0;
                switch (this.getIconAlignment()) {
                    default: {
                        n11 = 0;
                        n10 = n8 + n12;
                        break block0;
                    }
                    case 1: {
                        n11 = n9 / 2 - n8 / 2;
                        n11 = Math.max(n11, n7 + n12);
                        break block0;
                    }
                    case 2: 
                }
                n11 = n9 - n8;
                break;
            }
            case 1: {
                n10 = n9 / 2 - n7 / 2;
                switch (this.getIconAlignment()) {
                    default: {
                        n11 = 0;
                        n10 = Math.max(n10 + n12, n8);
                        break block0;
                    }
                    case 1: {
                        n11 = n9 / 2 - (n8 + n7 + n12) / 2;
                        n10 = n11 + n8 + n12;
                        break block0;
                    }
                    case 2: 
                }
                n11 = n9 - n8;
                n10 = Math.min(n10, n9 - n8 - n7 - n12);
                break;
            }
            case 2: {
                n10 = n9 - n7;
                switch (this.getIconAlignment()) {
                    default: {
                        n11 = 0;
                        break block0;
                    }
                    case 1: {
                        n11 = n9 / 2 - n8 / 2;
                        n11 = Math.min(n11, n9 - n7 - n8 - n12);
                        break block0;
                    }
                    case 2: 
                }
                n11 = n9 - n8;
                n10 = n11 - n7 - n12;
            }
        }
        if (jGoObject2 != null) {
            jGoObject2.setVisible(true);
            if (this.isVertical()) {
                jGoObject2.setTopLeft(n2 + n10, n3 + n5 / 2 - jGoObject2.getHeight() / 2);
            } else {
                jGoObject2.setTopLeft(n2 + n4 / 2 - jGoObject2.getWidth() / 2, n3 + n10);
            }
        }
        if (jGoObject3 != null) {
            jGoObject3.setVisible(true);
            if (this.isVertical()) {
                jGoObject3.setTopLeft(n2 + n11, n3 + n5 / 2 - jGoObject3.getHeight() / 2);
            } else {
                jGoObject3.setTopLeft(n2 + n4 / 2 - jGoObject3.getWidth() / 2, n3 + n11);
            }
        }
        if ((jGoRectangle = this.getRect()) == null) {
            return;
        }
        int n13 = jGoRectangle.getLeft();
        int n14 = jGoRectangle.getTop();
        int n15 = jGoRectangle.getWidth();
        int n16 = jGoRectangle.getHeight();
        JGoObject jGoObject4 = this.getLeftPort(n);
        if (jGoObject4 != null) {
            int n17;
            jGoObject4.setVisible(true);
            if (this.isVertical()) {
                n17 = n13 - jGoObject4.getWidth();
                n6 = n3 + n5 / 2 - jGoObject4.getHeight() / 2;
                jGoObject4.setTopLeft(n17, n6);
            } else {
                n17 = n2 + n4 / 2 - jGoObject4.getWidth() / 2;
                n6 = n14 - jGoObject4.getHeight();
                jGoObject4.setTopLeft(n17, n6);
            }
        }
        if ((jGoObject = this.getRightPort(n)) != null) {
            jGoObject.setVisible(true);
            if (this.isVertical()) {
                n6 = n13 + n15;
                int n18 = n3 + n5 / 2 - jGoObject.getHeight() / 2;
                jGoObject.setTopLeft(n6, n18);
            } else {
                n6 = n2 + n4 / 2 - jGoObject.getWidth() / 2;
                int n19 = n14 + n16;
                jGoObject.setTopLeft(n6, n19);
            }
        }
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        super.paint(graphics2D, jGoView);
        int n = 0;
        if (this.getLinePen() != null) {
            n = this.getLinePen().getWidth();
        }
        if (n == 0) {
            return;
        }
        JGoRectangle jGoRectangle = this.getRect();
        if (jGoRectangle == null) {
            return;
        }
        Insets insets = this.getInsets();
        int n2 = jGoRectangle.getLeft();
        int n3 = jGoRectangle.getTop();
        int n4 = jGoRectangle.getWidth();
        int n5 = jGoRectangle.getHeight();
        int n6 = n2 + insets.left;
        int n7 = n3 + insets.top;
        int n8 = n4 - insets.left - insets.right;
        int n9 = n5 - insets.top - insets.bottom;
        int n10 = 0;
        n10 = this.isVertical() ? n9 : n8;
        int n11 = 0;
        for (int i = this.getFirstVisibleIndex(); i < this.getLastVisibleIndex(); ++i) {
            int n12 = this.getItemSize(i);
            if (n11 + n12 > n10) continue;
            int n13 = Math.max(n, this.getSpacing());
            if ((n11 += n12) + n13 <= n10) {
                if (this.isVertical()) {
                    JGoDrawable.drawLine(graphics2D, this.getLinePen(), n2, n7 + n11 + n13 / 2, n2 + n4, n7 + n11 + n13 / 2);
                } else {
                    JGoDrawable.drawLine(graphics2D, this.getLinePen(), n6 + n11 + n13 / 2, n3, n6 + n11 + n13 / 2, n3 + n5);
                }
            }
            n11 += n13;
        }
    }

    public void updateScrollBar() {
        JGoScrollBar jGoScrollBar = this.getScrollBar();
        if (jGoScrollBar != null) {
            jGoScrollBar.setVertical(this.isVertical());
            if (this.getFirstVisibleIndex() == 0 && this.getLastVisibleIndex() == this.getNumItems() - 1) {
                jGoScrollBar.setVisible(false);
            } else {
                jGoScrollBar.setVisible(true);
                boolean bl = this.isInitializing();
                this.setInitializing(true);
                jGoScrollBar.setValues(this.getFirstVisibleIndex(), this.getLastVisibleIndex() - this.getFirstVisibleIndex() + 1, 0, this.getNumItems(), 1, Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 1));
                this.setInitializing(bl);
            }
        }
    }

    public void update(int n, int n2, Object object) {
        if (n == 1003) {
            if (this.getScrollBar() != null && !this.isInitializing()) {
                this.setFirstVisibleIndex(this.getScrollBar().getValue());
            }
        } else {
            super.update(n, n2, object);
        }
    }

    public void setVisible(boolean bl) {
        if (this.getScrollBar() != null) {
            this.getScrollBar().setVisible(bl);
        }
        super.setVisible(bl);
    }

    public JGoObject redirectSelection() {
        return this.getRect();
    }

    public Dimension getMinimumRectSize() {
        Dimension dimension = this.getMaxItemSize();
        Insets insets = this.getInsets();
        int n = dimension.width + insets.left + insets.right;
        int n2 = dimension.height + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getMinimumRectSize();
        int n = this.getMaxPortWidth(true);
        int n2 = this.getMaxPortWidth(false);
        if (this.isVertical()) {
            return new Dimension(dimension.width + n + n2, dimension.height);
        }
        return new Dimension(dimension.width, dimension.height + n + n2);
    }

    public void setBoundingRect(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getMinimumSize();
        super.setBoundingRect(n, n2, Math.max(n3, dimension.width), Math.max(n4, dimension.height));
    }

    protected void rescaleChildren(Rectangle rectangle) {
        if (this.getRect() != null) {
            Rectangle rectangle2 = this.getBoundingRect();
            int n = this.getMaxPortWidth(true);
            int n2 = this.getMaxPortWidth(false);
            if (this.isVertical()) {
                this.getRect().setBoundingRect(rectangle2.x + n, rectangle2.y, rectangle2.width - n - n2, rectangle2.height);
            } else {
                this.getRect().setBoundingRect(rectangle2.x, rectangle2.y + n, rectangle2.width, rectangle2.height - n - n2);
            }
        }
    }

    protected boolean geometryChangeChild(JGoObject jGoObject, Rectangle rectangle) {
        if (this.isInitializing()) {
            return false;
        }
        int n = -1;
        if (jGoObject != this.getRect() && (jGoObject.getWidth() != rectangle.width || jGoObject.getHeight() != rectangle.height) && (n = this.findItem(jGoObject)) >= 0) {
            this.adjustMaxItemSize(jGoObject, rectangle.width, rectangle.height, this.getIcon(n));
            return super.geometryChangeChild(jGoObject, rectangle);
        }
        if (jGoObject == this.getRect()) {
            return super.geometryChangeChild(jGoObject, rectangle);
        }
        return false;
    }

    public void adjustMaxItemSize(JGoObject jGoObject, int n, int n2, JGoObject jGoObject2) {
        int n3;
        int n4 = -1;
        int n5 = -1;
        if (jGoObject != null) {
            n4 = jGoObject.getWidth();
            n5 = jGoObject.getHeight();
        }
        int n6 = n;
        int n7 = n2;
        int n8 = n4;
        int n9 = n5;
        if (jGoObject2 != null) {
            n6 += jGoObject2.getWidth();
            n7 += jGoObject2.getHeight();
            n8 += jGoObject2.getWidth();
            n9 += jGoObject2.getHeight();
            int n10 = this.getIconSpacing();
            if (this.isVertical()) {
                n6 += n10;
                n8 += n10;
            } else {
                n7 += n10;
                n9 += n10;
            }
        }
        Insets insets = this.getInsets();
        if (this.myMaxItemSize.width > -1) {
            if (n4 > n && n8 > this.myMaxItemSize.width) {
                this.myMaxItemSize.width = n8;
                n3 = n8 + insets.left + insets.right;
                if (this.getRect().getWidth() < n3) {
                    this.getRect().setWidth(n3);
                }
            } else if (n4 < n && n6 == this.myMaxItemSize.width) {
                this.myMaxItemSize.width = -1;
            }
        }
        if (this.myMaxItemSize.height > -1) {
            if (n5 > n2 && n9 > this.myMaxItemSize.height) {
                this.myMaxItemSize.height = n9;
                n3 = n9 + insets.top + insets.bottom;
                if (this.getRect().getHeight() < n3) {
                    this.getRect().setHeight(n3);
                }
            } else if (n5 < n2 && n7 == this.myMaxItemSize.height) {
                this.myMaxItemSize.height = -1;
            }
        }
    }

    public Dimension getMaxItemSize() {
        if (this.myMaxItemSize.width < 0 || this.myMaxItemSize.height < 0) {
            this.myMaxItemSize.width = -1;
            this.myMaxItemSize.height = -1;
            for (int i = 0; i < this.myVector.size(); ++i) {
                int n;
                JGoObject jGoObject = (JGoObject)this.myVector.get(i);
                int n2 = 0;
                int n3 = 0;
                if (jGoObject != null) {
                    n2 = jGoObject.getWidth();
                    n3 = jGoObject.getHeight();
                    if (n2 > this.myMaxItemSize.width) {
                        this.myMaxItemSize.width = n2;
                    }
                    if (n3 > this.myMaxItemSize.height) {
                        this.myMaxItemSize.height = n3;
                    }
                }
                JGoObject jGoObject2 = null;
                if (i < this.myIcons.size()) {
                    jGoObject2 = (JGoObject)this.myIcons.get(i);
                }
                int n4 = 0;
                int n5 = 0;
                if (jGoObject2 != null) {
                    n4 = jGoObject2.getWidth();
                    n5 = jGoObject2.getHeight();
                    if (n4 > this.myMaxItemSize.width) {
                        this.myMaxItemSize.width = n4;
                    }
                    if (n5 > this.myMaxItemSize.height) {
                        this.myMaxItemSize.height = n5;
                    }
                }
                if (jGoObject == null || jGoObject2 == null) continue;
                if (this.isVertical()) {
                    n = n2 + n4 + this.getIconSpacing();
                    if (n <= this.myMaxItemSize.width) continue;
                    this.myMaxItemSize.width = n;
                    continue;
                }
                n = n3 + n5 + this.getIconSpacing();
                if (n <= this.myMaxItemSize.height) continue;
                this.myMaxItemSize.height = n;
            }
        }
        return this.myMaxItemSize;
    }

    public int getMaxPortWidth(boolean bl) {
        int n = 0;
        ArrayList arrayList = bl ? this.myLeftPorts : this.myRightPorts;
        for (int i = 0; i < arrayList.size(); ++i) {
            JGoObject jGoObject = (JGoObject)arrayList.get(i);
            if (jGoObject == null) continue;
            n = this.isVertical() ? Math.max(n, jGoObject.getWidth()) : Math.max(n, jGoObject.getHeight());
        }
        return n;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75565: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isVertical());
                return;
            }
            case 75566: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isScrollBarOnRight());
                return;
            }
            case 75567: {
                jGoDocumentChangedEdit.setNewValue(this.getLinePen());
                return;
            }
            case 75568: {
                Insets insets = this.getInsets();
                jGoDocumentChangedEdit.setNewValue(new Insets(insets.top, insets.left, insets.bottom, insets.right));
                return;
            }
            case 75569: {
                jGoDocumentChangedEdit.setNewValueInt(this.getSpacing());
                return;
            }
            case 75570: {
                jGoDocumentChangedEdit.setNewValueInt(this.getAlignment());
                return;
            }
            case 75571: {
                jGoDocumentChangedEdit.setNewValueInt(this.getFirstVisibleIndex());
                return;
            }
            case 75572: {
                jGoDocumentChangedEdit.setNewValue(this.getItem(jGoDocumentChangedEdit.getOldValueInt()));
                return;
            }
            case 75573: {
                jGoDocumentChangedEdit.setNewValue(this.getLeftPort(jGoDocumentChangedEdit.getOldValueInt()));
                return;
            }
            case 75574: {
                jGoDocumentChangedEdit.setNewValue(this.getRightPort(jGoDocumentChangedEdit.getOldValueInt()));
                return;
            }
            case 75575: {
                return;
            }
            case 75576: {
                return;
            }
            case 75577: {
                jGoDocumentChangedEdit.setNewValue(this.getIcon(jGoDocumentChangedEdit.getOldValueInt()));
                return;
            }
            case 75578: {
                jGoDocumentChangedEdit.setNewValueInt(this.getIconAlignment());
                return;
            }
            case 75579: {
                jGoDocumentChangedEdit.setNewValueInt(this.getIconSpacing());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75565: {
                this.myVertical = jGoDocumentChangedEdit.getValueBoolean(bl);
                return;
            }
            case 75566: {
                this.myScrollBarOnRight = jGoDocumentChangedEdit.getValueBoolean(bl);
                return;
            }
            case 75567: {
                this.myLinePen = (JGoPen)jGoDocumentChangedEdit.getValue(bl);
                this.update();
                return;
            }
            case 75568: {
                Insets insets = (Insets)jGoDocumentChangedEdit.getValue(bl);
                this.myInsets.top = insets.top;
                this.myInsets.left = insets.left;
                this.myInsets.bottom = insets.bottom;
                this.myInsets.right = insets.right;
                return;
            }
            case 75569: {
                this.mySpacing = jGoDocumentChangedEdit.getValueInt(bl);
                return;
            }
            case 75570: {
                this.myAlignment = jGoDocumentChangedEdit.getValueInt(bl);
                return;
            }
            case 75571: {
                this.myFirstItem = jGoDocumentChangedEdit.getValueInt(bl);
                return;
            }
            case 75572: {
                this.setItem(jGoDocumentChangedEdit.getOldValueInt(), (JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75573: {
                this.setLeftPort(jGoDocumentChangedEdit.getOldValueInt(), (JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75574: {
                this.setRightPort(jGoDocumentChangedEdit.getOldValueInt(), (JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75575: {
                if (bl) {
                    this.removeItem(jGoDocumentChangedEdit.getOldValueInt());
                } else {
                    JGoObject[] jGoObjectArray = (JGoObject[])jGoDocumentChangedEdit.getOldValue();
                    this.insertItem(jGoDocumentChangedEdit.getOldValueInt(), jGoObjectArray[0], jGoObjectArray[1], jGoObjectArray[2], jGoObjectArray[3]);
                }
                return;
            }
            case 75576: {
                if (bl) {
                    JGoObject[] jGoObjectArray = (JGoObject[])jGoDocumentChangedEdit.getOldValue();
                    this.insertItem(jGoDocumentChangedEdit.getOldValueInt(), jGoObjectArray[0], jGoObjectArray[1], jGoObjectArray[2], jGoObjectArray[3]);
                } else {
                    this.removeItem(jGoDocumentChangedEdit.getOldValueInt());
                }
                return;
            }
            case 75577: {
                this.setIcon(jGoDocumentChangedEdit.getOldValueInt(), (JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75578: {
                this.myIconAlignment = jGoDocumentChangedEdit.getValueInt(bl);
                return;
            }
            case 75579: {
                this.myIconSpacing = jGoDocumentChangedEdit.getValueInt(bl);
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("bar")) {
            this.myBar = (JGoScrollBar)object;
        } else if (string.equals("rect")) {
            this.myRect = (JGoRectangle)object;
        } else if (string.equals("vectorelements")) {
            this.myVector.add(object);
        } else if (string.equals("icons")) {
            this.myIcons.add(object);
        } else if (string.equals("leftports")) {
            this.myLeftPorts.add(object);
        } else if (string.equals("rightports")) {
            this.myRightPorts.add(object);
        } else if (string.equals("linepen")) {
            this.myLinePen = (JGoPen)object;
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            int n;
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.ListArea", domElement);
            domElement2.setAttribute("alignment", Integer.toString(this.myAlignment));
            domElement2.setAttribute("firstitem", Integer.toString(this.myFirstItem));
            domElement2.setAttribute("iconalignment", Integer.toString(this.myIconAlignment));
            domElement2.setAttribute("iconspacing", Integer.toString(this.myIconSpacing));
            domElement2.setAttribute("lastitem", Integer.toString(this.myLastItem));
            domElement2.setAttribute("scrollbaronright", this.myScrollBarOnRight ? "true" : "false");
            domElement2.setAttribute("spacing", Integer.toString(this.mySpacing));
            domElement2.setAttribute("vertical", this.myVertical ? "true" : "false");
            domElement2.setAttribute("insetleft", Integer.toString(this.myInsets.left));
            domElement2.setAttribute("insetright", Integer.toString(this.myInsets.right));
            domElement2.setAttribute("insettop", Integer.toString(this.myInsets.top));
            domElement2.setAttribute("insetbottom", Integer.toString(this.myInsets.bottom));
            if (this.myBar != null) {
                domDoc.registerReferencingNode(domElement2, "bar", this.myBar);
            }
            if (this.myRect != null) {
                domDoc.registerReferencingNode(domElement2, "rect", this.myRect);
            }
            for (n = 0; n < this.myVector.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "vectorelements", (JGoObject)this.myVector.get(n));
            }
            for (n = 0; n < this.myIcons.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "icons", (JGoObject)this.myIcons.get(n));
            }
            for (n = 0; n < this.myLeftPorts.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "leftports", (JGoObject)this.myLeftPorts.get(n));
            }
            for (n = 0; n < this.myRightPorts.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "rightports", (JGoObject)this.myRightPorts.get(n));
            }
            if (this.myLinePen != null) {
                if (!domDoc.isRegisteredReference(this.myLinePen)) {
                    domElement2.setAttribute("embeddedlinepen", "true");
                    DomElement domElement3 = domDoc.createElement("g");
                    domElement2.appendChild(domElement3);
                    this.myLinePen.SVGWriteObject(domDoc, domElement3);
                }
                domDoc.registerReferencingNode(domElement2, "linepen", this.myLinePen);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.myAlignment = Integer.parseInt(domElement2.getAttribute("alignment"));
            this.myFirstItem = Integer.parseInt(domElement2.getAttribute("firstitem"));
            this.myIconAlignment = Integer.parseInt(domElement2.getAttribute("iconalignment"));
            this.myIconSpacing = Integer.parseInt(domElement2.getAttribute("iconspacing"));
            this.myLastItem = Integer.parseInt(domElement2.getAttribute("lastitem"));
            this.myScrollBarOnRight = domElement2.getAttribute("scrollbaronright").equals("true");
            this.mySpacing = Integer.parseInt(domElement2.getAttribute("spacing"));
            this.myVertical = domElement2.getAttribute("vertical").equals("true");
            this.myInsets.left = Integer.parseInt(domElement2.getAttribute("insetleft"));
            this.myInsets.right = Integer.parseInt(domElement2.getAttribute("insetright"));
            this.myInsets.top = Integer.parseInt(domElement2.getAttribute("insettop"));
            this.myInsets.bottom = Integer.parseInt(domElement2.getAttribute("insetbottom"));
            String string = domElement2.getAttribute("bar");
            domDoc.registerReferencingObject(this, "bar", string);
            String string2 = domElement2.getAttribute("rect");
            domDoc.registerReferencingObject(this, "rect", string2);
            String string3 = domElement2.getAttribute("vectorelements");
            while (string3.length() > 0) {
                int n = string3.indexOf(" ");
                if (n == -1) {
                    n = string3.length();
                }
                String string4 = string3.substring(0, n);
                string3 = n >= string3.length() ? "" : string3.substring(n + 1);
                domDoc.registerReferencingObject(this, "vectorelements", string4);
            }
            String string5 = domElement2.getAttribute("icons");
            while (string5.length() > 0) {
                int n = string5.indexOf(" ");
                if (n == -1) {
                    n = string5.length();
                }
                String string6 = string5.substring(0, n);
                string5 = n >= string5.length() ? "" : string5.substring(n + 1);
                domDoc.registerReferencingObject(this, "icons", string6);
            }
            String string7 = domElement2.getAttribute("leftports");
            while (string7.length() > 0) {
                int n = string7.indexOf(" ");
                if (n == -1) {
                    n = string7.length();
                }
                String string8 = string7.substring(0, n);
                string7 = n >= string7.length() ? "" : string7.substring(n + 1);
                domDoc.registerReferencingObject(this, "leftports", string8);
            }
            String string9 = domElement2.getAttribute("rightports");
            while (string9.length() > 0) {
                int n = string9.indexOf(" ");
                if (n == -1) {
                    n = string9.length();
                }
                String string10 = string9.substring(0, n);
                string9 = n >= string9.length() ? "" : string9.substring(n + 1);
                domDoc.registerReferencingObject(this, "rightports", string10);
            }
            if (domElement2.getAttribute("embeddedlinepen").equals("true")) {
                domDoc.SVGTraverseChildren(jGoDocument, domElement2, null, false);
            }
            String string11 = domElement2.getAttribute("linepen");
            domDoc.registerReferencingObject(this, "linepen", string11);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

