/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.ArrayList;

public class MultiTextNode
extends JGoNode {
    public static final int LinePenChanged = 75567;
    public static final int InsetsChanged = 75568;
    public static final int SpacingChanged = 75569;
    public static final int ItemWidthChanged = 75571;
    public static final int ItemChanged = 75572;
    public static final int BackgroundChanged = 75557;
    public static final int TopPortChanged = 75558;
    public static final int BottomPortChanged = 75560;
    public static final int LeftPortChanged = 75573;
    public static final int RightPortChanged = 75574;
    public static final int ItemInsertedChanged = 75575;
    public static final int ItemRemovedChanged = 75576;
    private ArrayList myVector = new ArrayList();
    private ArrayList myLeftPorts = new ArrayList();
    private ArrayList myRightPorts = new ArrayList();
    private JGoObject myTopPort = null;
    private JGoObject myBottomPort = null;
    private JGoDrawable myBack = null;
    private Insets myInsets = new Insets(1, 1, 1, 1);
    private int mySpacing = 0;
    private JGoPen myLinePen = null;
    private int myItemWidth = 150;

    public void initialize() {
        this.setInitializing(true);
        this.setResizable(false);
        this.myBack = this.createBackground();
        this.addObjectAtHead(this.myBack);
        this.myTopPort = this.createEndPort(true);
        this.addObjectAtTail(this.myTopPort);
        this.myBottomPort = this.createEndPort(false);
        this.addObjectAtTail(this.myBottomPort);
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    public JGoDrawable createBackground() {
        JGoRectangle jGoRectangle = new JGoRectangle();
        jGoRectangle.setBrush(null);
        jGoRectangle.setSelectable(false);
        jGoRectangle.setDraggable(false);
        jGoRectangle.setResizable(false);
        return jGoRectangle;
    }

    public JGoObject createEndPort(boolean bl) {
        JGoPort jGoPort = new JGoPort();
        jGoPort.setSize(5, 3);
        jGoPort.setStyle(0);
        if (bl) {
            jGoPort.setFromSpot(2);
            jGoPort.setToSpot(2);
        } else {
            jGoPort.setFromSpot(6);
            jGoPort.setToSpot(6);
        }
        return jGoPort;
    }

    public JGoObject createItem(int n, String string) {
        JGoText jGoText = new JGoText(string);
        jGoText.setTransparent(true);
        jGoText.setMultiline(true);
        jGoText.setClipping(true);
        jGoText.setWrapping(true);
        jGoText.setWrappingWidth(this.getItemWidth());
        return jGoText;
    }

    public JGoObject createPort(int n, boolean bl) {
        JGoPort jGoPort = new JGoPort();
        jGoPort.setSize(3, 5);
        jGoPort.setStyle(0);
        if (bl) {
            jGoPort.setFromSpot(8);
            jGoPort.setToSpot(8);
        } else {
            jGoPort.setFromSpot(4);
            jGoPort.setToSpot(4);
        }
        return jGoPort;
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        JGoObject jGoObject;
        JGoObject jGoObject2;
        int n;
        MultiTextNode multiTextNode = (MultiTextNode)jGoArea;
        multiTextNode.myInsets.top = this.myInsets.top;
        multiTextNode.myInsets.left = this.myInsets.left;
        multiTextNode.myInsets.bottom = this.myInsets.bottom;
        multiTextNode.myInsets.right = this.myInsets.right;
        multiTextNode.mySpacing = this.mySpacing;
        multiTextNode.myLinePen = this.myLinePen;
        multiTextNode.myItemWidth = this.myItemWidth;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        multiTextNode.myBack = (JGoDrawable)jGoCopyEnvironment.get(this.myBack);
        multiTextNode.myTopPort = (JGoObject)jGoCopyEnvironment.get(this.myTopPort);
        multiTextNode.myBottomPort = (JGoObject)jGoCopyEnvironment.get(this.myBottomPort);
        for (n = 0; n < this.myVector.size(); ++n) {
            jGoObject2 = (JGoObject)this.myVector.get(n);
            jGoObject = (JGoObject)jGoCopyEnvironment.get(jGoObject2);
            multiTextNode.myVector.add(jGoObject);
        }
        for (n = 0; n < this.myLeftPorts.size(); ++n) {
            jGoObject2 = (JGoObject)this.myLeftPorts.get(n);
            jGoObject = (JGoObject)jGoCopyEnvironment.get(jGoObject2);
            multiTextNode.myLeftPorts.add(jGoObject);
        }
        for (n = 0; n < this.myRightPorts.size(); ++n) {
            jGoObject2 = (JGoObject)this.myRightPorts.get(n);
            jGoObject = (JGoObject)jGoCopyEnvironment.get(jGoObject2);
            multiTextNode.myRightPorts.add(jGoObject);
        }
    }

    public JGoDrawable getBackground() {
        return this.myBack;
    }

    public void setBackground(JGoDrawable jGoDrawable) {
        JGoDrawable jGoDrawable2 = this.myBack;
        if (jGoDrawable2 != jGoDrawable) {
            if (jGoDrawable2 != null) {
                if (jGoDrawable != null) {
                    jGoDrawable.setBoundingRect(jGoDrawable2.getBoundingRect());
                }
                this.removeObject(jGoDrawable2);
            }
            this.myBack = jGoDrawable;
            if (jGoDrawable != null) {
                jGoDrawable.setSelectable(false);
                jGoDrawable.setDraggable(false);
                jGoDrawable.setResizable(false);
                this.addObjectAtHead(jGoDrawable);
            }
            this.update(75557, 0, jGoDrawable2);
        }
    }

    public JGoPen getLinePen() {
        return this.myLinePen;
    }

    public void setLinePen(JGoPen jGoPen) {
        JGoPen jGoPen2 = this.myLinePen;
        if (jGoPen2 != jGoPen) {
            this.myLinePen = jGoPen;
            this.layoutChildren(null);
            this.update(75567, 0, jGoPen2);
        }
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public void setInsets(Insets insets) {
        Insets insets2 = this.myInsets;
        if (!insets2.equals(insets)) {
            Insets insets3 = new Insets(insets2.top, insets2.left, insets2.bottom, insets2.right);
            this.myInsets.top = insets.top;
            this.myInsets.left = insets.left;
            this.myInsets.bottom = insets.bottom;
            this.myInsets.right = insets.right;
            this.layoutChildren(null);
            this.update(75568, 0, insets3);
        }
    }

    public int getSpacing() {
        return this.mySpacing;
    }

    public void setSpacing(int n) {
        int n2 = this.mySpacing;
        if (n2 != n) {
            this.mySpacing = n;
            this.layoutChildren(null);
            this.update(75569, n2, null);
        }
    }

    public JGoPen getPen() {
        return this.getBackground().getPen();
    }

    public void setPen(JGoPen jGoPen) {
        this.getBackground().setPen(jGoPen);
    }

    public JGoBrush getBrush() {
        return this.getBackground().getBrush();
    }

    public void setBrush(JGoBrush jGoBrush) {
        this.getBackground().setBrush(jGoBrush);
    }

    public JGoObject getTopPort() {
        return this.myTopPort;
    }

    public void setTopPort(JGoObject jGoObject) {
        JGoObject jGoObject2 = this.myTopPort;
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                this.removeObject(jGoObject2);
            }
            this.myTopPort = jGoObject;
            if (jGoObject != null) {
                this.addObjectAtTail(jGoObject);
            }
            this.update(75558, 0, jGoObject2);
        }
    }

    public JGoObject getBottomPort() {
        return this.myBottomPort;
    }

    public void setBottomPort(JGoObject jGoObject) {
        JGoObject jGoObject2 = this.myBottomPort;
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                this.removeObject(jGoObject2);
            }
            this.myBottomPort = jGoObject;
            if (jGoObject != null) {
                this.addObjectAtTail(jGoObject);
            }
            this.update(75560, 0, jGoObject2);
        }
    }

    public int getNumItems() {
        return this.myVector.size();
    }

    public JGoObject getItem(int n) {
        if (n < 0 || n >= this.myVector.size()) {
            return null;
        }
        return (JGoObject)this.myVector.get(n);
    }

    public void setItem(int n, JGoObject jGoObject) {
        if (n < 0 || n >= this.getNumItems()) {
            return;
        }
        JGoObject jGoObject2 = this.getItem(n);
        if (jGoObject2 == null) {
            return;
        }
        if (jGoObject2 != jGoObject) {
            this.removeObject(jGoObject2);
            this.myVector.set(n, jGoObject);
            if (jGoObject != null) {
                this.addObjectAtTail(jGoObject);
                jGoObject.setSelectable(false);
                jGoObject.setResizable(false);
                jGoObject.setDraggable(false);
                this.layoutChildren(jGoObject);
            }
            this.update(75572, n, jGoObject2);
        }
    }

    public JGoObject getLeftPort(int n) {
        if (n < 0 || n >= this.myLeftPorts.size()) {
            return null;
        }
        return (JGoObject)this.myLeftPorts.get(n);
    }

    public void setLeftPort(int n, JGoObject jGoObject) {
        JGoObject jGoObject2 = this.getLeftPort(n);
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                if (jGoObject != null) {
                    jGoObject.setBoundingRect(jGoObject2.getBoundingRect());
                }
                this.removeObject(jGoObject2);
            }
            this.myLeftPorts.set(n, jGoObject);
            if (jGoObject != null) {
                jGoObject.setSelectable(false);
                jGoObject.setDraggable(false);
                jGoObject.setResizable(false);
                this.addObjectAtTail(jGoObject);
            }
            this.update(75573, n, jGoObject2);
        }
    }

    public JGoObject getRightPort(int n) {
        if (n < 0 || n >= this.myRightPorts.size()) {
            return null;
        }
        return (JGoObject)this.myRightPorts.get(n);
    }

    public void setRightPort(int n, JGoObject jGoObject) {
        JGoObject jGoObject2 = this.getRightPort(n);
        if (jGoObject2 != jGoObject) {
            if (jGoObject2 != null) {
                if (jGoObject != null) {
                    jGoObject.setBoundingRect(jGoObject2.getBoundingRect());
                }
                this.removeObject(jGoObject2);
            }
            this.myRightPorts.set(n, jGoObject);
            if (jGoObject != null) {
                jGoObject.setSelectable(false);
                jGoObject.setDraggable(false);
                jGoObject.setResizable(false);
                this.addObjectAtTail(jGoObject);
            }
            this.update(75574, n, jGoObject2);
        }
    }

    public String getString(int n) {
        JGoObject jGoObject = this.getItem(n);
        if (jGoObject != null && jGoObject instanceof JGoText) {
            JGoText jGoText = (JGoText)jGoObject;
            return jGoText.getText();
        }
        return "";
    }

    public void setString(int n, String string) {
        JGoObject jGoObject = this.getItem(n);
        if (jGoObject != null && jGoObject instanceof JGoText) {
            JGoText jGoText = (JGoText)jGoObject;
            jGoText.setText(string);
        }
    }

    public JGoObject addString(String string) {
        int n = this.getNumItems();
        this.insertItem(n, this.createItem(n, string), this.createPort(n, true), this.createPort(n, false));
        return this.getItem(n);
    }

    public final void addItem(JGoObject jGoObject, JGoObject jGoObject2, JGoObject jGoObject3) {
        this.insertItem(this.getNumItems(), jGoObject, jGoObject2, jGoObject3);
    }

    public void insertItem(int n, JGoObject jGoObject, JGoObject jGoObject2, JGoObject jGoObject3) {
        if (n < 0 || n > this.getNumItems()) {
            return;
        }
        JGoDrawable jGoDrawable = this.getBackground();
        this.myVector.add(n, jGoObject);
        if (jGoObject != null) {
            jGoObject.setTopLeft(jGoDrawable.getLeft(), jGoDrawable.getTop());
            jGoObject.setSelectable(false);
            jGoObject.setDraggable(false);
            jGoObject.setResizable(false);
            this.addObjectAtTail(jGoObject);
        }
        this.myLeftPorts.add(n, jGoObject2);
        if (jGoObject2 != null) {
            jGoObject2.setTopLeft(jGoDrawable.getLeft(), jGoDrawable.getTop());
            jGoObject2.setSelectable(false);
            jGoObject2.setDraggable(false);
            jGoObject2.setResizable(false);
            this.addObjectAtTail(jGoObject2);
        }
        this.myRightPorts.add(n, jGoObject3);
        if (jGoObject3 != null) {
            jGoObject3.setTopLeft(jGoDrawable.getLeft(), jGoDrawable.getTop());
            jGoObject3.setSelectable(false);
            jGoObject3.setDraggable(false);
            jGoObject3.setResizable(false);
            this.addObjectAtTail(jGoObject3);
        }
        this.layoutChildren(null);
        JGoObject[] jGoObjectArray = new JGoObject[]{jGoObject, jGoObject2, jGoObject3};
        this.update(75575, n, jGoObjectArray);
    }

    public void removeItem(int n) {
        JGoObject jGoObject;
        if (n < 0 || n >= this.getNumItems()) {
            return;
        }
        JGoObject jGoObject2 = this.getLeftPort(n);
        this.myLeftPorts.remove(n);
        if (jGoObject2 != null) {
            super.removeObject(jGoObject2);
        }
        JGoObject jGoObject3 = this.getRightPort(n);
        this.myRightPorts.remove(n);
        if (jGoObject3 != null) {
            super.removeObject(jGoObject3);
        }
        if ((jGoObject = this.getItem(n)) != null) {
            this.myVector.remove(n);
            super.removeObject(jGoObject);
        }
        this.layoutChildren(null);
        JGoObject[] jGoObjectArray = new JGoObject[]{jGoObject, jGoObject2, jGoObject3};
        this.update(75576, n, jGoObjectArray);
    }

    public void removeObject(JGoObject jGoObject) {
        boolean bl = false;
        int n = this.getNumItems();
        for (int i = 0; i < n; ++i) {
            JGoObject jGoObject2 = this.getItem(i);
            if (jGoObject2 != jGoObject) continue;
            this.removeItem(i);
            bl = true;
            break;
        }
        if (!bl) {
            super.removeObject(jGoObject);
        }
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        Insets insets = this.getInsets();
        JGoDrawable jGoDrawable = this.getBackground();
        if (jGoDrawable == null) {
            return;
        }
        this.setInitializing(true);
        this.sendObjectToBack(jGoDrawable);
        int n = 0;
        if (this.getTopPort() != null) {
            n = this.getTopPort().getHeight();
        }
        int n2 = 0;
        if (this.getBottomPort() != null) {
            n2 = this.getBottomPort().getHeight();
        }
        int n3 = this.getMaxPortWidth(true);
        int n4 = this.getMaxPortWidth(false);
        int n5 = this.getItemWidth();
        int n6 = jGoDrawable.getLeft() + insets.left;
        int n7 = jGoDrawable.getTop() + insets.top;
        int n8 = n5 + insets.left + insets.right;
        int n9 = 0;
        if (this.getLinePen() != null) {
            n9 = this.getLinePen().getWidth();
        }
        int n10 = Math.max(n9, this.getSpacing());
        this.layoutEndPorts();
        int n11 = 0;
        int n12 = this.getNumItems();
        for (int i = 0; i < n12; ++i) {
            int n13 = this.getItemHeight(i);
            this.layoutItem(i, n6, n7 + n11, n8, n13, n5);
            n11 += n13;
            n11 += n10;
        }
        if (n12 > 0) {
            n11 -= n10;
        }
        jGoDrawable.setSize(n8, n11 + insets.top + insets.bottom);
        this.setInitializing(false);
    }

    public int getItemWidth() {
        return this.myItemWidth;
    }

    public void setItemWidth(int n) {
        int n2 = this.myItemWidth;
        if (n2 != n) {
            this.myItemWidth = n;
            for (int i = 0; i < this.getNumItems(); ++i) {
                JGoObject jGoObject = this.getItem(i);
                if (jGoObject == null || !(jGoObject instanceof JGoText)) continue;
                JGoText jGoText = (JGoText)jGoObject;
                jGoText.setWrappingWidth(n);
            }
            this.layoutChildren(null);
            this.update(75571, n2, null);
        }
    }

    public int getMaxPortWidth(boolean bl) {
        int n = 0;
        ArrayList arrayList = bl ? this.myLeftPorts : this.myRightPorts;
        for (int i = 0; i < arrayList.size(); ++i) {
            JGoObject jGoObject = (JGoObject)arrayList.get(i);
            if (jGoObject == null) continue;
            n = Math.max(n, jGoObject.getWidth());
        }
        return n;
    }

    protected int getItemHeight(int n) {
        JGoObject jGoObject;
        JGoObject jGoObject2;
        int n2 = 0;
        JGoObject jGoObject3 = this.getItem(n);
        if (jGoObject3 != null) {
            n2 = jGoObject3.getHeight();
        }
        if ((jGoObject2 = this.getLeftPort(n)) != null) {
            n2 = Math.max(n2, jGoObject2.getHeight());
        }
        if ((jGoObject = this.getRightPort(n)) != null) {
            n2 = Math.max(n2, jGoObject.getHeight());
        }
        return n2;
    }

    protected void layoutEndPorts() {
        JGoDrawable jGoDrawable = this.getBackground();
        if (jGoDrawable == null) {
            return;
        }
        JGoObject jGoObject = this.getTopPort();
        if (jGoObject != null) {
            jGoObject.setSpotLocation(6, jGoDrawable, 2);
        }
        if ((jGoObject = this.getBottomPort()) != null) {
            jGoObject.setSpotLocation(2, jGoDrawable, 6);
        }
    }

    protected void layoutItem(int n, int n2, int n3, int n4, int n5, int n6) {
        JGoObject jGoObject;
        int n7;
        JGoDrawable jGoDrawable;
        JGoObject jGoObject2 = this.getItem(n);
        if (jGoObject2 != null) {
            jGoObject2.setTopLeft(n2, n3 + n5 / 2 - jGoObject2.getHeight() / 2);
            jGoObject2.setWidth(n6);
        }
        if ((jGoDrawable = this.getBackground()) == null) {
            return;
        }
        int n8 = jGoDrawable.getLeft();
        int n9 = jGoDrawable.getTop();
        int n10 = jGoDrawable.getWidth();
        JGoObject jGoObject3 = this.getLeftPort(n);
        if (jGoObject3 != null) {
            jGoObject3.setVisible(true);
            int n11 = n8 - jGoObject3.getWidth();
            n7 = n3 + n5 / 2 - jGoObject3.getHeight() / 2;
            jGoObject3.setTopLeft(n11, n7);
        }
        if ((jGoObject = this.getRightPort(n)) != null) {
            jGoObject.setVisible(true);
            n7 = n8 + n10;
            int n12 = n3 + n5 / 2 - jGoObject.getHeight() / 2;
            jGoObject.setTopLeft(n7, n12);
        }
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        super.paint(graphics2D, jGoView);
        int n = 0;
        if (this.getLinePen() != null) {
            n = this.getLinePen().getWidth();
        }
        if (n <= 0) {
            return;
        }
        JGoDrawable jGoDrawable = this.getBackground();
        if (jGoDrawable == null) {
            return;
        }
        int n2 = jGoDrawable.getLeft();
        int n3 = jGoDrawable.getTop();
        int n4 = jGoDrawable.getWidth();
        int n5 = jGoDrawable.getHeight();
        Insets insets = this.getInsets();
        int n6 = n2 + insets.left;
        int n7 = n3 + insets.top;
        int n8 = n4 - insets.left - insets.right;
        int n9 = 0;
        int n10 = Math.max(n, this.getSpacing());
        int n11 = this.getNumItems() - 1;
        for (int i = 0; i < n11; ++i) {
            int n12 = this.getItemHeight(i);
            JGoDrawable.drawLine(graphics2D, this.getLinePen(), n2, n7 + (n9 += n12) + n10 / 2, n2 + n4, n7 + n9 + n10 / 2);
            n9 += n10;
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75567: {
                jGoDocumentChangedEdit.setNewValue(this.getLinePen());
                return;
            }
            case 75568: {
                Insets insets = this.getInsets();
                jGoDocumentChangedEdit.setNewValue(new Insets(insets.top, insets.left, insets.bottom, insets.right));
                return;
            }
            case 75569: {
                jGoDocumentChangedEdit.setNewValueInt(this.getSpacing());
                return;
            }
            case 75572: {
                jGoDocumentChangedEdit.setNewValue(this.getItem(jGoDocumentChangedEdit.getOldValueInt()));
                return;
            }
            case 75571: {
                jGoDocumentChangedEdit.setNewValueInt(this.getItemWidth());
                return;
            }
            case 75557: {
                jGoDocumentChangedEdit.setNewValue(this.getBackground());
                return;
            }
            case 75558: {
                jGoDocumentChangedEdit.setNewValue(this.getTopPort());
                return;
            }
            case 75560: {
                jGoDocumentChangedEdit.setNewValue(this.getBottomPort());
                return;
            }
            case 75573: {
                jGoDocumentChangedEdit.setNewValue(this.getLeftPort(jGoDocumentChangedEdit.getOldValueInt()));
                return;
            }
            case 75574: {
                jGoDocumentChangedEdit.setNewValue(this.getRightPort(jGoDocumentChangedEdit.getOldValueInt()));
                return;
            }
            case 75575: {
                return;
            }
            case 75576: {
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 75567: {
                this.myLinePen = (JGoPen)jGoDocumentChangedEdit.getValue(bl);
                this.update();
                return;
            }
            case 75568: {
                Insets insets = (Insets)jGoDocumentChangedEdit.getValue(bl);
                this.myInsets.top = insets.top;
                this.myInsets.left = insets.left;
                this.myInsets.bottom = insets.bottom;
                this.myInsets.right = insets.right;
                return;
            }
            case 75569: {
                this.mySpacing = jGoDocumentChangedEdit.getValueInt(bl);
                return;
            }
            case 75572: {
                this.setItem(jGoDocumentChangedEdit.getOldValueInt(), (JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75571: {
                this.myItemWidth = jGoDocumentChangedEdit.getValueInt(bl);
                return;
            }
            case 75557: {
                this.setBackground((JGoDrawable)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75558: {
                this.setTopPort((JGoPort)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75560: {
                this.setBottomPort((JGoPort)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75573: {
                this.setLeftPort(jGoDocumentChangedEdit.getOldValueInt(), (JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75574: {
                this.setRightPort(jGoDocumentChangedEdit.getOldValueInt(), (JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 75575: {
                if (bl) {
                    this.removeItem(jGoDocumentChangedEdit.getOldValueInt());
                } else {
                    JGoObject[] jGoObjectArray = (JGoObject[])jGoDocumentChangedEdit.getOldValue();
                    this.insertItem(jGoDocumentChangedEdit.getOldValueInt(), jGoObjectArray[0], jGoObjectArray[1], jGoObjectArray[2]);
                }
                return;
            }
            case 75576: {
                if (bl) {
                    JGoObject[] jGoObjectArray = (JGoObject[])jGoDocumentChangedEdit.getOldValue();
                    this.insertItem(jGoDocumentChangedEdit.getOldValueInt(), jGoObjectArray[0], jGoObjectArray[1], jGoObjectArray[2]);
                } else {
                    this.removeItem(jGoDocumentChangedEdit.getOldValueInt());
                }
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("backdraw")) {
            this.myBack = (JGoDrawable)object;
            this.layoutChildren(null);
        } else if (string.equals("topport")) {
            this.myTopPort = (JGoObject)object;
        } else if (string.equals("bottomport")) {
            this.myBottomPort = (JGoObject)object;
        } else if (string.equals("vectorelements")) {
            this.myVector.add(object);
            this.layoutChildren(null);
        } else if (string.equals("leftports")) {
            this.myLeftPorts.add(object);
        } else if (string.equals("rightports")) {
            this.myRightPorts.add(object);
        } else if (string.equals("linepen")) {
            this.myLinePen = (JGoPen)object;
            this.layoutChildren(null);
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            int n;
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.MultiTextNode", domElement);
            domElement2.setAttribute("spacing", Integer.toString(this.mySpacing));
            domElement2.setAttribute("itemwidth", Integer.toString(this.myItemWidth));
            domElement2.setAttribute("insetleft", Integer.toString(this.myInsets.left));
            domElement2.setAttribute("insetright", Integer.toString(this.myInsets.right));
            domElement2.setAttribute("insettop", Integer.toString(this.myInsets.top));
            domElement2.setAttribute("insetbottom", Integer.toString(this.myInsets.bottom));
            if (this.myBack != null) {
                domDoc.registerReferencingNode(domElement2, "backdraw", this.myBack);
            }
            if (this.myTopPort != null) {
                domDoc.registerReferencingNode(domElement2, "topport", this.myTopPort);
            }
            if (this.myBottomPort != null) {
                domDoc.registerReferencingNode(domElement2, "bottomport", this.myBottomPort);
            }
            for (n = 0; n < this.myVector.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "vectorelements", (JGoObject)this.myVector.get(n));
            }
            for (n = 0; n < this.myLeftPorts.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "leftports", (JGoObject)this.myLeftPorts.get(n));
            }
            for (n = 0; n < this.myRightPorts.size(); ++n) {
                domDoc.registerReferencingNode(domElement2, "rightports", (JGoObject)this.myRightPorts.get(n));
            }
            if (this.myLinePen != null) {
                if (!domDoc.isRegisteredReference(this.myLinePen)) {
                    domElement2.setAttribute("embeddedlinepen", "true");
                    DomElement domElement3 = domDoc.createElement("g");
                    domElement2.appendChild(domElement3);
                    this.myLinePen.SVGWriteObject(domDoc, domElement3);
                }
                domDoc.registerReferencingNode(domElement2, "linepen", this.myLinePen);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.mySpacing = Integer.parseInt(domElement2.getAttribute("spacing"));
            this.myItemWidth = Integer.parseInt(domElement2.getAttribute("itemwidth"));
            this.myInsets.left = Integer.parseInt(domElement2.getAttribute("insetleft"));
            this.myInsets.right = Integer.parseInt(domElement2.getAttribute("insetright"));
            this.myInsets.top = Integer.parseInt(domElement2.getAttribute("insettop"));
            this.myInsets.bottom = Integer.parseInt(domElement2.getAttribute("insetbottom"));
            String string = domElement2.getAttribute("backdraw");
            domDoc.registerReferencingObject(this, "backdraw", string);
            String string2 = domElement2.getAttribute("topport");
            domDoc.registerReferencingObject(this, "topport", string2);
            String string3 = domElement2.getAttribute("bottomport");
            domDoc.registerReferencingObject(this, "bottomport", string3);
            String string4 = domElement2.getAttribute("vectorelements");
            while (string4.length() > 0) {
                int n = string4.indexOf(" ");
                if (n == -1) {
                    n = string4.length();
                }
                String string5 = string4.substring(0, n);
                string4 = n >= string4.length() ? "" : string4.substring(n + 1);
                domDoc.registerReferencingObject(this, "vectorelements", string5);
            }
            String string6 = domElement2.getAttribute("leftports");
            while (string6.length() > 0) {
                int n = string6.indexOf(" ");
                if (n == -1) {
                    n = string6.length();
                }
                String string7 = string6.substring(0, n);
                string6 = n >= string6.length() ? "" : string6.substring(n + 1);
                domDoc.registerReferencingObject(this, "leftports", string7);
            }
            String string8 = domElement2.getAttribute("rightports");
            while (string8.length() > 0) {
                int n = string8.indexOf(" ");
                if (n == -1) {
                    n = string8.length();
                }
                String string9 = string8.substring(0, n);
                string8 = n >= string8.length() ? "" : string8.substring(n + 1);
                domDoc.registerReferencingObject(this, "rightports", string9);
            }
            if (domElement2.getAttribute("embeddedlinepen").equals("true")) {
                domDoc.SVGTraverseChildren(jGoDocument, domElement2, null, false);
            }
            String string10 = domElement2.getAttribute("linepen");
            domDoc.registerReferencingObject(this, "linepen", string10);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

