/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.SimpleNodeLabel;
import com.nwoods.jgo.examples.SimpleNodePort;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class SimpleNode
extends JGoNode {
    protected JGoText myLabel = null;
    protected JGoObject myIcon = null;
    protected JGoPort myInputPort = null;
    protected JGoPort myOutputPort = null;

    public void initialize(Point point, Dimension dimension, JGoObject jGoObject, String string, boolean bl, boolean bl2) {
        this.setInitializing(true);
        this.setDraggable(true);
        this.setResizable(false);
        this.set4ResizeHandles(true);
        this.myIcon = jGoObject;
        if (this.myIcon != null) {
            this.myIcon.setBoundingRect(point, dimension);
            this.myIcon.setSelectable(false);
            this.addObjectAtHead(this.myIcon);
        }
        if (string != null) {
            this.myLabel = new SimpleNodeLabel(string, this);
        }
        if (bl) {
            this.myInputPort = this.createPort(true);
        }
        if (bl2) {
            this.myOutputPort = this.createPort(false);
        }
        this.setInitializing(false);
        this.layoutChildren(null);
        this.setTopLeft(point);
    }

    protected JGoPort createPort(boolean bl) {
        return new SimpleNodePort(bl, this);
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        SimpleNode simpleNode = (SimpleNode)jGoArea;
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        simpleNode.myIcon = (JGoObject)jGoCopyEnvironment.get(this.myIcon);
        simpleNode.myLabel = (JGoText)jGoCopyEnvironment.get(this.myLabel);
        simpleNode.myInputPort = (JGoPort)jGoCopyEnvironment.get(this.myInputPort);
        simpleNode.myOutputPort = (JGoPort)jGoCopyEnvironment.get(this.myOutputPort);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = super.removeObjectAtPos(jGoListPosition);
        if (jGoObject == this.myIcon) {
            this.myIcon = null;
        } else if (jGoObject == this.myLabel) {
            this.myLabel = null;
        } else if (jGoObject == this.myInputPort) {
            this.myInputPort = null;
        } else if (jGoObject == this.myOutputPort) {
            this.myOutputPort = null;
        }
        return jGoObject;
    }

    public void layoutChildren(JGoObject jGoObject) {
        if (this.isInitializing()) {
            return;
        }
        this.setInitializing(true);
        JGoObject jGoObject2 = this.getIcon();
        JGoText jGoText = this.getLabel();
        JGoPort jGoPort = this.getInputPort();
        JGoPort jGoPort2 = this.getOutputPort();
        if (jGoText != null) {
            if (jGoObject2 != null) {
                jGoText.setSpotLocation(2, jGoObject2, 6);
            } else {
                jGoText.setSpotLocation(6, this, 6);
            }
        }
        if (jGoPort != null) {
            if (jGoObject2 != null) {
                jGoPort.setSpotLocation(4, jGoObject2, 8);
            } else {
                jGoPort.setSpotLocation(8, this, 8);
            }
        }
        if (jGoPort2 != null) {
            if (jGoObject2 != null) {
                jGoPort2.setSpotLocation(8, jGoObject2, 4);
            } else {
                jGoPort2.setSpotLocation(4, this, 4);
            }
        }
        this.setInitializing(false);
    }

    public void rescaleChildren(Rectangle rectangle) {
        if (this.myIcon != null) {
            double d;
            int n = this.myIcon.getWidth();
            int n2 = this.myIcon.getHeight();
            if (n <= 0) {
                n = 1;
            }
            double d2 = (double)n2 / (double)n;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            if (this.myInputPort != null) {
                n3 -= this.myInputPort.getWidth();
            }
            if (this.myOutputPort != null) {
                n3 -= this.myOutputPort.getWidth();
            }
            if (this.myLabel != null) {
                n4 -= this.myLabel.getHeight();
            }
            if (d2 < (d = (double)n4 / (double)n3)) {
                n4 = (int)Math.rint(d2 * (double)n3);
            } else {
                n3 = (int)Math.rint((double)n4 / d2);
            }
            this.myIcon.setSize(n3, n4);
        }
    }

    public Dimension getMinimumIconSize() {
        return new Dimension(20, 20);
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        if (this.myInputPort != null) {
            n += this.myInputPort.getWidth();
        }
        if (this.myOutputPort != null) {
            n += this.myOutputPort.getWidth();
        }
        Dimension dimension = this.getMinimumIconSize();
        n += dimension.width;
        n2 += dimension.height;
        if (this.myLabel != null) {
            n = Math.max(n, this.myLabel.getWidth());
            n2 += this.myLabel.getHeight();
        }
        return new Dimension(n, n2);
    }

    public void setBoundingRect(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getMinimumSize();
        super.setBoundingRect(n, n2, Math.max(n3, dimension.width), Math.max(n4, dimension.height));
    }

    protected Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        Dimension dimension = this.getMinimumSize();
        Rectangle rectangle2 = super.handleResize(graphics2D, jGoView, rectangle, point, n, n2, Math.max(n3, dimension.width), Math.max(n4, dimension.height));
        if (n2 == 2) {
            this.setBoundingRect(rectangle2);
        }
        return null;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.SimpleNode", domElement);
            if (this.myIcon != null) {
                domDoc.registerReferencingNode(domElement2, "simpleicon", this.myIcon);
            }
            if (this.myInputPort != null) {
                domDoc.registerReferencingNode(domElement2, "simpleinputport", this.myInputPort);
            }
            if (this.myOutputPort != null) {
                domDoc.registerReferencingNode(domElement2, "simpleoutputport", this.myOutputPort);
            }
            if (this.myLabel != null) {
                domDoc.registerReferencingNode(domElement2, "simplelabel", this.myLabel);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            String string = domElement2.getAttribute("simpleicon");
            domDoc.registerReferencingObject(this, "simpleicon", string);
            String string2 = domElement2.getAttribute("simpleinputport");
            domDoc.registerReferencingObject(this, "simpleinputport", string2);
            String string3 = domElement2.getAttribute("simpleoutputport");
            domDoc.registerReferencingObject(this, "simpleoutputport", string3);
            String string4 = domElement2.getAttribute("simplelabel");
            domDoc.registerReferencingObject(this, "simplelabel", string4);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingElement());
        }
        return domElement.getNextSibling();
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("simpleicon")) {
            this.myIcon = (JGoObject)object;
        }
        if (string.equals("simpleinputport")) {
            this.myInputPort = (JGoPort)object;
        }
        if (string.equals("simpleoutputport")) {
            this.myOutputPort = (JGoPort)object;
        }
        if (string.equals("simplelabel")) {
            this.myLabel = (JGoText)object;
        }
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public JGoObject getIcon() {
        return this.myIcon;
    }

    public JGoPort getInputPort() {
        return this.myInputPort;
    }

    public JGoPort getOutputPort() {
        return this.myOutputPort;
    }
}

