/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.processor;

import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.MultiPortNode;
import com.nwoods.jgo.examples.processor.ActivityPort;
import com.nwoods.jgo.examples.processor.ProcessDocument;
import com.nwoods.jgo.examples.processor.ProcessView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;

public class ActivityNode
extends MultiPortNode {
    public static final int Start = 0;
    public static final int Finish = 1;
    public static final int Activity = 2;
    private static Dimension myStdSize = new Dimension(50, 50);
    private static Point myStdPoint = new Point(0, 0);
    private int myID = -1;
    private int myActivityType = 0;
    static /* synthetic */ Class class$com$nwoods$jgo$examples$processor$ActivityNode;

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        ActivityNode activityNode = (ActivityNode)super.copyObject(jGoCopyEnvironment);
        if (activityNode != null) {
            activityNode.myActivityType = this.myActivityType;
        }
        return activityNode;
    }

    public void initialize(int n, int n2) {
        super.initialize(myStdPoint, ActivityNode.getImage(n), ActivityNode.getLabelString(n));
        this.myID = n2;
        this.myActivityType = n;
        if (this.getLabel() != null) {
            this.getLabel().setBold(true);
            this.getLabel().setTextColor(new Color(0, 127, 0));
        }
        this.resetEditability();
    }

    public void addScatteredPorts(int n) {
        if (this.getActivityType() == 0) {
            ActivityPort activityPort = new ActivityPort(false, true, 4, new Point(40, 25), new Dimension(8, 8), this.getIcon(), this, 0);
            activityPort.setMaxLinks(999999);
        } else if (this.getActivityType() == 1) {
            ActivityPort activityPort = new ActivityPort(true, false, 8, new Point(10, 25), new Dimension(8, 8), this.getIcon(), this, 0);
            activityPort.setMaxLinks(999999);
        } else {
            for (int i = 0; i < n; ++i) {
                Point point = new Point(8 * (int)(Math.random() * 6.0), 8 * (int)(Math.random() * 6.0));
                int n2 = 0;
                n2 = point.x > point.y ? (point.x < 40 - point.y ? 2 : 4) : (point.x > 40 - point.y ? 6 : 8);
                ActivityPort activityPort = new ActivityPort(true, true, n2, point, new Dimension(8, 8), this.getIcon(), this, i);
                activityPort.setMaxLinks(1);
            }
        }
    }

    public ProcessDocument getDoc() {
        return (ProcessDocument)this.getDocument();
    }

    protected void ownerChange(JGoObjectCollection jGoObjectCollection, JGoObjectCollection jGoObjectCollection2, JGoObject jGoObject) {
        if (jGoObjectCollection == null && jGoObjectCollection2 != null && jGoObjectCollection2 instanceof ProcessDocument && this.getID() == -1) {
            ProcessDocument processDocument = (ProcessDocument)jGoObjectCollection2;
            this.myID = processDocument.getNextNodeID();
        }
    }

    public void resetEditability() {
        if (this.getLabel() != null) {
            this.getLabel().setEditable(this.getActivityType() != 0 && this.getActivityType() != 1);
        }
    }

    public String getToolTipText() {
        return "a tooltip";
    }

    public boolean doMouseDblClick(int n, Point point, Point point2, JGoView jGoView) {
        if (jGoView instanceof ProcessView) {
            ProcessView processView = (ProcessView)jGoView;
            processView.editActivity(this);
            return true;
        }
        return false;
    }

    public int getID() {
        return this.myID;
    }

    public int getActivityType() {
        return this.myActivityType;
    }

    public String getText() {
        if (this.getLabel() != null) {
            return this.getLabel().getText();
        }
        return "";
    }

    public void setText(String string) {
        if (this.getLabel() != null) {
            this.getLabel().setText(string);
        }
    }

    public ActivityPort getPortByID(int n) {
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            ActivityPort activityPort;
            JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPos(jGoListPosition);
            if (!(jGoObject instanceof ActivityPort) || (activityPort = (ActivityPort)jGoObject).getID() != n) continue;
            return activityPort;
        }
        return null;
    }

    public static JGoImage getImage(int n) {
        JGoImage jGoImage = null;
        switch (n) {
            case 0: {
                jGoImage = new JGoImage(myStdPoint, ActivityNode.getStdSize());
                jGoImage.loadImage((class$com$nwoods$jgo$examples$processor$ActivityNode == null ? (class$com$nwoods$jgo$examples$processor$ActivityNode = ActivityNode.class$("com.nwoods.jgo.examples.processor.ActivityNode")) : class$com$nwoods$jgo$examples$processor$ActivityNode).getResource("images/star.gif"), true);
                break;
            }
            case 1: {
                jGoImage = new JGoImage(myStdPoint, ActivityNode.getStdSize());
                jGoImage.loadImage((class$com$nwoods$jgo$examples$processor$ActivityNode == null ? (class$com$nwoods$jgo$examples$processor$ActivityNode = ActivityNode.class$("com.nwoods.jgo.examples.processor.ActivityNode")) : class$com$nwoods$jgo$examples$processor$ActivityNode).getResource("images/star.gif"), true);
                break;
            }
            default: {
                jGoImage = new JGoImage(myStdPoint, ActivityNode.getStdSize());
                jGoImage.loadImage((class$com$nwoods$jgo$examples$processor$ActivityNode == null ? (class$com$nwoods$jgo$examples$processor$ActivityNode = ActivityNode.class$("com.nwoods.jgo.examples.processor.ActivityNode")) : class$com$nwoods$jgo$examples$processor$ActivityNode).getResource("images/doc.gif"), true);
            }
        }
        return jGoImage;
    }

    public static String getLabelString(int n) {
        switch (n) {
            case 0: {
                return "Start";
            }
            case 1: {
                return "Finish";
            }
        }
        return "Activity" + Integer.toString(n - 2 + 1);
    }

    public static Dimension getStdSize() {
        return myStdSize;
    }

    public static void setStdSize(int n, int n2) {
        ActivityNode.myStdSize.width = n;
        ActivityNode.myStdSize.height = n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

