/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.processor;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoLinkLabel;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.processor.FlowLink;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class FlowLabel
extends JGoLinkLabel {
    public static final int ChangedOffset = 65658;
    public static final int ChangedSegment = 65659;
    public static final int ChangedSegmentDistance = 65660;
    public static final int ChangedConnectorPen = 65661;
    public static final int ChangedBoxPen = 65662;
    private Point myOffset = new Point(0, 0);
    private int mySegment = 3;
    private int mySegmentDistance = 50;
    private JGoPen myConnectorPen = JGoPen.lightGray;
    private JGoPen myBoxPen = JGoPen.lightGray;

    public FlowLabel() {
        this.setTextColor(new Color(0, 127, 0));
        this.setAlignment(2);
        this.setEditOnSingleClick(true);
        this.setEditable(true);
        this.setDraggable(true);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        FlowLabel flowLabel = (FlowLabel)super.copyObject(jGoCopyEnvironment);
        if (flowLabel != null) {
            flowLabel.myOffset.x = this.myOffset.x;
            flowLabel.myOffset.y = this.myOffset.y;
            flowLabel.mySegment = this.mySegment;
            flowLabel.mySegmentDistance = this.mySegmentDistance;
            flowLabel.myConnectorPen = this.myConnectorPen;
            flowLabel.myBoxPen = this.myBoxPen;
        }
        return flowLabel;
    }

    public FlowLink getLink() {
        return (FlowLink)this.getPartner();
    }

    public Point getOffset() {
        return this.myOffset;
    }

    public void setOffset(Point point) {
        this.setOffset(point.x, point.y);
    }

    public void setOffset(int n, int n2) {
        int n3 = this.myOffset.x;
        int n4 = this.myOffset.y;
        if (n3 != n || n4 != n2) {
            this.myOffset.x = n;
            this.myOffset.y = n2;
            this.update(65658, 0, new Point(n3, n4));
            if (this.getLink() != null) {
                this.getLink().positionLabels();
            }
        }
    }

    public int getSegment() {
        return this.mySegment;
    }

    public void setSegment(int n) {
        int n2 = this.mySegment;
        if (n2 != n && n >= 0) {
            this.mySegment = n;
            this.update(65659, n2, null);
            if (this.getLink() != null) {
                this.getLink().positionLabels();
            }
        }
    }

    public int getSegmentDistance() {
        return this.mySegmentDistance;
    }

    public void setSegmentDistance(int n) {
        int n2 = this.mySegmentDistance;
        if (n2 != n && n >= 0 && n <= 100) {
            this.mySegmentDistance = n;
            this.update(65660, n2, null);
            if (this.getLink() != null) {
                this.getLink().positionLabels();
            }
        }
    }

    public Point getMidLabelConnectionPoint(Point point) {
        FlowLink flowLink = this.getLink();
        if (flowLink != null) {
            int n;
            int n2 = flowLink.getNumPoints();
            if (n2 < 2) {
                return point;
            }
            if (point == null) {
                point = new Point(0, 0);
            }
            if ((n = this.getSegment()) < 1) {
                n = 1;
            } else if (n >= n2 - 2) {
                n = n2 - 3;
            }
            int n3 = flowLink.getPointX(n);
            int n4 = flowLink.getPointY(n);
            int n5 = flowLink.getPointX(n + 1);
            int n6 = flowLink.getPointY(n + 1);
            int n7 = this.getSegmentDistance();
            point.x = n3 + (n5 - n3) * n7 / 100;
            point.y = n4 + (n6 - n4) * n7 / 100;
        }
        return point;
    }

    public JGoPen getConnectorPen() {
        return this.myConnectorPen;
    }

    public void setConnectorPen(JGoPen jGoPen) {
        JGoPen jGoPen2 = this.myConnectorPen;
        if (jGoPen2 != jGoPen) {
            this.myConnectorPen = jGoPen;
            this.update(65661, 0, jGoPen2);
        }
    }

    public JGoPen getBoxPen() {
        return this.myBoxPen;
    }

    public void setBoxPen(JGoPen jGoPen) {
        JGoPen jGoPen2 = this.myBoxPen;
        if (jGoPen2 != jGoPen) {
            this.myBoxPen = jGoPen;
            this.update(65662, 0, jGoPen2);
        }
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        FlowLink flowLink = this.getLink();
        if (flowLink != null) {
            Cloneable cloneable;
            if (this.getConnectorPen() != null && (cloneable = this.getMidLabelConnectionPoint(null)) != null) {
                Rectangle rectangle = this.getBoundingRect();
                JGoDrawable.drawLine(graphics2D, this.getConnectorPen(), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, cloneable.x, cloneable.y);
            }
            if (this.getBoxPen() != null) {
                cloneable = this.getBoundingRect();
                JGoDrawable.drawRect(graphics2D, this.getBoxPen(), JGoBrush.white, ((Rectangle)cloneable).x - 4, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width + 6, ((Rectangle)cloneable).height + 1);
            }
        }
        super.paint(graphics2D, jGoView);
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        Point point;
        super.expandRectByPenWidth(rectangle);
        FlowLink flowLink = this.getLink();
        if (flowLink != null && this.getConnectorPen() != null && (point = this.getMidLabelConnectionPoint(null)) != null) {
            rectangle.add(point);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65658: {
                jGoDocumentChangedEdit.setNewValue(this.getOffset());
                return;
            }
            case 65659: {
                jGoDocumentChangedEdit.setNewValueInt(this.getSegment());
                return;
            }
            case 65660: {
                jGoDocumentChangedEdit.setNewValueInt(this.getSegmentDistance());
                return;
            }
            case 65661: {
                jGoDocumentChangedEdit.setNewValue(this.getConnectorPen());
                return;
            }
            case 65662: {
                jGoDocumentChangedEdit.setNewValue(this.getBoxPen());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 65658: {
                this.setOffset((Point)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 65659: {
                this.setSegment(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 65660: {
                this.setSegmentDistance(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 65661: {
                this.setConnectorPen((JGoPen)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 65662: {
                this.setBoxPen((JGoPen)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.FlowLabel", domElement);
            domElement2.setAttribute("offsetx", Integer.toString((int)this.getOffset().getX()));
            domElement2.setAttribute("offsety", Integer.toString((int)this.getOffset().getY()));
            domElement2.setAttribute("segment", Integer.toString(this.getSegment()));
            domElement2.setAttribute("segmentdistance", Integer.toString(this.getSegmentDistance()));
            JGoPen jGoPen = this.getBoxPen();
            if (jGoPen != null) {
                if (!domDoc.isRegisteredReference(this.getBoxPen())) {
                    domElement2.setAttribute("embeddedboxpen", "true");
                    DomElement domElement3 = domDoc.createElement("g");
                    domElement2.appendChild(domElement3);
                    this.getBoxPen().SVGWriteObject(domDoc, domElement3);
                }
                domDoc.registerReferencingNode(domElement2, "boxpen", this.getBoxPen());
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            int n = Integer.parseInt(domElement2.getAttribute("offsetX"));
            int n2 = Integer.parseInt(domElement2.getAttribute("offsetY"));
            this.setOffset(n, n2);
            this.setSegment(Integer.parseInt(domElement2.getAttribute("segment")));
            this.setSegmentDistance(Integer.parseInt(domElement2.getAttribute("segmentdistance")));
            if (domElement2.getAttribute("embeddedboxpen").equals("true")) {
                domDoc.SVGTraverseChildren(jGoDocument, domElement2, null, false);
            }
            String string = domElement2.getAttribute("boxpen");
            domDoc.registerReferencingObject(this, "boxpen", string);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

