/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.processor;

import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.processor.ActivityNode;
import com.nwoods.jgo.examples.processor.FlowLabel;
import com.nwoods.jgo.examples.processor.ProcessDocument;
import com.nwoods.jgo.examples.processor.ProcessView;
import java.awt.Color;
import java.awt.Point;

public class FlowLink
extends JGoLabeledLink {
    public FlowLink() {
        this.init();
    }

    public FlowLink(JGoPort jGoPort, JGoPort jGoPort2) {
        super(jGoPort, jGoPort2);
        this.init();
        FlowLabel flowLabel = new FlowLabel();
        flowLabel.setText("label");
        this.setMidLabel(flowLabel);
    }

    private void init() {
        this.setOrthogonal(true);
        this.setJumpsOver(true);
        this.setRoundedCorners(true);
        this.setAvoidsNodes(true);
        this.setGrabChildSelection(false);
    }

    public ProcessDocument getDoc() {
        return (ProcessDocument)this.getDocument();
    }

    public ActivityNode getFromNode() {
        if (this.getFromPort() != null) {
            return (ActivityNode)this.getFromPort().getParent();
        }
        return null;
    }

    public ActivityNode getToNode() {
        if (this.getToPort() != null) {
            return (ActivityNode)this.getToPort().getParent();
        }
        return null;
    }

    public boolean doMouseDblClick(int n, Point point, Point point2, JGoView jGoView) {
        ProcessView processView = (ProcessView)jGoView;
        processView.editFlow(this);
        return true;
    }

    public void calculateStroke() {
        super.calculateStroke();
        int n = this.getNumPoints();
        if (n >= 5 && this.isOrthogonal() && this.getAdjustingStyle() == 0) {
            Point point = this.getPoint(n - 1);
            Point point2 = this.getPoint(n - 2);
            Point point3 = this.getPoint(n - 3);
            Point point4 = this.getPoint(n - 4);
            if (point.x == point2.x && point2.x == point3.x && point3.x != point4.x || point.y == point2.y && point2.y == point3.y && point3.y != point4.y) {
                this.insertPoint(n - 2, point2);
            }
            point = this.getPoint(0);
            point2 = this.getPoint(1);
            point3 = this.getPoint(2);
            point4 = this.getPoint(3);
            if (point.x == point2.x && point2.x == point3.x && point3.x != point4.x || point.y == point2.y && point2.y == point3.y && point3.y != point4.y) {
                this.insertPoint(1, point2);
            }
        }
    }

    protected void positionMidLabel(JGoObject jGoObject, int n, int n2, int n3, int n4) {
        if (jGoObject instanceof FlowLabel) {
            FlowLabel flowLabel = (FlowLabel)jGoObject;
            Point point = flowLabel.getOffset();
            Point point2 = flowLabel.getMidLabelConnectionPoint(null);
            if (point2 != null) {
                jGoObject.setSpotLocationOffset(0, point2.x, point2.y, point.x, point.y);
            }
        } else {
            super.positionMidLabel(jGoObject, n, n2, n3, n4);
        }
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        super.gainedSelection(jGoSelection);
        this.setSkipsUndoManager(true);
        Color color = jGoSelection.getPrimarySelection() == this ? jGoSelection.getView().getPrimarySelectionColor() : jGoSelection.getView().getSecondarySelectionColor();
        this.setHighlight(JGoPen.make(65535, 6, color));
        this.setSkipsUndoManager(false);
    }

    protected void lostSelection(JGoSelection jGoSelection) {
        super.lostSelection(jGoSelection);
        ProcessDocument processDocument = (ProcessDocument)this.getDocument();
        if (processDocument != null) {
            this.setSkipsUndoManager(true);
            this.setHighlight(processDocument.getLinkHighlightPen());
            this.setSkipsUndoManager(false);
        }
    }

    public String getText() {
        JGoText jGoText = (JGoText)this.getMidLabel();
        if (jGoText != null) {
            return jGoText.getText();
        }
        return "";
    }

    public void setText(String string) {
        JGoText jGoText = (JGoText)this.getMidLabel();
        if (jGoText != null) {
            jGoText.setText(string);
        }
    }
}

