/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.processor;

import com.nwoods.jgo.JGoBasicNode;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoUndoManager;
import com.nwoods.jgo.examples.processor.ActivityNode;
import com.nwoods.jgo.examples.processor.AppAction;
import com.nwoods.jgo.examples.processor.FlowLink;
import com.nwoods.jgo.examples.processor.RemoteConnectorNode;
import com.nwoods.jgo.examples.processor.WFLFilter;
import com.nwoods.jgo.examples.processor.XMLFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ProcessDocument
extends JGoDocument {
    private static final String processTag = "Process";
    private static final String activityTag = "Activity";
    private static final String flowTag = "Flow";
    public static final int NAME_CHANGED = 65536;
    public static final int LOCATION_CHANGED = 65537;
    public static final int LINKS_JUMP_OVER_CHANGED = 65538;
    private String myName = "";
    private String myLocation = "";
    private boolean myLinksJumpOver = true;
    private int myLastNodeID = -1;
    private int myLastConnectorID = 0;
    private JGoPen myPen = JGoPen.make(65535, 2, Color.blue);
    private JGoPen myHighlightPen = JGoPen.make(65535, 6, Color.white);
    private transient boolean myIsLocationModifiable = true;
    private transient boolean myIsModified = false;

    public ProcessDocument() {
        this.setMaintainsPartID(true);
        this.setUndoManager(new JGoUndoManager());
        this.setLinksLayer(this.addLayerAfter(this.getFirstLayer()));
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        String string2 = this.myName;
        if (!string2.equals(string)) {
            this.myName = string;
            this.fireUpdate(65536, 0, null, 0, string2);
        }
    }

    public String getLocation() {
        return this.myLocation;
    }

    public void setLocation(String string) {
        String string2 = this.myLocation;
        if (!string2.equals(string)) {
            this.myLocation = string;
            this.fireUpdate(65537, 0, null, 0, string2);
            this.updateLocationModifiable();
        }
    }

    public boolean getLinksJumpOver() {
        return this.myLinksJumpOver;
    }

    public void setLinksJumpOver(boolean bl) {
        boolean bl2 = this.myLinksJumpOver;
        if (bl2 != bl) {
            this.myLinksJumpOver = bl;
            this.fireUpdate(65538, 0, null, bl2 ? 1 : 0, null);
            JGoListPosition jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject instanceof JGoLink)) continue;
                JGoLink jGoLink = (JGoLink)jGoObject;
                jGoLink.setJumpsOver(bl);
            }
        }
    }

    public boolean isLocationModifiable() {
        return this.myIsLocationModifiable;
    }

    public void updateLocationModifiable() {
        File file;
        boolean bl = true;
        if (!this.getLocation().equals("") && (file = new File(this.getLocation())).exists() && !file.canWrite()) {
            bl = false;
        }
        if (this.isLocationModifiable() != bl) {
            boolean bl2 = this.isModifiable();
            this.myIsLocationModifiable = bl;
            if (bl2 != this.isModifiable()) {
                this.fireUpdate(208, 0, null, bl2 ? 1 : 0, null);
            }
        }
    }

    public boolean isModifiable() {
        return super.isModifiable() && this.isLocationModifiable();
    }

    public void updatePaperColor() {
        if (this.isModifiable()) {
            this.setPaperColor(Color.white);
        } else {
            this.setPaperColor(new Color(221, 221, 221));
        }
        if (this.myHighlightPen != null && !this.getPaperColor().equals(this.myHighlightPen.getColor())) {
            this.myHighlightPen = JGoPen.make(65535, 6, this.getPaperColor());
            JGoListPosition jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject instanceof JGoLink)) continue;
                JGoLink jGoLink = (JGoLink)jGoObject;
                jGoLink.setHighlight(this.myHighlightPen);
            }
        }
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    public void setModified(boolean bl) {
        if (this.myIsModified != bl) {
            this.myIsModified = bl;
        }
    }

    public void fireUpdate(int n, int n2, Object object, int n3, Object object2) {
        RemoteConnectorNode remoteConnectorNode;
        RemoteConnectorNode remoteConnectorNode2;
        JGoText jGoText;
        if (n == 208) {
            this.updatePaperColor();
        } else if (n != 206) {
            this.setModified(true);
        }
        if (n == 204 && object instanceof JGoLink) {
            RemoteConnectorNode remoteConnectorNode3;
            JGoBasicNode jGoBasicNode;
            JGoLink jGoLink = (JGoLink)object;
            if (jGoLink.getToPort() != null && jGoLink.getToPort().getParent() instanceof JGoBasicNode && (jGoBasicNode = (JGoBasicNode)jGoLink.getToPort().getParent()).getPort().getNumLinks() == 0) {
                this.removeObject(jGoBasicNode);
                if (jGoBasicNode instanceof RemoteConnectorNode) {
                    remoteConnectorNode3 = ((RemoteConnectorNode)jGoBasicNode).getOtherConnector();
                    this.removeObject(remoteConnectorNode3);
                }
            }
            if (jGoLink.getFromPort() != null && jGoLink.getFromPort().getParent() instanceof JGoBasicNode && (jGoBasicNode = (JGoBasicNode)jGoLink.getFromPort().getParent()).getPort().getNumLinks() == 0) {
                this.removeObject(jGoBasicNode);
                if (jGoBasicNode instanceof RemoteConnectorNode) {
                    remoteConnectorNode3 = ((RemoteConnectorNode)jGoBasicNode).getOtherConnector();
                    this.removeObject(remoteConnectorNode3);
                }
            }
        } else if (n == 203 && n2 == 501 && object instanceof JGoText && (jGoText = (JGoText)object).getParent() != null && jGoText.getParent() instanceof RemoteConnectorNode && (remoteConnectorNode2 = (remoteConnectorNode = (RemoteConnectorNode)jGoText.getParent()).getOtherConnector()) != null) {
            remoteConnectorNode2.setText(remoteConnectorNode.getText());
        }
        super.fireUpdate(n, n2, object, n3, object2);
    }

    public ActivityNode newNode(int n) {
        ActivityNode activityNode = new ActivityNode();
        activityNode.initialize(n, this.getNextNodeID());
        this.addObjectAtTail(activityNode);
        activityNode.addScatteredPorts((int)(Math.random() * 5.0) + 1);
        return activityNode;
    }

    public int getNextNodeID() {
        return ++this.myLastNodeID;
    }

    public ActivityNode findNodeByID(int n) {
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            ActivityNode activityNode;
            JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof ActivityNode) || (activityNode = (ActivityNode)jGoObject).getID() != n) continue;
            return activityNode;
        }
        return null;
    }

    public FlowLink newLink(JGoPort jGoPort, JGoPort jGoPort2) {
        FlowLink flowLink = new FlowLink(jGoPort, jGoPort2);
        flowLink.setPen(this.getLinkPen());
        flowLink.setHighlight(this.myHighlightPen);
        flowLink.setJumpsOver(this.getLinksJumpOver());
        this.getLinksLayer().addObjectAtTail(flowLink);
        flowLink.calculateStroke();
        return flowLink;
    }

    public JGoPen getLinkPen() {
        return this.myPen;
    }

    public void setLinkPen(JGoPen jGoPen) {
        if (!this.myPen.equals(jGoPen)) {
            this.myPen = jGoPen;
            JGoListPosition jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject instanceof JGoLink)) continue;
                JGoLink jGoLink = (JGoLink)jGoObject;
                jGoLink.setPen(jGoPen);
            }
        }
    }

    public JGoPen getLinkHighlightPen() {
        return this.myHighlightPen;
    }

    public void setLinkHighlightPen(JGoPen jGoPen) {
        if (!this.myHighlightPen.equals(jGoPen)) {
            this.myHighlightPen = jGoPen;
            JGoListPosition jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject instanceof JGoLink)) continue;
                JGoLink jGoLink = (JGoLink)jGoObject;
                jGoLink.setHighlight(jGoPen);
            }
        }
    }

    public boolean isAvoidable(JGoObject jGoObject) {
        if (!jGoObject.isVisible()) {
            return false;
        }
        return jGoObject instanceof ActivityNode;
    }

    public Rectangle getAvoidableRectangle(JGoObject jGoObject, Rectangle rectangle) {
        ActivityNode activityNode;
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        if (jGoObject instanceof ActivityNode && (activityNode = (ActivityNode)jGoObject).getIcon() != null) {
            Rectangle rectangle2 = activityNode.getIcon().getBoundingRect();
            rectangle.x = rectangle2.x;
            rectangle.y = rectangle2.y;
            rectangle.width = rectangle2.width;
            rectangle.height = rectangle2.height;
        }
        return rectangle;
    }

    public int getNextConnectorID() {
        return ++this.myLastConnectorID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ProcessDocument open(Component component, String string) {
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null && !string.equals("")) {
            object = new File(string);
            jFileChooser.setCurrentDirectory((File)object);
        } else {
            jFileChooser.setCurrentDirectory(null);
        }
        object = new WFLFilter();
        XMLFilter xMLFilter = new XMLFilter();
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        jFileChooser.addChoosableFileFilter(xMLFilter);
        jFileChooser.setFileFilter((FileFilter)object);
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            ProcessDocument processDocument;
            FileInputStream fileInputStream;
            String string2;
            block21: {
                string2 = jFileChooser.getSelectedFile().getName();
                String string3 = jFileChooser.getSelectedFile().getAbsolutePath();
                fileInputStream = null;
                fileInputStream = new FileInputStream(string3);
                processDocument = null;
                processDocument = string3.endsWith(".xml") ? ProcessDocument.loadXML(fileInputStream) : ProcessDocument.loadObjects(fileInputStream);
                if (processDocument != null) break block21;
                ProcessDocument processDocument2 = null;
                Object var12_16 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return processDocument2;
            }
            processDocument.setName(string2);
            processDocument.updateLocationModifiable();
            processDocument.updatePaperColor();
            processDocument.setModified(false);
            processDocument.setUndoManager(new JGoUndoManager());
            ProcessDocument processDocument3 = processDocument;
            Object var12_17 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return processDocument3;
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, iOException, "Open Document Error", 0);
                ProcessDocument processDocument4 = null;
                Object var12_18 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return processDocument4;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception, "Loading Document Exception", 0);
                ProcessDocument processDocument5 = null;
                Object var12_19 = null;
                {
                    catch (Throwable throwable) {
                        Object var12_20 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return processDocument5;
            }
        }
        return null;
    }

    public void save() {
        if (this.getLocation().equals("")) {
            this.saveAs(".wfl");
        } else {
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void store() {
        block15: {
            if (!this.getLocation().equals("")) {
                FileOutputStream fileOutputStream;
                block13: {
                    fileOutputStream = null;
                    fileOutputStream = new FileOutputStream(this.getLocation());
                    if (this.getLocation().endsWith(".xml")) {
                        this.storeXML(fileOutputStream);
                        break block13;
                    }
                    this.storeObjects(fileOutputStream);
                }
                Object var4_2 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setModified(false);
                {
                    break block15;
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception, "Save Document Error", 0);
                        Object var4_3 = null;
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        this.setModified(false);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setModified(false);
                    throw throwable;
                }
            }
        }
    }

    public void saveAs(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        String string2 = this.getLocation();
        File file = new File(string2);
        jFileChooser.setCurrentDirectory(file);
        WFLFilter wFLFilter = new WFLFilter();
        XMLFilter xMLFilter = new XMLFilter();
        jFileChooser.addChoosableFileFilter(wFLFilter);
        jFileChooser.addChoosableFileFilter(xMLFilter);
        if (string.equalsIgnoreCase(".xml")) {
            jFileChooser.setFileFilter(xMLFilter);
        } else {
            jFileChooser.setFileFilter(wFLFilter);
        }
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            String string3 = ".wfl";
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter.getDescription() == ".xml") {
                string3 = ".xml";
            }
            String string4 = jFileChooser.getSelectedFile().getName();
            this.setName(string4);
            string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            String string5 = string2.toLowerCase();
            if (string5.indexOf(".") == -1) {
                string2 = string2 + string3;
            }
            this.setLocation(string2);
            this.store();
        }
    }

    public static ProcessDocument loadObjects(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = objectInputStream.readObject();
        if (object instanceof ProcessDocument) {
            ProcessDocument processDocument = (ProcessDocument)object;
            return processDocument;
        }
        return null;
    }

    public void storeObjects(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public static ProcessDocument loadXML(InputStream inputStream) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("XML support not enabled.  Edit ProcessDocument.java to un-comment-out /*XML ... XML*/ code.");
    }

    public void storeXML(OutputStream outputStream) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("XML support not enabled.  Edit ProcessDocument.java to un-comment-out /*XML ... XML*/ code.");
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getHint()) {
            case 65536: {
                jGoDocumentChangedEdit.setNewValue(this.getName());
                return;
            }
            case 65537: {
                jGoDocumentChangedEdit.setNewValue(this.getLocation());
                return;
            }
            case 65538: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.getLinksJumpOver());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getHint()) {
            case 65536: {
                this.setName((String)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 65537: {
                this.setLocation((String)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 65538: {
                this.setLinksJumpOver(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void endTransaction(String string) {
        super.endTransaction(string);
        AppAction.updateAllActions();
    }
}

