/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.processor;

import com.nwoods.jgo.JGoBasicNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoGlobal;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import com.nwoods.jgo.examples.Comment;
import com.nwoods.jgo.examples.processor.ActivityDialog;
import com.nwoods.jgo.examples.processor.ActivityNode;
import com.nwoods.jgo.examples.processor.AppAction;
import com.nwoods.jgo.examples.processor.ExternalConnectorNode;
import com.nwoods.jgo.examples.processor.FlowDialog;
import com.nwoods.jgo.examples.processor.FlowLabel;
import com.nwoods.jgo.examples.processor.FlowLink;
import com.nwoods.jgo.examples.processor.ProcessDocument;
import com.nwoods.jgo.examples.processor.Processor;
import com.nwoods.jgo.examples.processor.RemoteConnectorNode;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class ProcessView
extends JGoView
implements JGoViewListener {
    public static final int MouseStateRoutingLink = 101;
    public static final int MouseStateMovingPort = 102;
    private JPopupMenu myPopupMenu = new JPopupMenu();
    private Point myMouseUpDocPoint = new Point(0, 0);
    private JGoPort myFromPort = null;
    private boolean myOrthogonal = true;
    private boolean myHoriz = true;
    private Point myOriginalPosition = new Point(0, 0);
    private Point myOffset = new Point(0, 0);
    protected Point myDefaultLocation = new Point(10, 10);
    protected Processor myApp = null;
    protected JInternalFrame myInternalFrame = null;
    private Point myPopupPoint = new Point(0, 0);
    private boolean myOriginalScale = true;
    private Point myOriginalDocPosition = new Point(0, 0);
    private double myOriginalDocScale = 1.0;
    private boolean myCanceling = false;

    public ProcessView() {
    }

    public ProcessView(JGoDocument jGoDocument) {
        super(jGoDocument);
    }

    public void initialize(Processor processor, JInternalFrame jInternalFrame) {
        this.myApp = processor;
        this.myInternalFrame = jInternalFrame;
        this.addViewListener(this);
        this.setIncludingNegativeCoords(true);
        this.setDragsRealtime(true);
        this.updateTitle();
    }

    public JGoDocument createDefaultModel() {
        return new ProcessDocument();
    }

    ProcessDocument getDoc() {
        return (ProcessDocument)this.getDocument();
    }

    Processor getApp() {
        return this.myApp;
    }

    JInternalFrame getInternalFrame() {
        return this.myInternalFrame;
    }

    public void onKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            if (this.getDoc().isModifiable()) {
                this.deleteSelection();
            }
        } else if (n == 36) {
            this.setViewPosition(0, 0);
        } else if (n == 39) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, 10, 0, 3);
            }
        } else if (n == 37) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, -10, 0, 3);
            }
        } else if (n == 40) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, 0, 10, 3);
            }
        } else if (n == 38) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, 0, -10, 3);
            }
        } else if (!(n != 117 || keyEvent.isControlDown() || keyEvent.isShiftDown() || keyEvent.isAltDown() || keyEvent.isMetaDown())) {
            this.zoomToFit();
        } else if (n == 27) {
            this.doCancelMouse();
        } else if (n == 10 && this.getState() == 102) {
            this.stopMovingPort();
        } else if (Character.isLetter(keyEvent.getKeyChar())) {
            if (!this.selectNextNode(keyEvent.getKeyChar())) {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            super.onKeyEvent(keyEvent);
        }
    }

    public void doCancelMouse() {
        this.myCanceling = true;
        this.myMouseUpDocPoint.x = -9999;
        this.myMouseUpDocPoint.y = -9999;
        if (this.getState() == 101) {
            this.cancelRoutedLink();
        } else if (this.getState() == 102) {
            this.stopMovingPort();
        } else {
            super.doCancelMouse();
            this.getSelection().clearSelection();
        }
        this.myCanceling = false;
    }

    public boolean doMouseDown(int n, Point point, Point point2) {
        if (this.getState() == 101) {
            if (this.getCurrentObject() == null) {
                this.startRoutedLink(n, point, point2);
            } else {
                JGoObject jGoObject = this.pickDocObject(point, false);
                if (jGoObject instanceof JGoPort && this.myFromPort.validLink((JGoPort)jGoObject)) {
                    this.finishRoutedLink(n, point, point2, jGoObject);
                } else {
                    this.addPointToRoutedLink(n, point, point2);
                }
            }
            return true;
        }
        if (this.getState() == 102) {
            this.pickMovablePort(n, point, point2);
            return true;
        }
        if ((n & 4) != 0) {
            JPopupMenu jPopupMenu = this.myPopupMenu;
            jPopupMenu.removeAll();
            JGoObject jGoObject = this.pickDocObject(point, true);
            if (jGoObject != null) {
                jGoObject = jGoObject.getTopLevelObject();
                this.getSelection().selectObject(jGoObject);
                jPopupMenu.add(this.getApp().ObjectPropertiesAction);
                jPopupMenu.addSeparator();
                if (jGoObject instanceof FlowLink) {
                    AppAction appAction;
                    FlowLink flowLink = (FlowLink)jGoObject;
                    AppAction appAction2 = new AppAction("Insert Point", (Container)this.getApp()){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ProcessView.this.insertPointIntoLink();
                        }

                        public boolean canAct() {
                            return super.canAct() && this.getView().getDoc().isModifiable();
                        }
                    };
                    jPopupMenu.add(appAction2);
                    if (flowLink.getNumPoints() > (flowLink.isOrthogonal() ? 6 : 2)) {
                        appAction = new AppAction("Remove Segment", (Container)this.getApp()){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ProcessView.this.removeSegmentFromLink();
                            }

                            public boolean canAct() {
                                return super.canAct() && this.getView().getDoc().isModifiable();
                            }
                        };
                        jPopupMenu.add(appAction);
                    }
                    if (flowLink.getFromPort().getParent() instanceof ActivityNode && flowLink.getToPort().getParent() instanceof ActivityNode) {
                        appAction = new AppAction("Remote Connection", (Container)this.getApp()){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ProcessView.this.replaceLinkWithRemoteConnection();
                            }

                            public boolean canAct() {
                                return super.canAct() && this.getView().getDoc().isModifiable();
                            }
                        };
                        jPopupMenu.add(appAction);
                    }
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add(this.getApp().CopyAction);
                jPopupMenu.add(this.getApp().CutAction);
            } else {
                jPopupMenu.add(this.getApp().FilePropertiesAction);
                jPopupMenu.addSeparator();
                AppAction appAction = new AppAction("Paste", (Container)this.getApp()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ProcessView.this.pasteHere();
                    }

                    public boolean canAct() {
                        return super.canAct() && this.getView().getDoc().isModifiable();
                    }
                };
                jPopupMenu.add(appAction);
                this.myPopupPoint = point;
            }
            jPopupMenu.show(this, point2.x, point2.y);
            return true;
        }
        return super.doMouseDown(n, point, point2);
    }

    public boolean doMouseMove(int n, Point point, Point point2) {
        if (this.getState() == 101) {
            this.followPointerForRoutedLink(n, point, point2);
            return true;
        }
        if (this.getState() == 102) {
            this.followPointerForMovablePort(n, point, point2);
            return true;
        }
        return super.doMouseMove(n, point, point2);
    }

    public boolean doMouseUp(int n, Point point, Point point2) {
        this.myMouseUpDocPoint.x = point.x;
        this.myMouseUpDocPoint.y = point.y;
        if (this.getState() == 101) {
            return false;
        }
        if (this.getState() == 102) {
            this.dropMovablePort(n, point, point2);
            return false;
        }
        return super.doMouseUp(n, point, point2);
    }

    public void startRoutingLink() {
        this.setState(101);
        this.getDocument().startTransaction();
        this.setCurrentObject(null);
        this.myFromPort = null;
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void cancelRoutedLink() {
        if (!this.hasFocus()) {
            return;
        }
        if (this.getCurrentObject() != null) {
            this.removeObject(this.getCurrentObject());
            this.setCurrentObject(null);
        }
        this.myFromPort = null;
        this.setCursor(this.getDefaultCursor());
        this.getDocument().endTransaction(false);
        this.setState(0);
    }

    void startRoutedLink(int n, Point point, Point point2) {
        JGoObject jGoObject = this.pickDocObject(point, false);
        if (jGoObject instanceof JGoPort && ((JGoPort)jGoObject).isValidSource()) {
            this.myFromPort = (JGoPort)jGoObject;
            JGoStroke jGoStroke = new JGoStroke();
            Point point3 = this.myFromPort.getFromLinkPoint(point);
            jGoStroke.addPoint(point3);
            if (this.myOrthogonal) {
                if (this.myFromPort.getFromSpot() == 8) {
                    this.myHoriz = true;
                    jGoStroke.addPoint(point3.x - this.myFromPort.getEndSegmentLength(), point3.y);
                } else if (this.myFromPort.getFromSpot() == 4) {
                    this.myHoriz = true;
                    jGoStroke.addPoint(point3.x + this.myFromPort.getEndSegmentLength(), point3.y);
                } else if (this.myFromPort.getFromSpot() == 2) {
                    this.myHoriz = false;
                    jGoStroke.addPoint(point3.x, point3.y - this.myFromPort.getEndSegmentLength());
                } else if (this.myFromPort.getFromSpot() == 6) {
                    this.myHoriz = false;
                    jGoStroke.addPoint(point3.x, point3.y + this.myFromPort.getEndSegmentLength());
                } else {
                    this.myHoriz = true;
                    jGoStroke.addPoint(point3.x + this.myFromPort.getEndSegmentLength(), point3.y);
                }
            }
            jGoStroke.addPoint(point);
            this.addObjectAtTail(jGoStroke);
            this.setCurrentObject(jGoStroke);
        }
    }

    void followPointerForRoutedLink(int n, Point point, Point point2) {
        JGoStroke jGoStroke = (JGoStroke)this.getCurrentObject();
        if (jGoStroke != null) {
            int n2 = jGoStroke.getNumPoints();
            jGoStroke.setPoint(n2 - 1, point);
            if (this.myOrthogonal && n2 > 2) {
                Point point3 = jGoStroke.getPoint(n2 - 2);
                Point point4 = new Point(point3.x, point3.y);
                if (this.myHoriz) {
                    point4.x = point.x;
                } else {
                    point4.y = point.y;
                }
                jGoStroke.setPoint(n2 - 2, point4);
            }
        }
    }

    void addPointToRoutedLink(int n, Point point, Point point2) {
        JGoStroke jGoStroke = (JGoStroke)this.getCurrentObject();
        this.myHoriz = !this.myHoriz;
        jGoStroke.addPoint(point);
    }

    void finishRoutedLink(int n, Point point, Point point2, JGoObject jGoObject) {
        Point point3;
        Point point4;
        Point point5;
        JGoPort jGoPort = (JGoPort)jGoObject;
        JGoStroke jGoStroke = (JGoStroke)this.getCurrentObject();
        this.removeObject(jGoStroke);
        FlowLink flowLink = this.getDoc().newLink(this.myFromPort, jGoPort);
        Point point6 = flowLink.getPoint(0);
        Point point7 = flowLink.getPoint(1);
        boolean bl = false;
        Point point8 = flowLink.getPoint(flowLink.getNumPoints() - 2);
        Point point9 = flowLink.getPoint(flowLink.getNumPoints() - 1);
        boolean bl2 = false;
        if (this.myFromPort.getFromSpot() != -1) {
            bl = true;
            if (this.myOrthogonal) {
                Point point10 = flowLink.getPoint(1);
                point5 = jGoStroke.getPoint(1);
                point4 = new Point(point5.x, point5.y);
                point3 = jGoStroke.getPoint(2);
                if (point4.x == point3.x) {
                    point4.y = point10.y;
                } else if (point4.y == point3.y) {
                    point4.x = point10.x;
                }
                jGoStroke.setPoint(1, point4);
            }
        }
        if (jGoPort.getToSpot() != -1) {
            bl2 = true;
            if (this.myOrthogonal) {
                int n2 = jGoStroke.getNumPoints();
                point5 = flowLink.getPoint(flowLink.getNumPoints() - 2);
                point4 = jGoStroke.getPoint(n2 - 2);
                point3 = new Point(point4.x, point4.y);
                Point point11 = jGoStroke.getPoint(n2 - 3);
                if (point3.x == point11.x) {
                    point3.y = point5.y;
                } else if (point3.y == point11.y) {
                    point3.x = point5.x;
                }
                jGoStroke.setPoint(n2 - 2, point3);
            }
        }
        flowLink.removeAllPoints();
        flowLink.addPoint(point6);
        if (bl) {
            flowLink.addPoint(point7);
        }
        for (int i = 1; i < jGoStroke.getNumPoints() - 1; ++i) {
            flowLink.addPoint(jGoStroke.getPoint(i));
        }
        if (bl2) {
            flowLink.addPoint(point8);
        }
        flowLink.addPoint(point9);
        this.selectObject(flowLink);
        this.setCurrentObject(null);
        this.myFromPort = null;
        this.setCursor(this.getDefaultCursor());
        this.getDocument().endTransaction("created routing link");
        this.setState(0);
    }

    public void startMovingPort() {
        this.setState(102);
        this.getDocument().startTransaction();
        this.setCurrentObject(null);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void stopMovingPort() {
        if (!this.hasFocus()) {
            return;
        }
        if (this.getCurrentObject() != null) {
            this.getCurrentObject().setTopLeft(this.myOriginalPosition);
        }
        this.setCursor(this.getDefaultCursor());
        if (this.getDocument() != null) {
            this.getDocument().endTransaction(false);
        }
        this.setState(0);
    }

    void pickMovablePort(int n, Point point, Point point2) {
        JGoObject jGoObject = this.pickDocObject(point, false);
        if (jGoObject instanceof JGoPort) {
            JGoPort jGoPort = (JGoPort)jGoObject;
            this.setCurrentObject(jGoPort);
            this.myOriginalPosition.x = jGoPort.getLeft();
            this.myOriginalPosition.y = jGoPort.getTop();
            this.myOffset.x = point.x - jGoPort.getLeft();
            this.myOffset.y = point.y - jGoPort.getTop();
        }
    }

    void followPointerForMovablePort(int n, Point point, Point point2) {
        if (this.getCurrentObject() != null) {
            this.getCurrentObject().setTopLeft(point.x - this.myOffset.x, point.y - this.myOffset.y);
        }
    }

    void dropMovablePort(int n, Point point, Point point2) {
        if (this.getCurrentObject() != null) {
            this.setCurrentObject(null);
            if (this.getDocument() != null) {
                this.getDocument().endTransaction("moved port");
            }
        } else if (this.getDocument() != null) {
            this.getDocument().endTransaction(false);
        }
    }

    void insertPointIntoLink() {
        if (this.getSelection().getPrimarySelection() instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)this.getSelection().getPrimarySelection();
            int n = jGoLink.getSegmentNearPoint(this.myMouseUpDocPoint);
            if (n < 1) {
                n = 1;
            } else if (n >= jGoLink.getNumPoints() - 2) {
                n = jGoLink.getNumPoints() - 3;
            }
            Point point = jGoLink.getPoint(n);
            Point point2 = jGoLink.getPoint(n + 1);
            Point point3 = new Point((point.x + point2.x) / 2, (point.y + point2.y) / 2);
            this.getDocument().startTransaction();
            jGoLink.insertPoint(n + 1, point3);
            if (jGoLink instanceof JGoLink && jGoLink.isOrthogonal()) {
                jGoLink.insertPoint(n + 1, point3);
            }
            this.getSelection().clearSelection(jGoLink);
            this.selectObject(jGoLink);
            this.getDocument().endTransaction("inserted point into link stroke");
        }
    }

    void removeSegmentFromLink() {
        if (this.getSelection().getPrimarySelection() instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)this.getSelection().getPrimarySelection();
            int n = jGoLink.getSegmentNearPoint(this.myMouseUpDocPoint);
            this.getDocument().startTransaction();
            if (jGoLink.isOrthogonal()) {
                n = Math.max(n, 2);
                n = Math.min(n, jGoLink.getNumPoints() - 5);
                Point point = jGoLink.getPoint(n);
                Point point2 = jGoLink.getPoint(n + 1);
                jGoLink.removePoint(n);
                jGoLink.removePoint(n);
                Point point3 = jGoLink.getPoint(n);
                Point point4 = new Point(point3.x, point3.y);
                if (point.x == point2.x) {
                    point4.y = point.y;
                } else {
                    point4.x = point.x;
                }
                jGoLink.setPoint(n, point4);
            } else {
                n = Math.max(n, 1);
                n = Math.min(n, jGoLink.getNumPoints() - 2);
                jGoLink.removePoint(n);
            }
            this.getSelection().clearSelection(jGoLink);
            this.selectObject(jGoLink);
            this.getDocument().endTransaction("removed segment from link stroke");
        }
    }

    void replaceLinkWithRemoteConnection() {
        if (this.getSelection().getPrimarySelection() instanceof FlowLink) {
            FlowLink flowLink = (FlowLink)this.getSelection().getPrimarySelection();
            String string = flowLink.getText();
            JGoPort jGoPort = flowLink.getFromPort();
            Point point = jGoPort.getFromLinkPoint();
            double d = jGoPort.getFromLinkDir();
            point.x += (int)(100.0 * Math.cos(d));
            point.y += (int)(100.0 * Math.sin(d));
            JGoPort jGoPort2 = flowLink.getToPort();
            int n = flowLink.getNumPoints() - 3;
            Point point2 = jGoPort2.getToLinkPoint();
            double d2 = jGoPort2.getToLinkDir();
            point2.x += (int)(100.0 * Math.cos(d2));
            point2.y += (int)(100.0 * Math.sin(d2));
            this.getDocument().startTransaction();
            flowLink.unlink();
            int n2 = this.getDoc().getNextConnectorID();
            RemoteConnectorNode remoteConnectorNode = new RemoteConnectorNode(point, "C" + Integer.toString(n2));
            RemoteConnectorNode remoteConnectorNode2 = new RemoteConnectorNode(point2, "C" + Integer.toString(n2));
            remoteConnectorNode.setOtherConnector(remoteConnectorNode2);
            this.getDoc().getFirstLayer().addObjectAtTail(remoteConnectorNode);
            FlowLink flowLink2 = this.getDoc().newLink(jGoPort, remoteConnectorNode.getPort());
            flowLink2.setArrowHeads(false, true);
            flowLink2.setText(string);
            remoteConnectorNode2.setOtherConnector(remoteConnectorNode);
            this.getDoc().getFirstLayer().addObjectAtTail(remoteConnectorNode2);
            FlowLink flowLink3 = this.getDoc().newLink(remoteConnectorNode2.getPort(), jGoPort2);
            flowLink3.setText(string);
            this.getDocument().endTransaction("replaced link with remote connectors");
        }
    }

    public boolean doMouseDblClick(int n, Point point, Point point2) {
        if (!super.doMouseDblClick(n, point, point2)) {
            FlowLabel flowLabel;
            JGoObject jGoObject = this.pickDocObject(point, true);
            if (jGoObject != null && jGoObject instanceof FlowLabel && (flowLabel = (FlowLabel)jGoObject).getLink() != null) {
                return flowLabel.getLink().doMouseDblClick(n, point, point2, this);
            }
            this.getApp().editProcessProperties();
            return true;
        }
        return false;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        JGoCopyEnvironment jGoCopyEnvironment = this.getDocument().createDefaultCopyEnvironment();
        this.getDocument().startTransaction();
        if (this.getDocument().isModifiable() && this.doDrop(dropTargetDropEvent, jGoCopyEnvironment)) {
            Iterator iterator = jGoCopyEnvironment.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (!(v instanceof ActivityNode)) continue;
                ActivityNode activityNode = (ActivityNode)v;
                activityNode.resetEditability();
                activityNode.getLabel().setSelectable(true);
            }
            this.fireUpdate(35, 0, null);
            this.getDocument().endTransaction("Drop");
        } else {
            dropTargetDropEvent.rejectDrop();
            this.getDocument().endTransaction(false);
        }
    }

    public void selectAll() {
        JGoSelection jGoSelection = this.getSelection();
        JGoLayer jGoLayer = this.getFirstLayer();
        while (jGoLayer != null) {
            if (jGoLayer.isVisible()) {
                JGoListPosition jGoListPosition = jGoLayer.getFirstObjectPos();
                while (jGoListPosition != null) {
                    JGoObject jGoObject = jGoLayer.getObjectAtPos(jGoListPosition);
                    jGoListPosition = jGoLayer.getNextObjectPosAtTop(jGoListPosition);
                    if (!jGoObject.isVisible() || jGoObject instanceof FlowLabel || !jGoObject.isSelectable() && jGoObject.redirectSelection() == jGoObject) continue;
                    this.getSelection().extendSelection(jGoObject);
                }
            }
            jGoLayer = this.getNextLayer(jGoLayer);
        }
    }

    private boolean containsRect(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle2.width;
        int n4 = rectangle2.height;
        if (n <= 0 || n2 <= 0 || n3 < 0 || n4 < 0) {
            return false;
        }
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle2.x;
        int n8 = rectangle2.y;
        return n7 >= n5 && n8 >= n6 && n7 + n3 <= n5 + n && n8 + n4 <= n6 + n2;
    }

    public void selectInBox(Rectangle rectangle) {
        JGoLayer jGoLayer = this.getFirstLayer();
        while (jGoLayer != null) {
            if (jGoLayer.isVisible()) {
                JGoListPosition jGoListPosition = jGoLayer.getFirstObjectPos();
                while (jGoListPosition != null) {
                    JGoObject jGoObject = jGoLayer.getObjectAtPos(jGoListPosition);
                    jGoListPosition = jGoLayer.getNextObjectPosAtTop(jGoListPosition);
                    if (!jGoObject.isVisible() || jGoObject instanceof FlowLabel || !this.containsRect(rectangle, jGoObject.getBoundingRect()) || !jGoObject.isSelectable() && !(jGoObject instanceof JGoObjectCollection) && jGoObject.redirectSelection() == jGoObject) continue;
                    this.getSelection().extendSelection(jGoObject);
                }
            }
            jGoLayer = this.getNextLayer(jGoLayer);
        }
    }

    public void moveSelection(JGoSelection jGoSelection, int n, int n2, int n3, int n4) {
        FlowLink flowLink;
        if (n2 == 0 && n3 == 0) {
            return;
        }
        JGoObject jGoObject = jGoSelection.getPrimarySelection();
        FlowLabel flowLabel = null;
        if (jGoObject instanceof FlowLabel && jGoSelection.getNumObjects() == 1) {
            flowLabel = (FlowLabel)jGoObject;
        }
        super.moveSelection(jGoSelection, n, n2, n3, n4);
        if (flowLabel != null && (flowLink = flowLabel.getLink()) != null) {
            Rectangle rectangle = flowLabel.getBoundingRect();
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            int n5 = 1;
            int n6 = flowLink.getNumPoints() - 1;
            Point point2 = new Point(0, 0);
            double d = 1.0E21;
            int n7 = 0;
            Point point3 = new Point(0, 0);
            Point point4 = null;
            Point point5 = null;
            for (int i = n5; i < n6 - 1; ++i) {
                point4 = flowLink.getPoint(i);
                point5 = flowLink.getPoint(i + 1);
                JGoStroke.getNearestPointOnLine(point4, point5, point, point2);
                double d2 = (point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y);
                if (!(d2 < d)) continue;
                d = d2;
                n7 = i;
                point3.x = point2.x;
                point3.y = point2.y;
            }
            point4 = flowLink.getPoint(n7);
            point5 = flowLink.getPoint(n7 + 1);
            flowLabel.setSegment(n7);
            point2.x = point3.x;
            point2.y = point3.y;
            double d3 = Math.sqrt((point4.x - point2.x) * (point4.x - point2.x) + (point4.y - point2.y) * (point4.y - point2.y));
            double d4 = Math.sqrt((point4.x - point5.x) * (point4.x - point5.x) + (point4.y - point5.y) * (point4.y - point5.y));
            if (d4 <= 0.0) {
                flowLabel.setSegmentDistance(0);
            } else {
                flowLabel.setSegmentDistance((int)Math.rint(d3 * 100.0 / d4));
            }
            flowLabel.setOffset(point.x - point2.x, point.y - point2.y);
        }
    }

    public void paste() {
        Toolkit toolkit;
        JGoDocument jGoDocument = this.getDocument();
        if (jGoDocument != null) {
            jGoDocument.startTransaction();
        }
        if ((toolkit = this.getToolkit()) == null) {
            toolkit = JGoGlobal.getToolkit();
        }
        JGoCopyEnvironment jGoCopyEnvironment = this.pasteFromClipboard(toolkit.getSystemClipboard());
        Iterator iterator = jGoCopyEnvironment.values().iterator();
        boolean bl = false;
        JGoSelection jGoSelection = this.getSelection();
        while (iterator.hasNext()) {
            JGoObject jGoObject;
            Object v = iterator.next();
            if (!(v instanceof JGoObject) || !(jGoObject = (JGoObject)v).isTopLevel() || jGoObject.getDocument() != jGoDocument || jGoObject instanceof FlowLabel) continue;
            if (!bl) {
                bl = true;
                jGoSelection.clearSelection();
            }
            jGoSelection.extendSelection(jGoObject);
        }
        if (jGoDocument != null) {
            jGoDocument.endTransaction(this.getEditPresentationName(10));
        }
    }

    public void viewChanged(JGoViewEvent jGoViewEvent) {
        switch (jGoViewEvent.getHint()) {
            case 1: 
            case 20: 
            case 21: 
            case 108: {
                AppAction.updateAllActions();
            }
        }
    }

    public void documentChanged(JGoDocumentEvent jGoDocumentEvent) {
        if (jGoDocumentEvent.getHint() == 65536 || jGoDocumentEvent.getHint() == 208) {
            this.updateTitle();
        }
        super.documentChanged(jGoDocumentEvent);
    }

    public void updateTitle() {
        if (this.getInternalFrame() != null) {
            String string = this.getDoc().getName();
            if (!this.getDocument().isModifiable()) {
                string = string + " (read-only)";
            }
            this.getInternalFrame().setTitle(string);
            this.getInternalFrame().repaint();
        }
    }

    protected JGoLink createTemporaryLinkForNewLink(JGoPort jGoPort, JGoPort jGoPort2) {
        JGoLink jGoLink = new JGoLink(jGoPort, jGoPort2);
        jGoLink.setOrthogonal(true);
        return jGoLink;
    }

    public void newLink(JGoPort jGoPort, JGoPort jGoPort2) {
        FlowLink flowLink = this.getDoc().newLink(jGoPort, jGoPort2);
        this.fireUpdate(31, 0, flowLink);
        this.getDoc().endTransaction("new FlowLink");
    }

    protected void noNewLink(JGoPort jGoPort, JGoPort jGoPort2) {
        if (this.myCanceling) {
            this.getDoc().endTransaction(false);
        } else if (jGoPort == null && jGoPort2 != null) {
            ExternalConnectorNode externalConnectorNode = new ExternalConnectorNode(this.myMouseUpDocPoint, "in", false);
            this.getDoc().getFirstLayer().addObjectAtTail(externalConnectorNode);
            FlowLink flowLink = this.getDoc().newLink(externalConnectorNode.getPort(), jGoPort2);
            this.fireUpdate(31, 0, flowLink);
            this.getDoc().endTransaction("linked to new input");
        } else if (jGoPort != null && jGoPort2 == null) {
            ExternalConnectorNode externalConnectorNode = new ExternalConnectorNode(this.myMouseUpDocPoint, "out", true);
            this.getDoc().getFirstLayer().addObjectAtTail(externalConnectorNode);
            FlowLink flowLink = this.getDoc().newLink(jGoPort, externalConnectorNode.getPort());
            flowLink.setArrowHeads(false, true);
            this.fireUpdate(31, 0, flowLink);
            this.getDoc().endTransaction("linked to new output");
        } else {
            this.getDoc().endTransaction(false);
        }
    }

    public void reLink(JGoLink jGoLink, JGoPort jGoPort, JGoPort jGoPort2) {
        JGoBasicNode jGoBasicNode;
        if (jGoPort2 != null) {
            if (jGoPort2.getParent() instanceof JGoBasicNode) {
                jGoLink.setArrowHeads(false, true);
                jGoBasicNode = (JGoBasicNode)jGoPort2.getParent();
                jGoBasicNode.getDocument().removeObject(jGoBasicNode);
            } else {
                jGoLink.setArrowHeads(false, false);
            }
        }
        if (jGoPort != null && jGoPort.getParent() instanceof JGoBasicNode) {
            jGoBasicNode = (JGoBasicNode)jGoPort.getParent();
            jGoBasicNode.getDocument().removeObject(jGoBasicNode);
        }
        super.reLink(jGoLink, jGoPort, jGoPort2);
    }

    public void insertActivity() {
        this.getDoc().startTransaction();
        Point point = this.getDefaultLocation();
        if (point == null) {
            point = new Point(100, 70);
        }
        ActivityNode activityNode = this.getDoc().newNode(2);
        activityNode.setTopLeft(point);
        this.getDoc().endTransaction("new Activity");
    }

    public void insertInput() {
        this.getDoc().startTransaction();
        Point point = this.getDefaultLocation();
        if (point == null) {
            point = new Point(100, 70);
        }
        ActivityNode activityNode = this.getDoc().newNode(0);
        activityNode.setTopLeft(point);
        this.getDoc().endTransaction("new Output");
    }

    public void insertOutput() {
        this.getDoc().startTransaction();
        Point point = this.getDefaultLocation();
        if (point == null) {
            point = new Point(100, 70);
        }
        ActivityNode activityNode = this.getDoc().newNode(1);
        activityNode.setTopLeft(point);
        this.getDoc().endTransaction("new Input");
    }

    public void insertComment() {
        this.getDoc().startTransaction();
        Point point = this.getDefaultLocation();
        if (point == null) {
            point = new Point(100, 70);
        }
        Comment comment = new Comment("a comment");
        comment.setEditable(true);
        comment.setTopLeft(point);
        this.getDoc().getFirstLayer().addObjectAtHead(comment);
        this.getDoc().endTransaction("new Comment");
    }

    public void pasteHere() {
        this.getDoc().startTransaction();
        Point point = this.myPopupPoint;
        this.getSelection().clearSelection();
        this.paste();
        Rectangle rectangle = JGoDocument.computeBounds(this.getSelection());
        this.moveSelection(this.getSelection(), 0, point.x - rectangle.x, point.y - rectangle.y, 3);
        this.getDoc().endTransaction("Paste Here");
    }

    public Point getDefaultLocation() {
        if (this.myDefaultLocation != null) {
            this.myDefaultLocation.x += 10;
            this.myDefaultLocation.y += 10;
        }
        return this.myDefaultLocation;
    }

    public void setDefaultLocation(Point point) {
        this.myDefaultLocation = point;
    }

    public void editDrawRoutedLink() {
        JOptionPane.showMessageDialog(this, "Starting a mode to allow you to click on a port and\n  start drawing a link whose path you can specify by clicking.\nThis mode stops when you click on another port, or when you\n  type ESCAPE to cancel the new link.", "Drawing Routed Link Mode", 1);
        this.startRoutingLink();
    }

    public void editMovePort() {
        JOptionPane.showMessageDialog(this, "Starting a mode to allow you to reposition ports on a node.\nThe relative position may not be maintained or permitted if\n  the node definition doesn't support it.\nType ESCAPE or ENTER to stop this mode.", "Moving Port Mode", 1);
        this.startMovingPort();
    }

    public void editObjectProperties() {
        JGoSelection jGoSelection = this.getSelection();
        if (jGoSelection.isEmpty()) {
            this.getApp().editProcessProperties();
            return;
        }
        this.getDocument().startTransaction();
        JGoObject jGoObject = jGoSelection.getPrimarySelection();
        jGoObject = jGoObject.getTopLevelObject();
        if (jGoObject instanceof ActivityNode) {
            this.editActivity((ActivityNode)jGoObject);
        } else if (jGoObject instanceof FlowLink) {
            this.editFlow((FlowLink)jGoObject);
        } else if (jGoObject instanceof FlowLabel) {
            FlowLabel flowLabel = (FlowLabel)jGoObject;
            this.editFlow(flowLabel.getLink());
        }
        this.getDocument().endTransaction("Object Properties");
    }

    public void editActivity(ActivityNode activityNode) {
        if (activityNode == null) {
            return;
        }
        switch (activityNode.getActivityType()) {
            case 0: {
                JOptionPane.showInternalMessageDialog(this, "A Start node has no editable properties", "information", 1);
                break;
            }
            case 1: {
                JOptionPane.showInternalMessageDialog(this, "A Finish node has no editable properties", "information", 1);
                break;
            }
            default: {
                ActivityDialog activityDialog = new ActivityDialog(this.getFrame(), activityNode);
                activityDialog.setLocationRelativeTo(null);
                activityDialog.setVisible(true);
            }
        }
    }

    public void editFlow(FlowLink flowLink) {
        if (flowLink == null) {
            return;
        }
        FlowDialog flowDialog = new FlowDialog(this.getFrame(), flowLink);
        flowDialog.setLocationRelativeTo(null);
        flowDialog.setVisible(true);
    }

    public Rectangle2D.Double getPrintPageRect(Graphics2D graphics2D, PageFormat pageFormat) {
        return new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight() - 20.0);
    }

    public void printDecoration(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2) {
        super.printDecoration(graphics2D, pageFormat, n, n2);
        String string = Integer.toString(n);
        string = string + ", ";
        string = string + Integer.toString(n2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(Color.black);
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font(JGoText.getDefaultFontFaceName(), 0, 10));
        graphics2D.drawString(string, (int)(pageFormat.getImageableX() + pageFormat.getImageableWidth() / 2.0), (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight() - 10.0));
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    public double getPrintScale(Graphics2D graphics2D, PageFormat pageFormat) {
        return this.getScale();
    }

    public void zoomIn() {
        this.myOriginalScale = true;
        double d = Math.rint(this.getScale() / (double)0.9f * 100.0) / 100.0;
        this.setScale(d);
    }

    public void zoomOut() {
        this.myOriginalScale = true;
        double d = Math.rint(this.getScale() * (double)0.9f * 100.0) / 100.0;
        this.setScale(d);
    }

    public void zoomNormal() {
        this.myOriginalScale = true;
        this.setScale(1.0);
    }

    public void zoomToFit() {
        if (this.myOriginalScale) {
            this.myOriginalDocPosition = this.getViewPosition();
            this.myOriginalDocScale = this.getScale();
            this.RescaleToFit();
        } else {
            this.setViewPosition(this.myOriginalDocPosition);
            this.setScale(this.myOriginalDocScale);
        }
        this.myOriginalScale = !this.myOriginalScale;
    }

    public void RescaleToFit() {
        Dimension dimension = this.getCanvas().getSize();
        Rectangle rectangle = this.getDocument().computeBounds();
        if (rectangle.x > 0) {
            rectangle.width += rectangle.x;
            rectangle.x = 0;
        }
        if (rectangle.y > 0) {
            rectangle.height += rectangle.y;
            rectangle.y = 0;
        }
        this.setViewPosition(0, 0);
        double d = 1.0;
        if (rectangle.width > 0 && rectangle.height > 0) {
            d = Math.min((double)dimension.width / (double)rectangle.width, (double)dimension.height / (double)rectangle.height);
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.setScale(d);
    }

    public boolean matchesNodeLabel(ActivityNode activityNode, char c) {
        if (activityNode == null) {
            return false;
        }
        String string = activityNode.getText();
        return string.length() > 0 && Character.toUpperCase(string.charAt(0)) == c;
    }

    public boolean selectNextNode(char c) {
        ActivityNode activityNode;
        JGoListPosition jGoListPosition;
        c = Character.toUpperCase(c);
        JGoDocument jGoDocument = this.getDocument();
        ActivityNode activityNode2 = null;
        JGoObject jGoObject = this.getSelection().getPrimarySelection();
        if (jGoObject != null && jGoObject instanceof ActivityNode) {
            activityNode2 = (ActivityNode)jGoObject;
        }
        JGoListPosition jGoListPosition2 = null;
        if (activityNode2 != null) {
            jGoListPosition2 = jGoDocument.findObject(activityNode2);
        }
        if ((jGoListPosition = jGoListPosition2) != null) {
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
        }
        while (jGoListPosition != null) {
            jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof ActivityNode) || !this.matchesNodeLabel(activityNode = (ActivityNode)jGoObject, c)) continue;
            this.selectObject(activityNode);
            this.scrollRectToVisible(activityNode.getBoundingRect());
            return true;
        }
        jGoListPosition = jGoDocument.getFirstObjectPos();
        while (jGoListPosition != null && jGoListPosition != jGoListPosition2) {
            jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof ActivityNode) || !this.matchesNodeLabel(activityNode = (ActivityNode)jGoObject, c)) continue;
            this.selectObject(activityNode);
            this.scrollRectToVisible(activityNode.getBoundingRect());
            return true;
        }
        return false;
    }
}

