/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.processor;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoPalette;
import com.nwoods.jgo.examples.Comment;
import com.nwoods.jgo.examples.MultiPortNodePort;
import com.nwoods.jgo.examples.processor.ActivityNode;
import com.nwoods.jgo.examples.processor.AppAction;
import com.nwoods.jgo.examples.processor.HelpDlg;
import com.nwoods.jgo.examples.processor.ProcessDialog;
import com.nwoods.jgo.examples.processor.ProcessDocument;
import com.nwoods.jgo.examples.processor.ProcessView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class Processor
extends JApplet
implements Runnable {
    AppAction FileNewAction = new AppAction("New", Processor.iconImage("images/new.gif"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            Processor.this.newProcess();
        }

        public boolean canAct() {
            return true;
        }
    };
    AppAction FileOpenAction = new AppAction("Open", Processor.iconImage("images/open.gif"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            Processor.this.openProcess();
        }

        public boolean canAct() {
            return true;
        }
    };
    AppAction FileCloseAction = new AppAction("Close", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            Processor.this.closeProcess();
        }
    };
    AppAction FileSaveAction = new AppAction("Save", Processor.iconImage("images/save.gif"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            Processor.this.saveProcess();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isLocationModifiable();
        }
    };
    AppAction FileSaveAsAction = new AppAction("Save As", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            Processor.this.saveAsProcess();
        }
    };
    AppAction FilePropertiesAction = new AppAction("Properties", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            Processor.this.editProcessProperties();
        }
    };
    AppAction PrintAction = new AppAction("Print", Processor.iconImage("images/print.gif"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().print();
        }
    };
    AppAction CutAction = new AppAction("Cut", Processor.iconImage("images/remove.gif"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().cut();
        }

        public boolean canAct() {
            return super.canAct() && !this.getView().getSelection().isEmpty() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction CopyAction = new AppAction("Copy", Processor.iconImage("images/copy.gif"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().copy();
        }

        public boolean canAct() {
            return super.canAct() && !this.getView().getSelection().isEmpty();
        }
    };
    AppAction PasteAction = new AppAction("Paste", Processor.iconImage("images/paste.gif"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().paste();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction DeleteAction = new AppAction("Delete", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().deleteSelection();
        }

        public boolean canAct() {
            return super.canAct() && !this.getView().getSelection().isEmpty() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction SelectAllAction = new AppAction("Select All", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().selectAll();
        }
    };
    JMenuItem UndoMenuItem = null;
    AppAction UndoAction = new AppAction("Undo", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().getDocument().undo();
            AppAction.updateAllActions();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDocument().canUndo();
        }

        public void updateEnabled() {
            super.updateEnabled();
            if (Processor.this.UndoMenuItem != null && this.getView() != null) {
                Processor.this.UndoMenuItem.setText(this.getView().getDocument().getUndoManager().getUndoPresentationName());
            }
        }
    };
    JMenuItem RedoMenuItem = null;
    AppAction RedoAction = new AppAction("Redo", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().getDocument().redo();
            AppAction.updateAllActions();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDocument().canRedo();
        }

        public void updateEnabled() {
            super.updateEnabled();
            if (Processor.this.RedoMenuItem != null && this.getView() != null) {
                Processor.this.RedoMenuItem.setText(this.getView().getDocument().getUndoManager().getRedoPresentationName());
            }
        }
    };
    AppAction DrawRoutedLinkAction = new AppAction("Draw Routed Link", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().editDrawRoutedLink();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction MovePortAction = new AppAction("Move Port", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().editMovePort();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction ObjectPropertiesAction = new AppAction("Properties", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().editObjectProperties();
        }

        public boolean canAct() {
            return super.canAct() && !this.getView().getSelection().isEmpty();
        }
    };
    JCheckBoxMenuItem LinksJumpOverMenuItem = null;
    AppAction LinksJumpOverAction = new AppAction("Links Jump Over", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().getDoc().setLinksJumpOver(!this.getView().getDoc().getLinksJumpOver());
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isModifiable();
        }

        public void updateEnabled() {
            super.updateEnabled();
            if (Processor.this.LinksJumpOverMenuItem != null && this.getView() != null) {
                Processor.this.LinksJumpOverMenuItem.setSelected(this.getView().getDoc().getLinksJumpOver());
            }
        }
    };
    AppAction ZoomNormalAction = new AppAction("Normal Zoom", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().zoomNormal();
        }
    };
    AppAction ZoomInAction = new AppAction("Zoom In", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().zoomIn();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getScale() < 8.0;
        }
    };
    AppAction ZoomOutAction = new AppAction("Zoom Out", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().zoomOut();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getScale() > (double)0.13f;
        }
    };
    AppAction ZoomToFitAction = new AppAction("Zoom To Fit", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().zoomToFit();
        }
    };
    AppAction InsertCommentAction = new AppAction("Comment", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().insertComment();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction InsertInputAction = new AppAction("Start", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().insertInput();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction InsertOutputAction = new AppAction("Finish", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().insertOutput();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction InsertActivityAction = new AppAction("Activity", (Container)this){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getView().insertActivity();
        }

        public boolean canAct() {
            return super.canAct() && this.getView().getDoc().isModifiable();
        }
    };
    AppAction AboutAction = new AppAction("About", Processor.iconImage("images/tb_07_u.gif"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            Processor.this.showAbout();
        }

        public boolean canAct() {
            return true;
        }
    };
    protected HashMap myMap = new HashMap();
    protected ProcessView myCurrentView;
    protected JDesktopPane myDesktop;
    protected JGoPalette myPalette;
    protected JMenuBar mainMenuBar;
    protected JToolBar toolBar;
    protected JMenu filemenu;
    protected JMenu editmenu;
    protected JMenu viewmenu;
    protected JMenu insertmenu;
    protected JMenu helpmenu;
    private int myDocCount = 1;
    static /* synthetic */ Class class$com$nwoods$jgo$examples$processor$Processor;

    public Processor() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            this.mainMenuBar = new JMenuBar();
            this.toolBar = new JToolBar();
            this.filemenu = new JMenu();
            this.editmenu = new JMenu();
            this.viewmenu = new JMenu();
            this.insertmenu = new JMenu();
            this.helpmenu = new JMenu();
            this.initMenus();
            this.initToolbar();
            this.myDesktop = new JDesktopPane();
            this.myPalette = new JGoPalette();
            this.myPalette.setPreferredSize(new Dimension(100, 300));
            this.myPalette.setMinimumSize(new Dimension(100, 100));
            JSplitPane jSplitPane = new JSplitPane(1);
            jSplitPane.setContinuousLayout(true);
            jSplitPane.setLeftComponent(this.getPalette());
            jSplitPane.setRightComponent(this.getDesktop());
            jSplitPane.setDividerLocation(100);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this.toolBar, "North");
            container.add((Component)jSplitPane, "Center");
            container.validate();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
        }
    }

    private static Icon iconImage(String string) {
        URL uRL = (class$com$nwoods$jgo$examples$processor$Processor == null ? (class$com$nwoods$jgo$examples$processor$Processor = Processor.class$("com.nwoods.jgo.examples.processor.Processor")) : class$com$nwoods$jgo$examples$processor$Processor).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    void initMenus() {
        JMenuItem jMenuItem = null;
        this.filemenu.setText("File");
        this.filemenu.setMnemonic('F');
        jMenuItem = this.filemenu.add(this.FileNewAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.setMnemonic('N');
        jMenuItem.setIcon(null);
        jMenuItem = this.filemenu.add(this.FileOpenAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem.setMnemonic('O');
        jMenuItem.setIcon(null);
        jMenuItem = this.filemenu.add(this.FileCloseAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        jMenuItem.setMnemonic('C');
        jMenuItem = this.filemenu.add(this.FileSaveAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.setMnemonic('S');
        jMenuItem.setIcon(null);
        jMenuItem = this.filemenu.add(this.FileSaveAsAction);
        jMenuItem.setMnemonic('A');
        this.filemenu.addSeparator();
        jMenuItem = this.filemenu.add(this.FilePropertiesAction);
        jMenuItem.setMnemonic('r');
        this.filemenu.addSeparator();
        jMenuItem = this.filemenu.add(this.PrintAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.setMnemonic('P');
        jMenuItem.setIcon(null);
        this.mainMenuBar.add(this.filemenu);
        this.editmenu.setText("Edit");
        this.editmenu.setMnemonic('E');
        jMenuItem = this.editmenu.add(this.CutAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem.setMnemonic('t');
        jMenuItem.setIcon(null);
        jMenuItem = this.editmenu.add(this.CopyAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.setMnemonic('C');
        jMenuItem.setIcon(null);
        jMenuItem = this.editmenu.add(this.PasteAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem.setMnemonic('P');
        jMenuItem.setIcon(null);
        jMenuItem = this.editmenu.add(this.DeleteAction);
        jMenuItem.setMnemonic('D');
        jMenuItem = this.editmenu.add(this.SelectAllAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItem.setMnemonic('l');
        this.editmenu.addSeparator();
        this.UndoMenuItem = this.editmenu.add(this.UndoAction);
        this.UndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.UndoMenuItem.setMnemonic('U');
        this.RedoMenuItem = this.editmenu.add(this.RedoAction);
        this.RedoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.RedoMenuItem.setMnemonic('R');
        this.editmenu.addSeparator();
        jMenuItem = this.editmenu.add(this.ObjectPropertiesAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 2));
        jMenuItem.setMnemonic('o');
        this.editmenu.addSeparator();
        jMenuItem = this.editmenu.add(this.DrawRoutedLinkAction);
        jMenuItem.setMnemonic('w');
        jMenuItem = this.editmenu.add(this.MovePortAction);
        jMenuItem.setMnemonic('v');
        this.mainMenuBar.add(this.editmenu);
        this.viewmenu.setText("View");
        this.viewmenu.setMnemonic('V');
        jMenuItem = this.viewmenu.add(this.ZoomNormalAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 3));
        jMenuItem.setMnemonic('N');
        jMenuItem = this.viewmenu.add(this.ZoomInAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 2));
        jMenuItem.setMnemonic('I');
        jMenuItem = this.viewmenu.add(this.ZoomOutAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 1));
        jMenuItem.setMnemonic('O');
        jMenuItem = this.viewmenu.add(this.ZoomToFitAction);
        jMenuItem.setMnemonic('Z');
        this.viewmenu.addSeparator();
        this.LinksJumpOverMenuItem = new JCheckBoxMenuItem(this.LinksJumpOverAction);
        this.viewmenu.add(this.LinksJumpOverMenuItem);
        this.LinksJumpOverMenuItem.setMnemonic('j');
        this.mainMenuBar.add(this.viewmenu);
        this.insertmenu.setText("Insert");
        this.insertmenu.setMnemonic('I');
        jMenuItem = this.insertmenu.add(this.InsertCommentAction);
        jMenuItem.setMnemonic('C');
        jMenuItem = this.insertmenu.add(this.InsertInputAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = this.insertmenu.add(this.InsertOutputAction);
        jMenuItem.setMnemonic('F');
        jMenuItem = this.insertmenu.add(this.InsertActivityAction);
        jMenuItem.setMnemonic('A');
        this.mainMenuBar.add(this.insertmenu);
        this.helpmenu.setText("Help");
        this.helpmenu.setMnemonic('H');
        jMenuItem = this.helpmenu.add(this.AboutAction);
        jMenuItem.setMnemonic('A');
        jMenuItem.setIcon(null);
        this.mainMenuBar.add(this.helpmenu);
        this.setJMenuBar(this.mainMenuBar);
    }

    protected JToolBar initToolbar() {
        JButton jButton = null;
        jButton = this.toolBar.add(this.FileNewAction);
        jButton.setToolTipText("Create a new work-flow window");
        jButton = this.toolBar.add(this.FileOpenAction);
        jButton.setToolTipText("Open a previously saved work-flow window");
        jButton = this.toolBar.add(this.FileSaveAction);
        jButton.setToolTipText("Save a work-flow window");
        this.toolBar.addSeparator();
        jButton = this.toolBar.add(this.CutAction);
        jButton.setToolTipText("Cut to clipboard");
        jButton = this.toolBar.add(this.CopyAction);
        jButton.setToolTipText("Copy to clipboard");
        jButton = this.toolBar.add(this.PasteAction);
        jButton.setToolTipText("Paste from clipboard");
        this.toolBar.addSeparator();
        jButton = this.toolBar.add(this.PrintAction);
        jButton.setToolTipText("Print selected work-flow window");
        this.toolBar.addSeparator();
        jButton = this.toolBar.add(this.AboutAction);
        jButton.setToolTipText("Display help about this application");
        return this.toolBar;
    }

    public void addExitCommand() {
        this.filemenu.addSeparator();
        AppAction appAction = new AppAction("Exit", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                Processor.this.exit();
            }

            public boolean canAct() {
                return true;
            }
        };
        JMenuItem jMenuItem = this.filemenu.add(appAction);
        jMenuItem.setMnemonic('x');
    }

    void initPalette() {
        this.getPalette().setBorder(new TitledBorder("Activities"));
        JGoDocument jGoDocument = this.getPalette().getDocument();
        Comment comment = new Comment("a comment");
        comment.setEditable(true);
        jGoDocument.addObjectAtTail(comment);
        for (int i = 0; i < 8; ++i) {
            ActivityNode activityNode = this.makePaletteNode(i, -1);
            jGoDocument.addObjectAtTail(activityNode);
        }
    }

    ActivityNode makePaletteNode(int n, int n2) {
        ActivityNode activityNode = new ActivityNode();
        JGoImage jGoImage = new JGoImage(new Rectangle(0, 0, 40, 40));
        jGoImage.loadImage((class$com$nwoods$jgo$examples$processor$Processor == null ? (class$com$nwoods$jgo$examples$processor$Processor = Processor.class$("com.nwoods.jgo.examples.processor.Processor")) : class$com$nwoods$jgo$examples$processor$Processor).getResource("doc.gif"), true);
        activityNode.initialize(n, n2);
        activityNode.addScatteredPorts((int)(Math.random() * 5.0) + 1);
        activityNode.getLabel().setSelectable(false);
        return activityNode;
    }

    public void init() {
        JGoImage.setDefaultBase(this.getCodeBase());
    }

    public void start() {
        new Thread(this).start();
        this.initPalette();
        MultiPortNodePort.FULL = new JGoBrush(65535, Color.green);
    }

    public void run() {
        this.getPalette().initializeDragDropHandling();
        if (this.getDesktop().getAllFrames().length == 0) {
            this.newProcess();
        }
        AppAction.updateAllActions();
    }

    public void destroy() {
        JInternalFrame[] jInternalFrameArray = this.getDesktop().getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            JInternalFrame jInternalFrame = jInternalFrameArray[i];
            try {
                jInternalFrame.setClosed(true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            final Processor processor = new Processor();
            final JFrame jFrame = new JFrame();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    if (processor.getCurrentView() != null) {
                        processor.getCurrentView().getDoc().updateLocationModifiable();
                    }
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Object object = windowEvent.getSource();
                    if (object == jFrame) {
                        processor.exit();
                    }
                }
            });
            processor.addExitCommand();
            jFrame.setTitle("Process Flow Editor");
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jFrame.setBounds(0, 0, dimension.width, dimension.height);
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)processor, "Center");
            container.validate();
            jFrame.setVisible(true);
            processor.start();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    void exit() {
        this.destroy();
        System.exit(0);
    }

    void showAbout() {
        HelpDlg helpDlg = new HelpDlg(null, "About", true);
        helpDlg.setVisible(true);
    }

    void editProcessProperties() {
        ProcessView processView = this.getCurrentView();
        if (processView != null) {
            processView.getDoc().startTransaction();
            new ProcessDialog(processView.getFrame(), processView.getDoc()).setVisible(true);
            processView.getDoc().endTransaction("Process Properties");
        }
    }

    public void createFrame(ProcessDocument processDocument) {
        final ProcessView processView = new ProcessView(processDocument);
        final JInternalFrame jInternalFrame = new JInternalFrame(processDocument.getName(), true, true, true);
        jInternalFrame.setDefaultCloseOperation(2);
        processView.initialize(this, jInternalFrame);
        jInternalFrame.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                Processor.this.myCurrentView = processView;
                processView.requestFocus();
                processView.getDoc().updateLocationModifiable();
                AppAction.updateAllActions();
            }

            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                Processor.this.myCurrentView = null;
                AppAction.updateAllActions();
            }

            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            }
        });
        jInternalFrame.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if (propertyChangeEvent.getPropertyName().equals("closed") && propertyChangeEvent.getOldValue() == Boolean.FALSE && propertyChangeEvent.getNewValue() == Boolean.TRUE && processView.getDoc().isModified()) {
                    String string = "Save changes to ";
                    string = processView.getDoc().getName().equals("") ? string + "modified document?" : string + processView.getDoc().getName();
                    string = string + "\n  (";
                    string = processView.getDoc().getLocation().equals("") ? string + "<no location>" : string + processView.getDoc().getLocation();
                    string = string + ")";
                    int n = JOptionPane.showConfirmDialog(processView.getFrame(), string, "Closing modified document", 1, 3);
                    if (n == 1 || n == 0) {
                        if (n == 0) {
                            if (processView.getDoc().isLocationModifiable()) {
                                processView.getDoc().save();
                            } else {
                                processView.getDoc().saveAs(".wfl");
                            }
                        }
                        Processor.this.getDesktop().remove(jInternalFrame);
                        Processor.this.getDesktop().repaint();
                    } else {
                        throw new PropertyVetoException("", propertyChangeEvent);
                    }
                }
            }
        });
        Container container = jInternalFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add(processView);
        jInternalFrame.setSize(500, 400);
        this.getDesktop().add(jInternalFrame);
        jInternalFrame.show();
        processView.initializeDragDropHandling();
    }

    void newProcess() {
        ProcessDocument processDocument = new ProcessDocument();
        String string = "Untitled" + Integer.toString(this.myDocCount++);
        processDocument.setName(string);
        this.createFrame(processDocument);
        processDocument.setModified(false);
        processDocument.discardAllEdits();
    }

    void openProcess() {
        ProcessDocument processDocument;
        String string = null;
        ProcessView processView = this.getCurrentView();
        if (processView != null) {
            processDocument = processView.getDoc();
            string = processDocument.getLocation();
        }
        if ((processDocument = ProcessDocument.open(this, string)) != null) {
            this.createFrame(processDocument);
        }
    }

    void closeProcess() {
        JInternalFrame jInternalFrame;
        if (this.getCurrentView() != null && (jInternalFrame = this.getCurrentView().getInternalFrame()) != null) {
            try {
                jInternalFrame.setClosed(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void saveProcess() {
        if (this.getCurrentView() != null) {
            ProcessDocument processDocument = this.getCurrentView().getDoc();
            processDocument.save();
        }
    }

    void saveAsProcess() {
        if (this.getCurrentView() != null) {
            ProcessDocument processDocument = this.getCurrentView().getDoc();
            processDocument.saveAs(".wfl");
        }
    }

    ProcessDocument findProcessDocument(String string) {
        Object v = this.myMap.get(string);
        if (v != null && v instanceof ProcessDocument) {
            return (ProcessDocument)v;
        }
        return null;
    }

    ProcessView getCurrentView() {
        return this.myCurrentView;
    }

    JDesktopPane getDesktop() {
        return this.myDesktop;
    }

    JGoPalette getPalette() {
        return this.myPalette;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

