/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.jtreeapp;

import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.jtreeapp.GoTreeNode;
import com.nwoods.jgo.examples.jtreeapp.GoTreeNodePort;
import com.nwoods.jgo.examples.jtreeapp.JGoTree;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GoTree
extends JGoTree {
    public GoTree() {
        this.setSelectable(false);
    }

    public JComponent createComponent(JGoView jGoView) {
        Serializable serializable;
        JComponent jComponent = super.createComponent(jGoView);
        JTree jTree = null;
        if (jComponent instanceof JTree) {
            jTree = (JTree)jComponent;
        } else if (jComponent instanceof JScrollPane) {
            serializable = (JScrollPane)jComponent;
            jTree = (JTree)serializable.getViewport().getView();
        }
        if (jTree != null) {
            jTree.setAutoscrolls(true);
            this.enableListeners(false, jTree, jGoView);
            serializable = this.getGoTreeNode();
            jTree.addTreeExpansionListener(new JTListener((GoTreeNode)serializable, jGoView));
            SwingUtilities.updateComponentTreeUI(jTree);
            jTree.addComponentListener(new CListener((GoTreeNode)serializable, jGoView));
            this.enableListeners(true, jTree, jGoView);
        }
        return jComponent;
    }

    public GoTreeNode getGoTreeNode() {
        return (GoTreeNode)this.getParent();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.getGoTreeNode().layoutPorts();
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        Object[] objectArray = treeModelEvent.getChildren();
        TreeModel treeModel = this.getTreeModel();
        GoTreeNode goTreeNode = this.getGoTreeNode();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            TreePath treePath2 = treePath.pathByAddingChild(object);
            GoTreeNodePort goTreeNodePort = goTreeNode.findPort(treePath2);
            goTreeNode.removePort(goTreeNodePort);
        }
        goTreeNode.layoutPorts();
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.getGoTreeNode().resetAllPorts();
    }

    static class CListener
    extends ComponentAdapter {
        private GoTreeNode myTreeNode;
        private JGoView myView;

        public CListener(GoTreeNode goTreeNode, JGoView jGoView) {
            this.myTreeNode = goTreeNode;
            this.myView = jGoView;
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.myTreeNode.layoutPorts();
        }
    }

    static class JTListener
    implements TreeExpansionListener {
        private GoTreeNode myTreeNode;
        private JGoView myView;

        public JTListener(GoTreeNode goTreeNode, JGoView jGoView) {
            this.myTreeNode = goTreeNode;
            this.myView = jGoView;
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.myTreeNode.layoutPorts();
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.myTreeNode.layoutPorts();
        }
    }
}

