/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.jtreeapp;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.jtreeapp.GoTree;
import com.nwoods.jgo.examples.jtreeapp.GoTreeNodePort;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GoTreeNode
extends JGoNode {
    public static final int ChangedLinkSource = 1020;
    public static final int ChangedLinkDestination = 1021;
    public static final int ChangedAllowingCrossLevelLinks = 1022;
    private GoTree myTree = null;
    private HashMap myMap = new HashMap();
    private HashMap myOldMap = null;
    private boolean myLinkSource = true;
    private boolean myLinkDestination = false;
    private boolean myAllowingCrossLevelLinks = false;
    private boolean myMergeInvisiblePorts = true;

    void initialize(TreeModel treeModel, boolean bl, boolean bl2) {
        if (this.myTree == null) {
            this.myTree = new GoTree();
            this.myTree.setTreeModel(treeModel);
            this.addObjectAtTail(this.myTree);
        }
        this.setLinkSource(bl);
        this.setLinkDestination(bl2);
    }

    public void initialize(TreeModel treeModel, boolean bl, boolean bl2, JGoView jGoView) {
        this.initialize(treeModel, bl, bl2);
        this.myTree.getJTree(jGoView);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        GoTreeNode goTreeNode = (GoTreeNode)super.copyObject(jGoCopyEnvironment);
        if (goTreeNode != null) {
            goTreeNode.myLinkSource = this.myLinkSource;
            goTreeNode.myLinkDestination = this.myLinkDestination;
        }
        return goTreeNode;
    }

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        GoTreeNode goTreeNode = (GoTreeNode)jGoArea;
        goTreeNode.myTree = (GoTree)this.myTree.copyObject(jGoCopyEnvironment);
        goTreeNode.addObjectAtTail(goTreeNode.myTree);
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            Object v;
            JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPos(jGoListPosition);
            if (jGoObject == this.myTree || (v = jGoCopyEnvironment.get(jGoObject)) != null) continue;
            JGoObject jGoObject2 = jGoObject.copyObject(jGoCopyEnvironment);
            jGoArea.addObjectAtTail(jGoObject2);
        }
    }

    protected void geometryChange(Rectangle rectangle) {
        if (rectangle.width != this.getWidth() || rectangle.height != this.getHeight()) {
            this.layoutChildren();
        } else {
            super.geometryChange(rectangle);
        }
    }

    protected void layoutChildren() {
        Rectangle rectangle = this.getBoundingRect();
        this.myTree.setBoundingRect(rectangle);
        this.layoutPorts();
    }

    protected void resetAllPorts() {
        this.myOldMap = this.myMap;
        this.myMap = new HashMap();
        this.layoutPorts();
        Iterator iterator = this.myOldMap.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (this.myMap.containsKey(v) || !(v instanceof TreePath)) continue;
            TreePath treePath = (TreePath)v;
            GoTreeNodePort goTreeNodePort = (GoTreeNodePort)this.myMap.get(treePath);
            this.removeObject(goTreeNodePort);
        }
        this.myOldMap = null;
    }

    protected void layoutPorts() {
        Object object;
        Object object2;
        JTree jTree = this.myTree.getJTree(null);
        JGoView jGoView = null;
        int n = 0;
        int n2 = 0;
        if (jTree != null) {
            jGoView = this.myTree.getFirstView();
            object2 = jTree.getLocationOnScreen();
            object = jGoView.getCanvas().getLocationOnScreen();
            n = ((Point)object2).x - ((Point)object).x;
            n2 = ((Point)object2).y - ((Point)object).y;
        }
        if ((object2 = this.myTree.getTreeModel()) != null && (object = object2.getRoot()) != null) {
            this.traverseTree((TreeModel)object2, new TreePath(object), jGoView, jTree, n, n2, 0, 0);
        }
    }

    protected GoTreeNodePort traverseTree(TreeModel treeModel, TreePath treePath, JGoView jGoView, JTree jTree, int n, int n2, int n3, int n4) {
        Object object;
        GoTreeNodePort goTreeNodePort = this.getPort(treePath);
        if (jGoView != null && jTree != null) {
            object = this.getBoundingRect();
            if (jTree.isVisible(treePath)) {
                Rectangle rectangle = jTree.getPathBounds(treePath);
                if (rectangle != null) {
                    rectangle.x += n;
                    rectangle.y += n2;
                    jGoView.convertViewToDoc(rectangle);
                    goTreeNodePort.setLabelLeft(rectangle.x);
                    goTreeNodePort.setLabelRight(rectangle.x + rectangle.width);
                    rectangle.x = ((Rectangle)object).x;
                    rectangle.width = ((Rectangle)object).width - 1;
                    if (rectangle.y < ((Rectangle)object).y) {
                        rectangle.height = rectangle.y + rectangle.height < ((Rectangle)object).y ? 0 : rectangle.y + rectangle.height - ((Rectangle)object).y;
                        rectangle.y = ((Rectangle)object).y;
                    } else if (rectangle.y + rectangle.height > ((Rectangle)object).y + ((Rectangle)object).height - 1) {
                        rectangle.height = rectangle.y > ((Rectangle)object).y ? 0 : ((Rectangle)object).y + ((Rectangle)object).height - 1 - rectangle.y;
                        rectangle.y = ((Rectangle)object).y + ((Rectangle)object).height - 1 - rectangle.height;
                    }
                    goTreeNodePort.setVisible(true);
                    goTreeNodePort.setBoundingRect(rectangle);
                    if (this.myMergeInvisiblePorts) {
                        n3 = rectangle.y;
                        n4 = rectangle.height;
                    } else {
                        n3 = rectangle.y + rectangle.height;
                        n4 = 0;
                    }
                }
            } else {
                goTreeNodePort.setBoundingRect(((Rectangle)object).x, n3, ((Rectangle)object).width - 1, n4);
                goTreeNodePort.setVisible(false);
            }
        }
        object = treePath.getLastPathComponent();
        int n5 = treeModel.getChildCount(object);
        goTreeNodePort.setChildCount(n5);
        for (int i = 0; i < n5; ++i) {
            Object object2 = treeModel.getChild(object, i);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            GoTreeNodePort goTreeNodePort2 = this.traverseTree(treeModel, treePath2, jGoView, jTree, n, n2, n3, n4);
            goTreeNodePort.setChild(i, goTreeNodePort2);
            if (this.myMergeInvisiblePorts) {
                n3 = goTreeNodePort2.getTop();
                n4 = goTreeNodePort2.getHeight();
                continue;
            }
            n3 = goTreeNodePort2.getTop() + goTreeNodePort2.getHeight();
            n4 = 0;
        }
        return goTreeNodePort;
    }

    public void removePort(GoTreeNodePort goTreeNodePort) {
        if (goTreeNodePort == null) {
            return;
        }
        for (int i = goTreeNodePort.getChildCount() - 1; i >= 0; --i) {
            GoTreeNodePort goTreeNodePort2 = goTreeNodePort.getChild(i);
            this.removePort(goTreeNodePort2);
            goTreeNodePort.removeChild(goTreeNodePort2);
        }
        this.mapPathToPort(goTreeNodePort.getTreePath(), null);
        this.removeObject(goTreeNodePort);
    }

    public GoTree getTree() {
        return this.myTree;
    }

    public GoTreeNodePort findPort(TreePath treePath) {
        GoTreeNodePort goTreeNodePort = (GoTreeNodePort)this.myMap.get(treePath);
        if (goTreeNodePort != null) {
            return goTreeNodePort;
        }
        if (this.myOldMap != null) {
            goTreeNodePort = (GoTreeNodePort)this.myOldMap.get(treePath);
        }
        return goTreeNodePort;
    }

    public GoTreeNodePort getPort(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        GoTreeNodePort goTreeNodePort = this.findPort(treePath);
        if (goTreeNodePort == null) {
            goTreeNodePort = this.makePort(treePath);
        }
        return goTreeNodePort;
    }

    void mapPathToPort(TreePath treePath, GoTreeNodePort goTreeNodePort) {
        if (goTreeNodePort == null) {
            this.myMap.remove(treePath);
        } else {
            this.myMap.put(treePath, goTreeNodePort);
        }
    }

    public GoTreeNodePort makePort(TreePath treePath) {
        GoTreeNodePort goTreeNodePort = new GoTreeNodePort(treePath);
        this.mapPathToPort(treePath, goTreeNodePort);
        goTreeNodePort.setValidDestination(this.isLinkDestination());
        goTreeNodePort.setValidSource(this.isLinkSource());
        goTreeNodePort.setBrush(null);
        goTreeNodePort.setLocation(this.getTopLeft());
        this.addObjectAtTail(goTreeNodePort);
        return goTreeNodePort;
    }

    public boolean isLinkSource() {
        return this.myLinkSource;
    }

    public void setLinkSource(boolean bl) {
        boolean bl2 = this.myLinkSource;
        if (bl != bl2) {
            this.myLinkSource = bl;
            this.update(1020, bl2 ? 1 : 0, null);
        }
    }

    public boolean isLinkDestination() {
        return this.myLinkDestination;
    }

    public void setLinkDestination(boolean bl) {
        boolean bl2 = this.myLinkDestination;
        if (bl != bl2) {
            this.myLinkDestination = bl;
            this.update(1021, bl2 ? 1 : 0, null);
        }
    }

    public boolean isAllowingCrossLevelLinks() {
        return this.myAllowingCrossLevelLinks;
    }

    public void setAllowingCrossLevelLinks(boolean bl) {
        boolean bl2 = this.myAllowingCrossLevelLinks;
        if (bl != bl2) {
            this.myAllowingCrossLevelLinks = bl;
            this.update(1022, bl2 ? 1 : 0, null);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1020: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isLinkSource());
                return;
            }
            case 1021: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isLinkDestination());
                return;
            }
            case 1022: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isLinkSource());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1020: {
                this.setLinkSource(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 1021: {
                this.setLinkDestination(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 1022: {
                this.setAllowingCrossLevelLinks(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

