/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.jtreeapp;

import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.examples.jtreeapp.GoTreeNode;
import java.awt.Point;
import java.util.Vector;
import javax.swing.tree.TreePath;

public class GoTreeNodePort
extends JGoPort {
    public static final int ChangedTreePath = 1020;
    public static final int ChangedMinLinks = 1021;
    public static final int ChangedMaxLinks = 1022;
    private TreePath myPath = null;
    private GoTreeNodePort myParentPort = null;
    private Vector myChildPorts = null;
    private int myMinLinks = 0;
    private int myMaxLinks = 999999;
    private int myLabelLeft = 0;
    private int myLabelRight = 0;

    public GoTreeNodePort() {
        this.setStyle(4);
    }

    public GoTreeNodePort(TreePath treePath) {
        this.setStyle(4);
        this.myPath = treePath;
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        GoTreeNodePort goTreeNodePort = (GoTreeNodePort)super.copyObject(jGoCopyEnvironment);
        if (goTreeNodePort != null) {
            goTreeNodePort.myPath = this.myPath;
            goTreeNodePort.myMinLinks = this.myMinLinks;
            goTreeNodePort.myMaxLinks = this.myMaxLinks;
            GoTreeNode goTreeNode = this.getGoTreeNode();
            GoTreeNode goTreeNode2 = (GoTreeNode)jGoCopyEnvironment.get(goTreeNode);
            if (goTreeNode2 != null) {
                goTreeNode2.mapPathToPort(goTreeNodePort.getTreePath(), goTreeNodePort);
                GoTreeNodePort goTreeNodePort2 = this.findCopiedTNP(jGoCopyEnvironment, goTreeNode2, this.getParentPort());
                int n = this.getChildCount();
                goTreeNodePort.setChildCount(n);
                for (int i = 0; i < n; ++i) {
                    GoTreeNodePort goTreeNodePort3 = this.findCopiedTNP(jGoCopyEnvironment, goTreeNode2, this.getChild(i));
                    goTreeNodePort.setChild(i, goTreeNodePort3);
                }
            }
        }
        return goTreeNodePort;
    }

    private GoTreeNodePort findCopiedTNP(JGoCopyEnvironment jGoCopyEnvironment, GoTreeNode goTreeNode, GoTreeNodePort goTreeNodePort) {
        if (goTreeNodePort == null) {
            return null;
        }
        Object v = jGoCopyEnvironment.get(goTreeNodePort);
        if (v != null && v instanceof GoTreeNodePort) {
            return (GoTreeNodePort)v;
        }
        GoTreeNodePort goTreeNodePort2 = (GoTreeNodePort)goTreeNodePort.copyObject(jGoCopyEnvironment);
        if (goTreeNodePort2.getParent() != goTreeNode) {
            goTreeNode.addObjectAtTail(goTreeNodePort2);
        }
        return goTreeNodePort2;
    }

    public boolean isPointInObj(Point point) {
        return point.x > this.getLabelLeft() && this.getBoundingRect().contains(point.x, point.y);
    }

    public GoTreeNode getGoTreeNode() {
        return (GoTreeNode)this.getParent();
    }

    public TreePath getTreePath() {
        return this.myPath;
    }

    public void setTreePath(TreePath treePath) {
        TreePath treePath2 = this.myPath;
        if (!treePath2.equals(treePath)) {
            GoTreeNode goTreeNode = this.getGoTreeNode();
            if (treePath2 != null && goTreeNode != null) {
                goTreeNode.mapPathToPort(treePath2, null);
            }
            this.myPath = treePath;
            if (treePath != null && goTreeNode != null) {
                goTreeNode.mapPathToPort(treePath, this);
            }
            this.update(1020, 0, treePath2);
        }
    }

    public GoTreeNodePort getParentPort() {
        return this.myParentPort;
    }

    public int getChildCount() {
        if (this.myChildPorts != null) {
            return this.myChildPorts.size();
        }
        return 0;
    }

    public void setChildCount(int n) {
        if (n <= 0) {
            this.myChildPorts = null;
        } else {
            if (this.myChildPorts == null) {
                this.myChildPorts = new Vector();
            }
            this.myChildPorts.setSize(n);
        }
    }

    public GoTreeNodePort getChild(int n) {
        if (this.myChildPorts != null) {
            return (GoTreeNodePort)this.myChildPorts.get(n);
        }
        return null;
    }

    public void setChild(int n, GoTreeNodePort goTreeNodePort) {
        if (this.myChildPorts == null) {
            this.myChildPorts = new Vector(n + 1);
        }
        if (n >= this.myChildPorts.size()) {
            this.myChildPorts.setSize(n + 1);
        }
        this.myChildPorts.set(n, goTreeNodePort);
        goTreeNodePort.myParentPort = this;
    }

    public void removeChild(GoTreeNodePort goTreeNodePort) {
        if (goTreeNodePort == null) {
            return;
        }
        if (goTreeNodePort.getParentPort() != this) {
            return;
        }
        if (this.myChildPorts != null) {
            this.myChildPorts.remove(goTreeNodePort);
            goTreeNodePort.myParentPort = null;
        }
    }

    public void removeChild(int n) {
        this.removeChild(this.getChild(n));
    }

    public int getLevel() {
        GoTreeNodePort goTreeNodePort = this.getParentPort();
        if (goTreeNodePort == null) {
            return 0;
        }
        return 1 + goTreeNodePort.getLevel();
    }

    public int getMinLinks() {
        return this.myMinLinks;
    }

    public void setMinLinks(int n) {
        int n2 = this.myMinLinks;
        if (n2 != n && n >= 0) {
            this.myMinLinks = n;
            this.update(1021, n2, null);
        }
    }

    public int getMaxLinks() {
        return this.myMaxLinks;
    }

    public void setMaxLinks(int n) {
        int n2 = this.myMaxLinks;
        if (n2 != n && n >= 0) {
            this.myMaxLinks = n;
            this.update(1022, n2, null);
        }
    }

    public int getNumValidLinks() {
        int n = 0;
        JGoListPosition jGoListPosition = this.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = this.getLinkAtPos(jGoListPosition);
            jGoListPosition = this.getNextLinkPos(jGoListPosition);
            if (!jGoLink.isVisible() || jGoLink.getDocument() == null || jGoLink.getFromPort().getDocument() == null || jGoLink.getToPort().getDocument() == null) continue;
            ++n;
        }
        return n;
    }

    public boolean isValidSource() {
        return this.getMaxLinks() > 0 && this.getNumValidLinks() < this.getMaxLinks() && super.isValidSource();
    }

    public boolean isValidDestination() {
        return this.getMaxLinks() > 0 && this.getNumValidLinks() < this.getMaxLinks() && super.isValidDestination();
    }

    public boolean validLink(JGoPort jGoPort) {
        if (this.getParent() == jGoPort.getParent()) {
            return false;
        }
        if (jGoPort instanceof GoTreeNodePort) {
            GoTreeNode goTreeNode = this.getGoTreeNode();
            GoTreeNodePort goTreeNodePort = (GoTreeNodePort)jGoPort;
            GoTreeNode goTreeNode2 = goTreeNodePort.getGoTreeNode();
            if (goTreeNode != null && !goTreeNode.isAllowingCrossLevelLinks() && goTreeNode2 != null && !goTreeNode2.isAllowingCrossLevelLinks() && this.getLevel() != goTreeNodePort.getLevel()) {
                return false;
            }
        }
        return super.validLink(jGoPort);
    }

    public String getToolTipText() {
        if (this.getTreePath() != null) {
            return this.getTreePath().toString();
        }
        return null;
    }

    public final int getLabelLeft() {
        return this.myLabelLeft;
    }

    public final void setLabelLeft(int n) {
        this.myLabelLeft = n;
    }

    public final int getLabelRight() {
        return this.myLabelRight;
    }

    public final void setLabelRight(int n) {
        this.myLabelRight = n;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1020: {
                jGoDocumentChangedEdit.setNewValue(this.getTreePath());
                return;
            }
            case 1021: {
                jGoDocumentChangedEdit.setNewValueInt(this.getMinLinks());
                return;
            }
            case 1022: {
                jGoDocumentChangedEdit.setNewValueInt(this.getMaxLinks());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1020: {
                this.setTreePath((TreePath)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 1021: {
                this.setMinLinks(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 1022: {
                this.setMaxLinks(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

