/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.jtreeapp;

import com.nwoods.jgo.JGoControl;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public class JGoTree
extends JGoControl
implements TreeModelListener {
    public static final int ChangedAutoscrollMargin = 1011;
    private TreeModel myModel = null;
    private int myAutoscrollMargin = 12;
    private transient JGoView myFirstView = null;
    private transient boolean myListenersInitialized = false;
    private transient MListener myMListener = null;
    private transient DGListener myDGListener = null;
    private transient DragGestureRecognizer myDGRecognizer = null;

    public JGoTree() {
    }

    public JGoTree(Rectangle rectangle) {
        super(rectangle);
    }

    public JGoTree(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoTree jGoTree = (JGoTree)super.copyObject(jGoCopyEnvironment);
        if (jGoTree != null) {
            jGoTree.myModel = this.myModel;
        }
        return jGoTree;
    }

    public JComponent createComponent(JGoView jGoView) {
        JGoJTree jGoJTree;
        TreeModel treeModel = this.getTreeModel();
        if (treeModel != null) {
            jGoJTree = new JGoJTree(treeModel);
        } else {
            jGoJTree = new JGoJTree();
            treeModel = jGoJTree.getModel();
            this.setTreeModel(treeModel);
        }
        jGoJTree.setJGoTree(this);
        this.enableListeners(true, jGoJTree, jGoView);
        new DropTarget(jGoJTree, new DTListener(jGoJTree, jGoView));
        JScrollPane jScrollPane = new JScrollPane(jGoJTree);
        jGoJTree.setScrollPane(jScrollPane);
        JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
        if (jScrollBar != null) {
            new DropTarget(jScrollBar, new DTListener(jScrollBar, jGoView));
        }
        if ((jScrollBar = jScrollPane.getVerticalScrollBar()) != null) {
            new DropTarget(jScrollBar, new DTListener(jScrollBar, jGoView));
        }
        return jScrollPane;
    }

    public JComponent getComponent(JGoView jGoView) {
        if (this.myFirstView == null) {
            this.myFirstView = jGoView;
            JComponent jComponent = super.getComponent(jGoView);
            TreeModel treeModel = this.getTreeModel();
            Object object = treeModel.getRoot();
            Object[] objectArray = new Object[]{object};
            TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray);
            this.treeNodesInserted(treeModelEvent);
            return jComponent;
        }
        return super.getComponent(jGoView);
    }

    public void enableListeners(boolean bl, JTree jTree, JGoView jGoView) {
        if (this.myMListener == null) {
            this.myMListener = new MListener(jTree, jGoView);
        }
        if (this.myDGListener == null) {
            this.myDGListener = new DGListener(jTree, jGoView);
        }
        if (bl && !this.myListenersInitialized) {
            jTree.addMouseListener(this.myMListener);
            jTree.addMouseMotionListener(this.myMListener);
            this.myDGRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(jTree, 3, this.myDGListener);
            this.myListenersInitialized = true;
        } else if (this.myDGRecognizer != null) {
            jTree.removeMouseListener(this.myMListener);
            jTree.removeMouseMotionListener(this.myMListener);
            this.myDGRecognizer.removeDragGestureListener(this.myDGListener);
            this.myListenersInitialized = false;
        }
    }

    public JTree getJTree(JGoView jGoView) {
        if (jGoView == null) {
            jGoView = this.myFirstView;
        }
        if (jGoView == null) {
            return null;
        }
        JComponent jComponent = this.getComponent(jGoView);
        if (jComponent instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)jComponent;
            return (JTree)jScrollPane.getViewport().getView();
        }
        return (JTree)jComponent;
    }

    public JGoView getFirstView() {
        return this.myFirstView;
    }

    public TreeModel getTreeModel() {
        return this.myModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.myModel;
        if (treeModel2 == null && treeModel != null) {
            this.myModel = treeModel;
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public int getAutoscrollMargin() {
        return this.myAutoscrollMargin;
    }

    public void setAutoscrollMargin(int n) {
        int n2 = this.myAutoscrollMargin;
        if (n >= 0 && n != n2) {
            this.myAutoscrollMargin = n;
            this.update(1011, n2, null);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1011: {
                jGoDocumentChangedEdit.setNewValueInt(this.getAutoscrollMargin());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1011: {
                this.setAutoscrollMargin(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    static class DTListener
    implements DropTargetListener {
        private JComponent myComp;
        private JGoView myView;

        public DTListener(JComponent jComponent, JGoView jGoView) {
            this.myComp = jComponent;
            this.myView = jGoView;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.myView.onDragEnter(this.makeDragEvent(dropTargetDragEvent));
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.myView.onDragOver(this.makeDragEvent(dropTargetDragEvent));
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.myView.onDropActionChanged(this.makeDragEvent(dropTargetDragEvent));
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.myView.onDragExit(dropTargetEvent);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.myView.onDrop(this.makeDropEvent(dropTargetDropEvent));
        }

        public DropTargetDragEvent makeDragEvent(DropTargetDragEvent dropTargetDragEvent) {
            return new DropTargetDragEvent(dropTargetDragEvent.getDropTargetContext(), this.adjustPoint(dropTargetDragEvent.getLocation()), dropTargetDragEvent.getDropAction(), dropTargetDragEvent.getSourceActions());
        }

        public DropTargetDropEvent makeDropEvent(DropTargetDropEvent dropTargetDropEvent) {
            return new DropTargetDropEvent(dropTargetDropEvent.getDropTargetContext(), this.adjustPoint(dropTargetDropEvent.getLocation()), dropTargetDropEvent.getDropAction(), dropTargetDropEvent.getSourceActions());
        }

        public Point adjustPoint(Point point) {
            Point point2 = this.myComp.getLocationOnScreen();
            Point point3 = this.myView.getCanvas().getLocationOnScreen();
            return new Point(point2.x - point3.x + point.x, point2.y - point3.y + point.y);
        }
    }

    static class DGListener
    implements DragGestureListener {
        private JComponent myComp;
        private JGoView myView;

        public DGListener(JComponent jComponent, JGoView jGoView) {
            this.myComp = jComponent;
            this.myView = jGoView;
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            this.myView.onDragGestureRecognized(this.makeDragGestureEvent(dragGestureEvent));
        }

        public DragGestureEvent makeDragGestureEvent(DragGestureEvent dragGestureEvent) {
            this.myView.requestFocus();
            Point point = this.adjustPoint(dragGestureEvent.getDragOrigin());
            Point point2 = this.myView.viewToDocCoords(point);
            List<Object> list = Arrays.asList(dragGestureEvent.toArray());
            return new DragGestureEvent(dragGestureEvent.getSourceAsDragGestureRecognizer(), dragGestureEvent.getDragAction(), point, list);
        }

        public Point adjustPoint(Point point) {
            Point point2 = this.myComp.getLocationOnScreen();
            Point point3 = this.myView.getCanvas().getLocationOnScreen();
            return new Point(point2.x - point3.x + point.x, point2.y - point3.y + point.y);
        }
    }

    static class MListener
    implements MouseListener,
    MouseMotionListener {
        private JComponent myComp;
        private JGoView myView;

        public MListener(JComponent jComponent, JGoView jGoView) {
            this.myComp = jComponent;
            this.myView = jGoView;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.myView.requestFocus();
            this.myView.getCanvas().mousePressed(this.makeMouseEvent(mouseEvent));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.myView.getCanvas().mouseReleased(this.makeMouseEvent(mouseEvent));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.myView.getCanvas().mouseMoved(this.makeMouseEvent(mouseEvent));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.myView.getCanvas().mouseDragged(this.makeMouseEvent(mouseEvent));
        }

        public MouseEvent makeMouseEvent(MouseEvent mouseEvent) {
            Point point = this.adjustPoint(mouseEvent.getPoint());
            return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        }

        public Point adjustPoint(Point point) {
            Point point2 = this.myComp.getLocationOnScreen();
            Point point3 = this.myView.getCanvas().getLocationOnScreen();
            return new Point(point2.x - point3.x + point.x, point2.y - point3.y + point.y);
        }
    }

    public static class JGoJTree
    extends JTree
    implements Autoscroll {
        private JScrollPane myScrollPane = null;
        private JGoTree myJGoTree = null;
        private TreeModelListener myOrigTML = null;

        public JGoJTree() {
        }

        public JGoJTree(TreeModel treeModel) {
            super(treeModel);
        }

        void setJGoTree(JGoTree jGoTree) {
            this.myJGoTree = jGoTree;
            if (this.treeModelListener != null && this.treeModelListener instanceof TMListener) {
                ((TMListener)this.treeModelListener).setJGoTree(jGoTree);
            }
        }

        protected TreeModelListener createTreeModelListener() {
            TreeModelListener treeModelListener = super.createTreeModelListener();
            return new TMListener(this.myJGoTree, treeModelListener);
        }

        void setScrollPane(JScrollPane jScrollPane) {
            this.myScrollPane = jScrollPane;
        }

        public Insets getAutoscrollInsets() {
            if (this.myScrollPane == null) {
                return new Insets(0, 0, 0, 0);
            }
            int n = this.myJGoTree.getAutoscrollMargin();
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.myScrollPane.getViewport().getSize();
            Point point = this.myScrollPane.getViewport().getViewPosition();
            return new Insets(point.y + n, point.x + n, dimension.height - (point.y + dimension2.height) + n, dimension.width - (point.x + dimension2.width) + n);
        }

        public void autoscroll(Point point) {
            int n;
            int n2;
            if (this.myScrollPane == null) {
                return;
            }
            int n3 = this.myJGoTree.getAutoscrollMargin();
            Dimension dimension = this.getSize();
            Rectangle rectangle = this.myScrollPane.getViewport().getViewRect();
            int n4 = n2 = rectangle.y;
            if (point.y < rectangle.y + n3 / 4) {
                n4 = n2 - this.getScrollableBlockIncrement(rectangle, 1, -1);
                n4 = Math.max(n4, 0);
            } else if (point.y > rectangle.y + rectangle.height - n3 / 4) {
                n4 = n2 + this.getScrollableBlockIncrement(rectangle, 1, 1);
                n4 = Math.min(n4, dimension.height - rectangle.height);
            } else if (point.y < rectangle.y + n3) {
                n4 = n2 - this.getScrollableUnitIncrement(rectangle, 1, -1);
                n4 = Math.max(n4, 0);
            } else if (point.y > rectangle.y + rectangle.height - n3) {
                n4 = n2 + this.getScrollableUnitIncrement(rectangle, 1, 1);
                n4 = Math.min(n4, dimension.height - rectangle.height);
            }
            int n5 = n = rectangle.x;
            if (point.x < rectangle.x + n3 / 4) {
                n5 = n - this.getScrollableBlockIncrement(rectangle, 0, -1);
                n5 = Math.max(n5, 0);
            } else if (point.x > rectangle.x + rectangle.width - n3 / 4) {
                n5 = n + this.getScrollableBlockIncrement(rectangle, 0, 1);
                n5 = Math.min(n5, dimension.width - rectangle.width);
            } else if (point.x < rectangle.x + n3) {
                n5 = n - this.getScrollableUnitIncrement(rectangle, 0, -1);
                n5 = Math.max(n5, 0);
            } else if (point.x > rectangle.x + rectangle.width - n3) {
                n5 = n + this.getScrollableUnitIncrement(rectangle, 0, 1);
                n5 = Math.min(n5, dimension.width - rectangle.width);
            }
            if (n4 - n2 != 0 || n5 - n != 0) {
                Point point2 = new Point(rectangle.x + (n5 - n), rectangle.y + (n4 - n2));
                this.myScrollPane.getViewport().setViewPosition(point2);
            }
        }

        static class TMListener
        implements TreeModelListener {
            private JGoTree myJGoTree = null;
            private TreeModelListener myOrigTML = null;

            public TMListener(JGoTree jGoTree, TreeModelListener treeModelListener) {
                this.myJGoTree = jGoTree;
                this.myOrigTML = treeModelListener;
            }

            void setJGoTree(JGoTree jGoTree) {
                this.myJGoTree = jGoTree;
            }

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                this.myOrigTML.treeNodesChanged(treeModelEvent);
                this.myJGoTree.treeNodesChanged(treeModelEvent);
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                this.myOrigTML.treeNodesInserted(treeModelEvent);
                this.myJGoTree.treeNodesInserted(treeModelEvent);
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                this.myOrigTML.treeNodesRemoved(treeModelEvent);
                this.myJGoTree.treeNodesRemoved(treeModelEvent);
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                this.myOrigTML.treeStructureChanged(treeModelEvent);
                this.myJGoTree.treeStructureChanged(treeModelEvent);
            }
        }
    }
}

