/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.jtreeapp;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoDocumentListener;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoUndoManager;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import com.nwoods.jgo.examples.jtreeapp.GoTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class JTreeApp
extends JApplet
implements Runnable,
JGoViewListener,
JGoDocumentListener {
    private JGoView myView = new JGoView();
    private int myNodeCounter = 0;
    private int TNcounter = 23;

    public JTreeApp() {
        this.getContentPane().add((Component)this.myView, "Center");
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        this.myView.initializeDragDropHandling();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame jFrame = new JFrame();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setTitle("JTree App");
            jFrame.setSize(700, 400);
            JTreeApp jTreeApp = new JTreeApp();
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jTreeApp, "Center");
            container.validate();
            jFrame.setVisible(true);
            jTreeApp.init();
            jTreeApp.start();
            JOptionPane.showMessageDialog(jTreeApp, "Type Ctrl-T to add children to the currently selected JTree treenode;\nType Ctrl-Shift-T to remove the currently selected JTree treenode.\n\nEach GoTreeNode supports a different combination of allowing source and/or destination links.\n\nOnly the rightmost GoTreeNode supports cross-level links.\n\nCAVEAT: copying GoTreeNodes is not supported until you implement a policy for copying TreeModels,\n    and undo/redo of JTree changes is not supported until you implement undo/redo support for TreeModels.\n", "Demo of GoTreeNodes displaying JTrees", 1);
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public void init() {
        this.myView.setPrimarySelectionColor(JGoBrush.ColorMagenta);
        this.myView.setIncludingNegativeCoords(true);
        this.myView.setHidingDisabledScrollbars(true);
        this.myView.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JTreeApp.this.handleKeyPressed(keyEvent);
            }
        });
        this.myView.addViewListener(this);
        JGoDocument jGoDocument = this.myView.getDocument();
        jGoDocument.addDocumentListener(this);
        GoTreeNode goTreeNode = new GoTreeNode();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("first"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("second"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("third"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("fourth"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("fifth"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("sixth"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("seventh"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("eighth"));
        goTreeNode.initialize(defaultTreeModel, true, false, this.myView);
        goTreeNode.setBoundingRect(new Point(50, 100), new Dimension(100, 150));
        jGoDocument.addObjectAtTail(goTreeNode);
        goTreeNode = new GoTreeNode();
        goTreeNode.initialize(null, true, true, this.myView);
        goTreeNode.setBoundingRect(new Point(250, 100), new Dimension(100, 150));
        jGoDocument.addObjectAtTail(goTreeNode);
        goTreeNode = new GoTreeNode();
        goTreeNode.initialize(null, false, true, this.myView);
        goTreeNode.setBoundingRect(new Point(450, 100), new Dimension(100, 150));
        jGoDocument.addObjectAtTail(goTreeNode);
        goTreeNode.setAllowingCrossLevelLinks(true);
        jGoDocument.setUndoManager(new JGoUndoManager());
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            this.myView.deleteSelection();
        } else if (n == 36) {
            Rectangle rectangle = this.myView.getDocument().computeBounds();
            this.myView.setViewPosition(rectangle.x, rectangle.y);
        } else if (n == 35) {
            Rectangle rectangle = this.myView.getDocument().computeBounds();
            Dimension dimension = this.myView.getExtentSize();
            this.myView.setViewPosition(Math.max(rectangle.x, rectangle.x + rectangle.width - dimension.width), Math.max(rectangle.y, rectangle.y + rectangle.height - dimension.height));
        } else if (keyEvent.isControlDown() && n == 65) {
            this.myView.selectAll();
        } else if (keyEvent.isControlDown() && n == 88) {
            this.myView.cut();
        } else if (keyEvent.isControlDown() && n == 67) {
            this.myView.copy();
        } else if (keyEvent.isControlDown() && n == 86) {
            this.myView.paste();
        } else if (keyEvent.isControlDown() && n == 90) {
            this.myView.getDocument().undo();
        } else if (keyEvent.isControlDown() && n == 89) {
            this.myView.getDocument().redo();
        } else if (keyEvent.isControlDown() && n == 84) {
            this.modifyTree(keyEvent.getModifiers());
        }
    }

    public void viewChanged(JGoViewEvent jGoViewEvent) {
        if (jGoViewEvent.getHint() == 2 && jGoViewEvent.getJGoObject() instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)jGoViewEvent.getJGoObject();
            jGoLink.setPen(JGoPen.make(65535, 2, JGoBrush.ColorGray));
            jGoLink.setBrush(JGoBrush.gray);
            jGoLink.setArrowHeads(false, true);
        }
    }

    public void documentChanged(JGoDocumentEvent jGoDocumentEvent) {
        if (jGoDocumentEvent.getHint() == 202 && jGoDocumentEvent.getJGoObject() instanceof JGoLink) {
            JGoLink jGoLink = (JGoLink)jGoDocumentEvent.getJGoObject();
            jGoLink.setPen(JGoPen.make(65535, 2, jGoLink.getBrush().getColor()));
            jGoLink.setArrowHeads(false, true);
        }
    }

    void modifyTree(int n) {
        JGoObject jGoObject = this.myView.getSelection().getPrimarySelection();
        if (jGoObject == null) {
            return;
        }
        if (!(jGoObject instanceof GoTreeNode)) {
            return;
        }
        GoTreeNode goTreeNode = (GoTreeNode)jGoObject;
        JTree jTree = goTreeNode.getTree().getJTree(this.myView);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        Object object = jTree.getLastSelectedPathComponent();
        if (object != null && object instanceof MutableTreeNode) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)object;
            if ((n & 1) != 0 && object != defaultTreeModel.getRoot()) {
                int[] nArray = new int[1];
                Object[] objectArray = new Object[1];
                TreeNode treeNode = mutableTreeNode.getParent();
                nArray[0] = treeNode.getIndex(mutableTreeNode);
                objectArray[0] = mutableTreeNode;
                mutableTreeNode.removeFromParent();
                defaultTreeModel.nodesWereRemoved(treeNode, nArray, objectArray);
            } else {
                int n2 = mutableTreeNode.getChildCount();
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Integer.toString(this.TNcounter++));
                mutableTreeNode.insert(defaultMutableTreeNode, n2);
                int[] nArray = new int[]{n2};
                defaultTreeModel.nodesWereInserted(mutableTreeNode, nArray);
            }
        }
    }
}

