/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class Diamond
extends JGoDrawable {
    private transient GeneralPath myPath = null;

    public Diamond() {
    }

    public Diamond(Rectangle rectangle) {
        super(rectangle);
    }

    public Diamond(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        this.resetPath();
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        GeneralPath generalPath = this.getPath(jGoView);
        Diamond.drawPath(graphics2D, this.getPen(), this.getBrush(), generalPath);
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        JGoPen jGoPen = this.getPen();
        if (jGoPen != null) {
            int n = 5 * jGoPen.getWidth();
            rectangle.x -= n;
            rectangle.y -= n;
            rectangle.width += n * 2;
            rectangle.height += n * 2;
        }
    }

    public boolean isPointInObj(Point point) {
        if (!super.isPointInObj(point)) {
            return false;
        }
        GeneralPath generalPath = this.getPath(null);
        return generalPath.contains(point.x, point.y);
    }

    public boolean getNearestIntersectionPoint(int n, int n2, int n3, int n4, Point point) {
        double d;
        Rectangle rectangle = this.getBoundingRect();
        int n5 = this.getPen().getWidth();
        int n6 = rectangle.x + rectangle.width / 2;
        int n7 = rectangle.y - n5;
        int n8 = rectangle.x + rectangle.width + n5;
        int n9 = rectangle.y + rectangle.height / 2;
        int n10 = n6;
        int n11 = rectangle.y + rectangle.height + n5;
        int n12 = rectangle.x - n5;
        int n13 = n9;
        Point point2 = new Point(0, 0);
        double d2 = 1.0E21;
        if (JGoStroke.getNearestIntersectionOnLine(n6, n7, n8, n9, n, n2, n3, n4, point2) && (d = (double)((point2.x - n) * (point2.x - n) + (point2.y - n2) * (point2.y - n2))) < d2) {
            d2 = d;
            point.x = point2.x;
            point.y = point2.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(n8, n9, n10, n11, n, n2, n3, n4, point2) && (d = (double)((point2.x - n) * (point2.x - n) + (point2.y - n2) * (point2.y - n2))) < d2) {
            d2 = d;
            point.x = point2.x;
            point.y = point2.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(n10, n11, n12, n13, n, n2, n3, n4, point2) && (d = (double)((point2.x - n) * (point2.x - n) + (point2.y - n2) * (point2.y - n2))) < d2) {
            d2 = d;
            point.x = point2.x;
            point.y = point2.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(n12, n13, n6, n7, n, n2, n3, n4, point2) && (d = (double)((point2.x - n) * (point2.x - n) + (point2.y - n2) * (point2.y - n2))) < d2) {
            d2 = d;
            point.x = point2.x;
            point.y = point2.y;
        }
        return d2 < 1.0E21;
    }

    void makePath(GeneralPath generalPath, JGoView jGoView) {
        Rectangle rectangle = this.getBoundingRect();
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height / 2;
        int n5 = n;
        int n6 = rectangle.y + rectangle.height;
        int n7 = rectangle.x;
        int n8 = n4;
        generalPath.moveTo(n, n2);
        generalPath.lineTo(n3, n4);
        generalPath.lineTo(n5, n6);
        generalPath.lineTo(n7, n8);
        generalPath.lineTo(n, n2);
        generalPath.closePath();
    }

    GeneralPath getPath(JGoView jGoView) {
        if (this.myPath == null) {
            this.myPath = new GeneralPath(1, 8);
        }
        if (this.myPath.getCurrentPoint() == null) {
            this.makePath(this.myPath, jGoView);
        }
        return this.myPath;
    }

    void resetPath() {
        if (this.myPath != null) {
            this.myPath.reset();
        }
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        super.changeValue(jGoDocumentChangedEdit, bl);
        if (jGoDocumentChangedEdit.getFlags() == 1) {
            this.resetPath();
        }
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        Object object;
        if (domDoc.JGoXMLOutputEnabled()) {
            object = domDoc.createJGoClassElement("com.nwoods.jgo.examples.Diamond", domElement);
        }
        if (domDoc.SVGOutputEnabled()) {
            object = this.getBoundingRect();
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            nArray[0] = ((Rectangle)object).x + ((Rectangle)object).width / 2;
            nArray2[0] = ((Rectangle)object).y;
            nArray[1] = ((Rectangle)object).x + ((Rectangle)object).width;
            nArray2[1] = ((Rectangle)object).y + ((Rectangle)object).height / 2;
            nArray[2] = nArray[0];
            nArray2[2] = ((Rectangle)object).y + ((Rectangle)object).height;
            nArray[3] = ((Rectangle)object).x;
            nArray2[3] = nArray2[1];
            DomElement domElement2 = domDoc.createElement("path");
            String string = "M " + Integer.toString(nArray[0]) + " " + Integer.toString(nArray2[0]);
            string = string + " L " + Integer.toString(nArray[1]) + " " + Integer.toString(nArray2[1]);
            string = string + " L " + Integer.toString(nArray[2]) + " " + Integer.toString(nArray2[2]);
            string = string + " L " + Integer.toString(nArray[3]) + " " + Integer.toString(nArray2[3]);
            string = string + " Z";
            domElement2.setAttribute("d", string);
            this.SVGWriteAttributes(domElement2);
            domElement.appendChild(domElement2);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

