/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.examples.SimpleNode;
import java.awt.Rectangle;

public class SimpleNodePort
extends JGoPort {
    private static Rectangle myTriangleRect = new Rectangle(0, 0, 8, 8);

    public SimpleNodePort() {
    }

    public SimpleNodePort(boolean bl, JGoArea jGoArea) {
        super(SimpleNodePort.TriangleRect());
        this.initialize(bl, jGoArea);
    }

    public void initialize(boolean bl, JGoArea jGoArea) {
        this.setSelectable(false);
        this.setDraggable(false);
        this.setResizable(false);
        this.setVisible(true);
        this.setStyle(3);
        this.setPen(JGoPen.darkGray);
        this.setBrush(JGoBrush.lightGray);
        if (bl) {
            this.setValidSource(false);
            this.setValidDestination(true);
            this.setToSpot(8);
        } else {
            this.setValidSource(true);
            this.setValidDestination(false);
            this.setFromSpot(4);
        }
        this.setTopLeft(jGoArea.getLeft(), jGoArea.getTop());
        jGoArea.addObjectAtTail(this);
    }

    public final boolean isInput() {
        return this.isValidDestination();
    }

    public final boolean isOutput() {
        return this.isValidSource();
    }

    public boolean validLink(JGoPort jGoPort) {
        return super.validLink(jGoPort) && this.isOutput() && jGoPort instanceof SimpleNodePort && ((SimpleNodePort)jGoPort).isInput();
    }

    public SimpleNode getNode() {
        return (SimpleNode)this.getParent();
    }

    public static Rectangle TriangleRect() {
        return myTriangleRect;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.SimpleNodePort", domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingElement());
        }
        return domElement.getNextSibling();
    }
}

