/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.flower;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.examples.SimpleNode;
import com.nwoods.jgo.examples.SimpleNodePort;
import com.nwoods.jgo.examples.flower.FlowLink;
import com.nwoods.jgo.examples.flower.ProcessDocument;
import com.nwoods.jgo.examples.flower.ProcessView;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;

public class ActivityNode
extends SimpleNode {
    public static final int Start = 1;
    public static final int Finish = 2;
    public static final int Activity = 3;
    private static Dimension myStdSize = new Dimension(50, 50);
    private static Point myStdPoint = new Point();
    private int myID = -1;
    private int myTaskDuration = 0;
    private int myActivityType = 0;
    static /* synthetic */ Class class$com$nwoods$jgo$examples$flower$ActivityNode;

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        ActivityNode activityNode = (ActivityNode)super.copyObject(jGoCopyEnvironment);
        if (activityNode != null) {
            activityNode.myActivityType = this.myActivityType;
            activityNode.myTaskDuration = this.myTaskDuration;
        }
        return activityNode;
    }

    public void initialize(int n, int n2) {
        super.initialize(myStdPoint, ActivityNode.getStdSize(), ActivityNode.getImage(n), ActivityNode.getLabelString(n), false, false);
        this.myID = n2;
        this.myActivityType = n;
        this.resetEditability();
        if (n != 1) {
            this.myTaskDuration = 0;
            this.myInputPort = new SimpleNodePort(true, this);
        }
        if (n != 2) {
            this.myTaskDuration = 0;
            this.myOutputPort = new SimpleNodePort(false, this);
        }
        if (n == 3) {
            this.myTaskDuration = 5;
        }
        this.setSize(ActivityNode.getStdSize());
        this.layoutChildren(null);
    }

    public ProcessDocument getDoc() {
        return (ProcessDocument)this.getDocument();
    }

    protected void ownerChange(JGoObjectCollection jGoObjectCollection, JGoObjectCollection jGoObjectCollection2, JGoObject jGoObject) {
        if (jGoObjectCollection == null && jGoObjectCollection2 != null && jGoObjectCollection2 instanceof ProcessDocument && this.getID() == -1) {
            ProcessDocument processDocument = (ProcessDocument)jGoObjectCollection2;
            this.myID = processDocument.getNextNodeID();
        }
    }

    public void resetEditability() {
        if (this.getLabel() != null) {
            this.getLabel().setEditable(this.getActivityType() != 1 && this.getActivityType() != 2);
        }
    }

    public String getToolTipText() {
        String string = Integer.toString(this.getTaskDuration());
        return string;
    }

    public boolean doMouseDblClick(int n, Point point, Point point2, JGoView jGoView) {
        ProcessView processView = (ProcessView)jGoView;
        processView.editActivity(this);
        return true;
    }

    public int getID() {
        return this.myID;
    }

    public int getActivityType() {
        return this.myActivityType;
    }

    public String getText() {
        if (this.getLabel() != null) {
            return this.getLabel().getText();
        }
        return "";
    }

    public void setText(String string) {
        if (this.getLabel() != null) {
            this.getLabel().setText(string);
        }
    }

    public int getTaskDuration() {
        return this.myTaskDuration;
    }

    public void setTaskDuration(int n) {
        this.myTaskDuration = n;
        this.updateDownstreamLinks();
    }

    protected void updateDownstreamLinks() {
        Object object;
        Serializable serializable;
        int n = 0;
        JGoPort jGoPort = this.getInputPort();
        if (jGoPort != null) {
            serializable = jGoPort.getFirstLinkPos();
            while (serializable != null) {
                object = (FlowLink)jGoPort.getLinkAtPos((JGoListPosition)serializable);
                int n2 = Integer.parseInt(((FlowLink)object).getText());
                if (n2 > n) {
                    n = n2;
                }
                serializable = jGoPort.getNextLinkPos((JGoListPosition)serializable);
            }
        }
        serializable = new Integer(n + this.getTaskDuration());
        object = ((Integer)serializable).toString();
        JGoPort jGoPort2 = this.getOutputPort();
        if (jGoPort2 != null) {
            FlowLink flowLink;
            JGoListPosition jGoListPosition = jGoPort2.getFirstLinkPos();
            while (jGoListPosition != null) {
                flowLink = (FlowLink)jGoPort2.getLinkAtPos(jGoListPosition);
                flowLink.setText((String)object);
                jGoListPosition = jGoPort2.getNextLinkPos(jGoListPosition);
            }
            jGoListPosition = jGoPort2.getFirstLinkPos();
            while (jGoListPosition != null) {
                flowLink = (FlowLink)jGoPort2.getLinkAtPos(jGoListPosition);
                ActivityNode activityNode = flowLink.getToNode();
                activityNode.updateDownstreamLinks();
                jGoListPosition = jGoPort2.getNextLinkPos(jGoListPosition);
            }
        }
    }

    public boolean downstreamNodeContainsFlag(int n) {
        if ((this.getFlags() & n) != 0) {
            return true;
        }
        JGoPort jGoPort = this.getOutputPort();
        if (jGoPort == null) {
            return false;
        }
        JGoListPosition jGoListPosition = jGoPort.getFirstLinkPos();
        while (jGoListPosition != null) {
            FlowLink flowLink = (FlowLink)jGoPort.getLinkAtPos(jGoListPosition);
            ActivityNode activityNode = flowLink.getToNode();
            if (activityNode.downstreamNodeContainsFlag(n)) {
                return true;
            }
            jGoListPosition = jGoPort.getNextLinkPos(jGoListPosition);
        }
        return false;
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.flower.ActivityNode", domElement);
            domElement2.setAttribute("actid", Integer.toString(this.myID));
            domElement2.setAttribute("acttype", Integer.toString(this.myActivityType));
            domElement2.setAttribute("actduration", Integer.toString(this.myTaskDuration));
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.myID = Integer.parseInt(domElement2.getAttribute("actid"));
            this.myActivityType = Integer.parseInt(domElement2.getAttribute("acttype"));
            this.myTaskDuration = Integer.parseInt(domElement2.getAttribute("actduration"));
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public static JGoImage getImage(int n) {
        JGoImage jGoImage = null;
        switch (n) {
            default: {
                jGoImage = new JGoImage(myStdPoint, ActivityNode.getStdSize());
                jGoImage.loadImage((class$com$nwoods$jgo$examples$flower$ActivityNode == null ? (class$com$nwoods$jgo$examples$flower$ActivityNode = ActivityNode.class$("com.nwoods.jgo.examples.flower.ActivityNode")) : class$com$nwoods$jgo$examples$flower$ActivityNode).getResource("images/doc.gif"), true);
                break;
            }
            case 1: {
                jGoImage = new JGoImage(myStdPoint, ActivityNode.getStdSize());
                jGoImage.loadImage((class$com$nwoods$jgo$examples$flower$ActivityNode == null ? (class$com$nwoods$jgo$examples$flower$ActivityNode = ActivityNode.class$("com.nwoods.jgo.examples.flower.ActivityNode")) : class$com$nwoods$jgo$examples$flower$ActivityNode).getResource("images/star.gif"), true);
                break;
            }
            case 2: {
                jGoImage = new JGoImage(myStdPoint, ActivityNode.getStdSize());
                jGoImage.loadImage((class$com$nwoods$jgo$examples$flower$ActivityNode == null ? (class$com$nwoods$jgo$examples$flower$ActivityNode = ActivityNode.class$("com.nwoods.jgo.examples.flower.ActivityNode")) : class$com$nwoods$jgo$examples$flower$ActivityNode).getResource("images/star.gif"), true);
            }
        }
        return jGoImage;
    }

    public static String getLabelString(int n) {
        switch (n) {
            default: {
                return "Activity";
            }
            case 1: {
                return "Start";
            }
            case 2: 
        }
        return "Finish";
    }

    public static Dimension getStdSize() {
        return myStdSize;
    }

    public static void setStdSize(int n, int n2) {
        ActivityNode.myStdSize.width = n;
        ActivityNode.myStdSize.height = n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

