/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.flower;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoOverview;
import com.nwoods.jgo.JGoPalette;
import com.nwoods.jgo.examples.flower.ActivityNode;
import com.nwoods.jgo.examples.flower.AppAction;
import com.nwoods.jgo.examples.flower.HelpDlg;
import com.nwoods.jgo.examples.flower.ProcessDialog;
import com.nwoods.jgo.examples.flower.ProcessDocument;
import com.nwoods.jgo.examples.flower.ProcessView;
import com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayout;
import com.nwoods.jgo.layout.JGoRandomAutoLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class Flower
extends JApplet
implements Runnable {
    private static boolean imagesErrorDisplayed = false;
    AppAction FileNewAction = null;
    AppAction FileOpenAction;
    AppAction FileCloseAction;
    AppAction FileSaveAction;
    AppAction FileSaveAsAction;
    AppAction FilePropertiesAction;
    AppAction PrintPreviewAction;
    AppAction PrintAction;
    AppAction CutAction;
    AppAction CopyAction;
    AppAction PasteAction;
    AppAction DeleteAction;
    AppAction SelectAllAction;
    JMenuItem UndoMenuItem;
    AppAction UndoAction;
    JMenuItem RedoMenuItem;
    AppAction RedoAction;
    AppAction ObjectPropertiesAction;
    AppAction ZoomNormalAction;
    AppAction ZoomInAction;
    AppAction ZoomOutAction;
    AppAction ZoomToFitAction;
    AppAction OverviewAction;
    AppAction GridAction;
    AppAction OrthoAction;
    AppAction InsertInputAction;
    AppAction InsertOutputAction;
    AppAction InsertActivityAction;
    AppAction RandomLayoutAction;
    AppAction LayerLayoutAction;
    AppAction AboutAction;
    AppAction PropertiesAction;
    static JFrame mainFrame;
    protected HashMap myMap;
    protected ProcessView myCurrentView;
    protected JDesktopPane myDesktop;
    protected JGoPalette myPalette;
    protected JMenuBar mainMenuBar;
    protected JToolBar toolBar;
    protected JMenu filemenu;
    protected JMenu editmenu;
    protected JMenu viewmenu;
    protected JMenu insertmenu;
    protected JMenu layoutmenu;
    protected JMenu helpmenu;
    protected JDialog myOverviewDialog;
    protected JGoOverview myOverview;
    private int myDocCount;
    static /* synthetic */ Class class$com$nwoods$jgo$examples$flower$Flower;

    public Flower() {
        Object object = Flower.iconImage("images/new.gif");
        this.FileNewAction = new AppAction("New", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.newProcess();
            }

            public boolean canAct() {
                return true;
            }
        };
        this.FileOpenAction = null;
        object = Flower.iconImage("images/open.gif");
        this.FileOpenAction = new AppAction("Open", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.openProcess();
            }

            public boolean canAct() {
                return true;
            }
        };
        this.FileCloseAction = new AppAction("Close", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.closeProcess();
            }
        };
        this.FileSaveAction = null;
        object = Flower.iconImage("images/save.gif");
        this.FileSaveAction = new AppAction("Save", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.saveProcess();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isLocationModifiable();
            }
        };
        this.FileSaveAsAction = new AppAction("Save As", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.saveAsProcess();
            }
        };
        this.FilePropertiesAction = new AppAction("Process Properties", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.editProcessProperties();
            }
        };
        this.PrintPreviewAction = null;
        this.PrintPreviewAction = new AppAction("Print Preview", null, this){

            public void actionPerformed(ActionEvent actionEvent) {
                PageFormat pageFormat;
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PageFormat pageFormat2 = printerJob.pageDialog(pageFormat = printerJob.validatePage(printerJob.defaultPage()));
                if (pageFormat2 != pageFormat) {
                    this.getView().printPreview("Print Preview", pageFormat2);
                }
            }
        };
        this.PrintAction = null;
        object = Flower.iconImage("images/print.gif");
        this.PrintAction = new AppAction("Print", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().print();
            }
        };
        this.CutAction = null;
        object = Flower.iconImage("images/remove.gif");
        this.CutAction = new AppAction("Cut", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().cut();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty() && this.getView().getDoc().isModifiable();
            }
        };
        this.CopyAction = null;
        object = Flower.iconImage("images/copy.gif");
        this.CopyAction = new AppAction("Copy", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().copy();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty();
            }
        };
        this.PasteAction = null;
        object = Flower.iconImage("images/paste.gif");
        this.PasteAction = new AppAction("Paste", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().paste();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModifiable();
            }
        };
        this.DeleteAction = new AppAction("Delete", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().deleteSelection();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty() && this.getView().getDoc().isModifiable();
            }
        };
        this.SelectAllAction = new AppAction("Select All", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().selectAll();
            }
        };
        this.UndoMenuItem = null;
        this.UndoAction = new AppAction("Undo", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().getDocument().undo();
                AppAction.updateAllActions();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDocument().canUndo();
            }

            public void updateEnabled() {
                super.updateEnabled();
                if (Flower.this.UndoMenuItem != null && this.getView() != null) {
                    Flower.this.UndoMenuItem.setText(this.getView().getDocument().getUndoManager().getUndoPresentationName());
                }
            }
        };
        this.RedoMenuItem = null;
        this.RedoAction = new AppAction("Redo", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().getDocument().redo();
                AppAction.updateAllActions();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDocument().canRedo();
            }

            public void updateEnabled() {
                super.updateEnabled();
                if (Flower.this.RedoMenuItem != null && this.getView() != null) {
                    Flower.this.RedoMenuItem.setText(this.getView().getDocument().getUndoManager().getRedoPresentationName());
                }
            }
        };
        this.ObjectPropertiesAction = new AppAction("Object Properties", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().editObjectProperties();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty();
            }
        };
        this.ZoomNormalAction = new AppAction("Normal Zoom", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().zoomNormal();
            }
        };
        this.ZoomInAction = new AppAction("Zoom In", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().zoomIn();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getScale() < 8.0;
            }
        };
        this.ZoomOutAction = new AppAction("Zoom Out", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().zoomOut();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getScale() > (double)0.13f;
            }
        };
        this.ZoomToFitAction = new AppAction("Zoom To Fit", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().zoomToFit();
            }
        };
        this.OverviewAction = new AppAction("Overview", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.overviewAction();
            }
        };
        this.GridAction = new AppAction("Toggle Grid", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().showGrid();
            }
        };
        this.OrthoAction = new AppAction("Toggle Orthogonal Flows", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().getDoc().toggleOrthogonalFlows();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModifiable();
            }
        };
        this.InsertInputAction = new AppAction("Start", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().insertInput();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModifiable();
            }
        };
        this.InsertOutputAction = new AppAction("Finish", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().insertOutput();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModifiable();
            }
        };
        this.InsertActivityAction = new AppAction("Activity", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().insertActivity();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModifiable();
            }
        };
        this.RandomLayoutAction = new AppAction("Random Layout", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.randomAction();
            }
        };
        this.LayerLayoutAction = null;
        object = Flower.iconImage("images/layout.gif");
        this.LayerLayoutAction = new AppAction("Layered Digraph Layout", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.layerAction();
            }
        };
        this.AboutAction = null;
        object = Flower.iconImage("images/tb_07_u.gif");
        this.AboutAction = new AppAction("About", (Icon)object, this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.showAbout();
            }

            public boolean canAct() {
                return true;
            }
        };
        this.PropertiesAction = new AppAction("Properties", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().editObjectProperties();
            }
        };
        this.myMap = new HashMap();
        this.myDocCount = 1;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            this.mainMenuBar = new JMenuBar();
            this.toolBar = new JToolBar();
            this.filemenu = new JMenu();
            this.editmenu = new JMenu();
            this.viewmenu = new JMenu();
            this.insertmenu = new JMenu();
            this.layoutmenu = new JMenu();
            this.helpmenu = new JMenu();
            this.initMenus();
            this.initToolbar();
            this.myDesktop = new JDesktopPane();
            this.myPalette = new JGoPalette();
            this.myPalette.setPreferredSize(new Dimension(100, 300));
            this.myPalette.setMinimumSize(new Dimension(100, 100));
            object = new JSplitPane(1);
            ((JSplitPane)object).setContinuousLayout(true);
            ((JSplitPane)object).setLeftComponent(this.getPalette());
            ((JSplitPane)object).setRightComponent(this.getDesktop());
            ((JSplitPane)object).setDividerLocation(100);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this.toolBar, "North");
            container.add((Component)object, "Center");
            container.validate();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
        }
    }

    private static Icon iconImage(String string) {
        URL uRL = (class$com$nwoods$jgo$examples$flower$Flower == null ? (class$com$nwoods$jgo$examples$flower$Flower = Flower.class$("com.nwoods.jgo.examples.flower.Flower")) : class$com$nwoods$jgo$examples$flower$Flower).getResource(string);
        if (uRL == null) {
            if (!imagesErrorDisplayed) {
                JOptionPane.showMessageDialog(null, "Image files not found.\nThe Flower.images directory must be placed in the class path.", "alert", 0);
                imagesErrorDisplayed = true;
            }
        } else {
            return new ImageIcon(uRL);
        }
        return null;
    }

    void initMenus() {
        JMenuItem jMenuItem = null;
        this.filemenu.setText("File");
        this.filemenu.setMnemonic('F');
        jMenuItem = this.filemenu.add(this.FileNewAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.setMnemonic('N');
        jMenuItem.setIcon(null);
        jMenuItem = this.filemenu.add(this.FileOpenAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem.setMnemonic('O');
        jMenuItem.setIcon(null);
        jMenuItem = this.filemenu.add(this.FileCloseAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        jMenuItem.setMnemonic('C');
        jMenuItem = this.filemenu.add(this.FileSaveAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.setMnemonic('S');
        jMenuItem.setIcon(null);
        jMenuItem = this.filemenu.add(this.FileSaveAsAction);
        jMenuItem.setMnemonic('A');
        this.filemenu.addSeparator();
        this.filemenu.addSeparator();
        jMenuItem = this.filemenu.add(this.PrintPreviewAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItem.setMnemonic('R');
        jMenuItem.setIcon(null);
        jMenuItem = this.filemenu.add(this.PrintAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.setMnemonic('P');
        jMenuItem.setIcon(null);
        this.mainMenuBar.add(this.filemenu);
        this.editmenu.setText("Edit");
        this.editmenu.setMnemonic('E');
        jMenuItem = this.editmenu.add(this.CutAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem.setMnemonic('t');
        jMenuItem.setIcon(null);
        jMenuItem = this.editmenu.add(this.CopyAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.setMnemonic('C');
        jMenuItem.setIcon(null);
        jMenuItem = this.editmenu.add(this.PasteAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem.setMnemonic('P');
        jMenuItem.setIcon(null);
        jMenuItem = this.editmenu.add(this.DeleteAction);
        jMenuItem.setMnemonic('D');
        jMenuItem = this.editmenu.add(this.SelectAllAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItem.setMnemonic('l');
        this.editmenu.addSeparator();
        this.UndoMenuItem = this.editmenu.add(this.UndoAction);
        this.UndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.UndoMenuItem.setMnemonic('U');
        this.RedoMenuItem = this.editmenu.add(this.RedoAction);
        this.RedoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.RedoMenuItem.setMnemonic('R');
        this.editmenu.addSeparator();
        jMenuItem = this.editmenu.add(this.ObjectPropertiesAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 2));
        jMenuItem.setMnemonic('o');
        this.mainMenuBar.add(this.editmenu);
        this.viewmenu.setText("View");
        this.viewmenu.setMnemonic('V');
        jMenuItem = this.viewmenu.add(this.ZoomNormalAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 3));
        jMenuItem.setMnemonic('N');
        jMenuItem = this.viewmenu.add(this.ZoomInAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 2));
        jMenuItem.setMnemonic('I');
        jMenuItem = this.viewmenu.add(this.ZoomOutAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 1));
        jMenuItem.setMnemonic('O');
        jMenuItem = this.viewmenu.add(this.ZoomToFitAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        jMenuItem.setMnemonic('Z');
        this.viewmenu.addSeparator();
        this.viewmenu.add(this.OverviewAction).setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.viewmenu.addSeparator();
        jMenuItem = this.viewmenu.add(this.GridAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenuItem.setMnemonic('G');
        jMenuItem = this.viewmenu.add(this.OrthoAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItem.setMnemonic('O');
        this.mainMenuBar.add(this.viewmenu);
        this.insertmenu.setText("Insert");
        this.insertmenu.setMnemonic('I');
        jMenuItem = this.insertmenu.add(this.InsertInputAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = this.insertmenu.add(this.InsertOutputAction);
        jMenuItem.setMnemonic('F');
        jMenuItem = this.insertmenu.add(this.InsertActivityAction);
        jMenuItem.setMnemonic('A');
        this.mainMenuBar.add(this.insertmenu);
        this.layoutmenu.setText("Layout");
        this.layoutmenu.setMnemonic('L');
        jMenuItem = this.layoutmenu.add(this.RandomLayoutAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItem.setMnemonic('R');
        jMenuItem = this.layoutmenu.add(this.LayerLayoutAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jMenuItem.setMnemonic('L');
        jMenuItem.setIcon(null);
        this.mainMenuBar.add(this.layoutmenu);
        this.helpmenu.setText("Help");
        this.helpmenu.setMnemonic('H');
        jMenuItem = this.helpmenu.add(this.AboutAction);
        jMenuItem.setMnemonic('A');
        jMenuItem.setIcon(null);
        this.mainMenuBar.add(this.helpmenu);
        this.setJMenuBar(this.mainMenuBar);
        JPopupMenu jPopupMenu = ProcessView.getPopupMenu();
        jPopupMenu.add(this.PropertiesAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.CopyAction);
        jPopupMenu.add(this.CutAction);
    }

    protected JToolBar initToolbar() {
        JButton jButton = null;
        jButton = this.toolBar.add(this.FileNewAction);
        jButton.setToolTipText("Create a new work-flow window");
        jButton = this.toolBar.add(this.FileOpenAction);
        jButton.setToolTipText("Open a previously saved work-flow window");
        jButton = this.toolBar.add(this.FileSaveAction);
        jButton.setToolTipText("Save a work-flow window");
        this.toolBar.addSeparator();
        jButton = this.toolBar.add(this.CutAction);
        jButton.setToolTipText("Cut to clipboard");
        jButton = this.toolBar.add(this.CopyAction);
        jButton.setToolTipText("Copy to clipboard");
        jButton = this.toolBar.add(this.PasteAction);
        jButton.setToolTipText("Paste to clipboard");
        this.toolBar.addSeparator();
        jButton = this.toolBar.add(this.PrintAction);
        jButton.setToolTipText("Print selected work-flow window");
        this.toolBar.addSeparator();
        jButton = this.toolBar.add(this.LayerLayoutAction);
        jButton.setToolTipText("Automatically layout diagram");
        this.toolBar.addSeparator();
        jButton = this.toolBar.add(this.AboutAction);
        jButton.setToolTipText("Display help about this application");
        return this.toolBar;
    }

    public void addExitCommand() {
        this.filemenu.addSeparator();
        AppAction appAction = new AppAction("Exit", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                Flower.this.exit();
            }

            public boolean canAct() {
                return true;
            }
        };
        JMenuItem jMenuItem = this.filemenu.add(appAction);
        jMenuItem.setMnemonic('x');
    }

    public void init() {
        JGoImage.setDefaultBase(this.getCodeBase());
    }

    void initPalette() {
        this.getPalette().setBorder(new TitledBorder("Activities"));
        JGoDocument jGoDocument = this.getPalette().getDocument();
        ActivityNode activityNode = new ActivityNode();
        activityNode.initialize(1, -1);
        activityNode.getLabel().setEditable(false);
        jGoDocument.addObjectAtTail(activityNode);
        activityNode = new ActivityNode();
        activityNode.initialize(2, -1);
        activityNode.getLabel().setEditable(false);
        jGoDocument.addObjectAtTail(activityNode);
        activityNode = new ActivityNode();
        activityNode.initialize(3, -1);
        activityNode.getLabel().setEditable(false);
        jGoDocument.addObjectAtTail(activityNode);
    }

    public void start() {
        new Thread(this).start();
        this.initPalette();
    }

    public void run() {
        this.getPalette().initializeDragDropHandling();
        if (this.getDesktop().getAllFrames().length == 0) {
            this.newProcess();
        }
        AppAction.updateAllActions();
    }

    public void destroy() {
        JInternalFrame[] jInternalFrameArray = this.getDesktop().getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            JInternalFrame jInternalFrame = jInternalFrameArray[i];
            try {
                jInternalFrame.setClosed(true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            final Flower flower = new Flower();
            mainFrame = new JFrame();
            mainFrame.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    if (flower.getCurrentView() != null) {
                        flower.getCurrentView().getDoc().updateLocationModifiable();
                    }
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Object object = windowEvent.getSource();
                    if (object == mainFrame) {
                        flower.exit();
                    }
                }
            });
            flower.addExitCommand();
            mainFrame.setTitle("Workflow Editor");
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            mainFrame.setBounds(0, 0, dimension.width, dimension.height);
            Container container = mainFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)flower, "Center");
            container.validate();
            mainFrame.setVisible(true);
            flower.start();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    void exit() {
        this.destroy();
        System.exit(0);
    }

    void showAbout() {
        HelpDlg helpDlg = new HelpDlg(mainFrame, "About", true);
        helpDlg.setVisible(true);
    }

    void editProcessProperties() {
        ProcessView processView = this.getCurrentView();
        if (processView != null) {
            processView.getDoc().startTransaction();
            new ProcessDialog(processView.getFrame(), processView.getDoc()).setVisible(true);
            processView.getDoc().endTransaction("Process Properties");
        }
    }

    public void createFrame(ProcessDocument processDocument) {
        final ProcessView processView = new ProcessView(processDocument);
        final JInternalFrame jInternalFrame = new JInternalFrame(processDocument.getName(), true, true, true);
        jInternalFrame.setDefaultCloseOperation(2);
        processView.initialize(this, jInternalFrame);
        jInternalFrame.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                Flower.this.myCurrentView = processView;
                processView.requestFocus();
                if (Flower.this.myOverview != null) {
                    Flower.this.myOverview.setObserved(processView);
                }
                processView.getDoc().updateLocationModifiable();
                AppAction.updateAllActions();
            }

            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                Flower.this.myCurrentView = null;
                AppAction.updateAllActions();
            }

            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            }
        });
        jInternalFrame.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if (propertyChangeEvent.getPropertyName().equals("closed") && propertyChangeEvent.getOldValue() == Boolean.FALSE && propertyChangeEvent.getNewValue() == Boolean.TRUE && processView.getDoc().isModified()) {
                    String string = "Save changes to ";
                    string = processView.getDoc().getName().equals("") ? string + "modified document?" : string + processView.getDoc().getName();
                    string = string + "\n  (";
                    string = processView.getDoc().getLocation().equals("") ? string + "<no location>" : string + processView.getDoc().getLocation();
                    string = string + ")";
                    int n = JOptionPane.showConfirmDialog(processView.getFrame(), string, "Closing modified document", 1, 3);
                    if (n == 1 || n == 0) {
                        if (n == 0) {
                            if (processView.getDoc().isLocationModifiable()) {
                                processView.getDoc().save();
                            } else {
                                processView.getDoc().saveAs(".wfl");
                            }
                        }
                        Flower.this.getDesktop().remove(jInternalFrame);
                        Flower.this.getDesktop().repaint();
                    } else {
                        throw new PropertyVetoException("", propertyChangeEvent);
                    }
                }
            }
        });
        Container container = jInternalFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add(processView);
        jInternalFrame.setSize(500, 400);
        this.getDesktop().add(jInternalFrame);
        jInternalFrame.show();
        processView.initializeDragDropHandling();
    }

    void newProcess() {
        ProcessDocument processDocument = new ProcessDocument();
        String string = "Untitled" + Integer.toString(this.myDocCount++);
        processDocument.setName(string);
        this.createFrame(processDocument);
        processDocument.setModified(false);
        processDocument.discardAllEdits();
    }

    void openProcess() {
        ProcessDocument processDocument;
        String string = null;
        ProcessView processView = this.getCurrentView();
        if (processView != null) {
            processDocument = processView.getDoc();
            string = processDocument.getLocation();
        }
        if ((processDocument = ProcessDocument.open(this, string)) != null) {
            this.createFrame(processDocument);
        }
    }

    void closeProcess() {
        JInternalFrame jInternalFrame;
        if (this.getCurrentView() != null && (jInternalFrame = this.getCurrentView().getInternalFrame()) != null) {
            try {
                jInternalFrame.setClosed(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void saveProcess() {
        if (this.getCurrentView() != null) {
            ProcessDocument processDocument = this.getCurrentView().getDoc();
            processDocument.save();
        }
    }

    void saveAsProcess() {
        if (this.getCurrentView() != null) {
            ProcessDocument processDocument = this.getCurrentView().getDoc();
            processDocument.saveAs(".wfl");
        }
    }

    void overviewAction() {
        if (this.myOverview == null) {
            this.myOverview = new JGoOverview();
            this.myOverview.setObserved(this.getCurrentView());
            this.myOverviewDialog = new JDialog(mainFrame, "Overview", false);
            this.myOverviewDialog.getContentPane().setLayout(new BorderLayout());
            this.myOverviewDialog.getContentPane().add((Component)this.myOverview, "Center");
        }
        this.myOverviewDialog.pack();
        this.myOverviewDialog.setVisible(true);
    }

    void randomAction() {
        ProcessDocument processDocument = this.getCurrentView().getDoc();
        processDocument.startTransaction();
        Rectangle rectangle = this.getCurrentView().getViewRect();
        JGoRandomAutoLayout jGoRandomAutoLayout = new JGoRandomAutoLayout(processDocument, rectangle.x + 100, rectangle.width - rectangle.x - 100, rectangle.y + 100, rectangle.height - rectangle.y - 100);
        jGoRandomAutoLayout.performLayout();
        processDocument.endTransaction("Random Layout");
    }

    void layerAction() {
        ProcessDocument processDocument = this.getCurrentView().getDoc();
        processDocument.startTransaction();
        JGoLayeredDigraphAutoLayout jGoLayeredDigraphAutoLayout = new JGoLayeredDigraphAutoLayout(processDocument, 30, 30, 3, 1, 2, 1, 4, 1);
        jGoLayeredDigraphAutoLayout.performLayout();
        processDocument.endTransaction("LayeredDigraph Layout");
    }

    ProcessDocument findProcessDocument(String string) {
        Object v = this.myMap.get(string);
        if (v != null && v instanceof ProcessDocument) {
            return (ProcessDocument)v;
        }
        return null;
    }

    ProcessView getCurrentView() {
        return this.myCurrentView;
    }

    JDesktopPane getDesktop() {
        return this.myDesktop;
    }

    JGoPalette getPalette() {
        return this.myPalette;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

