/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.flower;

import com.nwoods.jgo.examples.flower.ProcessDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProcessDialog
extends JDialog {
    JPanel panel1 = new JPanel();
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JLabel label1 = new JLabel();
    JTextField nameField = new JTextField();
    JLabel label2 = new JLabel();
    JTextField locField = new JTextField();
    JCheckBox readonly = new JCheckBox();
    public ProcessDocument myObject;
    boolean fComponentsAdjusted = false;

    public ProcessDialog(Frame frame, ProcessDocument processDocument) {
        super(frame, "Process Properties", true);
        try {
            this.myObject = processDocument;
            this.init();
            this.pack();
            this.updateDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ProcessDialog() {
        super((Frame)null, "Process Properties", true);
    }

    private final void init() {
        this.panel1.setLayout(null);
        this.panel1.setMinimumSize(new Dimension(294, 241));
        this.panel1.setPreferredSize(new Dimension(294, 241));
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcessDialog.this.OnOK();
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcessDialog.this.OnCancel();
            }
        });
        this.getContentPane().add(this.panel1);
        this.OKButton.setText("OK");
        this.panel1.add(this.OKButton);
        this.OKButton.setFont(new Font("Dialog", 0, 12));
        this.OKButton.setBounds(new Rectangle(60, 204, 79, 22));
        this.OKButton.getRootPane().setDefaultButton(this.OKButton);
        this.CancelButton.setText("Cancel");
        this.panel1.add(this.CancelButton);
        this.CancelButton.setFont(new Font("Dialog", 0, 12));
        this.CancelButton.setBounds(new Rectangle(168, 204, 79, 22));
        this.label1.setText("Process Name:");
        this.label1.setHorizontalAlignment(2);
        this.panel1.add(this.label1);
        this.label1.setBounds(new Rectangle(50, 10, 148, 24));
        this.panel1.add(this.nameField);
        this.nameField.setBounds(new Rectangle(50, 40, 200, 24));
        this.nameField.setEnabled(this.myObject.isModifiable());
        this.label2.setText("Path:");
        this.label2.setHorizontalAlignment(2);
        this.panel1.add(this.label2);
        this.label2.setBounds(new Rectangle(50, 70, 148, 24));
        this.panel1.add(this.locField);
        this.locField.setBounds(new Rectangle(50, 100, 200, 24));
        this.locField.setEnabled(this.myObject.isModifiable());
        this.readonly.setText("Read Only");
        this.readonly.setBounds(new Rectangle(50, 150, 100, 14));
        this.panel1.add(this.readonly);
    }

    void updateDialog() {
        if (this.myObject == null) {
            return;
        }
        this.nameField.setText(this.myObject.getName());
        this.locField.setText(this.myObject.getLocation());
        this.readonly.setSelected(!this.myObject.isModifiable());
    }

    void updateData() {
        if (this.myObject == null) {
            return;
        }
        this.myObject.setName(this.nameField.getText());
        this.myObject.setLocation(this.locField.getText());
        this.myObject.setModifiable(!this.readonly.isSelected());
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    void OnOK() {
        try {
            this.updateData();
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void OnCancel() {
        try {
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

