/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.flower;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoUndoManager;
import com.nwoods.jgo.examples.SVGGoView;
import com.nwoods.jgo.examples.flower.ActivityNode;
import com.nwoods.jgo.examples.flower.AppAction;
import com.nwoods.jgo.examples.flower.Filter;
import com.nwoods.jgo.examples.flower.FlowLink;
import com.nwoods.jgo.svg.DefaultDocument;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProcessDocument
extends JGoDocument {
    private static final String processTag = "Process";
    private static final String activityTag = "Activity";
    private static final String flowTag = "Flow";
    public static final int NAME_CHANGED = 65536;
    public static final int LOCATION_CHANGED = 65537;
    private JGoPen myPen = JGoPen.make(65535, 2, Color.black);
    private boolean myOrthoLinks = false;
    private String myName = "";
    private String myLocation = "";
    private String myDescription = "";
    private int myLastNodeID = -1;
    private transient boolean myIsLocationModifiable = true;
    private transient boolean myIsModified = false;
    static final String sFlowerWFL = "Flower temporary serialization format, read/write (*.wfl)";
    static final String sJGoSVGXML = "JGo SVG with XML extensions, read/write (*.svg)";
    static final String sBatikSVG = "Batik SVG, export only (*.svg)";
    static final String sJGoSVG = "JGo SVG, export only (*.svg)";
    static final String sFlowerXML = "Flower Custom XML, read/write (*.xml)";
    static final String sJGoXML = "JGo XML, read/write (*.xml)";

    public ProcessDocument() {
        this.setUndoManager(new JGoUndoManager());
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        String string2 = this.myName;
        if (!string2.equals(string)) {
            this.myName = string;
            this.fireUpdate(65536, 0, null, 0, string2);
        }
    }

    public String getLocation() {
        return this.myLocation;
    }

    public void setLocation(String string) {
        String string2 = this.myLocation;
        if (!string2.equals(string)) {
            this.myLocation = string;
            this.fireUpdate(65537, 0, null, 0, string2);
            this.updateLocationModifiable();
        }
    }

    public boolean isLocationModifiable() {
        return this.myIsLocationModifiable;
    }

    public void updateLocationModifiable() {
        File file;
        boolean bl = true;
        if (!this.getLocation().equals("") && (file = new File(this.getLocation())).exists() && !file.canWrite()) {
            bl = false;
        }
        if (this.isLocationModifiable() != bl) {
            boolean bl2 = this.isModifiable();
            this.myIsLocationModifiable = bl;
            if (bl2 != this.isModifiable()) {
                this.fireUpdate(208, 0, null, bl2 ? 1 : 0, null);
            }
        }
    }

    public boolean isModifiable() {
        return super.isModifiable() && this.isLocationModifiable();
    }

    public void updatePaperColor() {
        if (this.isModifiable()) {
            this.setPaperColor(Color.white);
        } else {
            this.setPaperColor(new Color(221, 221, 221));
        }
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    public void setModified(boolean bl) {
        if (this.myIsModified != bl) {
            this.myIsModified = bl;
        }
    }

    public void fireUpdate(int n, int n2, Object object, int n3, Object object2) {
        if (n == 208) {
            this.updatePaperColor();
        } else if (n != 206) {
            this.setModified(true);
        }
        super.fireUpdate(n, n2, object, n3, object2);
    }

    public ActivityNode newNode(int n) {
        ActivityNode activityNode = new ActivityNode();
        activityNode.initialize(n, this.getNextNodeID());
        this.addObjectAtTail(activityNode);
        return activityNode;
    }

    public int getNextNodeID() {
        return ++this.myLastNodeID;
    }

    public ActivityNode findNodeByID(int n) {
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            ActivityNode activityNode;
            JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof ActivityNode) || (activityNode = (ActivityNode)jGoObject).getID() != n) continue;
            return activityNode;
        }
        return null;
    }

    public FlowLink newLink(JGoPort jGoPort, JGoPort jGoPort2) {
        FlowLink flowLink = new FlowLink(jGoPort, jGoPort2);
        flowLink.initialize(" ");
        flowLink.setPen(this.getLinkPen());
        flowLink.setOrthogonal(this.isOrthogonalFlows());
        this.addObjectAtTail(flowLink);
        ActivityNode activityNode = (ActivityNode)jGoPort.getParent();
        activityNode.updateDownstreamLinks();
        return flowLink;
    }

    public FlowLink findLinkByNodes(ActivityNode activityNode, ActivityNode activityNode2) {
        if (activityNode == null || activityNode2 == null) {
            return null;
        }
        JGoPort jGoPort = activityNode.getOutputPort();
        if (jGoPort == null) {
            return null;
        }
        JGoPort jGoPort2 = activityNode2.getInputPort();
        if (jGoPort2 == null) {
            return null;
        }
        JGoListPosition jGoListPosition = jGoPort2.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = jGoPort2.getLinkAtPos(jGoListPosition);
            jGoListPosition = jGoPort2.getNextLinkPos(jGoListPosition);
            JGoPort jGoPort3 = jGoLink.getFromPort();
            if (jGoPort3 != jGoPort) continue;
            return (FlowLink)jGoLink;
        }
        return null;
    }

    public JGoPen getLinkPen() {
        return this.myPen;
    }

    public void setLinkPen(JGoPen jGoPen) {
        if (!this.myPen.equals(jGoPen)) {
            this.myPen = jGoPen;
            JGoListPosition jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject instanceof JGoLink)) continue;
                JGoLink jGoLink = (JGoLink)jGoObject;
                jGoLink.setPen(jGoPen);
            }
        }
    }

    void toggleOrthogonalFlows() {
        this.startTransaction();
        this.setOrthogonalFlows(!this.isOrthogonalFlows());
        this.endTransaction("Orthogonal Flows");
    }

    public boolean isOrthogonalFlows() {
        return this.myOrthoLinks;
    }

    void setOrthogonalFlows(boolean bl) {
        if (this.myOrthoLinks != bl) {
            this.myOrthoLinks = bl;
            JGoListPosition jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject instanceof JGoLink)) continue;
                JGoLink jGoLink = (JGoLink)jGoObject;
                jGoLink.setOrthogonal(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ProcessDocument open(Component component, String string) {
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null && !string.equals("")) {
            object = new File(string);
            jFileChooser.setCurrentDirectory((File)object);
        } else {
            jFileChooser.setCurrentDirectory(null);
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        object = new Filter(".wfl", "Flower temporary serialization format (*.wfl)");
        Filter filter = new Filter(".xml", "Extensible Markup Language (*.xml)");
        Filter filter2 = new Filter(".svg", "JGo SVG with XML extensions (*.svg)");
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        jFileChooser.addChoosableFileFilter(filter);
        jFileChooser.addChoosableFileFilter(filter2);
        jFileChooser.setFileFilter((FileFilter)object);
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            ProcessDocument processDocument;
            FileInputStream fileInputStream;
            String string2;
            block24: {
                string2 = jFileChooser.getSelectedFile().getName();
                String string3 = jFileChooser.getSelectedFile().getAbsolutePath();
                string3.toLowerCase();
                fileInputStream = null;
                fileInputStream = new FileInputStream(string3);
                processDocument = null;
                if (string3.endsWith(".xml")) {
                    processDocument = ProcessDocument.loadXML(fileInputStream);
                    if (processDocument == null) {
                        fileInputStream = new FileInputStream(string3);
                        processDocument = ProcessDocument.loadSVG1(fileInputStream);
                    }
                } else {
                    processDocument = string3.endsWith(".svg") ? ProcessDocument.loadSVG1(fileInputStream) : ProcessDocument.loadObjects(fileInputStream);
                }
                if (processDocument != null) break block24;
                ProcessDocument processDocument2 = null;
                Object var13_17 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return processDocument2;
            }
            processDocument.setName(string2);
            processDocument.updateLocationModifiable();
            processDocument.updatePaperColor();
            processDocument.setModified(false);
            processDocument.setUndoManager(new JGoUndoManager());
            ProcessDocument processDocument3 = processDocument;
            Object var13_18 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return processDocument3;
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, iOException, "Open Document Error", 0);
                ProcessDocument processDocument4 = null;
                Object var13_19 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return processDocument4;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception, "Loading Document Exception", 0);
                ProcessDocument processDocument5 = null;
                Object var13_20 = null;
                {
                    catch (Throwable throwable) {
                        Object var13_21 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return processDocument5;
            }
        }
        return null;
    }

    public void save() {
        if (this.getLocation().equals("")) {
            this.saveAs(".wfl");
        } else {
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void store() {
        block19: {
            if (!this.getLocation().equals("")) {
                FileOutputStream fileOutputStream;
                block17: {
                    fileOutputStream = null;
                    fileOutputStream = new FileOutputStream(this.getLocation());
                    if (this.myDescription.equals(sFlowerXML)) {
                        this.storeXML(fileOutputStream);
                        break block17;
                    }
                    if (this.myDescription.equals(sJGoSVGXML)) {
                        this.storeSVG1(fileOutputStream, true, true);
                        break block17;
                    }
                    if (this.myDescription.equals(sJGoSVG)) {
                        this.storeSVG1(fileOutputStream, false, true);
                        break block17;
                    }
                    if (this.myDescription.equals(sJGoXML)) {
                        this.storeSVG1(fileOutputStream, true, false);
                        break block17;
                    }
                    if (this.myDescription.equals(sBatikSVG)) {
                        this.storeSVG2(fileOutputStream);
                        break block17;
                    }
                    this.storeObjects(fileOutputStream);
                }
                Object var4_2 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setModified(false);
                {
                    break block19;
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception, "Save Document Error", 0);
                        Object var4_3 = null;
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        this.setModified(false);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setModified(false);
                    throw throwable;
                }
            }
        }
    }

    public void saveAs(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        String string2 = this.getLocation();
        File file = new File(string2);
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        Filter filter = new Filter(".wfl", sFlowerWFL);
        Filter filter2 = new Filter(".svg", sJGoSVGXML);
        Filter filter3 = new Filter(".svg", sBatikSVG);
        Filter filter4 = new Filter(".svg", sJGoSVG);
        Filter filter5 = new Filter(".xml", sFlowerXML);
        Filter filter6 = new Filter(".xml", sJGoXML);
        jFileChooser.addChoosableFileFilter(filter);
        jFileChooser.addChoosableFileFilter(filter2);
        jFileChooser.addChoosableFileFilter(filter4);
        jFileChooser.addChoosableFileFilter(filter3);
        jFileChooser.addChoosableFileFilter(filter6);
        jFileChooser.addChoosableFileFilter(filter5);
        if (string.equalsIgnoreCase(".svg")) {
            jFileChooser.setFileFilter(filter2);
        } else if (string.equalsIgnoreCase(".xml")) {
            jFileChooser.setFileFilter(filter5);
        } else {
            jFileChooser.setFileFilter(filter);
        }
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            String string3 = ".wfl";
            Filter filter7 = (Filter)jFileChooser.getFileFilter();
            this.myDescription = filter7.getDescription();
            string3 = filter7.getExtension();
            String string4 = jFileChooser.getSelectedFile().getName();
            this.setName(string4);
            string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            String string5 = string2.toLowerCase();
            if (string5.indexOf(".") == -1) {
                string2 = string2 + string3;
            }
            this.setLocation(string2);
            this.store();
        }
    }

    public static ProcessDocument loadObjects(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = objectInputStream.readObject();
        if (object instanceof ProcessDocument) {
            ProcessDocument processDocument = (ProcessDocument)object;
            return processDocument;
        }
        return null;
    }

    public void storeObjects(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public static ProcessDocument loadSVG1(InputStream inputStream) {
        ProcessDocument processDocument = new ProcessDocument();
        try {
            DefaultDocument defaultDocument = new DefaultDocument();
            defaultDocument.SVGReadDoc(inputStream, (JGoDocument)processDocument);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return processDocument;
    }

    public static ProcessDocument loadXML(InputStream inputStream) throws IOException, UnsupportedOperationException {
        ProcessDocument processDocument = new ProcessDocument();
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            if (element != null) {
                if (!element.getTagName().equals(processTag)) {
                    return null;
                }
                processDocument.setName(element.getAttribute("name"));
                processDocument.setLocation(element.getAttribute("location"));
                String string = element.getAttribute("lastnodeid");
                processDocument.myLastNodeID = Integer.parseInt(string);
                processDocument.setOrthogonalFlows(element.getAttribute("ortholinks").equals("1"));
                NodeList nodeList = element.getElementsByTagName("*");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2;
                    int n;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element2 = (Element)node;
                    if (element2.getTagName().equals(activityTag)) {
                        ActivityNode activityNode = new ActivityNode();
                        n = Integer.parseInt(element2.getAttribute("id"));
                        int n2 = Integer.parseInt(element2.getAttribute("type"));
                        int n3 = Integer.parseInt(element2.getAttribute("x"));
                        int n4 = Integer.parseInt(element2.getAttribute("y"));
                        string2 = element2.getAttribute("text");
                        activityNode.initialize(n2, n);
                        activityNode.setTopLeft(n3, n4);
                        activityNode.setText(string2);
                        processDocument.addObjectAtTail(activityNode);
                        continue;
                    }
                    if (!element2.getTagName().equals(flowTag)) continue;
                    int n5 = Integer.parseInt(element2.getAttribute("from"));
                    n = Integer.parseInt(element2.getAttribute("to"));
                    ActivityNode activityNode = processDocument.findNodeByID(n5);
                    ActivityNode activityNode2 = processDocument.findNodeByID(n);
                    if (activityNode == null || activityNode2 == null) continue;
                    FlowLink flowLink = new FlowLink(activityNode.getOutputPort(), activityNode2.getInputPort());
                    string2 = element2.getAttribute("text");
                    flowLink.setText(string2);
                    processDocument.addObjectAtTail(flowLink);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.err.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.err.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return processDocument;
    }

    public void storeXML(OutputStream outputStream) {
        Object object;
        Object object2;
        Document document = null;
        try {
            Element element;
            JGoObject jGoObject;
            JGoObject jGoObject2;
            object2 = DocumentBuilderFactory.newInstance();
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).newDocument();
            Element element2 = document.createElement(processTag);
            element2.setAttribute("name", this.getName());
            element2.setAttribute("location", this.getLocation());
            element2.setAttribute("lastnodeid", Integer.toString(this.myLastNodeID));
            element2.setAttribute("ortholinks", this.isOrthogonalFlows() ? "1" : "0");
            document.appendChild(element2);
            JGoListPosition jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                jGoObject2 = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject2 instanceof ActivityNode)) continue;
                jGoObject = (ActivityNode)jGoObject2;
                element = document.createElement(activityTag);
                element.setAttribute("id", Integer.toString(((ActivityNode)jGoObject).getID()));
                element.setAttribute("type", Integer.toString(((ActivityNode)jGoObject).getActivityType()));
                element.setAttribute("x", Integer.toString(jGoObject.getLeft()));
                element.setAttribute("y", Integer.toString(jGoObject.getTop()));
                element.setAttribute("text", ((ActivityNode)jGoObject).getText());
                element2.appendChild(element);
            }
            jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                jGoObject2 = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject2 instanceof FlowLink)) continue;
                jGoObject = (FlowLink)jGoObject2;
                element = document.createElement(flowTag);
                element.setAttribute("from", Integer.toString(((FlowLink)jGoObject).getFromNode().getID()));
                element.setAttribute("to", Integer.toString(((FlowLink)jGoObject).getToNode().getID()));
                element.setAttribute("text", ((FlowLink)jGoObject).getText());
                element2.appendChild(element);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        if (document != null) {
            try {
                object2 = TransformerFactory.newInstance();
                object = ((TransformerFactory)object2).newTransformer();
                ((Transformer)object).setOutputProperty("method", "xml");
                ((Transformer)object).setOutputProperty("indent", "yes");
                ((Transformer)object).transform(new DOMSource(document), new StreamResult(outputStream));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void storeSVG1(OutputStream outputStream, boolean bl, boolean bl2) {
        DefaultDocument defaultDocument = new DefaultDocument();
        defaultDocument.setGenerateJGoXML(bl);
        defaultDocument.setGenerateSVG(bl2);
        defaultDocument.SVGWriteDoc(outputStream, (JGoDocument)this);
    }

    public void storeSVG2(OutputStream outputStream) throws IOException, UnsupportedOperationException {
        SVGGoView sVGGoView = new SVGGoView();
        sVGGoView.setDocument(this);
        sVGGoView.generateSVG(outputStream);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getHint()) {
            case 65536: {
                jGoDocumentChangedEdit.setNewValue(this.getName());
                return;
            }
            case 65537: {
                jGoDocumentChangedEdit.setNewValue(this.getLocation());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getHint()) {
            case 65536: {
                this.setName((String)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 65537: {
                this.setLocation((String)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void endTransaction(String string) {
        super.endTransaction(string);
        AppAction.updateAllActions();
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.examples.flower.ProcessDocument", domElement);
            domElement2.setAttribute("isOrtho", this.myOrthoLinks ? "1" : "0");
            domElement2.setAttribute("name", this.myName);
            domElement2.setAttribute("location", this.myLocation);
            domElement2.setAttribute("lastid", Integer.toString(this.myLastNodeID));
            if (!domDoc.isRegisteredReference(this.myPen)) {
                domElement2.setAttribute("embeddedlinkpen", "true");
                DomElement domElement3 = domDoc.createElement("g");
                domElement2.appendChild(domElement3);
                this.myPen.SVGWriteObject(domDoc, domElement3);
                domDoc.registerReferencingNode(domElement2, "linkpen", this.myPen);
            }
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.myOrthoLinks = domElement2.getAttribute("isOrtho").equals("1");
            this.myName = domElement2.getAttribute("name");
            this.myLocation = domElement2.getAttribute("location");
            this.myLastNodeID = Integer.parseInt(domElement2.getAttribute("lastid"));
            if (domElement2.getAttribute("embeddedlinkpen").equals("true")) {
                domDoc.SVGTraverseChildren(jGoDocument, domElement2, null, false);
            }
            String string = domElement2.getAttribute("linkpen");
            domDoc.registerReferencingObject(this, "linkpen", string);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }
}

