/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.flower;

import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import com.nwoods.jgo.examples.flower.ActivityDialog;
import com.nwoods.jgo.examples.flower.ActivityNode;
import com.nwoods.jgo.examples.flower.AppAction;
import com.nwoods.jgo.examples.flower.FlowDialog;
import com.nwoods.jgo.examples.flower.FlowLink;
import com.nwoods.jgo.examples.flower.Flower;
import com.nwoods.jgo.examples.flower.ProcessDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class ProcessView
extends JGoView
implements JGoViewListener {
    protected Point myDefaultLocation = new Point(10, 10);
    protected Flower myApp = null;
    protected JInternalFrame myInternalFrame = null;
    protected static JPopupMenu myPopupMenu = new JPopupMenu();

    public ProcessView() {
    }

    public ProcessView(JGoDocument jGoDocument) {
        super(jGoDocument);
    }

    public void initialize(Flower flower, JInternalFrame jInternalFrame) {
        this.myApp = flower;
        this.myInternalFrame = jInternalFrame;
        this.addViewListener(this);
        this.setGridWidth(10);
        this.setGridHeight(10);
        this.updateTitle();
    }

    public JGoDocument createDefaultModel() {
        return new ProcessDocument();
    }

    ProcessDocument getDoc() {
        return (ProcessDocument)this.getDocument();
    }

    Flower getApp() {
        return this.myApp;
    }

    JInternalFrame getInternalFrame() {
        return this.myInternalFrame;
    }

    public void onKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            if (this.getDoc().isModifiable()) {
                this.deleteSelection();
            }
        } else if (n == 36) {
            this.setViewPosition(0, 0);
        } else if (n == 39) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, this.getGridWidth(), 0, 3);
            }
        } else if (n == 37) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, -this.getGridWidth(), 0, 3);
            }
        } else if (n == 40) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, 0, this.getGridHeight(), 3);
            }
        } else if (n == 38) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, 0, -this.getGridHeight(), 3);
            }
        } else if (n == 27) {
            this.getSelection().clearSelection();
        } else if (Character.isLetter(keyEvent.getKeyChar())) {
            if (!this.selectNextNode(keyEvent.getKeyChar())) {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            super.onKeyEvent(keyEvent);
        }
    }

    public boolean doMouseDown(int n, Point point, Point point2) {
        JGoObject jGoObject = this.pickDocObject(point, true);
        if (jGoObject != null && this.getCurrentMouseEvent() != null && this.getCurrentMouseEvent().isPopupTrigger()) {
            this.selectObject(jGoObject);
            return this.doPopupMenu(n, point, point2);
        }
        return super.doMouseDown(n, point, point2);
    }

    public boolean doMouseUp(int n, Point point, Point point2) {
        JGoObject jGoObject = this.pickDocObject(point, true);
        if (jGoObject != null && this.getCurrentMouseEvent() != null && this.getCurrentMouseEvent().isPopupTrigger()) {
            this.selectObject(jGoObject);
            return this.doPopupMenu(n, point, point2);
        }
        return super.doMouseUp(n, point, point2);
    }

    public boolean doMouseDblClick(int n, Point point, Point point2) {
        JGoObject jGoObject = this.pickDocObject(point, false);
        if (jGoObject == null) {
            JOptionPane.showInternalMessageDialog(this, "The diagram backround has no editable properties", "information", 1);
        }
        boolean bl = super.doMouseDblClick(n, point, point2);
        return bl;
    }

    public boolean doPopupMenu(int n, Point point, Point point2) {
        JPopupMenu jPopupMenu = ProcessView.getPopupMenu();
        jPopupMenu.show(this, point2.x, point2.y);
        return true;
    }

    public static JPopupMenu getPopupMenu() {
        return myPopupMenu;
    }

    public void viewChanged(JGoViewEvent jGoViewEvent) {
        switch (jGoViewEvent.getHint()) {
            case 1: 
            case 20: 
            case 21: 
            case 108: {
                AppAction.updateAllActions();
            }
        }
    }

    public void documentChanged(JGoDocumentEvent jGoDocumentEvent) {
        if (jGoDocumentEvent.getHint() == 65536 || jGoDocumentEvent.getHint() == 208) {
            this.updateTitle();
        }
        super.documentChanged(jGoDocumentEvent);
    }

    public void updateTitle() {
        if (this.getInternalFrame() != null) {
            String string = this.getDoc().getName();
            if (!this.getDocument().isModifiable()) {
                string = string + " (read-only)";
            }
            this.getInternalFrame().setTitle(string);
            this.getInternalFrame().repaint();
        }
    }

    public void newLink(JGoPort jGoPort, JGoPort jGoPort2) {
        FlowLink flowLink = this.getDoc().newLink(jGoPort, jGoPort2);
        this.fireUpdate(31, 0, flowLink);
        this.getDoc().endTransaction("new FlowLink");
    }

    public void insertActivity() {
        this.getDoc().startTransaction();
        Point point = this.getDefaultLocation();
        if (point == null) {
            point = new Point(100, 70);
        }
        ActivityNode activityNode = this.getDoc().newNode(3);
        activityNode.setTopLeft(point);
        this.getDoc().endTransaction("new Activity");
    }

    public void insertInput() {
        this.getDoc().startTransaction();
        Point point = this.getDefaultLocation();
        if (point == null) {
            point = new Point(100, 70);
        }
        ActivityNode activityNode = this.getDoc().newNode(1);
        activityNode.setTopLeft(point);
        this.getDoc().endTransaction("new Output");
    }

    public void insertOutput() {
        this.getDoc().startTransaction();
        Point point = this.getDefaultLocation();
        if (point == null) {
            point = new Point(100, 70);
        }
        ActivityNode activityNode = this.getDoc().newNode(2);
        activityNode.setTopLeft(point);
        this.getDoc().endTransaction("new Input");
    }

    public Point getDefaultLocation() {
        if (this.myDefaultLocation != null) {
            this.myDefaultLocation.x += 10;
            this.myDefaultLocation.y += 10;
        }
        return this.myDefaultLocation;
    }

    public void setDefaultLocation(Point point) {
        this.myDefaultLocation = point;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        JGoCopyEnvironment jGoCopyEnvironment = this.getDocument().createDefaultCopyEnvironment();
        this.getDocument().startTransaction();
        if (this.getDocument().isModifiable() && this.doDrop(dropTargetDropEvent, jGoCopyEnvironment)) {
            Iterator iterator = jGoCopyEnvironment.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (!(v instanceof ActivityNode)) continue;
                ActivityNode activityNode = (ActivityNode)v;
                activityNode.setSize(ActivityNode.getStdSize());
                activityNode.resetEditability();
                this.snapObject(activityNode);
            }
            this.fireUpdate(35, 0, null);
            this.getDocument().endTransaction("Drop");
        } else {
            dropTargetDropEvent.rejectDrop();
            this.getDocument().endTransaction(false);
        }
    }

    void editObjectProperties() {
        JGoSelection jGoSelection = this.getSelection();
        if (jGoSelection.isEmpty()) {
            this.getApp().editProcessProperties();
            return;
        }
        this.getDocument().startTransaction();
        JGoListPosition jGoListPosition = jGoSelection.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = jGoSelection.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoSelection.getNextObjectPos(jGoListPosition);
            if (!jGoObject.isTopLevel()) continue;
            if (jGoObject instanceof ActivityNode) {
                this.editActivity((ActivityNode)jGoObject);
                continue;
            }
            if (!(jGoObject instanceof FlowLink)) continue;
            this.editFlow((FlowLink)jGoObject);
        }
        this.getDocument().endTransaction("Object Properties");
    }

    void editActivity(ActivityNode activityNode) {
        switch (activityNode.getActivityType()) {
            case 1: {
                JOptionPane.showInternalMessageDialog(this, "A Start node has no editable properties", "information", 1);
                break;
            }
            case 2: {
                JOptionPane.showInternalMessageDialog(this, "A Finish node has no editable properties", "information", 1);
                break;
            }
            case 3: {
                ActivityDialog activityDialog = new ActivityDialog(this.getFrame(), activityNode);
                activityDialog.setLocationRelativeTo(null);
                activityDialog.setVisible(true);
                break;
            }
        }
    }

    void editFlow(FlowLink flowLink) {
        FlowDialog flowDialog = new FlowDialog(this.getFrame(), flowLink);
        flowDialog.setLocationRelativeTo(null);
        flowDialog.setVisible(true);
    }

    void showGrid() {
        int n = this.getGridStyle();
        if (n == 0) {
            n = 1;
            this.setGridPen(JGoPen.black);
            this.setSnapMove(1);
        } else {
            n = 0;
            this.setSnapMove(0);
        }
        this.setGridStyle(n);
    }

    public Rectangle2D.Double getPrintPageRect(Graphics2D graphics2D, PageFormat pageFormat) {
        return new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight() - 20.0);
    }

    public void printDecoration(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2) {
        super.printDecoration(graphics2D, pageFormat, n, n2);
        String string = Integer.toString(n);
        string = string + ", ";
        string = string + Integer.toString(n2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(Color.black);
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font(JGoText.getDefaultFontFaceName(), 0, 10));
        graphics2D.drawString(string, (int)(pageFormat.getImageableX() + pageFormat.getImageableWidth() / 2.0), (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight() - 10.0));
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    public double getPrintScale(Graphics2D graphics2D, PageFormat pageFormat) {
        return this.getScale();
    }

    void zoomIn() {
        double d = Math.rint(this.getScale() / (double)0.9f * 100.0) / 100.0;
        this.setScale(d);
    }

    void zoomOut() {
        double d = Math.rint(this.getScale() * (double)0.9f * 100.0) / 100.0;
        this.setScale(d);
    }

    void zoomNormal() {
        this.setScale(1.0);
    }

    void zoomToFit() {
        double d = 1.0;
        if (!this.getDocument().isEmpty()) {
            double d2 = this.getExtentSize().width;
            double d3 = this.getPrintDocumentSize().width;
            double d4 = this.getExtentSize().height;
            double d5 = this.getPrintDocumentSize().height;
            d = Math.min(d2 / d3, d4 / d5);
        }
        if (d > 2.0) {
            d = 1.0;
        }
        this.setScale(d *= this.getScale());
        this.setViewPosition(0, 0);
    }

    public boolean matchesNodeLabel(ActivityNode activityNode, char c) {
        if (activityNode == null) {
            return false;
        }
        String string = activityNode.getText();
        return string.length() > 0 && Character.toUpperCase(string.charAt(0)) == c;
    }

    public boolean selectNextNode(char c) {
        ActivityNode activityNode;
        JGoListPosition jGoListPosition;
        c = Character.toUpperCase(c);
        JGoDocument jGoDocument = this.getDocument();
        ActivityNode activityNode2 = null;
        JGoObject jGoObject = this.getSelection().getPrimarySelection();
        if (jGoObject != null && jGoObject instanceof ActivityNode) {
            activityNode2 = (ActivityNode)jGoObject;
        }
        JGoListPosition jGoListPosition2 = null;
        if (activityNode2 != null) {
            jGoListPosition2 = jGoDocument.findObject(activityNode2);
        }
        if ((jGoListPosition = jGoListPosition2) != null) {
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
        }
        while (jGoListPosition != null) {
            jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof ActivityNode) || !this.matchesNodeLabel(activityNode = (ActivityNode)jGoObject, c)) continue;
            this.selectObject(activityNode);
            this.scrollRectToVisible(activityNode.getBoundingRect());
            return true;
        }
        jGoListPosition = jGoDocument.getFirstObjectPos();
        while (jGoListPosition != null && jGoListPosition != jGoListPosition2) {
            jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
            if (!(jGoObject instanceof ActivityNode) || !this.matchesNodeLabel(activityNode = (ActivityNode)jGoObject, c)) continue;
            this.selectObject(activityNode);
            this.scrollRectToVisible(activityNode.getBoundingRect());
            return true;
        }
        return false;
    }

    public boolean validLink(JGoPort jGoPort, JGoPort jGoPort2) {
        JGoObject jGoObject;
        boolean bl = true;
        ActivityNode activityNode = null;
        JGoObject jGoObject2 = jGoPort.getParentNode();
        if (jGoObject2 instanceof ActivityNode) {
            activityNode = (ActivityNode)jGoObject2;
            int n = activityNode.getFlags();
            activityNode.setFlags(activityNode.getFlags() | 0x10000);
        }
        if ((jGoObject = jGoPort2.getParentNode()) instanceof ActivityNode) {
            ActivityNode activityNode2 = (ActivityNode)jGoObject;
            bl = !activityNode2.downstreamNodeContainsFlag(65536);
        }
        activityNode.setFlags(activityNode.getFlags() & 0xFFFEFFFF);
        return bl && super.validLink(jGoPort, jGoPort2);
    }
}

