/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.layoutdemo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoEllipse;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.examples.layoutdemo.BasicLayoutPort;
import java.awt.Color;
import java.awt.Point;

public class BasicLayoutNode
extends JGoNode {
    static int myStdSize = 40;
    protected JGoEllipse myEllipse = null;
    protected JGoText myLabel = null;
    protected BasicLayoutPort[] myPorts = null;
    protected int numPorts = 0;
    protected boolean horizontal = true;

    protected void copyChildren(JGoArea jGoArea, JGoCopyEnvironment jGoCopyEnvironment) {
        BasicLayoutNode basicLayoutNode = (BasicLayoutNode)jGoArea;
        basicLayoutNode.numPorts = this.numPorts;
        basicLayoutNode.myPorts = new BasicLayoutPort[this.numPorts];
        super.copyChildren(jGoArea, jGoCopyEnvironment);
        basicLayoutNode.myEllipse = (JGoEllipse)jGoCopyEnvironment.get(this.myEllipse);
        basicLayoutNode.myLabel = (JGoText)jGoCopyEnvironment.get(this.myLabel);
        Point point = basicLayoutNode.myEllipse.getSpotLocation(0);
        for (int i = 0; i < this.numPorts; ++i) {
            BasicLayoutPort basicLayoutPort;
            BasicLayoutPort basicLayoutPort2 = this.myPorts[i];
            basicLayoutNode.myPorts[i] = basicLayoutPort = (BasicLayoutPort)jGoCopyEnvironment.get(basicLayoutPort2);
            basicLayoutPort.myEllipse = basicLayoutNode.myEllipse;
        }
    }

    public void layoutChildren() {
        if (this.myEllipse == null) {
            return;
        }
        if (this.myLabel != null) {
            this.myLabel.setSpotLocation(2, this.myEllipse, 6);
        }
        if (this.myPorts != null) {
            Point point = this.myEllipse.getSpotLocation(0);
            for (int i = 0; i < this.numPorts; ++i) {
                if (this.horizontal) {
                    this.myPorts[i].setSpotLocation(0, point.x - BasicLayoutNode.getStdSize() / 4 * (this.numPorts - 1) + BasicLayoutNode.getStdSize() / 2 * i, point.y);
                    continue;
                }
                this.myPorts[i].setSpotLocation(0, point.x, point.y - BasicLayoutNode.getStdSize() / 4 * (this.numPorts - 1) + BasicLayoutNode.getStdSize() / 2 * i);
            }
        }
    }

    public void initialize(Point point, String string, int n, boolean bl) {
        int n2;
        this.horizontal = bl;
        this.numPorts = n;
        if (this.numPorts <= 0) {
            this.numPorts = 1;
        }
        if (this.horizontal) {
            this.setSize(myStdSize / 2 * (this.numPorts + 1), myStdSize);
        } else {
            this.setSize(myStdSize, myStdSize / 2 * (this.numPorts + 1));
        }
        this.setDraggable(true);
        this.setResizable(false);
        this.myEllipse = new JGoEllipse(this.getTopLeft(), this.getSize());
        this.myEllipse.setSelectable(false);
        this.myEllipse.setDraggable(false);
        this.myEllipse.setSpotLocation(0, point);
        if (string != null) {
            this.myLabel = new JGoText(string);
            this.myLabel.setSelectable(false);
            this.myLabel.setDraggable(false);
            this.myLabel.setAlignment(2);
            this.myLabel.setTransparent(true);
        }
        this.myPorts = new BasicLayoutPort[this.numPorts];
        for (n2 = 0; n2 < this.numPorts; ++n2) {
            this.myPorts[n2] = new BasicLayoutPort();
            this.myPorts[n2].myEllipse = this.myEllipse;
            this.myPorts[n2].setSize(16, 16);
        }
        this.addObjectAtHead(this.myEllipse);
        if (this.myLabel != null) {
            this.addObjectAtTail(this.myLabel);
        }
        for (n2 = 0; n2 < this.numPorts; ++n2) {
            this.addObjectAtTail(this.myPorts[n2]);
        }
        this.layoutChildren();
        this.setBrush(JGoBrush.white);
        this.setColor(Color.red);
    }

    public JGoPen getPen() {
        return this.myEllipse.getPen();
    }

    public void setPen(JGoPen jGoPen) {
        this.myEllipse.setPen(jGoPen);
    }

    public JGoBrush getBrush() {
        return this.myEllipse.getBrush();
    }

    public void setBrush(JGoBrush jGoBrush) {
        this.myEllipse.setBrush(jGoBrush);
    }

    public Color getColor() {
        return this.getPen().getColor();
    }

    public void setColor(Color color) {
        this.setPen(JGoPen.makeStockPen(color));
    }

    public void colorChange() {
        Color color = this.getColor();
        if (color == Color.red) {
            this.setColor(Color.green);
        } else if (color == Color.green) {
            this.setColor(Color.blue);
        } else if (color == Color.blue) {
            this.setColor(Color.red);
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    static int getStdSize() {
        return myStdSize;
    }

    static void setStdSize(int n) {
        myStdSize = n;
    }

    public JGoObject getEllipse() {
        return this.myEllipse;
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public BasicLayoutPort[] getPorts() {
        return this.myPorts;
    }
}

