/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.layoutdemo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.examples.layoutdemo.BasicLayoutNode;
import com.nwoods.jgo.examples.layoutdemo.BasicLayoutPort;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class DemoDocument
extends JGoDocument {
    public static final int NameChanged = 65536;
    public static final int LocationChanged = 65537;
    private JGoPen myPen = JGoPen.make(65535, 2, Color.black);
    private String myName = "";
    private String myLocation = "";
    private static boolean showArrows = true;
    private int myVersion = 1;
    private boolean changed = false;

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        String string2 = this.myName;
        if (!string2.equals(string)) {
            this.myName = string;
            this.fireUpdate(65536, 0, null, 0, string2);
        }
    }

    public String getLocation() {
        return this.myLocation;
    }

    public void setLocation(String string) {
        String string2 = this.myLocation;
        if (!string2.equals(string)) {
            this.myLocation = string;
            this.fireUpdate(65537, 0, null, 0, string2);
        }
    }

    public BasicLayoutNode newNode(Point point, String string, int n, boolean bl) {
        BasicLayoutNode basicLayoutNode = new BasicLayoutNode();
        basicLayoutNode.initialize(point, string, n, bl);
        this.addObjectAtTail(basicLayoutNode);
        return basicLayoutNode;
    }

    public JGoLink newLink(JGoPort jGoPort, JGoPort jGoPort2) {
        if (jGoPort.getParent() == jGoPort2.getParent()) {
            return null;
        }
        JGoLink jGoLink = new JGoLink(jGoPort, jGoPort2);
        jGoLink.setPen(this.getLinkPen());
        this.getLinksLayer().addObjectAtTail(jGoLink);
        jGoLink.setArrowHeads(false, this.isShowArrows());
        return jGoLink;
    }

    public JGoPen getLinkPen() {
        return this.myPen;
    }

    public void setLinkPen(JGoPen jGoPen) {
        if (!this.myPen.equals(jGoPen)) {
            this.myPen = jGoPen;
            JGoListPosition jGoListPosition = this.getFirstObjectPos();
            while (jGoListPosition != null) {
                JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                if (!(jGoObject instanceof JGoLink)) continue;
                JGoLink jGoLink = (JGoLink)jGoObject;
                jGoLink.setPen(jGoPen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static DemoDocument open(Component component, String string) {
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null && !string.equals("")) {
            File file = new File(string);
            jFileChooser.setCurrentDirectory(file);
        } else {
            jFileChooser.setCurrentDirectory(null);
        }
        int n = jFileChooser.showOpenDialog(null);
        DemoDocument demoDocument = new DemoDocument();
        if (n == 0) {
            int n2;
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            RandomAccessFile randomAccessFile = null;
            randomAccessFile = new RandomAccessFile(string2, "r");
            demoDocument.myVersion = n2 = randomAccessFile.readInt();
            String string3 = randomAccessFile.readLine();
            demoDocument.setName(string3);
            demoDocument.setLocation(string2);
            boolean bl = randomAccessFile.readBoolean();
            if (!bl) {
                demoDocument.toggleArrows();
            }
            boolean bl2 = randomAccessFile.readBoolean();
            while (bl2) {
                boolean bl3 = randomAccessFile.readBoolean();
                if (bl3) {
                    demoDocument.readNode(randomAccessFile);
                } else {
                    demoDocument.readLink(randomAccessFile);
                }
                bl2 = randomAccessFile.readBoolean();
            }
            demoDocument.changed = false;
            DemoDocument demoDocument2 = demoDocument;
            Object var13_18 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return demoDocument2;
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, iOException, "Open Document Error", 0);
                DemoDocument demoDocument3 = null;
                Object var13_19 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return demoDocument3;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception, "Loading Document Exception", 0);
                DemoDocument demoDocument4 = null;
                Object var13_20 = null;
                {
                    catch (Throwable throwable) {
                        Object var13_21 = null;
                        try {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return demoDocument4;
            }
        }
        return null;
    }

    public void save() {
        if (this.getLocation().equals("")) {
            this.saveAs();
        } else {
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void store() {
        block15: {
            boolean bl = this.changed;
            if (!this.getLocation().equals("")) {
                JGoObject jGoObject;
                this.changed = false;
                RandomAccessFile randomAccessFile = null;
                randomAccessFile = new RandomAccessFile(this.getLocation(), "rw");
                randomAccessFile.setLength(0L);
                randomAccessFile.writeInt(this.myVersion);
                randomAccessFile.writeBytes(this.getName() + "\r\n");
                randomAccessFile.writeBoolean(this.isShowArrows());
                JGoListPosition jGoListPosition = this.getFirstObjectPos();
                LinkedList<JGoObject> linkedList = new LinkedList<JGoObject>();
                while (jGoListPosition != null) {
                    jGoObject = this.getObjectAtPos(jGoListPosition);
                    jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                    if (jGoObject instanceof BasicLayoutNode) {
                        BasicLayoutNode basicLayoutNode = (BasicLayoutNode)jGoObject;
                        jGoObject = null;
                        randomAccessFile.writeBoolean(true);
                        this.writeNode(basicLayoutNode, randomAccessFile);
                        continue;
                    }
                    if (!(jGoObject instanceof JGoLink)) continue;
                    linkedList.addLast(jGoObject);
                }
                while (linkedList.size() > 0) {
                    jGoObject = (JGoLink)linkedList.removeLast();
                    randomAccessFile.writeBoolean(true);
                    this.writeLink((JGoLink)jGoObject, randomAccessFile);
                }
                randomAccessFile.writeBoolean(false);
                Object var8_8 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    break block15;
                }
                catch (Exception exception) {
                    this.changed = bl;
                }
                break block15;
                {
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, iOException, "Save Document Error", 0);
                        this.changed = bl;
                        Object var8_9 = null;
                        try {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                            break block15;
                        }
                        catch (Exception exception) {
                            this.changed = bl;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                    }
                    catch (Exception exception) {
                        this.changed = bl;
                    }
                    throw throwable;
                }
            }
        }
    }

    public void saveAs() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(null);
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getName();
            this.setName(string);
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            this.setLocation(string2);
            this.store();
        }
    }

    private void readNode(RandomAccessFile randomAccessFile) throws IOException {
        if (this.myVersion == 1) {
            boolean bl = randomAccessFile.readBoolean();
            String string = null;
            if (bl) {
                string = randomAccessFile.readLine();
            }
            char c = randomAccessFile.readChar();
            int n = randomAccessFile.readInt();
            boolean bl2 = randomAccessFile.readBoolean();
            int n2 = randomAccessFile.readInt();
            int n3 = randomAccessFile.readInt();
            Point point = new Point(n2, n3);
            BasicLayoutNode basicLayoutNode = this.newNode(point, string, n, bl2);
            if (c == 'g') {
                basicLayoutNode.colorChange();
            } else if (c == 'b') {
                basicLayoutNode.colorChange();
                basicLayoutNode.colorChange();
            }
        }
    }

    private void readLink(RandomAccessFile randomAccessFile) throws IOException {
        if (this.myVersion == 1) {
            int n = randomAccessFile.readInt();
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                int n2 = randomAccessFile.readInt();
                int n3 = randomAccessFile.readInt();
                pointArray[i] = new Point(n2, n3);
            }
            BasicLayoutPort basicLayoutPort = this.pickPort(pointArray[0]);
            BasicLayoutPort basicLayoutPort2 = this.pickPort(pointArray[n - 1]);
            JGoLink jGoLink = this.newLink(basicLayoutPort, basicLayoutPort2);
            if (n > 2) {
                pointArray[0] = jGoLink.getStartPoint();
                pointArray[n - 1] = jGoLink.getEndPoint();
                jGoLink.removeAllPoints();
                for (int i = 0; i < n; ++i) {
                    jGoLink.addPoint(pointArray[i]);
                }
            }
        }
    }

    private void writeNode(BasicLayoutNode basicLayoutNode, RandomAccessFile randomAccessFile) throws IOException {
        if (this.myVersion == 1) {
            randomAccessFile.writeBoolean(true);
            if (basicLayoutNode.getLabel() != null) {
                randomAccessFile.writeBoolean(true);
                randomAccessFile.writeBytes(basicLayoutNode.getLabel().getText() + "\r\n");
            } else {
                randomAccessFile.writeBoolean(false);
            }
            if (basicLayoutNode.getColor() == Color.green) {
                randomAccessFile.writeChar(103);
            } else if (basicLayoutNode.getColor() == Color.blue) {
                randomAccessFile.writeChar(98);
            } else {
                randomAccessFile.writeChar(114);
            }
            randomAccessFile.writeInt(basicLayoutNode.getNumPorts());
            randomAccessFile.writeBoolean(basicLayoutNode.isHorizontal());
            Point point = basicLayoutNode.getSpotLocation(0);
            randomAccessFile.writeInt(point.x);
            randomAccessFile.writeInt(point.y);
        }
    }

    private void writeLink(JGoLink jGoLink, RandomAccessFile randomAccessFile) throws IOException {
        if (this.myVersion == 1) {
            randomAccessFile.writeBoolean(false);
            int n = jGoLink.getNumPoints();
            randomAccessFile.writeInt(n);
            Point point = jGoLink.getFromPort().getSpotLocation(0);
            randomAccessFile.writeInt(point.x);
            randomAccessFile.writeInt(point.y);
            for (int i = 1; i < n - 1; ++i) {
                point = jGoLink.getPoint(i);
                randomAccessFile.writeInt(point.x);
                randomAccessFile.writeInt(point.y);
            }
            point = jGoLink.getToPort().getSpotLocation(0);
            randomAccessFile.writeInt(point.x);
            randomAccessFile.writeInt(point.y);
        }
    }

    public BasicLayoutPort pickPort(Point point) {
        JGoListPosition jGoListPosition = this.getLastObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject;
            JGoObject jGoObject2 = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getPrevObjectPos(jGoListPosition);
            if (!jGoObject2.isVisible() || !jGoObject2.isPointInObj(point)) continue;
            if (jGoObject2 instanceof JGoArea && (jGoObject = ((JGoArea)jGoObject2).pickObject(point, false)) != null) {
                jGoObject2 = jGoObject;
            }
            if (!(jGoObject2 instanceof BasicLayoutPort)) continue;
            return (BasicLayoutPort)jGoObject2;
        }
        return null;
    }

    public boolean isShowArrows() {
        return showArrows;
    }

    public void toggleArrows() {
        showArrows = !showArrows;
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
            if (jGoObject instanceof JGoLink) {
                ((JGoLink)jGoObject).setArrowHeads(false, this.isShowArrows());
            }
            jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }
}

