/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.layoutdemo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import com.nwoods.jgo.examples.layoutdemo.AppAction;
import com.nwoods.jgo.examples.layoutdemo.BasicLayoutNode;
import com.nwoods.jgo.examples.layoutdemo.DemoDocument;
import com.nwoods.jgo.examples.layoutdemo.LayoutDemo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import javax.swing.JInternalFrame;

public class DemoView
extends JGoView
implements JGoViewListener {
    protected Point myDefaultLocation = new Point(80, 80);
    protected LayoutDemo myApp = null;
    protected JInternalFrame myInternalFrame = null;

    public DemoView() {
    }

    public DemoView(JGoDocument jGoDocument) {
        super(jGoDocument);
    }

    public void initialize(LayoutDemo layoutDemo, JInternalFrame jInternalFrame) {
        this.myApp = layoutDemo;
        this.myInternalFrame = jInternalFrame;
        this.addViewListener(this);
        this.setGridWidth(10);
        this.setGridHeight(10);
        this.setSnapMove(1);
        this.showGrid();
    }

    public JGoDocument createDefaultModel() {
        return new DemoDocument();
    }

    DemoDocument getDoc() {
        return (DemoDocument)this.getDocument();
    }

    LayoutDemo getApp() {
        return this.myApp;
    }

    JInternalFrame getInternalFrame() {
        return this.myInternalFrame;
    }

    public void onKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            this.deleteSelection();
        } else {
            super.onKeyEvent(keyEvent);
        }
    }

    public void viewChanged(JGoViewEvent jGoViewEvent) {
        switch (jGoViewEvent.getHint()) {
            case 1: 
            case 20: 
            case 21: 
            case 108: {
                AppAction.updateAllActions();
            }
        }
    }

    public void documentChanged(JGoDocumentEvent jGoDocumentEvent) {
        if (jGoDocumentEvent.getHint() == 65536 && this.getInternalFrame() != null) {
            this.updateTitle();
        }
        if (jGoDocumentEvent.getHint() == 203 || jGoDocumentEvent.getHint() == 218 || jGoDocumentEvent.getHint() == 202 || jGoDocumentEvent.getHint() == 204) {
            this.getDoc().setChanged(true);
        }
        super.documentChanged(jGoDocumentEvent);
    }

    public void updateTitle() {
        if (this.getInternalFrame() != null) {
            String string = this.getDoc().getName();
            this.getInternalFrame().setTitle(string);
            this.getInternalFrame().repaint();
        }
    }

    public void newLink(JGoPort jGoPort, JGoPort jGoPort2) {
        JGoLink jGoLink = this.getDoc().newLink(jGoPort, jGoPort2);
        this.fireUpdate(31, 0, jGoLink);
        this.getDoc().endTransaction("new Link");
    }

    public void insertNode() {
        this.insertNode(null, null, 1, true);
    }

    public void insertNode(Point point) {
        this.insertNode(point, null, 1, true);
    }

    public void insertNode(String string) {
        this.insertNode(null, string, 1, true);
    }

    public void insertNode(Point point, String string) {
        this.insertNode(point, string, 1, true);
    }

    public void insertNode(Point point, String string, int n, boolean bl) {
        if (point == null) {
            point = this.getDefaultLocation();
        }
        if (point == null) {
            point = new Point(100, 70);
        }
        BasicLayoutNode basicLayoutNode = this.getDoc().newNode(point, string, n, bl);
    }

    public Point getDefaultLocation() {
        if (this.myDefaultLocation != null) {
            this.myDefaultLocation.x += 10;
            this.myDefaultLocation.y += 10;
        }
        return this.myDefaultLocation;
    }

    public void setDefaultLocation(Point point) {
        this.myDefaultLocation = point;
    }

    void showGrid() {
        int n = this.getGridStyle();
        if (n == 0) {
            n = 1;
            this.setGridPen(JGoPen.black);
        } else {
            n = 0;
        }
        this.setGridStyle(n);
    }

    public Rectangle2D.Double getPrintPageRect(Graphics2D graphics2D, PageFormat pageFormat) {
        return new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight() - 20.0);
    }

    public void printDecoration(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2) {
        super.printDecoration(graphics2D, pageFormat, n, n2);
        String string = Integer.toString(n);
        string = string + ", ";
        string = string + Integer.toString(n2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(Color.black);
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font(JGoText.getDefaultFontFaceName(), 0, 10));
        graphics2D.drawString(string, (int)(pageFormat.getImageableX() + pageFormat.getImageableWidth() / 2.0), (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight() - 10.0));
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    public double getPrintScale(Graphics2D graphics2D, PageFormat pageFormat) {
        return this.getScale();
    }

    void zoomIn() {
        double d = Math.rint(this.getScale() / (double)0.9f * 100.0) / 100.0;
        this.setScale(d);
    }

    void zoomOut() {
        double d = Math.rint(this.getScale() * (double)0.9f * 100.0) / 100.0;
        this.setScale(d);
    }

    void zoomNormal() {
        this.setScale(1.0);
    }

    void zoomToFit() {
        double d = 1.0;
        if (!this.getDocument().isEmpty()) {
            double d2 = this.getExtentSize().width;
            double d3 = this.getPrintDocumentSize().width;
            double d4 = this.getExtentSize().height;
            double d5 = this.getPrintDocumentSize().height;
            d = Math.min(d2 / d3, d4 / d5);
        }
        if ((d *= this.getScale()) > 1.0) {
            d = 1.0;
        }
        this.setScale(d);
        this.setViewPosition(0, 0);
    }

    public boolean doMouseDblClick(int n, Point point, Point point2) {
        JGoObject jGoObject = this.pickDocObject(point, false);
        if (jGoObject != null) {
            while (jGoObject.getParent() != null) {
                jGoObject = jGoObject.getParent();
            }
            ((BasicLayoutNode)jGoObject).colorChange();
        } else {
            this.insertNode(point);
        }
        return super.doMouseDblClick(n, point, point2);
    }

    public boolean isChanged() {
        return this.getDoc().isChanged();
    }
}

