/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.layoutdemo;

import com.nwoods.jgo.examples.layoutdemo.AppAction;
import com.nwoods.jgo.examples.layoutdemo.DemoDocument;
import com.nwoods.jgo.examples.layoutdemo.DemoView;
import com.nwoods.jgo.examples.layoutdemo.ForceDialog;
import com.nwoods.jgo.examples.layoutdemo.LayerDialog;
import com.nwoods.jgo.examples.layoutdemo.NodeDialog;
import com.nwoods.jgo.examples.layoutdemo.SimpleRAL;
import com.nwoods.jgo.examples.layoutdemo.TreeDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class LayoutDemo
extends JApplet
implements Runnable {
    protected HashMap myMap = new HashMap();
    protected DemoView myCurrentView = null;
    protected JDesktopPane myDesktop = new JDesktopPane();
    protected JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu filemenu = new JMenu();
    protected JMenu editmenu = new JMenu();
    protected JMenu viewmenu = new JMenu();
    protected JMenu insertmenu = new JMenu();
    protected JMenu layoutmenu = new JMenu();
    protected JMenu helpmenu = new JMenu();
    protected JPanel myStatusArea = new JPanel();
    protected JLabel myStatusLabel = new JLabel();
    private int myDocCount = 1;

    public LayoutDemo() {
        this.initMenus();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getDesktop(), "Center");
        container.add((Component)this.getStatusArea(), "South");
        this.initStatusArea();
        container.validate();
    }

    void initMenus() {
        JMenuItem jMenuItem = null;
        this.filemenu.setText("File");
        this.filemenu.setMnemonic('F');
        AppAction appAction = new AppAction("New", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.newDemo();
            }

            public boolean canAct() {
                return true;
            }
        };
        jMenuItem = this.filemenu.add(appAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.setMnemonic('N');
        AppAction appAction2 = new AppAction("Open", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.openDemo();
            }

            public boolean canAct() {
                return true;
            }
        };
        jMenuItem = this.filemenu.add(appAction2);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem.setMnemonic('O');
        AppAction appAction3 = new AppAction("Close", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.closeDemo();
            }
        };
        jMenuItem = this.filemenu.add(appAction3);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        jMenuItem.setMnemonic('C');
        AppAction appAction4 = new AppAction("Save", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.saveDemo();
            }
        };
        jMenuItem = this.filemenu.add(appAction4);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.setMnemonic('S');
        AppAction appAction5 = new AppAction("Save As", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.saveAsDemo();
            }
        };
        jMenuItem = this.filemenu.add(appAction5);
        jMenuItem.setMnemonic('A');
        this.filemenu.addSeparator();
        AppAction appAction6 = new AppAction("Print", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().print();
            }
        };
        jMenuItem = this.filemenu.add(appAction6);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.setMnemonic('P');
        this.filemenu.addSeparator();
        AppAction appAction7 = new AppAction("Exit", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.exit();
            }

            public boolean canAct() {
                return true;
            }
        };
        jMenuItem = this.filemenu.add(appAction7);
        jMenuItem.setMnemonic('x');
        this.mainMenuBar.add(this.filemenu);
        this.editmenu.setText("Edit");
        this.editmenu.setMnemonic('E');
        AppAction appAction8 = new AppAction("Cut", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().cut();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty();
            }
        };
        jMenuItem = this.editmenu.add(appAction8);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem.setMnemonic('t');
        AppAction appAction9 = new AppAction("Copy", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().copy();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty();
            }
        };
        jMenuItem = this.editmenu.add(appAction9);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.setMnemonic('C');
        AppAction appAction10 = new AppAction("Paste", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().paste();
            }
        };
        jMenuItem = this.editmenu.add(appAction10);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem.setMnemonic('P');
        AppAction appAction11 = new AppAction("Delete", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().deleteSelection();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty();
            }
        };
        jMenuItem = this.editmenu.add(appAction11);
        jMenuItem.setMnemonic('D');
        AppAction appAction12 = new AppAction("Select All", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().selectAll();
            }
        };
        jMenuItem = this.editmenu.add(appAction12);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItem.setMnemonic('l');
        this.mainMenuBar.add(this.editmenu);
        this.viewmenu.setText("View");
        this.viewmenu.setMnemonic('V');
        AppAction appAction13 = new AppAction("Normal Zoom", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().zoomNormal();
            }
        };
        jMenuItem = this.viewmenu.add(appAction13);
        jMenuItem.setMnemonic('N');
        AppAction appAction14 = new AppAction("Zoom In", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().zoomIn();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getScale() < 8.0;
            }
        };
        jMenuItem = this.viewmenu.add(appAction14);
        jMenuItem.setMnemonic('I');
        AppAction appAction15 = new AppAction("Zoom Out", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().zoomOut();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getScale() > (double)0.13f;
            }
        };
        jMenuItem = this.viewmenu.add(appAction15);
        jMenuItem.setMnemonic('O');
        AppAction appAction16 = new AppAction("Zoom To Fit", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().zoomToFit();
            }
        };
        jMenuItem = this.viewmenu.add(appAction16);
        jMenuItem.setMnemonic('Z');
        this.viewmenu.addSeparator();
        AppAction appAction17 = new AppAction("Toggle Grid", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().showGrid();
            }
        };
        jMenuItem = this.viewmenu.add(appAction17);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenuItem.setMnemonic('G');
        AppAction appAction18 = new AppAction("Toggle Arrow Heads", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.getView().getDoc().toggleArrows();
            }
        };
        jMenuItem = this.viewmenu.add(appAction18);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItem.setMnemonic('T');
        this.mainMenuBar.add(this.viewmenu);
        this.insertmenu.setText("Insert");
        this.insertmenu.setMnemonic('I');
        AppAction appAction19 = new AppAction("Basic Node", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.nodeAction();
            }
        };
        jMenuItem = this.insertmenu.add(appAction19);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenuItem.setMnemonic('B');
        this.mainMenuBar.add(this.insertmenu);
        this.layoutmenu.setText("Layout");
        this.layoutmenu.setMnemonic('L');
        AppAction appAction20 = new AppAction("Random Layout", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.randomAction();
            }
        };
        jMenuItem = this.layoutmenu.add(appAction20);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItem.setMnemonic('R');
        AppAction appAction21 = new AppAction("Force-Directed Layout", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.forceAction();
            }
        };
        jMenuItem = this.layoutmenu.add(appAction21);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItem.setMnemonic('F');
        AppAction appAction22 = new AppAction("Layered Digraph Layout", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.layerAction();
            }
        };
        jMenuItem = this.layoutmenu.add(appAction22);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jMenuItem.setMnemonic('L');
        AppAction appAction23 = new AppAction("Tree Layout", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.treeAction();
            }
        };
        jMenuItem = this.layoutmenu.add(appAction23);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItem.setMnemonic('T');
        this.mainMenuBar.add(this.layoutmenu);
        this.helpmenu.setText("Help");
        this.helpmenu.setMnemonic('H');
        AppAction appAction24 = new AppAction("About", (Container)this){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDemo.this.showAbout();
            }

            public boolean canAct() {
                return true;
            }
        };
        jMenuItem = this.helpmenu.add(appAction24);
        jMenuItem.setMnemonic('A');
        this.mainMenuBar.add(this.helpmenu);
        this.setJMenuBar(this.mainMenuBar);
    }

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
        AppAction.updateAllActions();
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        this.newDemo();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            final JFrame jFrame = new JFrame();
            final LayoutDemo layoutDemo = new LayoutDemo();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Object object = windowEvent.getSource();
                    if (object == jFrame) {
                        layoutDemo.exit();
                    }
                }
            });
            jFrame.setTitle("Layout Demo");
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jFrame.setBounds(0, 0, dimension.width, dimension.height);
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)layoutDemo, "Center");
            container.validate();
            jFrame.setVisible(true);
            layoutDemo.init();
            layoutDemo.start();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    void exit() {
        System.exit(0);
    }

    void showAbout() {
        JOptionPane.showMessageDialog(this, "LayoutDemo, an example of the JGo auto layout code.\n\n                      Northwoods Software\n                         www.nwoods.com", "       About LayoutDemo", 1);
    }

    public void createFrame(DemoDocument demoDocument) {
        final DemoView demoView = new DemoView(demoDocument);
        JInternalFrame jInternalFrame = new JInternalFrame(demoDocument.getName(), true, true, true);
        demoView.initialize(this, jInternalFrame);
        jInternalFrame.addVetoableChangeListener(new CloseListener(this, jInternalFrame));
        jInternalFrame.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                LayoutDemo.this.myCurrentView = demoView;
                demoView.requestFocus();
                AppAction.updateAllActions();
            }

            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
                demoView.zoomToFit();
                demoView.showGrid();
                demoView.setSnapMove(0);
            }

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            }
        });
        Container container = jInternalFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add(demoView);
        jInternalFrame.setSize(700, 500);
        this.getDesktop().add(jInternalFrame);
        jInternalFrame.show();
        demoView.initializeDragDropHandling();
    }

    void newDemo() {
        DemoDocument demoDocument = new DemoDocument();
        String string = "Untitled" + Integer.toString(this.myDocCount++);
        demoDocument.setName(string);
        this.createFrame(demoDocument);
    }

    void openDemo() {
        DemoDocument demoDocument;
        String string = null;
        DemoView demoView = this.getCurrentView();
        if (demoView != null) {
            demoDocument = demoView.getDoc();
            string = demoDocument.getLocation();
        }
        if ((demoDocument = DemoDocument.open(this, string)) != null) {
            this.createFrame(demoDocument);
        }
    }

    void closeDemo() {
        JInternalFrame jInternalFrame;
        if (this.getCurrentView() != null && (jInternalFrame = this.getCurrentView().getInternalFrame()) != null) {
            if (this.getCurrentView().isChanged()) {
                String string = "Save Changes to " + this.getCurrentView().getDoc().getName();
                int n = JOptionPane.showConfirmDialog(jInternalFrame, string, "Northwoods Software LayoutDemo", 1, 3);
                if (n == 0) {
                    this.saveDemo();
                }
                if (this.myCurrentView.isChanged() && n == 0 || n == 2) {
                    return;
                }
            }
            this.getDesktop().getDesktopManager().closeFrame(jInternalFrame);
            this.myCurrentView = null;
            AppAction.updateAllActions();
        }
    }

    void saveDemo() {
        if (this.getCurrentView() != null) {
            DemoDocument demoDocument = this.getCurrentView().getDoc();
            demoDocument.save();
        }
    }

    void saveAsDemo() {
        if (this.getCurrentView() != null) {
            DemoDocument demoDocument = this.getCurrentView().getDoc();
            demoDocument.saveAs();
        }
    }

    DemoDocument findDemoDocument(String string) {
        Object v = this.myMap.get(string);
        if (v != null && v instanceof DemoDocument) {
            return (DemoDocument)v;
        }
        return null;
    }

    DemoView getCurrentView() {
        return this.myCurrentView;
    }

    void randomAction() {
        this.setStatus("");
        DemoDocument demoDocument = this.getCurrentView().getDoc();
        Rectangle rectangle = this.getCurrentView().getViewRect();
        SimpleRAL simpleRAL = new SimpleRAL(demoDocument, rectangle.x + 100, rectangle.width - rectangle.x - 100, rectangle.y + 100, rectangle.height - rectangle.y - 100);
        simpleRAL.performLayout();
        this.setStatus("Random Layout done");
    }

    void forceAction() {
        this.setStatus("");
        ForceDialog forceDialog = new ForceDialog(this.getCurrentView().getFrame(), "Force-Directed Settings", true, this.getCurrentView(), this);
        forceDialog.setVisible(true);
    }

    void layerAction() {
        this.setStatus("");
        LayerDialog layerDialog = new LayerDialog(this.getCurrentView().getFrame(), "Layered-Digraph Settings", true, this.getCurrentView(), this);
        layerDialog.setVisible(true);
    }

    void treeAction() {
        this.setStatus("");
        TreeDialog treeDialog = new TreeDialog(this.getCurrentView().getFrame(), "Tree Layout Settings", true, this.getCurrentView());
        treeDialog.setVisible(true);
    }

    void nodeAction() {
        NodeDialog nodeDialog = new NodeDialog(this.getCurrentView().getFrame(), "Node Settings", true, this.getCurrentView());
        nodeDialog.setVisible(true);
    }

    JDesktopPane getDesktop() {
        return this.myDesktop;
    }

    public JPanel getStatusArea() {
        return this.myStatusArea;
    }

    public void setStatus(String string) {
        if (string.equals("")) {
            string = " ";
        }
        this.myStatusLabel.setText(string);
        this.myStatusLabel.paintImmediately(0, 0, this.myStatusLabel.getWidth(), this.myStatusLabel.getHeight());
    }

    protected void initStatusArea() {
        this.getStatusArea().setMinimumSize(new Dimension(10, 10));
        this.getStatusArea().setBorder(BorderFactory.createEtchedBorder());
        this.getStatusArea().setLayout(new BorderLayout());
        this.getStatusArea().add((Component)this.myStatusLabel, "Center");
        this.setStatus("Ready");
    }

    class CloseListener
    implements VetoableChangeListener {
        private String msg = "";
        private LayoutDemo myApp = null;
        private JInternalFrame myFrame = null;

        CloseListener(LayoutDemo layoutDemo2, JInternalFrame jInternalFrame) {
            this.myApp = layoutDemo2;
            this.myFrame = jInternalFrame;
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("closed")) {
                Component component = (Component)propertyChangeEvent.getSource();
                Boolean bl = (Boolean)propertyChangeEvent.getOldValue();
                Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                if (bl == Boolean.FALSE && bl2 == Boolean.TRUE) {
                    this.msg = "Save Changes to " + this.myApp.getCurrentView().getDoc().getName();
                    if (LayoutDemo.this.getCurrentView().isChanged()) {
                        int n = JOptionPane.showConfirmDialog(this.myFrame, this.msg, "Northwoods Software LayoutDemo", 1, 3);
                        if (n == 0) {
                            LayoutDemo.this.saveDemo();
                        }
                        if (LayoutDemo.this.myCurrentView.isChanged() && n == 0 || n == 2) {
                            throw new PropertyVetoException("close cancelled", propertyChangeEvent);
                        }
                        this.myApp.myCurrentView = null;
                        AppAction.updateAllActions();
                    } else {
                        this.myApp.myCurrentView = null;
                        AppAction.updateAllActions();
                    }
                }
            }
        }
    }
}

