/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.examples.layoutdemo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.examples.layoutdemo.BasicLayoutNode;
import com.nwoods.jgo.examples.layoutdemo.DemoView;
import com.nwoods.jgo.examples.layoutdemo.LayoutDemo;
import com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayout;
import com.nwoods.jgo.layout.JGoNetwork;
import com.nwoods.jgo.layout.JGoNetworkLink;
import com.nwoods.jgo.layout.JGoNetworkNode;
import java.awt.Color;
import java.awt.Rectangle;

public class SimpleLDAL
extends JGoLayeredDigraphAutoLayout {
    private LayoutDemo myApp = null;
    private boolean mySubNetLayout = true;

    public SimpleLDAL() {
    }

    public SimpleLDAL(JGoLayeredDigraphAutoLayout jGoLayeredDigraphAutoLayout) {
        super(jGoLayeredDigraphAutoLayout);
        if (jGoLayeredDigraphAutoLayout instanceof SimpleLDAL) {
            SimpleLDAL simpleLDAL = (SimpleLDAL)jGoLayeredDigraphAutoLayout;
            this.setApp(simpleLDAL.myApp);
        }
    }

    public int getLinkMinLength(JGoNetworkLink jGoNetworkLink) {
        JGoNetworkNode jGoNetworkNode = jGoNetworkLink.getFromNode();
        JGoNetworkNode jGoNetworkNode2 = jGoNetworkLink.getToNode();
        if (jGoNetworkNode.getJGoObject() != null && jGoNetworkNode2.getJGoObject() != null) {
            Color color;
            Color color2 = ((BasicLayoutNode)jGoNetworkNode.getJGoObject()).getColor();
            if (color2 == (color = ((BasicLayoutNode)jGoNetworkNode2.getJGoObject()).getColor())) {
                return 1 * super.getLinkMinLength(jGoNetworkLink);
            }
            return 2 * super.getLinkMinLength(jGoNetworkLink);
        }
        return super.getLinkMinLength(jGoNetworkLink);
    }

    public void performLayout() {
        if (this.mySubNetLayout) {
            Object object;
            DemoView demoView = this.myApp.getCurrentView();
            int n = 10;
            JGoNetwork[] jGoNetworkArray = this.getNetwork().splitIntoSubNetworks();
            for (int i = 0; i < jGoNetworkArray.length; ++i) {
                object = jGoNetworkArray[i];
                SimpleLDAL simpleLDAL = new SimpleLDAL(this);
                simpleLDAL.mySubNetLayout = false;
                simpleLDAL.setNetwork((JGoNetwork)object);
                simpleLDAL.performLayout();
                JGoSelection jGoSelection = ((JGoNetwork)object).getNodesAndLinks(null);
                Rectangle rectangle = JGoDocument.computeBounds(jGoSelection);
                demoView.moveSelection(jGoSelection, 0, n - rectangle.x, 0, 3);
                n += rectangle.width + 100;
            }
            super.performLayout();
            JGoSelection jGoSelection = this.getNetwork().getNodesAndLinks(null);
            object = JGoDocument.computeBounds(jGoSelection);
            demoView.moveSelection(jGoSelection, 0, n - ((Rectangle)object).x, 0, 3);
        } else {
            super.performLayout();
        }
    }

    public void progressUpdate(double d) {
        if (d == 1.0) {
            this.myApp.setStatus("Simple Layered Digraph Auto-Layout: 100% done.");
        } else {
            this.myApp.setStatus("Simple Layered Digraph Auto-Layout: " + 100.0 * d + "% done.");
        }
    }

    public LayoutDemo getApp() {
        return this.myApp;
    }

    public void setApp(LayoutDemo layoutDemo) {
        this.myApp = layoutDemo;
    }
}

