package com.nwoods.jgo.examples;
import com.nwoods.jgo.*;

import java.awt.*;

public class AutoLinkNode extends GeneralNode {
  public AutoLinkNode() {}

  public void initialize(Point loc, Dimension size, JGoObject icon,
                         String toplabeltext, String bottomlabeltext, int numinports, int numoutports) {
    super.initialize(loc, size, icon, toplabeltext, bottomlabeltext, numinports, numoutports);
    myAutoLinkingPort = new AutoLinkingPort();
    addObjectAtTail(myAutoLinkingPort);
  }

  protected void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
    super.copyChildren(newarea, env);
    AutoLinkNode newobj = (AutoLinkNode)newarea;
    newobj.myAutoLinkingPort = (AutoLinkingPort)env.get(myAutoLinkingPort);
  }

  public JGoObject removeObjectAtPos(JGoListPosition pos) {
    JGoObject child = super.removeObjectAtPos(pos);
    if (child == myAutoLinkingPort)
      myAutoLinkingPort = null;
    return child;
  }

  public void layoutChildren(JGoObject childchanged) {
    if (isInitializing()) return;
    super.layoutChildren(childchanged);
    setInitializing(true);
    JGoObject icon = getIcon();
    if (icon != null && myAutoLinkingPort != null) {
      myAutoLinkingPort.setSpotLocation(Center, icon, Center);
    }
    setInitializing(false);
  }

  private AutoLinkingPort myAutoLinkingPort = null;
}
