package com.nwoods.jgo.examples;
import com.nwoods.jgo.*;

import java.awt.*;

public class AutoLinkingPort extends JGoPort {
  public AutoLinkingPort() {
    setStyle(StyleDiamond);
    setFromSpot(Center);
    setToSpot(Center);
    setSize(7, 7);
    setPen(null);
    setBrush(JGoBrush.yellow);
  }

  public void update(int hint, int prevInt, Object prevVal) {
    super.update(hint, prevInt, prevVal);
    if (hint == JGoPort.ChangedAddedLink && getParent() instanceof GeneralNode) {
      JGoLink link = (JGoLink)prevVal;
      GeneralNode node = (GeneralNode)getParent();
      if (link.getToPort() != null && link.getToPort().getParent() == node) {
        String name = Integer.toString(node.getNumLeftPorts());
        GeneralNodePort p = new AutoLinkNodePort();
        p.initialize(true, name, node);
        GeneralNodePortLabel lab = new GeneralNodePortLabel();
        lab.initialize(name, p);
        node.addLeftPort(p);
        link.setToPort(p);
      } else if (link.getFromPort() != null && link.getFromPort().getParent() == node) {
        String name = Integer.toString(node.getNumRightPorts());
        GeneralNodePort p = new AutoLinkNodePort();
        p.initialize(false, name, node);
        GeneralNodePortLabel lab = new GeneralNodePortLabel();
        lab.initialize(name, p);
        node.addRightPort(p);
        link.setFromPort(p);
      }
    }
  }
}
