/*
 *  Copyright (c) Northwoods Software Corporation, 1999-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples;

import com.nwoods.jgo.*;

/**
 * GeneralNodeLabel is just a JGoText that treats a single click as a command
 * to start editing the text of the label.
 */
public class GeneralNodeLabel extends JGoText
{
  /** Create an empty label for a GeneralNode.  Call initialize() before using. */
  public GeneralNodeLabel()
  {
    super();
  }

  /** Create a label containing the given text for a GeneralNode */
  public GeneralNodeLabel(String text, GeneralNode parent)
  {
    super(text);
    initialize(text, parent);
  }

  public void initialize(String text, GeneralNode parent)
  {
    setSelectable(false);
    setDraggable(false);
    setResizable(false);
    setVisible(true);
    setEditable(true);
    setEditOnSingleClick(true);
    setTransparent(true);
    setAlignment(JGoText.ALIGN_CENTER);
    setTopLeft(parent.getLeft(), parent.getTop());
    parent.addObjectAtTail(this);
  }

  // access to the GeneralNode that this is part of
  public GeneralNode getGeneralNode()
  {
    return (GeneralNode)getParent();
  }

 public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
  {
    // Add GeneralNodeLabel element
    if (svgDoc.JGoXMLOutputEnabled()) {
      DomElement jBasicNode = svgDoc.createJGoClassElement(
          "com.nwoods.jgo.examples.GeneralNodeLabel", jGoElementGroup);
    }
    // Have superclass add to the JGoObject group
    super.SVGWriteObject(svgDoc, jGoElementGroup);
  }

  public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
  {
    if (jGoChildElement != null) {
      // This is a GeneralNodeLabel element
      super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
    }
    return svgElement.getNextSibling();
  }

}
