/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples;

import com.nwoods.jgo.*;
import java.awt.*;
import com.nwoods.jgo.examples.ListArea;


public class ListAreaRect extends JGoRectangle
{
  public ListAreaRect()
  {
    super();
  }

  // figure out the minimum width and height for resizing
  protected Rectangle handleResize(Graphics2D g, JGoView view, Rectangle prevRect,
                                   Point newPoint, int whichHandle, int event,
                                   int minWidth, int minHeight)
  {
    if (getParent() == null)
      return super.handleResize(g, view, prevRect, newPoint, whichHandle, event,
                                minWidth, minHeight);
    ListArea area = (ListArea)getParent();
    Dimension minSize = area.getMinimumRectSize();
    return super.handleResize(g, view, prevRect, newPoint, whichHandle, event,
                              minSize.width, minSize.height);
  }

  // constrain to the minimum width and height
  public void setBoundingRect(int left, int top, int width, int height)
  {
    if (getParent() == null) return;
    ListArea area = (ListArea)getParent();
    Dimension minSize = area.getMinimumRectSize();
    super.setBoundingRect(left, top,
                          Math.max(width, minSize.width),
                          Math.max(height, minSize.height));
  }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
  {
    // Add ListAreaRect element
    if (svgDoc.JGoXMLOutputEnabled()) {
      DomElement jIconicNodePort = svgDoc.createJGoClassElement(
          "com.nwoods.jgo.examples.ListAreaRect", jGoElementGroup);
    }

    // Have superclass add to the JGoObject group
    super.SVGWriteObject(svgDoc, jGoElementGroup);
  }

  public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
  {
    if (jGoChildElement != null) {
      // This is a ListAreaRect element
      super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
    }
    return svgElement.getNextSibling();
  }
}
