/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.nwoods.jgo.*;

/**
 * This is a minimal JGo applet/application. Most of the code here
 * is standard boilerplate that must be in any applet/application.
 * <p>
 * This just displays two BasicNodes, of different colors.
 * The user can only select nodes, move them, copy them, and link them together.
 */
public class MinimalApp extends JApplet implements Runnable {
  public MinimalApp() {
    myView = new JGoView();
    getContentPane().add(myView, BorderLayout.CENTER);
  }
  
  public void start() {  // Applet starting
    new Thread(this).start();  // enable drag-and-drop from separate thread (JDC bug 4225247)
  }

  public void run() {
    myView.initializeDragDropHandling();
  }

  public static void main(String args[]) {
    try {
      JFrame mainFrame = new JFrame();
      // close the application when the main window closes
      mainFrame.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent event) {
          System.exit(0);
        }
      });
      mainFrame.setTitle("Minimal JGo Application");
      mainFrame.setSize(400, 300);

      MinimalApp app = new MinimalApp();
      Container contentPane = mainFrame.getContentPane();
      contentPane.setLayout(new BorderLayout());
      contentPane.add(app, BorderLayout.CENTER);
      contentPane.validate();

      mainFrame.setVisible(true);

      app.init();  // do common initialization
      app.start();
    } catch (Throwable t) {
      System.err.println(t);
      t.printStackTrace();
      System.exit(1);
    }
  }

  public void init() {  // App initialization--only here do we do anything JGo specific
    // add JGoObjects to the document, not to the view
    JGoDocument doc = myView.getDocument();

    // create two nodes for fun...
    JGoBasicNode node1 = new JGoBasicNode("first");
    node1.setLocation(new Point(100, 100));  // specify position
    node1.setBrush(JGoBrush.blue);  // specify color
    doc.addObjectAtTail(node1);              // add to the document

    JGoBasicNode node2 = new JGoBasicNode("second");
    node2.setLocation(new Point(200, 100));
    node2.setBrush(JGoBrush.magenta);
    doc.addObjectAtTail(node2);
  }

  private JGoView myView;
}
