/*
 *  Copyright (c) Northwoods Software Corporation, 1999-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples;

import com.nwoods.jgo.*;
import java.awt.*;

/**
 * SimpleNodeLabel is just a JGoText that treats a single click as a command
 * to start editing the text of the label.
 */
public class SimpleNodeLabel extends JGoText
{
  /** Create an empty label for a SimpleNode.  Call initialize() before using. */
  public SimpleNodeLabel()
  {
    super();
  }

  /** Create a label containing the given text for a SimpleNode */
  public SimpleNodeLabel(String text, JGoArea parent)
  {
    super(text);
    initialize(text, parent);
  }

  public void initialize(String text, JGoArea parent)
  {
    setSelectable(false);
    setDraggable(false);
    setResizable(false);
    setVisible(true);
    setEditable(true);
    setEditOnSingleClick(true);
    setTransparent(true);
    setAlignment(JGoText.ALIGN_CENTER);
    setTopLeft(parent.getLeft(), parent.getTop());
    parent.addObjectAtTail(this);
  }

  public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
  {
    // Add <SimpleNodeLabel> element
    if (svgDoc.JGoXMLOutputEnabled()) {
      DomElement simpleNodeLabel = svgDoc.createJGoClassElement(
          "com.nwoods.jgo.examples.SimpleNodeLabel", jGoElementGroup);
    }

    // Have superclass add to the JGoObject group
    super.SVGWriteObject(svgDoc, jGoElementGroup);
  }

  public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
  {
    if (jGoChildElement != null) {
      // This is a <SimpleNodeLabel> element
      super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingElement());
    }
    return svgElement.getNextSibling();
  }


}
