/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples;

import java.applet.*;
import java.awt.*;
import java.awt.dnd.*;
import java.awt.event.*;
import javax.swing.*;
import com.nwoods.jgo.*;

public class TestIconicNode extends JGoIconicNode {
  public TestIconicNode() { super(); }

  public TestIconicNode(String s) {
    super(s);
    // create the background object implementing the selection appearance instead of a selection handle
    JGoRectangle r = new JGoRectangle();
    r.setSelectable(false);
    r.setVisible(false);  // assume node initially not selected, so rectangle should not be visible
    r.setBrush(JGoBrush.makeStockBrush(new Color(0, 0, 0x8B)));  // dark blue
    r.setPen(null);
    r.setBoundingRect(getBoundingRect());
    addObjectAtHead(r);
    myBack = r;
  }

  // make sure the "myBack" field is updated appropriately when this node is copied
  public JGoObject copyObject(JGoCopyEnvironment env) {
    TestIconicNode newobj = (TestIconicNode)super.copyObject(env);
    newobj.myBack = (JGoDrawable)env.get(myBack);
    return newobj;
  }

  // make sure the background rectangle is big enough to be behind both icon and label
  public void layoutChildren(JGoObject child) {
    super.layoutChildren(child);

    Rectangle r = getIcon().getBoundingRect();
    Rectangle rect = new Rectangle(r.x, r.y, r.width, r.height);
    rect = rect.union(getLabel().getBoundingRect());

    if (getBackground() != null) {
      // make the rectangle the size of the Icon and Label put together
      getBackground().setBoundingRect(rect);
      // make sure it's behind everything else
      addObjectAtHead(getBackground());
    }
  }

  // when the node is selected, the dark blue background rectangle is made visible
  // and the text is drawn white and bold
  protected void gainedSelection(JGoSelection selection) {
    getBackground().setVisible(true);
    getLabel().setBold(true);
    getLabel().setTextColor(JGoBrush.ColorWhite);
  }

  // when the node is de-selected, the background rectangle becomes invisible
  // and the text is drawn black and normal
  protected void lostSelection(JGoSelection selection) {
    getBackground().setVisible(false);
    getLabel().setBold(false);
    getLabel().setTextColor(JGoBrush.ColorBlack);
  }

  public JGoDrawable getBackground() { return myBack; }

  private JGoDrawable myBack = null;
}
