/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.animatedbasicapp;

import com.nwoods.jgo.*;
import java.awt.*;

public class AnimatedLink extends JGoLink {
  public AnimatedLink() { }

  public AnimatedLink(JGoPort from, JGoPort to) { super(from, to); }

  public void paint(Graphics2D g, JGoView view) {
    super.paint(g, view);
    JGoStroke s = this;
    if (mySeg >= s.getNumPoints() - 1)
      mySeg = 0;
    Point a = s.getPoint(mySeg);
    Point b = s.getPoint(mySeg + 1);
    double len = Math.sqrt((b.x - a.x) * (b.x - a.x) + (b.y - a.y) * (b.y - a.y));
    int x = b.x;
    int y = b.y;
    if (myDist >= len) {
      mySeg++;
      myDist = 0;
    } else if (len >= 1) {
      x = (int)(a.x + (b.x - a.x) * myDist / len);
      y = (int)(a.y + (b.y - a.y) * myDist / len);
    }
    JGoDrawable.drawEllipse(g, null, JGoBrush.red, x - 3, y - 3, 7, 7);
  }
  
  public void step() {
    myDist += 3;
    update();
  }

  transient private int mySeg = 0;
  transient private float myDist = 0;
}