/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.animatedbasicapp;

import com.nwoods.jgo.*;
import java.awt.*;
import java.awt.event.*;

public class AnimatedView extends JGoView {
  public AnimatedView() {
    new javax.swing.Timer(50, new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        JGoDocument doc = getDocument();
        doc.setSkipsUndoManager(true);
        JGoListPosition pos = doc.getFirstObjectPos();
        while (pos != null) {
          JGoObject obj = doc.getObjectAtPos(pos);
          pos = doc.getNextObjectPosAtTop(pos);
          if (obj instanceof AnimatedLink) {
            AnimatedLink link = (AnimatedLink)obj;
            link.step();
          }
        }
        doc.setSkipsUndoManager(false);
      }
    }).start();
  }

  public void newLink(JGoPort from, JGoPort to) {
    JGoDocument doc = getDocument();
    if (doc == null) return;

    JGoLink link = new AnimatedLink(from, to);

    //now smarter about automatically adding links to subgraphs
    //  [instead of doc.getLinksLayer().addObjectAtTail(link);]
    JGoSubGraphBase.reparentToCommonSubGraph(link, from, to, true, doc.getLinksLayer());

    fireUpdate(JGoViewEvent.LINK_CREATED, 0, link);
    doc.endTransaction(getEditPresentationName(4));
  }
}