/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.boxapp;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.nwoods.jgo.*;

public class BoxApp extends JApplet implements Runnable {
  public BoxApp() {
    myView = new BoxView();
    getContentPane().add(myView, BorderLayout.CENTER);
    myStatusBarLabel = new JLabel();
    myStatusBarLabel.setText(" ");
    getContentPane().add(myStatusBarLabel, BorderLayout.SOUTH);
  }
  
  public void start() {  // Applet starting
    new Thread(this).start();  // enable drag-and-drop from separate thread (JDC bug 4225247)
  }

  public void run() {
    myView.initializeDragDropHandling();
  }

  public static void main(String args[]) {
    try {
      JFrame mainFrame = new JFrame();
      // close the application when the main window closes
      mainFrame.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent event) {
          System.exit(0);
        }
      });
      mainFrame.setTitle("Box Application");
      mainFrame.setSize(600, 500);

      myApp = new BoxApp();
      Container contentPane = mainFrame.getContentPane();
      contentPane.setLayout(new BorderLayout());
      contentPane.add(myApp, BorderLayout.CENTER);
      contentPane.validate();

      mainFrame.setVisible(true);

      myApp.init();  // do common initialization
      myApp.start();
    } catch (Throwable t) {
      System.err.println(t);
      t.printStackTrace();
      System.exit(1);
    }
  }

  public void init() {  // App initialization--only here do we do anything JGo specific
    // add JGoObjects to the document, not to the view
    JGoDocument doc = myView.getDocument();

    doc.setLinksLayer(doc.addLayerAfter(doc.getDefaultLayer()));

    // create two nodes for fun...
    JGoBasicNode node1 = new JGoBasicNode("first");
    node1.setLocation(new Point(100, 100));  // specify position
    node1.setBrush(JGoBrush.blue);  // specify color
    doc.add(node1);              // add to the document
    node1.setDragsNode(false);

    JGoBasicNode node2 = new JGoBasicNode("second");
    node2.setLocation(new Point(200, 100));
    node2.setBrush(JGoBrush.magenta);
    doc.add(node2);
    node2.setDragsNode(false);

    BoxArea box1 = new BoxArea("Box 1");
    box1.getBorder().setBoundingRect(50, 150, 200, 150);
    doc.add(box1);

    TestSubGraph box2 = new TestSubGraph("Box 2");  //???
    box2.getBorder().setBoundingRect(300, 150, 200, 150);
    doc.add(box2);
  }

  public static void setStatus(String msg) {
    myApp.myStatusBarLabel.setText(msg);
  }

  private static BoxApp myApp;
  private JGoView myView;
  private JLabel myStatusBarLabel;
}
