/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

public class AboutDialog extends JDialog {
  JPanel panel1 = new JPanel();
  javax.swing.JLabel label1 = new javax.swing.JLabel();
  javax.swing.JButton okButton = new javax.swing.JButton();

  boolean fComponentsAdjusted = false;

  public AboutDialog(Frame frame, String title, boolean modal) {
    super(frame, title, modal);
    try  {
      jbInit();
      pack();
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }
  }

  public AboutDialog() {
    this(null, "", false);
  }

  void jbInit() throws Exception {
    panel1.setLayout(null);
    panel1.setMinimumSize(new Dimension(199, 96));
    panel1.setPreferredSize(new Dimension(199, 96));
    okButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        okButton_actionPerformed(e);
      }
    });
    getContentPane().add(panel1);
    label1.setText("A simple JGo application");
    panel1.add(label1);
    label1.setBounds(new Rectangle(40,23,166,21));
    okButton.setText("OK");
    panel1.add(okButton);
    okButton.setBounds(new Rectangle(71,61,66,23));
  }

  public void addNotify()
  {
    // Record the size of the window prior to calling parents addNotify.
    Dimension d = getSize();

    super.addNotify();

    // Only do this once.
    if (fComponentsAdjusted)
      return;

    // Adjust components according to the insets
    Insets insets = getInsets();
    setSize(insets.left + insets.right + d.width, insets.top + insets.bottom + d.height);
    Component components[] = getComponents();
    for (int i = 0; i < components.length; i++)
    {
      Point p = components[i].getLocation();
      p.translate(insets.left, insets.top);
      components[i].setLocation(p);
    }

    // Used for addNotify check.
    fComponentsAdjusted = true;
  }

  public void setVisible(boolean b)
  {
    if (b) {
      Rectangle bounds = getParent().getBounds();
      Rectangle abounds = getBounds();

      setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
                  bounds.y + (bounds.height - abounds.height)/2);
    }

    super.setVisible(b);
  }

  void okButton_actionPerformed(ActionEvent e) {
    try {
      this.dispose();
    } catch (Exception ex) {
    }
  }
}
