/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import java.awt.event.*;
import com.nwoods.jgo.*;

public class DecoratedTextNode extends JGoTextNode {
  public DecoratedTextNode() {}
  public DecoratedTextNode(String s) {
    super(s);
    setTopPort(null);
    JGoImage img = new JGoImage();
    img.setSelectable(false);
    img.loadImage(Demo1.class.getResource(myImgName), true);
    img.setSize(32, 32);
    insertObjectAfter(findObject(getBackground()), img);
    myDecoration = img;
    layoutChildren(getDecoration());
  }

  public JGoObject copyObject(JGoCopyEnvironment env) {
    DecoratedTextNode newobj = (DecoratedTextNode)super.copyObject(env);
    newobj.myDecoration = (JGoImage)env.get(myDecoration);
    return newobj;
  }

  public JGoObject removeObjectAtPos(JGoListPosition pos) {
    JGoObject obj = super.removeObjectAtPos(pos);
    if (obj == myDecoration) myDecoration = null;
    return obj;
  }

  public void layoutChildren(JGoObject child) {
    super.layoutChildren(child);
    if (!isInitializing() && getDecoration() != null && getBackground() != null) {
      getDecoration().setSpotLocation(BottomCenter, getBackground(), TopCenter);
    }
  }

  public boolean doMouseDblClick(int modifiers, Point dc, Point vc, JGoView view) {
    if (getDecoration() != null) {
      if (myImgName.equals("star.gif")) myImgName = "doc.gif";
      else myImgName = "star.gif";
      getDecoration().loadImage(Demo1.class.getResource(myImgName), true);
    }
    return true;
  }

  public JGoImage getDecoration() { return myDecoration; }

  private JGoImage myDecoration;
  private String myImgName = "star.gif";
}
